// This code conforms with the UFC specification version 2016.2.0
// and was automatically generated by FFC version 2016.2.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   max_signature_length:           0
//   no-evaluate_basis:              True
//   no-evaluate_basis_derivatives:  True
//   optimize:                       True
//   precision:                      15
//   quadrature_degree:              -1
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          True

#include "Poisson2D_5.h"

poisson2d_5_finite_element_0::poisson2d_5_finite_element_0() : ufc::finite_element()
{
    // Do nothing
}

poisson2d_5_finite_element_0::~poisson2d_5_finite_element_0()
{
    // Do nothing
}

const char * poisson2d_5_finite_element_0::signature() const
{
    return "FiniteElement('Lagrange', triangle, 1)";
}

ufc::shape poisson2d_5_finite_element_0::cell_shape() const
{
    return ufc::shape::triangle;
}

std::size_t poisson2d_5_finite_element_0::topological_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_0::geometric_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_0::space_dimension() const
{
    return 3;
}

std::size_t poisson2d_5_finite_element_0::value_rank() const
{
    return 0;
}

std::size_t poisson2d_5_finite_element_0::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_0::value_size() const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_0::reference_value_rank() const
{
    return 0;
}

std::size_t poisson2d_5_finite_element_0::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_0::reference_value_size() const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_0::degree() const
{
    return 1;
}

const char * poisson2d_5_finite_element_0::family() const
{
    return "Lagrange";
}

void poisson2d_5_finite_element_0::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis not generated (compiled with -fno-evaluate_basis)");
}

void poisson2d_5_finite_element_0::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

void poisson2d_5_finite_element_0::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis_derivatives not generated (compiled with -fno-evaluate_basis_derivatives)");
}

void poisson2d_5_finite_element_0::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 3; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[2];
    for (unsigned int r = 0; r < 2; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double poisson2d_5_finite_element_0::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void poisson2d_5_finite_element_0::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
}

void poisson2d_5_finite_element_0::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
}

void poisson2d_5_finite_element_0::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
}

std::size_t poisson2d_5_finite_element_0::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * poisson2d_5_finite_element_0::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * poisson2d_5_finite_element_0::create() const
{
    return new poisson2d_5_finite_element_0();
}


poisson2d_5_finite_element_1::poisson2d_5_finite_element_1() : ufc::finite_element()
{
    // Do nothing
}

poisson2d_5_finite_element_1::~poisson2d_5_finite_element_1()
{
    // Do nothing
}

const char * poisson2d_5_finite_element_1::signature() const
{
    return "VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
}

ufc::shape poisson2d_5_finite_element_1::cell_shape() const
{
    return ufc::shape::triangle;
}

std::size_t poisson2d_5_finite_element_1::topological_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_1::geometric_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_1::space_dimension() const
{
    return 6;
}

std::size_t poisson2d_5_finite_element_1::value_rank() const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_1::value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t poisson2d_5_finite_element_1::value_size() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_1::reference_value_rank() const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_1::reference_value_dimension(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
}

std::size_t poisson2d_5_finite_element_1::reference_value_size() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_1::degree() const
{
    return 1;
}

const char * poisson2d_5_finite_element_1::family() const
{
    return "Lagrange";
}

void poisson2d_5_finite_element_1::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis not generated (compiled with -fno-evaluate_basis)");
}

void poisson2d_5_finite_element_1::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis(r, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

void poisson2d_5_finite_element_1::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis_derivatives not generated (compiled with -fno-evaluate_basis_derivatives)");
}

void poisson2d_5_finite_element_1::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double poisson2d_5_finite_element_1::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 4:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
}

void poisson2d_5_finite_element_1::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[2];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    values[3] = vals[1];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    values[4] = vals[1];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    values[5] = vals[1];
}

void poisson2d_5_finite_element_1::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[3];
    vertex_values[3] = dof_values[4];
    vertex_values[5] = dof_values[5];
}

void poisson2d_5_finite_element_1::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = coordinate_dofs[0];
    dof_coordinates[7] = coordinate_dofs[1];
    dof_coordinates[8] = coordinate_dofs[2];
    dof_coordinates[9] = coordinate_dofs[3];
    dof_coordinates[10] = coordinate_dofs[4];
    dof_coordinates[11] = coordinate_dofs[5];
}

std::size_t poisson2d_5_finite_element_1::num_sub_elements() const
{
    return 2;
}

ufc::finite_element * poisson2d_5_finite_element_1::create_sub_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_0();
        break;
      }
    }
    
    return 0;
}

ufc::finite_element * poisson2d_5_finite_element_1::create() const
{
    return new poisson2d_5_finite_element_1();
}


poisson2d_5_finite_element_2::poisson2d_5_finite_element_2() : ufc::finite_element()
{
    // Do nothing
}

poisson2d_5_finite_element_2::~poisson2d_5_finite_element_2()
{
    // Do nothing
}

const char * poisson2d_5_finite_element_2::signature() const
{
    return "FiniteElement('Lagrange', triangle, 5)";
}

ufc::shape poisson2d_5_finite_element_2::cell_shape() const
{
    return ufc::shape::triangle;
}

std::size_t poisson2d_5_finite_element_2::topological_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_2::geometric_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_finite_element_2::space_dimension() const
{
    return 21;
}

std::size_t poisson2d_5_finite_element_2::value_rank() const
{
    return 0;
}

std::size_t poisson2d_5_finite_element_2::value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_2::value_size() const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_2::reference_value_rank() const
{
    return 0;
}

std::size_t poisson2d_5_finite_element_2::reference_value_dimension(std::size_t i) const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_2::reference_value_size() const
{
    return 1;
}

std::size_t poisson2d_5_finite_element_2::degree() const
{
    return 5;
}

const char * poisson2d_5_finite_element_2::family() const
{
    return "Lagrange";
}

void poisson2d_5_finite_element_2::_evaluate_basis(std::size_t i,
                                    double * values,
                                    const double * x,
                                    const double * coordinate_dofs,
                                    int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis not generated (compiled with -fno-evaluate_basis)");
}

void poisson2d_5_finite_element_2::_evaluate_basis_all(double * values,
                                        const double * x,
                                        const double * coordinate_dofs,
                                        int cell_orientation)
{
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 21; r++)
    {
      _evaluate_basis(r, &dof_values, x, coordinate_dofs, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
}

void poisson2d_5_finite_element_2::_evaluate_basis_derivatives(std::size_t i,
                                                std::size_t n,
                                                double * values,
                                                const double * x,
                                                const double * coordinate_dofs,
                                                int cell_orientation)
{
throw std::runtime_error("// Function evaluate_basis_derivatives not generated (compiled with -fno-evaluate_basis_derivatives)");
}

void poisson2d_5_finite_element_2::_evaluate_basis_derivatives_all(std::size_t n,
                                                    double * values,
                                                    const double * x,
                                                    const double * coordinate_dofs,
                                                    int cell_orientation)
{
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, coordinate_dofs, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 21; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 5)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[32];
    for (unsigned int r = 0; r < 32; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 21; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, coordinate_dofs, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
}

double poisson2d_5_finite_element_2::evaluate_dof(std::size_t i,
                                   const ufc::function& f,
                                   const double * coordinate_dofs,
                                   int cell_orientation,
                                   const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = coordinate_dofs[0];
      y[1] = coordinate_dofs[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = coordinate_dofs[2];
      y[1] = coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = coordinate_dofs[4];
      y[1] = coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.8*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
      y[1] = 0.8*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.6*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
      y[1] = 0.6*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.4*coordinate_dofs[2] + 0.6*coordinate_dofs[4];
      y[1] = 0.4*coordinate_dofs[3] + 0.6*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.2*coordinate_dofs[2] + 0.8*coordinate_dofs[4];
      y[1] = 0.2*coordinate_dofs[3] + 0.8*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.8*coordinate_dofs[0] + 0.2*coordinate_dofs[4];
      y[1] = 0.8*coordinate_dofs[1] + 0.2*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.6*coordinate_dofs[0] + 0.4*coordinate_dofs[4];
      y[1] = 0.6*coordinate_dofs[1] + 0.4*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.4*coordinate_dofs[0] + 0.6*coordinate_dofs[4];
      y[1] = 0.4*coordinate_dofs[1] + 0.6*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.2*coordinate_dofs[0] + 0.8*coordinate_dofs[4];
      y[1] = 0.2*coordinate_dofs[1] + 0.8*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.8*coordinate_dofs[0] + 0.2*coordinate_dofs[2];
      y[1] = 0.8*coordinate_dofs[1] + 0.2*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.6*coordinate_dofs[0] + 0.4*coordinate_dofs[2];
      y[1] = 0.6*coordinate_dofs[1] + 0.4*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.4*coordinate_dofs[0] + 0.6*coordinate_dofs[2];
      y[1] = 0.4*coordinate_dofs[1] + 0.6*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.2*coordinate_dofs[0] + 0.8*coordinate_dofs[2];
      y[1] = 0.2*coordinate_dofs[1] + 0.8*coordinate_dofs[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 15:
      {
        y[0] = 0.6*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
      y[1] = 0.6*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 16:
      {
        y[0] = 0.4*coordinate_dofs[0] + 0.4*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
      y[1] = 0.4*coordinate_dofs[1] + 0.4*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 17:
      {
        y[0] = 0.2*coordinate_dofs[0] + 0.6*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
      y[1] = 0.2*coordinate_dofs[1] + 0.6*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 18:
      {
        y[0] = 0.4*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
      y[1] = 0.4*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 19:
      {
        y[0] = 0.2*coordinate_dofs[0] + 0.4*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
      y[1] = 0.2*coordinate_dofs[1] + 0.4*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 20:
      {
        y[0] = 0.2*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.6*coordinate_dofs[4];
      y[1] = 0.2*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.6*coordinate_dofs[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
}

void poisson2d_5_finite_element_2::evaluate_dofs(double * values,
                                  const ufc::function& f,
                                  const double * coordinate_dofs,
                                  int cell_orientation,
                                  const ufc::cell& c) const
{
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = coordinate_dofs[0];
    y[1] = coordinate_dofs[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = coordinate_dofs[2];
    y[1] = coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = coordinate_dofs[4];
    y[1] = coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.8*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    y[1] = 0.8*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.6*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
    y[1] = 0.6*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.4*coordinate_dofs[2] + 0.6*coordinate_dofs[4];
    y[1] = 0.4*coordinate_dofs[3] + 0.6*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.2*coordinate_dofs[2] + 0.8*coordinate_dofs[4];
    y[1] = 0.2*coordinate_dofs[3] + 0.8*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.8*coordinate_dofs[0] + 0.2*coordinate_dofs[4];
    y[1] = 0.8*coordinate_dofs[1] + 0.2*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.6*coordinate_dofs[0] + 0.4*coordinate_dofs[4];
    y[1] = 0.6*coordinate_dofs[1] + 0.4*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.4*coordinate_dofs[0] + 0.6*coordinate_dofs[4];
    y[1] = 0.4*coordinate_dofs[1] + 0.6*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.2*coordinate_dofs[0] + 0.8*coordinate_dofs[4];
    y[1] = 0.2*coordinate_dofs[1] + 0.8*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.8*coordinate_dofs[0] + 0.2*coordinate_dofs[2];
    y[1] = 0.8*coordinate_dofs[1] + 0.2*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.6*coordinate_dofs[0] + 0.4*coordinate_dofs[2];
    y[1] = 0.6*coordinate_dofs[1] + 0.4*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.4*coordinate_dofs[0] + 0.6*coordinate_dofs[2];
    y[1] = 0.4*coordinate_dofs[1] + 0.6*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.2*coordinate_dofs[0] + 0.8*coordinate_dofs[2];
    y[1] = 0.2*coordinate_dofs[1] + 0.8*coordinate_dofs[3];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
    y[0] = 0.6*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    y[1] = 0.6*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[15] = vals[0];
    y[0] = 0.4*coordinate_dofs[0] + 0.4*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    y[1] = 0.4*coordinate_dofs[1] + 0.4*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[16] = vals[0];
    y[0] = 0.2*coordinate_dofs[0] + 0.6*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    y[1] = 0.2*coordinate_dofs[1] + 0.6*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[17] = vals[0];
    y[0] = 0.4*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
    y[1] = 0.4*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[18] = vals[0];
    y[0] = 0.2*coordinate_dofs[0] + 0.4*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
    y[1] = 0.2*coordinate_dofs[1] + 0.4*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[19] = vals[0];
    y[0] = 0.2*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.6*coordinate_dofs[4];
    y[1] = 0.2*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.6*coordinate_dofs[5];
    f.evaluate(vals, y, c);
    values[20] = vals[0];
}

void poisson2d_5_finite_element_2::interpolate_vertex_values(double * vertex_values,
                                              const double * dof_values,
                                              const double * coordinate_dofs,
                                              int cell_orientation,
                                              const ufc::cell& c) const
{
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
}

void poisson2d_5_finite_element_2::tabulate_dof_coordinates(double * dof_coordinates,
                                             const double * coordinate_dofs) const
{
    dof_coordinates[0] = coordinate_dofs[0];
    dof_coordinates[1] = coordinate_dofs[1];
    dof_coordinates[2] = coordinate_dofs[2];
    dof_coordinates[3] = coordinate_dofs[3];
    dof_coordinates[4] = coordinate_dofs[4];
    dof_coordinates[5] = coordinate_dofs[5];
    dof_coordinates[6] = 0.8*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    dof_coordinates[7] = 0.8*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    dof_coordinates[8] = 0.6*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
    dof_coordinates[9] = 0.6*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
    dof_coordinates[10] = 0.4*coordinate_dofs[2] + 0.6*coordinate_dofs[4];
    dof_coordinates[11] = 0.4*coordinate_dofs[3] + 0.6*coordinate_dofs[5];
    dof_coordinates[12] = 0.2*coordinate_dofs[2] + 0.8*coordinate_dofs[4];
    dof_coordinates[13] = 0.2*coordinate_dofs[3] + 0.8*coordinate_dofs[5];
    dof_coordinates[14] = 0.8*coordinate_dofs[0] + 0.2*coordinate_dofs[4];
    dof_coordinates[15] = 0.8*coordinate_dofs[1] + 0.2*coordinate_dofs[5];
    dof_coordinates[16] = 0.6*coordinate_dofs[0] + 0.4*coordinate_dofs[4];
    dof_coordinates[17] = 0.6*coordinate_dofs[1] + 0.4*coordinate_dofs[5];
    dof_coordinates[18] = 0.4*coordinate_dofs[0] + 0.6*coordinate_dofs[4];
    dof_coordinates[19] = 0.4*coordinate_dofs[1] + 0.6*coordinate_dofs[5];
    dof_coordinates[20] = 0.2*coordinate_dofs[0] + 0.8*coordinate_dofs[4];
    dof_coordinates[21] = 0.2*coordinate_dofs[1] + 0.8*coordinate_dofs[5];
    dof_coordinates[22] = 0.8*coordinate_dofs[0] + 0.2*coordinate_dofs[2];
    dof_coordinates[23] = 0.8*coordinate_dofs[1] + 0.2*coordinate_dofs[3];
    dof_coordinates[24] = 0.6*coordinate_dofs[0] + 0.4*coordinate_dofs[2];
    dof_coordinates[25] = 0.6*coordinate_dofs[1] + 0.4*coordinate_dofs[3];
    dof_coordinates[26] = 0.4*coordinate_dofs[0] + 0.6*coordinate_dofs[2];
    dof_coordinates[27] = 0.4*coordinate_dofs[1] + 0.6*coordinate_dofs[3];
    dof_coordinates[28] = 0.2*coordinate_dofs[0] + 0.8*coordinate_dofs[2];
    dof_coordinates[29] = 0.2*coordinate_dofs[1] + 0.8*coordinate_dofs[3];
    dof_coordinates[30] = 0.6*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    dof_coordinates[31] = 0.6*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    dof_coordinates[32] = 0.4*coordinate_dofs[0] + 0.4*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    dof_coordinates[33] = 0.4*coordinate_dofs[1] + 0.4*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    dof_coordinates[34] = 0.2*coordinate_dofs[0] + 0.6*coordinate_dofs[2] + 0.2*coordinate_dofs[4];
    dof_coordinates[35] = 0.2*coordinate_dofs[1] + 0.6*coordinate_dofs[3] + 0.2*coordinate_dofs[5];
    dof_coordinates[36] = 0.4*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
    dof_coordinates[37] = 0.4*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
    dof_coordinates[38] = 0.2*coordinate_dofs[0] + 0.4*coordinate_dofs[2] + 0.4*coordinate_dofs[4];
    dof_coordinates[39] = 0.2*coordinate_dofs[1] + 0.4*coordinate_dofs[3] + 0.4*coordinate_dofs[5];
    dof_coordinates[40] = 0.2*coordinate_dofs[0] + 0.2*coordinate_dofs[2] + 0.6*coordinate_dofs[4];
    dof_coordinates[41] = 0.2*coordinate_dofs[1] + 0.2*coordinate_dofs[3] + 0.6*coordinate_dofs[5];
}

std::size_t poisson2d_5_finite_element_2::num_sub_elements() const
{
    return 0;
}

ufc::finite_element * poisson2d_5_finite_element_2::create_sub_element(std::size_t i) const
{
    return 0;
}

ufc::finite_element * poisson2d_5_finite_element_2::create() const
{
    return new poisson2d_5_finite_element_2();
}


poisson2d_5_dofmap_0::poisson2d_5_dofmap_0() : ufc::dofmap()
{
    // Do nothing
}

poisson2d_5_dofmap_0::~poisson2d_5_dofmap_0()
{
    // Do nothing
}

const char * poisson2d_5_dofmap_0::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 1)";
}

bool poisson2d_5_dofmap_0::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t poisson2d_5_dofmap_0::topological_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_dofmap_0::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0];
}

std::size_t poisson2d_5_dofmap_0::num_element_dofs() const
{
    return 3;
}

std::size_t poisson2d_5_dofmap_0::num_facet_dofs() const
{
    return 2;
}

std::size_t poisson2d_5_dofmap_0::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t poisson2d_5_dofmap_0::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 3;
        break;
      }
    }
    
    return 0;
}

void poisson2d_5_dofmap_0::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    dofs[0] = entity_indices[0][0];
    dofs[1] = entity_indices[0][1];
    dofs[2] = entity_indices[0][2];
}

void poisson2d_5_dofmap_0::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
}

void poisson2d_5_dofmap_0::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
}

void poisson2d_5_dofmap_0::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
}

std::size_t poisson2d_5_dofmap_0::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * poisson2d_5_dofmap_0::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * poisson2d_5_dofmap_0::create() const
{
    return new poisson2d_5_dofmap_0();
}


poisson2d_5_dofmap_1::poisson2d_5_dofmap_1() : ufc::dofmap()
{
    // Do nothing
}

poisson2d_5_dofmap_1::~poisson2d_5_dofmap_1()
{
    // Do nothing
}

const char * poisson2d_5_dofmap_1::signature() const
{
    return "FFC dofmap for VectorElement(FiniteElement('Lagrange', triangle, 1), dim=2)";
}

bool poisson2d_5_dofmap_1::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
}

std::size_t poisson2d_5_dofmap_1::topological_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_dofmap_1::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return 2*num_global_entities[0];
}

std::size_t poisson2d_5_dofmap_1::num_element_dofs() const
{
    return 6;
}

std::size_t poisson2d_5_dofmap_1::num_facet_dofs() const
{
    return 4;
}

std::size_t poisson2d_5_dofmap_1::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
}

std::size_t poisson2d_5_dofmap_1::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
}

void poisson2d_5_dofmap_1::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + entity_indices[0][0];
    dofs[4] = offset + entity_indices[0][1];
    dofs[5] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
}

void poisson2d_5_dofmap_1::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 4;
      dofs[3] = 5;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    }
    
}

void poisson2d_5_dofmap_1::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
}

void poisson2d_5_dofmap_1::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 5;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 4;
        dofs[3] = 5;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 3;
        dofs[3] = 4;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
        break;
      }
    }
    
}

std::size_t poisson2d_5_dofmap_1::num_sub_dofmaps() const
{
    return 2;
}

ufc::dofmap * poisson2d_5_dofmap_1::create_sub_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_0();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * poisson2d_5_dofmap_1::create() const
{
    return new poisson2d_5_dofmap_1();
}


poisson2d_5_dofmap_2::poisson2d_5_dofmap_2() : ufc::dofmap()
{
    // Do nothing
}

poisson2d_5_dofmap_2::~poisson2d_5_dofmap_2()
{
    // Do nothing
}

const char * poisson2d_5_dofmap_2::signature() const
{
    return "FFC dofmap for FiniteElement('Lagrange', triangle, 5)";
}

bool poisson2d_5_dofmap_2::needs_mesh_entities(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
}

std::size_t poisson2d_5_dofmap_2::topological_dimension() const
{
    return 2;
}

std::size_t poisson2d_5_dofmap_2::global_dimension(const std::vector<std::size_t>&
                                            num_global_entities) const
{
    return num_global_entities[0] + 4*num_global_entities[1] + 6*num_global_entities[2];
}

std::size_t poisson2d_5_dofmap_2::num_element_dofs() const
{
    return 21;
}

std::size_t poisson2d_5_dofmap_2::num_facet_dofs() const
{
    return 6;
}

std::size_t poisson2d_5_dofmap_2::num_entity_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
}

std::size_t poisson2d_5_dofmap_2::num_entity_closure_dofs(std::size_t d) const
{
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 6;
        break;
      }
    case 2:
      {
        return 21;
        break;
      }
    }
    
    return 0;
}

void poisson2d_5_dofmap_2::tabulate_dofs(std::size_t * dofs,
                                  const std::vector<std::size_t>& num_global_entities,
                                  const std::vector<std::vector<std::size_t>>& entity_indices) const
{
    unsigned int offset = 0;
    dofs[0] = offset + entity_indices[0][0];
    dofs[1] = offset + entity_indices[0][1];
    dofs[2] = offset + entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + 4*entity_indices[1][0];
    dofs[4] = offset + 4*entity_indices[1][0] + 1;
    dofs[5] = offset + 4*entity_indices[1][0] + 2;
    dofs[6] = offset + 4*entity_indices[1][0] + 3;
    dofs[7] = offset + 4*entity_indices[1][1];
    dofs[8] = offset + 4*entity_indices[1][1] + 1;
    dofs[9] = offset + 4*entity_indices[1][1] + 2;
    dofs[10] = offset + 4*entity_indices[1][1] + 3;
    dofs[11] = offset + 4*entity_indices[1][2];
    dofs[12] = offset + 4*entity_indices[1][2] + 1;
    dofs[13] = offset + 4*entity_indices[1][2] + 2;
    dofs[14] = offset + 4*entity_indices[1][2] + 3;
    offset += 4*num_global_entities[1];
    dofs[15] = offset + 6*entity_indices[2][0];
    dofs[16] = offset + 6*entity_indices[2][0] + 1;
    dofs[17] = offset + 6*entity_indices[2][0] + 2;
    dofs[18] = offset + 6*entity_indices[2][0] + 3;
    dofs[19] = offset + 6*entity_indices[2][0] + 4;
    dofs[20] = offset + 6*entity_indices[2][0] + 5;
    offset += 6*num_global_entities[2];
}

void poisson2d_5_dofmap_2::tabulate_facet_dofs(std::size_t * dofs,
                                        std::size_t facet) const
{
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 7;
      dofs[3] = 8;
      dofs[4] = 9;
      dofs[5] = 10;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
}

void poisson2d_5_dofmap_2::tabulate_entity_dofs(std::size_t * dofs,
                                         std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
        dofs[3] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 9;
        dofs[3] = 10;
          break;
        }
      case 2:
        {
          dofs[0] = 11;
        dofs[1] = 12;
        dofs[2] = 13;
        dofs[3] = 14;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 15;
      dofs[1] = 16;
      dofs[2] = 17;
      dofs[3] = 18;
      dofs[4] = 19;
      dofs[5] = 20;
        break;
      }
    }
    
}

void poisson2d_5_dofmap_2::tabulate_entity_closure_dofs(std::size_t * dofs,
                                             std::size_t d, std::size_t i) const
{
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 1;
        dofs[1] = 2;
        dofs[2] = 3;
        dofs[3] = 4;
        dofs[4] = 5;
        dofs[5] = 6;
          break;
        }
      case 1:
        {
          dofs[0] = 0;
        dofs[1] = 2;
        dofs[2] = 7;
        dofs[3] = 8;
        dofs[4] = 9;
        dofs[5] = 10;
          break;
        }
      case 2:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 11;
        dofs[3] = 12;
        dofs[4] = 13;
        dofs[5] = 14;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 3;
      dofs[4] = 4;
      dofs[5] = 5;
      dofs[6] = 6;
      dofs[7] = 7;
      dofs[8] = 8;
      dofs[9] = 9;
      dofs[10] = 10;
      dofs[11] = 11;
      dofs[12] = 12;
      dofs[13] = 13;
      dofs[14] = 14;
      dofs[15] = 15;
      dofs[16] = 16;
      dofs[17] = 17;
      dofs[18] = 18;
      dofs[19] = 19;
      dofs[20] = 20;
        break;
      }
    }
    
}

std::size_t poisson2d_5_dofmap_2::num_sub_dofmaps() const
{
    return 0;
}

ufc::dofmap * poisson2d_5_dofmap_2::create_sub_dofmap(std::size_t i) const
{
    return 0;
}

ufc::dofmap * poisson2d_5_dofmap_2::create() const
{
    return new poisson2d_5_dofmap_2();
}


poisson2d_5_cell_integral_0_otherwise::poisson2d_5_cell_integral_0_otherwise() : ufc::cell_integral()
{
    
}

poisson2d_5_cell_integral_0_otherwise::~poisson2d_5_cell_integral_0_otherwise()
{
    
}

const std::vector<bool> & poisson2d_5_cell_integral_0_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({});
    return enabled;
}

void poisson2d_5_cell_integral_0_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // This function was generated using 'tensor' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 8
    //   quadrature_rule:   'default'
    //   representation:    'tensor'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 8
    //   quadrature_degree:           8
    //   quadrature_rule:             'default'
    //   representation:              'tensor'
    
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 1275
    // Total number of operations (multiply-add pairs):                  1286
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K[0]*K[0] + K[1]*K[1]);
    const double G0_0_1 = det*(K[0]*K[2] + K[1]*K[3]);
    const double G0_1_0 = det*(K[2]*K[0] + K[3]*K[1]);
    const double G0_1_1 = det*(K[2]*K[2] + K[3]*K[3]);
    
    // Compute element tensor
    A[0] = 0.342406580687832*G0_0_0 + 0.342406580687832*G0_0_1 + 0.342406580687832*G0_1_0 + 0.342406580687833*G0_1_1;
    A[1] = -0.0409984016754843*G0_0_0 - 0.0409984016754853*G0_1_0;
    A[2] = -0.0409984016754855*G0_0_1 - 0.0409984016754858*G0_1_1;
    A[3] = -0.0408192791005282*G0_0_0 - 0.0408192791005283*G0_0_1 - 0.0408192791005298*G0_1_0 - 0.0408192791005312*G0_1_1;
    A[4] = -0.0379774305555552*G0_0_0 - 0.0379774305555538*G0_0_1 - 0.0379774305555557*G0_1_0 - 0.037977430555553*G0_1_1;
    A[5] = -0.0379774305555542*G0_0_0 - 0.0379774305555559*G0_0_1 - 0.0379774305555538*G0_1_0 - 0.0379774305555569*G0_1_1;
    A[6] = -0.0408192791005292*G0_0_0 - 0.0408192791005281*G0_0_1 - 0.0408192791005301*G0_1_0 - 0.0408192791005282*G0_1_1;
    A[7] = 0.202287946428573*G0_0_0 - 0.648027584876544*G0_0_1 + 0.202287946428574*G0_1_0 - 0.648027584876545*G0_1_1;
    A[8] = -0.0158454585537946*G0_0_0 + 0.594204695767195*G0_0_1 - 0.0158454585537934*G0_1_0 + 0.594204695767196*G0_1_1;
    A[9] = -0.0696683476631385*G0_0_0 - 0.449959352954144*G0_0_1 - 0.0696683476631384*G0_1_0 - 0.449959352954145*G0_1_1;
    A[10] = 0.0408192791005293*G0_0_0 + 0.202374063051147*G0_0_1 + 0.0408192791005302*G0_1_0 + 0.202374063051147*G0_1_1;
    A[11] = -0.648027584876545*G0_0_0 + 0.202287946428573*G0_0_1 - 0.648027584876546*G0_1_0 + 0.202287946428572*G0_1_1;
    A[12] = 0.594204695767195*G0_0_0 - 0.0158454585537927*G0_0_1 + 0.594204695767197*G0_1_0 - 0.0158454585537928*G0_1_1;
    A[13] = -0.449959352954144*G0_0_0 - 0.0696683476631389*G0_0_1 - 0.449959352954145*G0_1_0 - 0.0696683476631398*G0_1_1;
    A[14] = 0.202374063051146*G0_0_0 + 0.0408192791005282*G0_0_1 + 0.202374063051147*G0_1_0 + 0.0408192791005311*G0_1_1;
    A[15] = -0.215291556437393*G0_0_0 - 0.215291556437392*G0_0_1 - 0.215291556437394*G0_1_0 - 0.215291556437391*G0_1_1;
    A[16] = -0.0538228891093442*G0_0_0 - 0.0538228891093426*G0_0_1 - 0.0538228891093438*G0_1_0 - 0.0538228891093416*G0_1_1;
    A[17] = 0.107645778218692*G0_0_0 + 0.10764577821869*G0_0_1 + 0.107645778218694*G0_1_0 + 0.10764577821869*G0_1_1;
    A[18] = -0.053822889109343*G0_0_0 - 0.0538228891093489*G0_0_1 - 0.0538228891093439*G0_1_0 - 0.0538228891093497*G0_1_1;
    A[19] = 0.107645778218693*G0_0_0 + 0.107645778218696*G0_0_1 + 0.107645778218693*G0_1_0 + 0.107645778218696*G0_1_1;
    A[20] = 0.107645778218693*G0_0_0 + 0.107645778218694*G0_0_1 + 0.107645778218692*G0_1_0 + 0.107645778218695*G0_1_1;
    A[21] = -0.0409984016754843*G0_0_0 - 0.0409984016754853*G0_0_1;
    A[22] = 0.342406580687828*G0_0_0;
    A[23] = 0.0409984016754852*G0_0_1;
    A[24] = 0.202287946428568*G0_0_0 + 0.850315531305108*G0_0_1;
    A[25] = -0.01584545855379*G0_0_0 - 0.610050154320987*G0_0_1;
    A[26] = -0.0696683476631388*G0_0_0 + 0.380291005291007*G0_0_1;
    A[27] = 0.0408192791005288*G0_0_0 - 0.16155478395062*G0_0_1;
    A[28] = -0.0408192791005305*G0_0_0;
    A[29] = -0.0379774305555561*G0_0_0;
    A[30] = -0.0379774305555542*G0_0_0;
    A[31] = -0.0408192791005288*G0_0_0;
    A[32] = 0.202374063051144*G0_0_0 + 0.161554783950614*G0_0_1;
    A[33] = -0.449959352954139*G0_0_0 - 0.380291005290998*G0_0_1;
    A[34] = 0.594204695767187*G0_0_0 + 0.61005015432098*G0_0_1;
    A[35] = -0.648027584876536*G0_0_0 - 0.850315531305109*G0_0_1;
    A[36] = 0.107645778218699*G0_0_0;
    A[37] = -0.0538228891093544*G0_0_0 - 1.19975644002901e-14*G0_0_1;
    A[38] = -0.215291556437382*G0_0_0 + 1.06149897899366e-14*G0_0_1;
    A[39] = 0.107645778218697*G0_0_0;
    A[40] = -0.0538228891093504*G0_0_0;
    A[41] = 0.107645778218693*G0_0_0;
    A[42] = -0.0409984016754855*G0_1_0 - 0.0409984016754858*G0_1_1;
    A[43] = 0.0409984016754852*G0_1_0;
    A[44] = 0.342406580687832*G0_1_1;
    A[45] = -0.161554783950616*G0_1_0 + 0.040819279100531*G0_1_1;
    A[46] = 0.380291005291007*G0_1_0 - 0.0696683476631403*G0_1_1;
    A[47] = -0.610050154320989*G0_1_0 - 0.0158454585537892*G0_1_1;
    A[48] = 0.850315531305117*G0_1_0 + 0.20228794642857*G0_1_1;
    A[49] = 0.161554783950617*G0_1_0 + 0.202374063051148*G0_1_1;
    A[50] = -0.380291005291007*G0_1_0 - 0.449959352954148*G0_1_1;
    A[51] = 0.610050154320991*G0_1_0 + 0.594204695767201*G0_1_1;
    A[52] = -0.850315531305117*G0_1_0 - 0.648027584876547*G0_1_1;
    A[53] = -0.0408192791005315*G0_1_1;
    A[54] = -0.0379774305555565*G0_1_1;
    A[55] = -0.0379774305555558*G0_1_1;
    A[56] = -0.0408192791005301*G0_1_1;
    A[57] = 0.107645778218699*G0_1_1;
    A[58] = 0.107645778218696*G0_1_1;
    A[59] = 0.107645778218696*G0_1_1;
    A[60] = -0.0538228891093517*G0_1_1;
    A[61] = -0.0538228891093531*G0_1_1;
    A[62] = -0.215291556437383*G0_1_1;
    A[63] = -0.0408192791005282*G0_0_0 - 0.0408192791005298*G0_0_1 - 0.0408192791005283*G0_1_0 - 0.0408192791005312*G0_1_1;
    A[64] = 0.202287946428568*G0_0_0 + 0.850315531305108*G0_1_0;
    A[65] = -0.161554783950616*G0_0_1 + 0.040819279100531*G0_1_1;
    A[66] = 1.98929398148147*G0_0_0 + 1.28098476080246*G0_0_1 + 1.28098476080246*G0_1_0 + 2.56196952160492*G0_1_1;
    A[67] = -0.90637745260141*G0_0_0 + 0.796578758818337*G0_0_1 - 0.529617228835973*G0_1_0 - 1.39508928571429*G0_1_1;
    A[68] = 0.818107914462079*G0_0_0 - 0.482253086419751*G0_0_1 + 0.23251488095238*G0_1_0 + 0.895612874779549*G0_1_1;
    A[69] = -0.340160659171077*G0_0_0 + 0.329396081349201*G0_0_1 - 0.0710462136243373*G0_1_0 - 0.340160659171084*G0_1_1;
    A[70] = 0.142092427248673*G0_0_0 + 0.0710462136243391*G0_0_1 + 0.0710462136243303*G0_1_0;
    A[71] = 0.131327849426814*G0_0_0 + 0.0301408179012409*G0_0_1 + 0.0301408179012376*G0_1_0;
    A[72] = 0.172233245149909*G0_0_0 + 0.0301408179012286*G0_0_1 + 0.0301408179012378*G0_1_0;
    A[73] = 0.340160659171077*G0_0_0 + 0.0710462136243438*G0_0_1 + 0.0710462136243372*G0_1_0;
    A[74] = 0.198068231922391*G0_0_0 + 0.269114445546724*G0_0_1 + 0.269114445546731*G0_1_0 + 0.340160659171059*G0_1_1;
    A[75] = -0.359536899250425*G0_0_0 - 0.663097993827144*G0_0_1 - 0.663097993827143*G0_1_0 - 0.895612874779519*G0_1_1;
    A[76] = 0.28633777006171*G0_0_0 + 0.865472056878293*G0_0_1 + 0.86547205687828*G0_1_0 + 1.39508928571426*G0_1_1;
    A[77] = -0.286337770061716*G0_0_0 - 1.28098476080246*G0_0_1 - 1.28098476080245*G0_1_0 - 2.56196952160492*G0_1_1;
    A[78] = -0.667403824955893*G0_0_0 - 0.262655698853599*G0_0_1 - 0.262655698853599*G0_1_0 + 2.03912407792384e-14*G0_1_1;
    A[79] = 1.35633680555553*G0_0_0 + 0.572675540123428*G0_0_1 + 0.572675540123437*G0_1_0 - 3.39267459611992e-14*G0_1_1;
    A[80] = -2.82031938932978*G0_0_0 - 1.66205081569662*G0_0_1 - 1.66205081569662*G0_1_0 + 3.77942035306722e-14*G0_1_1;
    A[81] = -0.419818535052917*G0_0_0 - 0.0731991291887148*G0_0_1 - 0.0731991291887131*G0_1_0;
    A[82] = 1.19486813822751*G0_0_0 + 0.572675540123455*G0_0_1 + 0.572675540123447*G0_1_0;
    A[83] = -0.990341159611987*G0_0_0 - 0.262655698853618*G0_0_1 - 0.262655698853617*G0_1_0;
    A[84] = -0.0379774305555552*G0_0_0 - 0.0379774305555557*G0_0_1 - 0.0379774305555538*G0_1_0 - 0.037977430555553*G0_1_1;
    A[85] = -0.01584545855379*G0_0_0 - 0.610050154320987*G0_1_0;
    A[86] = 0.380291005291007*G0_0_1 - 0.0696683476631403*G0_1_1;
    A[87] = -0.90637745260141*G0_0_0 - 0.529617228835973*G0_0_1 + 0.796578758818337*G0_1_0 - 1.39508928571429*G0_1_1;
    A[88] = 3.07436342592592*G0_0_0 + 1.17549189814814*G0_0_1 + 1.17549189814814*G0_1_0 + 3.69440310846561*G0_1_1;
    A[89] = -1.80414324294533*G0_0_0 + 0.699697558421514*G0_0_1 - 0.350925236992949*G0_1_0 - 1.80414324294534*G0_1_1;
    A[90] = 0.895612874779546*G0_0_0 - 0.482253086419752*G0_0_1 + 0.232514880952381*G0_1_0 + 0.818107914462087*G0_1_1;
    A[91] = 0.131327849426808*G0_0_0 + 0.101187031525573*G0_0_1 + 0.101187031525579*G0_1_0 + 0.0710462136243349*G0_1_1;
    A[92] = -0.297102347883603*G0_0_0 - 0.148551173941801*G0_0_1 - 0.1485511739418*G0_1_0 - 0.0172233245149881*G0_1_1;
    A[93] = -0.219597387566131*G0_0_0 - 0.062434551366835*G0_0_1 - 0.062434551366846*G0_1_0 - 0.0172233245149921*G0_1_1;
    A[94] = -0.895612874779546*G0_0_0 - 0.232514880952386*G0_0_1 - 0.232514880952381*G0_1_0 + 0.071046213624342*G0_1_1;
    A[95] = 0.11195160934744*G0_0_0 + 0.142092427248673*G0_0_1 + 0.142092427248672*G0_1_0 + 0.172233245149914*G0_1_1;
    A[96] = -0.11195160934744*G0_0_0 - 0.15716283619929*G0_0_1 - 0.157162836199289*G0_1_0 - 0.219597387566132*G0_1_1;
    A[97] = 0.103339947089951*G0_0_0 + 0.133480764991187*G0_0_1 + 0.133480764991186*G0_1_0 + 0.26696152998237*G0_1_1;
    A[98] = -0.0495170579806053*G0_0_0 + 0.529617228835974*G0_0_1 + 0.529617228835973*G0_1_0 + 1.39508928571429*G0_1_1;
    A[99] = -0.344466490299814*G0_0_0 - 0.447806437389763*G0_0_1 - 0.447806437389762*G0_1_0 - 0.516699735449737*G0_1_1;
    A[100] = 0.38752480158728*G0_0_0 + 0.859013310185163*G0_0_1 + 0.859013310185157*G0_1_0 + 1.01187031525571*G0_1_1;
    A[101] = 0.731991291887133*G0_0_0 - 1.30897266313933*G0_0_1 - 1.30897266313931*G0_1_0 - 3.96136463844797*G0_1_1;
    A[102] = 1.03339947089946*G0_0_0 + 0.374607308201047*G0_0_1 + 0.374607308201049*G0_1_0 + 0.0430583112874674*G0_1_1;
    A[103] = -3.81066054894178*G0_0_0 - 1.4015480324074*G0_0_1 - 1.40154803240739*G0_1_0 + 1.01187031525574*G0_1_1;
    A[104] = 2.02374063051146*G0_0_0 + 0.413359788359796*G0_0_1 + 0.413359788359794*G0_1_0 - 0.51669973544973*G0_1_1;
    A[105] = -0.0379774305555542*G0_0_0 - 0.0379774305555538*G0_0_1 - 0.0379774305555559*G0_1_0 - 0.0379774305555569*G0_1_1;
    A[106] = -0.0696683476631388*G0_0_0 + 0.380291005291007*G0_1_0;
    A[107] = -0.610050154320989*G0_0_1 - 0.0158454585537892*G0_1_1;
    A[108] = 0.818107914462079*G0_0_0 + 0.23251488095238*G0_0_1 - 0.482253086419751*G0_1_0 + 0.895612874779549*G0_1_1;
    A[109] = -1.80414324294533*G0_0_0 - 0.350925236992949*G0_0_1 + 0.699697558421515*G0_1_0 - 1.80414324294534*G0_1_1;
    A[110] = 3.69440310846559*G0_0_0 + 1.17549189814814*G0_0_1 + 1.17549189814814*G0_1_0 + 3.07436342592593*G0_1_1;
    A[111] = -1.39508928571429*G0_0_0 + 0.796578758818335*G0_0_1 - 0.529617228835978*G0_1_0 - 0.906377452601423*G0_1_1;
    A[112] = 0.172233245149902*G0_0_0 + 0.142092427248668*G0_0_1 + 0.142092427248665*G0_1_0 + 0.111951609347439*G0_1_1;
    A[113] = -0.219597387566124*G0_0_0 - 0.157162836199278*G0_0_1 - 0.157162836199286*G0_1_0 - 0.111951609347435*G0_1_1;
    A[114] = 0.266961529982349*G0_0_0 + 0.133480764991168*G0_0_1 + 0.133480764991179*G0_1_0 + 0.103339947089945*G0_1_1;
    A[115] = 1.39508928571429*G0_0_0 + 0.529617228835988*G0_0_1 + 0.529617228835978*G0_1_0 - 0.0495170579806009*G0_1_1;
    A[116] = 0.0710462136243353*G0_0_0 + 0.101187031525571*G0_0_1 + 0.101187031525571*G0_1_0 + 0.131327849426796*G0_1_1;
    A[117] = -0.0172233245149892*G0_0_0 - 0.148551173941795*G0_0_1 - 0.148551173941796*G0_1_0 - 0.297102347883595*G0_1_1;
    A[118] = -0.0172233245149931*G0_0_0 - 0.0624345513668473*G0_0_1 - 0.062434551366848*G0_1_0 - 0.219597387566146*G0_1_1;
    A[119] = 0.0710462136243392*G0_0_0 - 0.232514880952381*G0_0_1 - 0.232514880952378*G0_1_0 - 0.895612874779549*G0_1_1;
    A[120] = -0.516699735449717*G0_0_0 - 0.447806437389767*G0_0_1 - 0.447806437389753*G0_1_0 - 0.344466490299806*G0_1_1;
    A[121] = 0.0430583112874718*G0_0_0 + 0.374607308201054*G0_0_1 + 0.37460730820105*G0_1_0 + 1.03339947089946*G0_1_1;
    A[122] = -0.516699735449731*G0_0_0 + 0.413359788359802*G0_0_1 + 0.413359788359791*G0_1_0 + 2.02374063051149*G0_1_1;
    A[123] = 1.01187031525571*G0_0_0 + 0.859013310185181*G0_0_1 + 0.859013310185168*G0_1_0 + 0.387524801587294*G0_1_1;
    A[124] = 1.01187031525574*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 - 3.81066054894179*G0_1_1;
    A[125] = -3.96136463844794*G0_0_0 - 1.30897266313932*G0_0_1 - 1.30897266313931*G0_1_0 + 0.731991291887133*G0_1_1;
    A[126] = -0.0408192791005292*G0_0_0 - 0.0408192791005301*G0_0_1 - 0.0408192791005281*G0_1_0 - 0.0408192791005282*G0_1_1;
    A[127] = 0.0408192791005288*G0_0_0 - 0.16155478395062*G0_1_0;
    A[128] = 0.850315531305117*G0_0_1 + 0.20228794642857*G0_1_1;
    A[129] = -0.340160659171077*G0_0_0 - 0.0710462136243373*G0_0_1 + 0.329396081349201*G0_1_0 - 0.340160659171084*G0_1_1;
    A[130] = 0.895612874779546*G0_0_0 + 0.232514880952381*G0_0_1 - 0.482253086419752*G0_1_0 + 0.818107914462087*G0_1_1;
    A[131] = -1.39508928571429*G0_0_0 - 0.529617228835978*G0_0_1 + 0.796578758818334*G0_1_0 - 0.906377452601423*G0_1_1;
    A[132] = 2.56196952160495*G0_0_0 + 1.28098476080247*G0_0_1 + 1.28098476080247*G0_1_0 + 1.98929398148149*G0_1_1;
    A[133] = 0.340160659171078*G0_0_0 + 0.26911444554674*G0_0_1 + 0.269114445546739*G0_1_0 + 0.198068231922397*G0_1_1;
    A[134] = -0.895612874779549*G0_0_0 - 0.663097993827168*G0_0_1 - 0.663097993827159*G0_1_0 - 0.359536899250439*G0_1_1;
    A[135] = 1.3950892857143*G0_0_0 + 0.865472056878319*G0_0_1 + 0.86547205687831*G0_1_0 + 0.28633777006173*G0_1_1;
    A[136] = -2.56196952160495*G0_0_0 - 1.28098476080248*G0_0_1 - 1.28098476080247*G0_1_0 - 0.286337770061729*G0_1_1;
    A[137] = 0.0710462136243353*G0_0_1 + 0.071046213624336*G0_1_0 + 0.142092427248678*G0_1_1;
    A[138] = 0.0301408179012361*G0_0_1 + 0.0301408179012369*G0_1_0 + 0.131327849426813*G0_1_1;
    A[139] = 0.0301408179012351*G0_0_1 + 0.0301408179012354*G0_1_0 + 0.172233245149914*G0_1_1;
    A[140] = 0.0710462136243407*G0_0_1 + 0.071046213624339*G0_1_0 + 0.340160659171086*G0_1_1;
    A[141] = -0.262655698853611*G0_0_1 - 0.262655698853611*G0_1_0 - 0.66740382495591*G0_1_1;
    A[142] = -0.0731991291887124*G0_0_1 - 0.0731991291887162*G0_1_0 - 0.419818535052912*G0_1_1;
    A[143] = -0.262655698853615*G0_0_1 - 0.26265569885361*G0_1_0 - 0.990341159611998*G0_1_1;
    A[144] = 0.572675540123446*G0_0_1 + 0.572675540123452*G0_1_0 + 1.35633680555555*G0_1_1;
    A[145] = 0.572675540123444*G0_0_1 + 0.572675540123454*G0_1_0 + 1.19486813822751*G0_1_1;
    A[146] = -1.66205081569664*G0_0_1 - 1.66205081569664*G0_1_0 - 2.8203193893298*G0_1_1;
    A[147] = 0.202287946428574*G0_0_0 + 0.202287946428574*G0_0_1 - 0.648027584876544*G0_1_0 - 0.648027584876545*G0_1_1;
    A[148] = -0.0408192791005305*G0_0_0;
    A[149] = 0.161554783950617*G0_0_1 + 0.202374063051148*G0_1_1;
    A[150] = 0.142092427248673*G0_0_0 + 0.0710462136243303*G0_0_1 + 0.0710462136243391*G0_1_0;
    A[151] = 0.131327849426808*G0_0_0 + 0.101187031525579*G0_0_1 + 0.101187031525573*G0_1_0 + 0.0710462136243349*G0_1_1;
    A[152] = 0.172233245149902*G0_0_0 + 0.142092427248665*G0_0_1 + 0.142092427248668*G0_1_0 + 0.11195160934744*G0_1_1;
    A[153] = 0.340160659171078*G0_0_0 + 0.269114445546739*G0_0_1 + 0.26911444554674*G0_1_0 + 0.198068231922397*G0_1_1;
    A[154] = 1.98929398148149*G0_0_0 + 0.708309220679014*G0_0_1 + 0.708309220679014*G0_1_0 + 1.98929398148148*G0_1_1;
    A[155] = -0.906377452601407*G0_0_0 - 1.70295621141976*G0_0_1 - 0.376760223765427*G0_1_0 - 2.56842826829806*G0_1_1;
    A[156] = 0.818107914462078*G0_0_0 + 1.30036100088184*G0_0_1 + 0.585593033509697*G0_1_0 + 1.96345899470899*G0_1_1;
    A[157] = -0.340160659171078*G0_0_0 - 0.669556740520286*G0_0_1 - 0.26911444554674*G0_1_0 - 0.938671186067022*G0_1_1;
    A[158] = -0.286337770061734*G0_0_0 + 0.994646990740739*G0_0_1 + 0.994646990740744*G0_1_0 - 0.286337770061725*G0_1_1;
    A[159] = 0.286337770061734*G0_0_0 - 0.579134286816573*G0_0_1 - 0.579134286816579*G0_1_0 - 0.0495170579805968*G0_1_1;
    A[160] = -0.359536899250446*G0_0_0 + 0.303561094576718*G0_0_1 + 0.30356109457672*G0_1_0 + 0.0710462136243445*G0_1_1;
    A[161] = 0.198068231922402*G0_0_0 - 0.0710462136243347*G0_0_1 - 0.0710462136243411*G0_1_0;
    A[162] = -2.82031938932981*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 + 0.503782242063493*G0_1_1;
    A[163] = 1.35633680555555*G0_0_0 + 0.783661265432093*G0_0_1 + 0.783661265432096*G0_1_0 + 0.210985725308632*G0_1_1;
    A[164] = -0.667403824955903*G0_0_0 - 0.404748126102296*G0_0_1 - 0.404748126102295*G0_1_0 - 0.142092427248674*G0_1_1;
    A[165] = 1.1948681382275*G0_0_0 + 0.622192598104034*G0_0_1 + 0.622192598104043*G0_1_0 + 0.0495170579805964*G0_1_1;
    A[166] = -0.419818535052905*G0_0_0 - 0.346619405864182*G0_0_1 - 0.34661940586419*G0_1_0 - 0.273420276675481*G0_1_1;
    A[167] = -0.990341159611981*G0_0_0 - 0.727685460758366*G0_0_1 - 0.727685460758365*G0_1_0 - 0.465029761904756*G0_1_1;
    A[168] = -0.0158454585537946*G0_0_0 - 0.0158454585537934*G0_0_1 + 0.594204695767195*G0_1_0 + 0.594204695767196*G0_1_1;
    A[169] = -0.0379774305555561*G0_0_0;
    A[170] = -0.380291005291007*G0_0_1 - 0.449959352954148*G0_1_1;
    A[171] = 0.131327849426814*G0_0_0 + 0.0301408179012376*G0_0_1 + 0.0301408179012409*G0_1_0;
    A[172] = -0.297102347883603*G0_0_0 - 0.1485511739418*G0_0_1 - 0.148551173941801*G0_1_0 - 0.0172233245149881*G0_1_1;
    A[173] = -0.219597387566124*G0_0_0 - 0.157162836199286*G0_0_1 - 0.157162836199278*G0_1_0 - 0.111951609347435*G0_1_1;
    A[174] = -0.895612874779549*G0_0_0 - 0.663097993827159*G0_0_1 - 0.663097993827168*G0_1_0 - 0.359536899250439*G0_1_1;
    A[175] = -0.906377452601407*G0_0_0 - 0.376760223765427*G0_0_1 - 1.70295621141976*G0_1_0 - 2.56842826829806*G0_1_1;
    A[176] = 3.07436342592592*G0_0_0 + 1.89887152777777*G0_0_1 + 1.89887152777777*G0_1_0 + 4.41778273809524*G0_1_1;
    A[177] = -1.80414324294532*G0_0_0 - 2.50384080136684*G0_0_1 - 1.45321800595238*G0_1_0 - 3.95705880731923*G0_1_1;
    A[178] = 0.89561287477955*G0_0_0 + 1.3778659611993*G0_0_1 + 0.663097993827169*G0_1_0 + 1.963458994709*G0_1_1;
    A[179] = -0.0495170579805933*G0_0_0 - 0.579134286816576*G0_0_1 - 0.579134286816579*G0_1_0 + 0.286337770061723*G0_1_1;
    A[180] = 0.103339947089945*G0_0_0 - 0.030140817901236*G0_0_1 - 0.0301408179012354*G0_1_0 + 0.103339947089943*G0_1_1;
    A[181] = -0.111951609347443*G0_0_0 + 0.0452112268518503*G0_0_1 + 0.0452112268518522*G0_1_0 - 0.0172233245149984*G0_1_1;
    A[182] = 0.111951609347443*G0_0_0 - 0.0301408179012376*G0_0_1 - 0.0301408179012332*G0_1_0;
    A[183] = 0.731991291887113*G0_0_0 + 2.04096395502645*G0_0_1 + 2.04096395502645*G0_1_0 - 0.611428020282189*G0_1_1;
    A[184] = 0.387524801587306*G0_0_0 - 0.47148850859788*G0_0_1 - 0.471488508597885*G0_1_0 - 0.318631503527332*G0_1_1;
    A[185] = -0.344466490299828*G0_0_0 + 0.103339947089947*G0_0_1 + 0.103339947089948*G0_1_0 + 0.0344466490299801*G0_1_1;
    A[186] = -3.81066054894179*G0_0_0 - 2.40911251653437*G0_0_1 - 2.40911251653438*G0_1_0 + 0.00430583112875937*G0_1_1;
    A[187] = 1.03339947089947*G0_0_0 + 0.658792162698409*G0_0_1 + 0.658792162698406*G0_1_0 + 0.327243165784831*G0_1_1;
    A[188] = 2.02374063051145*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215166*G0_1_0 + 0.68032131834214*G0_1_1;
    A[189] = -0.0696683476631385*G0_0_0 - 0.0696683476631384*G0_0_1 - 0.449959352954144*G0_1_0 - 0.449959352954145*G0_1_1;
    A[190] = -0.0379774305555542*G0_0_0;
    A[191] = 0.610050154320991*G0_0_1 + 0.594204695767201*G0_1_1;
    A[192] = 0.172233245149909*G0_0_0 + 0.0301408179012378*G0_0_1 + 0.0301408179012286*G0_1_0;
    A[193] = -0.219597387566131*G0_0_0 - 0.062434551366846*G0_0_1 - 0.0624345513668351*G0_1_0 - 0.0172233245149921*G0_1_1;
    A[194] = 0.266961529982349*G0_0_0 + 0.133480764991179*G0_0_1 + 0.133480764991168*G0_1_0 + 0.103339947089945*G0_1_1;
    A[195] = 1.3950892857143*G0_0_0 + 0.865472056878311*G0_0_1 + 0.865472056878319*G0_1_0 + 0.28633777006173*G0_1_1;
    A[196] = 0.818107914462078*G0_0_0 + 0.585593033509697*G0_0_1 + 1.30036100088184*G0_1_0 + 1.96345899470899*G0_1_1;
    A[197] = -1.80414324294532*G0_0_0 - 1.45321800595238*G0_0_1 - 2.50384080136684*G0_1_0 - 3.95705880731923*G0_1_1;
    A[198] = 3.6944031084656*G0_0_0 + 2.51891121031746*G0_0_1 + 2.51891121031746*G0_1_0 + 4.41778273809524*G0_1_1;
    A[199] = -1.3950892857143*G0_0_0 - 2.19166804453264*G0_0_1 - 0.865472056878321*G0_1_0 - 2.56842826829807*G0_1_1;
    A[200] = 0.0710462136243364*G0_0_0 + 0.303561094576721*G0_0_1 + 0.303561094576719*G0_1_0 - 0.359536899250437*G0_1_1;
    A[201] = -0.0172233245149914*G0_0_0 + 0.0452112268518536*G0_0_1 + 0.0452112268518523*G0_1_0 - 0.111951609347443*G0_1_1;
    A[202] = -0.0172233245149895*G0_0_0 + 0.131327849426809*G0_0_1 + 0.131327849426808*G0_1_0 - 0.0172233245149865*G0_1_1;
    A[203] = 0.0710462136243363*G0_0_0 - 0.0301408179012389*G0_0_1 - 0.0301408179012354*G0_1_0;
    A[204] = -0.516699735449726*G0_0_0 - 0.930059523809526*G0_0_1 - 0.930059523809521*G0_1_0 + 0.680321318342152*G0_1_1;
    A[205] = 0.0430583112874754*G0_0_0 - 0.331548996913582*G0_0_1 - 0.331548996913578*G0_1_0 + 0.327243165784834*G0_1_1;
    A[206] = -0.516699735449733*G0_0_0 - 0.0688932980599591*G0_0_1 - 0.0688932980599654*G0_1_0 + 0.0344466490299841*G0_1_1;
    A[207] = 1.01187031525572*G0_0_0 + 2.41341834766313*G0_0_1 + 2.41341834766313*G0_1_0 + 0.00430583112874061*G0_1_1;
    A[208] = 1.01187031525573*G0_0_0 + 0.152857005070547*G0_0_1 + 0.152857005070545*G0_1_0 - 0.318631503527343*G0_1_1;
    A[209] = -3.96136463844795*G0_0_0 - 2.65239197530863*G0_0_1 - 2.65239197530863*G0_1_0 - 0.61142802028218*G0_1_1;
    A[210] = 0.0408192791005293*G0_0_0 + 0.0408192791005302*G0_0_1 + 0.202374063051147*G0_1_0 + 0.202374063051147*G0_1_1;
    A[211] = -0.0408192791005288*G0_0_0;
    A[212] = -0.850315531305117*G0_0_1 - 0.648027584876547*G0_1_1;
    A[213] = 0.340160659171077*G0_0_0 + 0.0710462136243372*G0_0_1 + 0.0710462136243438*G0_1_0;
    A[214] = -0.895612874779546*G0_0_0 - 0.232514880952381*G0_0_1 - 0.232514880952386*G0_1_0 + 0.071046213624342*G0_1_1;
    A[215] = 1.39508928571429*G0_0_0 + 0.529617228835978*G0_0_1 + 0.529617228835988*G0_1_0 - 0.049517057980601*G0_1_1;
    A[216] = -2.56196952160495*G0_0_0 - 1.28098476080247*G0_0_1 - 1.28098476080248*G0_1_0 - 0.286337770061729*G0_1_1;
    A[217] = -0.340160659171078*G0_0_0 - 0.26911444554674*G0_0_1 - 0.669556740520286*G0_1_0 - 0.938671186067022*G0_1_1;
    A[218] = 0.89561287477955*G0_0_0 + 0.663097993827169*G0_0_1 + 1.3778659611993*G0_1_0 + 1.963458994709*G0_1_1;
    A[219] = -1.3950892857143*G0_0_0 - 0.865472056878321*G0_0_1 - 2.19166804453264*G0_1_0 - 2.56842826829807*G0_1_1;
    A[220] = 2.56196952160495*G0_0_0 + 1.28098476080248*G0_0_1 + 1.28098476080248*G0_1_0 + 1.9892939814815*G0_1_1;
    A[221] = -0.0710462136243352*G0_0_1 - 0.0710462136243383*G0_1_0 + 0.198068231922397*G0_1_1;
    A[222] = -0.0301408179012362*G0_0_1 - 0.0301408179012355*G0_1_0 + 0.111951609347442*G0_1_1;
    A[223] = -0.0301408179012352*G0_0_1 - 0.0301408179012347*G0_1_0 + 0.0710462136243351*G0_1_1;
    A[224] = -0.0710462136243405*G0_0_1 - 0.0710462136243385*G0_1_0;
    A[225] = 0.262655698853612*G0_0_1 + 0.262655698853615*G0_1_0 - 0.465029761904764*G0_1_1;
    A[226] = 0.0731991291887123*G0_0_1 + 0.0731991291887096*G0_1_0 - 0.273420276675488*G0_1_1;
    A[227] = 0.262655698853615*G0_0_1 + 0.262655698853616*G0_1_0 - 0.142092427248679*G0_1_1;
    A[228] = -0.572675540123448*G0_0_1 - 0.572675540123456*G0_1_0 + 0.0495170579806033*G0_1_1;
    A[229] = -0.572675540123444*G0_0_1 - 0.572675540123452*G0_1_0 + 0.210985725308652*G0_1_1;
    A[230] = 1.66205081569664*G0_0_1 + 1.66205081569665*G0_1_0 + 0.503782242063488*G0_1_1;
    A[231] = -0.648027584876545*G0_0_0 - 0.648027584876546*G0_0_1 + 0.202287946428573*G0_1_0 + 0.202287946428572*G0_1_1;
    A[232] = 0.202374063051144*G0_0_0 + 0.161554783950614*G0_1_0;
    A[233] = -0.0408192791005315*G0_1_1;
    A[234] = 0.198068231922392*G0_0_0 + 0.269114445546731*G0_0_1 + 0.269114445546724*G0_1_0 + 0.340160659171059*G0_1_1;
    A[235] = 0.11195160934744*G0_0_0 + 0.142092427248671*G0_0_1 + 0.142092427248673*G0_1_0 + 0.172233245149914*G0_1_1;
    A[236] = 0.0710462136243353*G0_0_0 + 0.101187031525571*G0_0_1 + 0.101187031525571*G0_1_0 + 0.131327849426796*G0_1_1;
    A[237] = 0.071046213624336*G0_0_1 + 0.0710462136243353*G0_1_0 + 0.142092427248678*G0_1_1;
    A[238] = -0.286337770061734*G0_0_0 + 0.994646990740744*G0_0_1 + 0.994646990740739*G0_1_0 - 0.286337770061725*G0_1_1;
    A[239] = -0.0495170579805933*G0_0_0 - 0.579134286816579*G0_0_1 - 0.579134286816576*G0_1_0 + 0.286337770061723*G0_1_1;
    A[240] = 0.0710462136243364*G0_0_0 + 0.303561094576719*G0_0_1 + 0.303561094576721*G0_1_0 - 0.359536899250437*G0_1_1;
    A[241] = -0.0710462136243384*G0_0_1 - 0.0710462136243352*G0_1_0 + 0.198068231922397*G0_1_1;
    A[242] = 1.98929398148148*G0_0_0 + 0.708309220679007*G0_0_1 + 0.708309220679007*G0_1_0 + 1.98929398148148*G0_1_1;
    A[243] = -2.56842826829805*G0_0_0 - 0.376760223765424*G0_0_1 - 1.70295621141975*G0_1_0 - 0.906377452601396*G0_1_1;
    A[244] = 1.96345899470899*G0_0_0 + 0.585593033509691*G0_0_1 + 1.30036100088182*G0_1_0 + 0.81810791446207*G0_1_1;
    A[245] = -0.938671186067014*G0_0_0 - 0.269114445546733*G0_0_1 - 0.669556740520274*G0_1_0 - 0.340160659171064*G0_1_1;
    A[246] = 0.503782242063505*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 - 2.8203193893298*G0_1_1;
    A[247] = 0.0495170579805803*G0_0_0 + 0.622192598104035*G0_0_1 + 0.622192598104038*G0_1_0 + 1.19486813822749*G0_1_1;
    A[248] = -0.465029761904743*G0_0_0 - 0.727685460758355*G0_0_1 - 0.727685460758356*G0_1_0 - 0.990341159611981*G0_1_1;
    A[249] = 0.210985725308632*G0_0_0 + 0.783661265432099*G0_0_1 + 0.783661265432093*G0_1_0 + 1.35633680555554*G0_1_1;
    A[250] = -0.273420276675478*G0_0_0 - 0.346619405864191*G0_0_1 - 0.34661940586419*G0_1_0 - 0.419818535052892*G0_1_1;
    A[251] = -0.142092427248672*G0_0_0 - 0.40474812610229*G0_0_1 - 0.404748126102293*G0_1_0 - 0.667403824955904*G0_1_1;
    A[252] = 0.594204695767195*G0_0_0 + 0.594204695767197*G0_0_1 - 0.0158454585537928*G0_1_0 - 0.0158454585537928*G0_1_1;
    A[253] = -0.449959352954139*G0_0_0 - 0.380291005290998*G0_1_0;
    A[254] = -0.0379774305555565*G0_1_1;
    A[255] = -0.359536899250425*G0_0_0 - 0.663097993827143*G0_0_1 - 0.663097993827144*G0_1_0 - 0.895612874779519*G0_1_1;
    A[256] = -0.11195160934744*G0_0_0 - 0.157162836199289*G0_0_1 - 0.15716283619929*G0_1_0 - 0.219597387566132*G0_1_1;
    A[257] = -0.0172233245149892*G0_0_0 - 0.148551173941796*G0_0_1 - 0.148551173941795*G0_1_0 - 0.297102347883595*G0_1_1;
    A[258] = 0.0301408179012368*G0_0_1 + 0.0301408179012361*G0_1_0 + 0.131327849426813*G0_1_1;
    A[259] = 0.286337770061734*G0_0_0 - 0.579134286816579*G0_0_1 - 0.579134286816573*G0_1_0 - 0.0495170579805968*G0_1_1;
    A[260] = 0.103339947089945*G0_0_0 - 0.0301408179012354*G0_0_1 - 0.030140817901236*G0_1_0 + 0.103339947089943*G0_1_1;
    A[261] = -0.0172233245149914*G0_0_0 + 0.0452112268518524*G0_0_1 + 0.0452112268518536*G0_1_0 - 0.111951609347443*G0_1_1;
    A[262] = -0.0301408179012356*G0_0_1 - 0.0301408179012363*G0_1_0 + 0.111951609347442*G0_1_1;
    A[263] = -2.56842826829805*G0_0_0 - 1.70295621141975*G0_0_1 - 0.376760223765424*G0_1_0 - 0.906377452601396*G0_1_1;
    A[264] = 4.41778273809522*G0_0_0 + 1.89887152777776*G0_0_1 + 1.89887152777776*G0_1_0 + 3.0743634259259*G0_1_1;
    A[265] = -3.9570588073192*G0_0_0 - 1.45321800595236*G0_0_1 - 2.50384080136682*G0_1_0 - 1.8041432429453*G0_1_1;
    A[266] = 1.96345899470898*G0_0_0 + 0.663097993827146*G0_0_1 + 1.37786596119927*G0_1_0 + 0.89561287477952*G0_1_1;
    A[267] = -0.611428020282206*G0_0_0 + 2.04096395502644*G0_0_1 + 2.04096395502643*G0_1_0 + 0.731991291887105*G0_1_1;
    A[268] = 0.00430583112878178*G0_0_0 - 2.40911251653436*G0_0_1 - 2.40911251653436*G0_1_0 - 3.81066054894177*G0_1_1;
    A[269] = 0.680321318342118*G0_0_0 + 1.61038084215164*G0_0_1 + 1.61038084215164*G0_1_0 + 2.02374063051142*G0_1_1;
    A[270] = -0.318631503527333*G0_0_0 - 0.471488508597885*G0_0_1 - 0.47148850859788*G0_1_0 + 0.387524801587314*G0_1_1;
    A[271] = 0.327243165784826*G0_0_0 + 0.658792162698406*G0_0_1 + 0.658792162698406*G0_1_0 + 1.03339947089947*G0_1_1;
    A[272] = 0.0344466490299817*G0_0_0 + 0.103339947089947*G0_0_1 + 0.103339947089943*G0_1_0 - 0.344466490299829*G0_1_1;
    A[273] = -0.449959352954144*G0_0_0 - 0.449959352954145*G0_0_1 - 0.0696683476631389*G0_1_0 - 0.0696683476631398*G0_1_1;
    A[274] = 0.594204695767187*G0_0_0 + 0.61005015432098*G0_1_0;
    A[275] = -0.0379774305555558*G0_1_1;
    A[276] = 0.28633777006171*G0_0_0 + 0.86547205687828*G0_0_1 + 0.865472056878293*G0_1_0 + 1.39508928571426*G0_1_1;
    A[277] = 0.103339947089951*G0_0_0 + 0.133480764991186*G0_0_1 + 0.133480764991187*G0_1_0 + 0.266961529982369*G0_1_1;
    A[278] = -0.0172233245149931*G0_0_0 - 0.062434551366848*G0_0_1 - 0.0624345513668473*G0_1_0 - 0.219597387566145*G0_1_1;
    A[279] = 0.0301408179012355*G0_0_1 + 0.0301408179012351*G0_1_0 + 0.172233245149914*G0_1_1;
    A[280] = -0.359536899250446*G0_0_0 + 0.30356109457672*G0_0_1 + 0.303561094576718*G0_1_0 + 0.0710462136243445*G0_1_1;
    A[281] = -0.111951609347443*G0_0_0 + 0.0452112268518521*G0_0_1 + 0.0452112268518503*G0_1_0 - 0.0172233245149984*G0_1_1;
    A[282] = -0.0172233245149895*G0_0_0 + 0.131327849426808*G0_0_1 + 0.131327849426809*G0_1_0 - 0.0172233245149865*G0_1_1;
    A[283] = -0.0301408179012348*G0_0_1 - 0.0301408179012352*G0_1_0 + 0.0710462136243351*G0_1_1;
    A[284] = 1.96345899470899*G0_0_0 + 1.30036100088182*G0_0_1 + 0.585593033509691*G0_1_0 + 0.81810791446207*G0_1_1;
    A[285] = -3.9570588073192*G0_0_0 - 2.50384080136682*G0_0_1 - 1.45321800595236*G0_1_0 - 1.8041432429453*G0_1_1;
    A[286] = 4.41778273809521*G0_0_0 + 2.51891121031743*G0_0_1 + 2.51891121031743*G0_1_0 + 3.69440310846558*G0_1_1;
    A[287] = -2.56842826829804*G0_0_0 - 0.865472056878283*G0_0_1 - 2.19166804453261*G0_1_0 - 1.39508928571427*G0_1_1;
    A[288] = 0.680321318342169*G0_0_0 - 0.930059523809514*G0_0_1 - 0.93005952380951*G0_1_0 - 0.516699735449723*G0_1_1;
    A[289] = 0.00430583112871508*G0_0_0 + 2.4134183476631*G0_0_1 + 2.41341834766311*G0_1_0 + 1.01187031525569*G0_1_1;
    A[290] = -0.61142802028215*G0_0_0 - 2.65239197530861*G0_0_1 - 2.65239197530861*G0_1_0 - 3.96136463844794*G0_1_1;
    A[291] = 0.327243165784832*G0_0_0 - 0.331548996913579*G0_0_1 - 0.331548996913585*G0_1_0 + 0.0430583112874714*G0_1_1;
    A[292] = -0.318631503527338*G0_0_0 + 0.152857005070551*G0_0_1 + 0.152857005070546*G0_1_0 + 1.01187031525574*G0_1_1;
    A[293] = 0.0344466490299816*G0_0_0 - 0.0688932980599656*G0_0_1 - 0.0688932980599621*G0_1_0 - 0.516699735449731*G0_1_1;
    A[294] = 0.202374063051146*G0_0_0 + 0.202374063051147*G0_0_1 + 0.0408192791005282*G0_1_0 + 0.0408192791005311*G0_1_1;
    A[295] = -0.648027584876536*G0_0_0 - 0.850315531305109*G0_1_0;
    A[296] = -0.0408192791005301*G0_1_1;
    A[297] = -0.286337770061716*G0_0_0 - 1.28098476080245*G0_0_1 - 1.28098476080246*G0_1_0 - 2.56196952160492*G0_1_1;
    A[298] = -0.0495170579806053*G0_0_0 + 0.529617228835973*G0_0_1 + 0.529617228835974*G0_1_0 + 1.39508928571429*G0_1_1;
    A[299] = 0.0710462136243393*G0_0_0 - 0.232514880952378*G0_0_1 - 0.232514880952381*G0_1_0 - 0.895612874779549*G0_1_1;
    A[300] = 0.071046213624339*G0_0_1 + 0.0710462136243407*G0_1_0 + 0.340160659171086*G0_1_1;
    A[301] = 0.198068231922402*G0_0_0 - 0.0710462136243411*G0_0_1 - 0.0710462136243347*G0_1_0;
    A[302] = 0.111951609347443*G0_0_0 - 0.0301408179012332*G0_0_1 - 0.0301408179012376*G0_1_0;
    A[303] = 0.0710462136243363*G0_0_0 - 0.0301408179012354*G0_0_1 - 0.0301408179012389*G0_1_0;
    A[304] = -0.0710462136243385*G0_0_1 - 0.0710462136243405*G0_1_0;
    A[305] = -0.938671186067014*G0_0_0 - 0.669556740520274*G0_0_1 - 0.269114445546733*G0_1_0 - 0.340160659171064*G0_1_1;
    A[306] = 1.96345899470898*G0_0_0 + 1.37786596119927*G0_0_1 + 0.663097993827146*G0_1_0 + 0.895612874779521*G0_1_1;
    A[307] = -2.56842826829804*G0_0_0 - 2.19166804453261*G0_0_1 - 0.865472056878283*G0_1_0 - 1.39508928571427*G0_1_1;
    A[308] = 1.98929398148146*G0_0_0 + 1.28098476080245*G0_0_1 + 1.28098476080245*G0_1_0 + 2.56196952160493*G0_1_1;
    A[309] = -0.465029761904772*G0_0_0 + 0.262655698853608*G0_0_1 + 0.262655698853602*G0_1_0 - 1.78808790690654e-14*G0_1_1;
    A[310] = 0.0495170579806194*G0_0_0 - 0.572675540123429*G0_0_1 - 0.572675540123439*G0_1_0 + 3.31987042023751e-14*G0_1_1;
    A[311] = 0.503782242063468*G0_0_0 + 1.66205081569663*G0_0_1 + 1.66205081569663*G0_1_0 - 3.23910820040907e-14*G0_1_1;
    A[312] = -0.273420276675487*G0_0_0 + 0.0731991291887111*G0_0_1 + 0.0731991291887115*G0_1_0;
    A[313] = 0.210985725308648*G0_0_0 - 0.57267554012346*G0_0_1 - 0.572675540123447*G0_1_0;
    A[314] = -0.142092427248675*G0_0_0 + 0.262655698853616*G0_0_1 + 0.262655698853619*G0_1_0;
    A[315] = -0.215291556437393*G0_0_0 - 0.215291556437394*G0_0_1 - 0.215291556437392*G0_1_0 - 0.215291556437391*G0_1_1;
    A[316] = 0.107645778218699*G0_0_0;
    A[317] = 0.107645778218699*G0_1_1;
    A[318] = -0.667403824955892*G0_0_0 - 0.262655698853599*G0_0_1 - 0.262655698853599*G0_1_0 + 2.03322601810552e-14*G0_1_1;
    A[319] = -0.344466490299814*G0_0_0 - 0.447806437389762*G0_0_1 - 0.447806437389763*G0_1_0 - 0.516699735449737*G0_1_1;
    A[320] = -0.516699735449717*G0_0_0 - 0.447806437389753*G0_0_1 - 0.447806437389767*G0_1_0 - 0.344466490299806*G0_1_1;
    A[321] = -0.262655698853611*G0_0_1 - 0.262655698853611*G0_1_0 - 0.66740382495591*G0_1_1;
    A[322] = -2.82031938932981*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 + 0.503782242063493*G0_1_1;
    A[323] = 0.731991291887113*G0_0_0 + 2.04096395502645*G0_0_1 + 2.04096395502645*G0_1_0 - 0.61142802028219*G0_1_1;
    A[324] = -0.516699735449726*G0_0_0 - 0.93005952380952*G0_0_1 - 0.930059523809526*G0_1_0 + 0.680321318342152*G0_1_1;
    A[325] = 0.262655698853615*G0_0_1 + 0.262655698853611*G0_1_0 - 0.465029761904765*G0_1_1;
    A[326] = 0.503782242063505*G0_0_0 - 1.15826857363315*G0_0_1 - 1.15826857363315*G0_1_0 - 2.8203193893298*G0_1_1;
    A[327] = -0.611428020282206*G0_0_0 + 2.04096395502643*G0_0_1 + 2.04096395502644*G0_1_0 + 0.731991291887105*G0_1_1;
    A[328] = 0.680321318342169*G0_0_0 - 0.93005952380951*G0_0_1 - 0.930059523809514*G0_1_0 - 0.516699735449723*G0_1_1;
    A[329] = -0.465029761904772*G0_0_0 + 0.262655698853602*G0_0_1 + 0.262655698853607*G0_1_0 - 1.78531234934498e-14*G0_1_1;
    A[330] = 7.06156305114637*G0_0_0 + 3.10019841269839*G0_0_1 + 3.10019841269839*G0_1_0 + 7.06156305114637*G0_1_1;
    A[331] = -6.32957175925923*G0_0_0 - 3.05714010141091*G0_0_1 - 3.05714010141091*G0_1_0 - 1.80844907407404*G0_1_1;
    A[332] = 2.75573192239857*G0_0_0 + 1.37786596119927*G0_0_1 + 1.37786596119927*G0_1_0 + 1.03339947089946*G0_1_1;
    A[333] = -1.80844907407404*G0_0_0 - 3.0571401014109*G0_0_1 - 3.05714010141091*G0_1_0 - 6.32957175925925*G0_1_1;
    A[334] = 1.42092427248675*G0_0_0 + 1.46398258377423*G0_0_1 + 1.46398258377423*G0_1_0 + 1.42092427248674*G0_1_1;
    A[335] = 1.03339947089945*G0_0_0 + 1.37786596119928*G0_0_1 + 1.37786596119929*G0_1_0 + 2.75573192239858*G0_1_1;
    A[336] = -0.0538228891093442*G0_0_0 - 0.0538228891093437*G0_0_1 - 0.0538228891093426*G0_1_0 - 0.0538228891093416*G0_1_1;
    A[337] = -0.0538228891093545*G0_0_0 - 1.19767477185784e-14*G0_1_0;
    A[338] = 0.107645778218696*G0_1_1;
    A[339] = 1.35633680555553*G0_0_0 + 0.572675540123437*G0_0_1 + 0.572675540123428*G0_1_0 - 3.38711263897506e-14*G0_1_1;
    A[340] = 0.38752480158728*G0_0_0 + 0.859013310185157*G0_0_1 + 0.859013310185163*G0_1_0 + 1.01187031525571*G0_1_1;
    A[341] = 0.0430583112874718*G0_0_0 + 0.37460730820105*G0_0_1 + 0.374607308201054*G0_1_0 + 1.03339947089946*G0_1_1;
    A[342] = -0.0731991291887162*G0_0_1 - 0.0731991291887123*G0_1_0 - 0.419818535052912*G0_1_1;
    A[343] = 1.35633680555555*G0_0_0 + 0.783661265432096*G0_0_1 + 0.783661265432093*G0_1_0 + 0.210985725308632*G0_1_1;
    A[344] = 0.387524801587306*G0_0_0 - 0.471488508597885*G0_0_1 - 0.47148850859788*G0_1_0 - 0.318631503527332*G0_1_1;
    A[345] = 0.0430583112874754*G0_0_0 - 0.331548996913578*G0_0_1 - 0.331548996913582*G0_1_0 + 0.327243165784834*G0_1_1;
    A[346] = 0.0731991291887097*G0_0_1 + 0.0731991291887123*G0_1_0 - 0.273420276675488*G0_1_1;
    A[347] = 0.04951705798058*G0_0_0 + 0.622192598104038*G0_0_1 + 0.622192598104035*G0_1_0 + 1.19486813822749*G0_1_1;
    A[348] = 0.00430583112878189*G0_0_0 - 2.40911251653436*G0_0_1 - 2.40911251653436*G0_1_0 - 3.81066054894177*G0_1_1;
    A[349] = 0.00430583112871451*G0_0_0 + 2.41341834766311*G0_0_1 + 2.4134183476631*G0_1_0 + 1.01187031525569*G0_1_1;
    A[350] = 0.0495170579806194*G0_0_0 - 0.572675540123439*G0_0_1 - 0.572675540123429*G0_1_0 + 3.31982705215061e-14*G0_1_1;
    A[351] = -6.32957175925923*G0_0_0 - 3.05714010141091*G0_0_1 - 3.05714010141091*G0_1_0 - 1.80844907407404*G0_1_1;
    A[352] = 9.94646990740737*G0_0_0 + 4.97323495370366*G0_0_1 + 4.97323495370366*G0_1_0 + 8.65472056878304*G0_1_1;
    A[353] = -6.32957175925922*G0_0_0 - 3.27243165784826*G0_0_1 - 3.27243165784827*G0_1_0 - 2.0237406305114*G0_1_1;
    A[354] = -0.387524801587326*G0_0_0 + 2.55120494378305*G0_0_1 + 2.55120494378306*G0_1_0 - 0.387524801587332*G0_1_1;
    A[355] = -0.387524801587264*G0_0_0 - 2.93872974537035*G0_0_1 - 2.93872974537034*G0_1_0 - 5.87745949074073*G0_1_1;
    A[356] = -0.0861166225749491*G0_0_0 - 0.0430583112874673*G0_0_1 - 0.0430583112874748*G0_1_0 + 1.42092427248678*G0_1_1;
    A[357] = 0.107645778218692*G0_0_0 + 0.107645778218694*G0_0_1 + 0.10764577821869*G0_1_0 + 0.10764577821869*G0_1_1;
    A[358] = -0.215291556437382*G0_0_0 + 1.06010577920201e-14*G0_1_0;
    A[359] = 0.107645778218696*G0_1_1;
    A[360] = -2.82031938932978*G0_0_0 - 1.66205081569662*G0_0_1 - 1.66205081569662*G0_1_0 + 3.76831812282097e-14*G0_1_1;
    A[361] = 0.731991291887133*G0_0_0 - 1.30897266313931*G0_0_1 - 1.30897266313933*G0_1_0 - 3.96136463844797*G0_1_1;
    A[362] = -0.516699735449731*G0_0_0 + 0.413359788359791*G0_0_1 + 0.413359788359802*G0_1_0 + 2.02374063051149*G0_1_1;
    A[363] = -0.26265569885361*G0_0_1 - 0.262655698853615*G0_1_0 - 0.990341159611998*G0_1_1;
    A[364] = -0.667403824955903*G0_0_0 - 0.404748126102295*G0_0_1 - 0.404748126102296*G0_1_0 - 0.142092427248674*G0_1_1;
    A[365] = -0.344466490299828*G0_0_0 + 0.103339947089948*G0_0_1 + 0.103339947089947*G0_1_0 + 0.0344466490299801*G0_1_1;
    A[366] = -0.516699735449733*G0_0_0 - 0.0688932980599654*G0_0_1 - 0.0688932980599591*G0_1_0 + 0.0344466490299841*G0_1_1;
    A[367] = 0.262655698853616*G0_0_1 + 0.262655698853615*G0_1_0 - 0.142092427248679*G0_1_1;
    A[368] = -0.465029761904743*G0_0_0 - 0.727685460758356*G0_0_1 - 0.727685460758355*G0_1_0 - 0.990341159611981*G0_1_1;
    A[369] = 0.680321318342118*G0_0_0 + 1.61038084215164*G0_0_1 + 1.61038084215164*G0_1_0 + 2.02374063051142*G0_1_1;
    A[370] = -0.61142802028215*G0_0_0 - 2.65239197530861*G0_0_1 - 2.65239197530861*G0_1_0 - 3.96136463844794*G0_1_1;
    A[371] = 0.503782242063468*G0_0_0 + 1.66205081569663*G0_0_1 + 1.66205081569663*G0_1_0 - 3.22801681218454e-14*G0_1_1;
    A[372] = 2.75573192239857*G0_0_0 + 1.37786596119927*G0_0_1 + 1.37786596119927*G0_1_0 + 1.03339947089946*G0_1_1;
    A[373] = -6.32957175925922*G0_0_0 - 3.27243165784827*G0_0_1 - 3.27243165784826*G0_1_0 - 2.0237406305114*G0_1_1;
    A[374] = 7.06156305114633*G0_0_0 + 3.96136463844791*G0_0_1 + 3.96136463844791*G0_1_0 + 7.92272927689589*G0_1_1;
    A[375] = 1.42092427248679*G0_0_0 - 0.0430583112874649*G0_0_1 - 0.0430583112874601*G0_1_0 - 0.086116622574935*G0_1_1;
    A[376] = -1.80844907407409*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733684*G0_1_0 - 2.02374063051149*G0_1_1;
    A[377] = 1.03339947089946*G0_0_0 - 0.344466490299832*G0_0_1 - 0.344466490299841*G0_1_0 + 1.03339947089945*G0_1_1;
    A[378] = -0.053822889109343*G0_0_0 - 0.0538228891093439*G0_0_1 - 0.0538228891093489*G0_1_0 - 0.0538228891093498*G0_1_1;
    A[379] = 0.107645778218697*G0_0_0;
    A[380] = -0.0538228891093517*G0_1_1;
    A[381] = -0.419818535052917*G0_0_0 - 0.0731991291887132*G0_0_1 - 0.0731991291887148*G0_1_0;
    A[382] = 1.03339947089946*G0_0_0 + 0.374607308201049*G0_0_1 + 0.374607308201047*G0_1_0 + 0.0430583112874674*G0_1_1;
    A[383] = 1.01187031525571*G0_0_0 + 0.859013310185168*G0_0_1 + 0.859013310185181*G0_1_0 + 0.387524801587294*G0_1_1;
    A[384] = 0.572675540123452*G0_0_1 + 0.572675540123446*G0_1_0 + 1.35633680555555*G0_1_1;
    A[385] = 1.1948681382275*G0_0_0 + 0.622192598104043*G0_0_1 + 0.622192598104034*G0_1_0 + 0.0495170579805962*G0_1_1;
    A[386] = -3.81066054894179*G0_0_0 - 2.40911251653438*G0_0_1 - 2.40911251653437*G0_1_0 + 0.00430583112875935*G0_1_1;
    A[387] = 1.01187031525572*G0_0_0 + 2.41341834766313*G0_0_1 + 2.41341834766313*G0_1_0 + 0.00430583112874044*G0_1_1;
    A[388] = -0.572675540123456*G0_0_1 - 0.572675540123448*G0_1_0 + 0.0495170579806036*G0_1_1;
    A[389] = 0.210985725308633*G0_0_0 + 0.783661265432092*G0_0_1 + 0.783661265432099*G0_1_0 + 1.35633680555554*G0_1_1;
    A[390] = -0.318631503527333*G0_0_0 - 0.47148850859788*G0_0_1 - 0.471488508597884*G0_1_0 + 0.387524801587314*G0_1_1;
    A[391] = 0.327243165784832*G0_0_0 - 0.331548996913585*G0_0_1 - 0.331548996913579*G0_1_0 + 0.0430583112874713*G0_1_1;
    A[392] = -0.273420276675487*G0_0_0 + 0.0731991291887115*G0_0_1 + 0.0731991291887111*G0_1_0;
    A[393] = -1.80844907407404*G0_0_0 - 3.05714010141091*G0_0_1 - 3.0571401014109*G0_1_0 - 6.32957175925925*G0_1_1;
    A[394] = -0.387524801587326*G0_0_0 + 2.55120494378306*G0_0_1 + 2.55120494378305*G0_1_0 - 0.387524801587332*G0_1_1;
    A[395] = 1.42092427248679*G0_0_0 - 0.0430583112874602*G0_0_1 - 0.043058311287465*G0_1_0 - 0.086116622574935*G0_1_1;
    A[396] = 8.65472056878304*G0_0_0 + 4.97323495370366*G0_0_1 + 4.97323495370366*G0_1_0 + 9.9464699074074*G0_1_1;
    A[397] = -5.87745949074072*G0_0_0 - 2.93872974537035*G0_0_1 - 2.93872974537034*G0_1_0 - 0.38752480158728*G0_1_1;
    A[398] = -2.02374063051144*G0_0_0 - 3.2724316578483*G0_0_1 - 3.27243165784831*G0_1_0 - 6.32957175925925*G0_1_1;
    A[399] = 0.107645778218693*G0_0_0 + 0.107645778218693*G0_0_1 + 0.107645778218696*G0_1_0 + 0.107645778218696*G0_1_1;
    A[400] = -0.0538228891093504*G0_0_0;
    A[401] = -0.0538228891093531*G0_1_1;
    A[402] = 1.19486813822751*G0_0_0 + 0.572675540123447*G0_0_1 + 0.572675540123455*G0_1_0;
    A[403] = -3.81066054894178*G0_0_0 - 1.40154803240739*G0_0_1 - 1.4015480324074*G0_1_0 + 1.01187031525574*G0_1_1;
    A[404] = 1.01187031525574*G0_0_0 - 1.4015480324074*G0_0_1 - 1.4015480324074*G0_1_0 - 3.81066054894179*G0_1_1;
    A[405] = 0.572675540123454*G0_0_1 + 0.572675540123444*G0_1_0 + 1.19486813822751*G0_1_1;
    A[406] = -0.419818535052905*G0_0_0 - 0.34661940586419*G0_0_1 - 0.346619405864182*G0_1_0 - 0.273420276675481*G0_1_1;
    A[407] = 1.03339947089947*G0_0_0 + 0.658792162698406*G0_0_1 + 0.658792162698409*G0_1_0 + 0.327243165784831*G0_1_1;
    A[408] = 1.01187031525573*G0_0_0 + 0.152857005070545*G0_0_1 + 0.152857005070547*G0_1_0 - 0.318631503527343*G0_1_1;
    A[409] = -0.572675540123452*G0_0_1 - 0.572675540123444*G0_1_0 + 0.210985725308652*G0_1_1;
    A[410] = -0.273420276675478*G0_0_0 - 0.34661940586419*G0_0_1 - 0.346619405864191*G0_1_0 - 0.419818535052892*G0_1_1;
    A[411] = 0.327243165784826*G0_0_0 + 0.658792162698406*G0_0_1 + 0.658792162698406*G0_1_0 + 1.03339947089947*G0_1_1;
    A[412] = -0.318631503527338*G0_0_0 + 0.152857005070547*G0_0_1 + 0.152857005070551*G0_1_0 + 1.01187031525574*G0_1_1;
    A[413] = 0.210985725308648*G0_0_0 - 0.572675540123447*G0_0_1 - 0.57267554012346*G0_1_0;
    A[414] = 1.42092427248675*G0_0_0 + 1.46398258377423*G0_0_1 + 1.46398258377423*G0_1_0 + 1.42092427248674*G0_1_1;
    A[415] = -0.387524801587265*G0_0_0 - 2.93872974537034*G0_0_1 - 2.93872974537035*G0_1_0 - 5.87745949074073*G0_1_1;
    A[416] = -1.80844907407409*G0_0_0 + 1.24869102733684*G0_0_1 + 1.24869102733685*G0_1_0 - 2.02374063051149*G0_1_1;
    A[417] = -5.87745949074072*G0_0_0 - 2.93872974537034*G0_0_1 - 2.93872974537035*G0_1_0 - 0.38752480158728*G0_1_1;
    A[418] = 8.65472056878302*G0_0_0 + 3.68148561507933*G0_0_1 + 3.68148561507933*G0_1_0 + 8.65472056878305*G0_1_1;
    A[419] = -2.02374063051146*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733685*G0_1_0 - 1.80844907407408*G0_1_1;
    A[420] = 0.107645778218693*G0_0_0 + 0.107645778218692*G0_0_1 + 0.107645778218694*G0_1_0 + 0.107645778218695*G0_1_1;
    A[421] = 0.107645778218693*G0_0_0;
    A[422] = -0.215291556437383*G0_1_1;
    A[423] = -0.990341159611987*G0_0_0 - 0.262655698853617*G0_0_1 - 0.262655698853618*G0_1_0;
    A[424] = 2.02374063051146*G0_0_0 + 0.413359788359794*G0_0_1 + 0.413359788359795*G0_1_0 - 0.51669973544973*G0_1_1;
    A[425] = -3.96136463844794*G0_0_0 - 1.30897266313931*G0_0_1 - 1.30897266313932*G0_1_0 + 0.731991291887133*G0_1_1;
    A[426] = -1.66205081569664*G0_0_1 - 1.66205081569664*G0_1_0 - 2.8203193893298*G0_1_1;
    A[427] = -0.990341159611981*G0_0_0 - 0.727685460758365*G0_0_1 - 0.727685460758366*G0_1_0 - 0.465029761904756*G0_1_1;
    A[428] = 2.02374063051145*G0_0_0 + 1.61038084215166*G0_0_1 + 1.61038084215166*G0_1_0 + 0.68032131834214*G0_1_1;
    A[429] = -3.96136463844795*G0_0_0 - 2.65239197530863*G0_0_1 - 2.65239197530863*G0_1_0 - 0.61142802028218*G0_1_1;
    A[430] = 1.66205081569665*G0_0_1 + 1.66205081569664*G0_1_0 + 0.503782242063488*G0_1_1;
    A[431] = -0.142092427248672*G0_0_0 - 0.404748126102293*G0_0_1 - 0.40474812610229*G0_1_0 - 0.667403824955904*G0_1_1;
    A[432] = 0.0344466490299817*G0_0_0 + 0.103339947089943*G0_0_1 + 0.103339947089947*G0_1_0 - 0.344466490299829*G0_1_1;
    A[433] = 0.0344466490299816*G0_0_0 - 0.0688932980599621*G0_0_1 - 0.0688932980599656*G0_1_0 - 0.516699735449731*G0_1_1;
    A[434] = -0.142092427248675*G0_0_0 + 0.262655698853619*G0_0_1 + 0.262655698853616*G0_1_0;
    A[435] = 1.03339947089945*G0_0_0 + 1.37786596119929*G0_0_1 + 1.37786596119928*G0_1_0 + 2.75573192239858*G0_1_1;
    A[436] = -0.0861166225749491*G0_0_0 - 0.0430583112874749*G0_0_1 - 0.0430583112874673*G0_1_0 + 1.42092427248678*G0_1_1;
    A[437] = 1.03339947089946*G0_0_0 - 0.344466490299841*G0_0_1 - 0.344466490299832*G0_1_0 + 1.03339947089945*G0_1_1;
    A[438] = -2.02374063051144*G0_0_0 - 3.27243165784831*G0_0_1 - 3.2724316578483*G0_1_0 - 6.32957175925925*G0_1_1;
    A[439] = -2.02374063051146*G0_0_0 + 1.24869102733685*G0_0_1 + 1.24869102733685*G0_1_0 - 1.80844907407408*G0_1_1;
    A[440] = 7.92272927689589*G0_0_0 + 3.96136463844795*G0_0_1 + 3.96136463844795*G0_1_0 + 7.06156305114636*G0_1_1;
}


poisson2d_5_cell_integral_1_otherwise::poisson2d_5_cell_integral_1_otherwise() : ufc::cell_integral()
{
    
}

poisson2d_5_cell_integral_1_otherwise::~poisson2d_5_cell_integral_1_otherwise()
{
    
}

const std::vector<bool> & poisson2d_5_cell_integral_1_otherwise::enabled_coefficients() const
{
    static const std::vector<bool> enabled({true});
    return enabled;
}

void poisson2d_5_cell_integral_1_otherwise::tabulate_tensor(double * A,
                                    const double * const * w,
                                    const double * coordinate_dofs,
                                    int cell_orientation) const
{
    // This function was generated using 'tensor' representation
    // with the following integrals metadata:
    // 
    //   num_cells:         None
    //   quadrature_degree: 10
    //   quadrature_rule:   'default'
    //   representation:    'tensor'
    // 
    // and the following integral 0 metadata:
    // 
    //   estimated_polynomial_degree: 10
    //   quadrature_degree:           10
    //   quadrature_rule:             'default'
    //   representation:              'tensor'
    
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    21
    // Number of operations (multiply-add pairs) for tensor contraction: 430
    // Total number of operations (multiply-add pairs):                  454
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, coordinate_dofs);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    const double G0_6 = det*w[0][6]*(1.0);
    const double G0_7 = det*w[0][7]*(1.0);
    const double G0_8 = det*w[0][8]*(1.0);
    const double G0_9 = det*w[0][9]*(1.0);
    const double G0_10 = det*w[0][10]*(1.0);
    const double G0_11 = det*w[0][11]*(1.0);
    const double G0_12 = det*w[0][12]*(1.0);
    const double G0_13 = det*w[0][13]*(1.0);
    const double G0_14 = det*w[0][14]*(1.0);
    const double G0_15 = det*w[0][15]*(1.0);
    const double G0_16 = det*w[0][16]*(1.0);
    const double G0_17 = det*w[0][17]*(1.0);
    const double G0_18 = det*w[0][18]*(1.0);
    const double G0_19 = det*w[0][19]*(1.0);
    const double G0_20 = det*w[0][20]*(1.0);
    
    // Compute element tensor
    A[0] = 0.00138945256132756*G0_0 + 0.000123877456776762*G0_1 + 0.000123877456776762*G0_2 + 0.000363647010782428*G0_3 + 0.00020720181310459*G0_4 + 0.000207201813104588*G0_5 + 0.000363647010782428*G0_6 + 0.00118136348605098*G0_7 - 0.000958243145743139*G0_8 + 0.000462681126743622*G0_9 - 2.29644326866518e-05*G0_10 + 0.00118136348605098*G0_11 - 0.000958243145743143*G0_12 + 0.000462681126743625*G0_13 - 2.29644326866519e-05*G0_14 + 0.000892481361231349*G0_15 - 0.000974683591871097*G0_16 + 0.000879433388113943*G0_17 - 0.000974683591871086*G0_18 + 0.000649789061247384*G0_19 + 0.000879433388113938*G0_20;
    A[1] = 0.000123877456776762*G0_0 + 0.00138945256132756*G0_1 + 0.000123877456776762*G0_2 + 0.00118136348605098*G0_3 - 0.000958243145743146*G0_4 + 0.000462681126743627*G0_5 - 2.29644326866565e-05*G0_6 + 0.000363647010782428*G0_7 + 0.00020720181310459*G0_8 + 0.000207201813104592*G0_9 + 0.000363647010782426*G0_10 - 2.29644326866552e-05*G0_11 + 0.000462681126743629*G0_12 - 0.00095824314574315*G0_13 + 0.00118136348605099*G0_14 + 0.000879433388113943*G0_15 - 0.000974683591871098*G0_16 + 0.00089248136123136*G0_17 + 0.000649789061247394*G0_18 - 0.000974683591871091*G0_19 + 0.00087943338811394*G0_20;
    A[2] = 0.000123877456776762*G0_0 + 0.000123877456776762*G0_1 + 0.00138945256132756*G0_2 - 2.29644326866554e-05*G0_3 + 0.000462681126743624*G0_4 - 0.000958243145743145*G0_5 + 0.00118136348605098*G0_6 - 2.29644326866537e-05*G0_7 + 0.000462681126743625*G0_8 - 0.000958243145743145*G0_9 + 0.00118136348605099*G0_10 + 0.000363647010782429*G0_11 + 0.000207201813104591*G0_12 + 0.000207201813104592*G0_13 + 0.000363647010782427*G0_14 + 0.000879433388113943*G0_15 + 0.000649789061247399*G0_16 + 0.000879433388113938*G0_17 - 0.000974683591871096*G0_18 - 0.000974683591871099*G0_19 + 0.000892481361231361*G0_20;
    A[3] = 0.000363647010782428*G0_0 + 0.00118136348605098*G0_1 - 2.29644326866554e-05*G0_2 + 0.0147050657033296*G0_3 - 0.00958373625474319*G0_4 + 0.00770482812583507*G0_5 - 0.00396984582097429*G0_6 - 0.000411011153198656*G0_7 - 0.00144832501603334*G0_8 - 4.56679059109585e-05*G0_9 - 0.00248237688558869*G0_10 - 0.0024823768855887*G0_11 + 0.00576068013133987*G0_12 - 0.00735253285166481*G0_13 + 0.00735253285166482*G0_14 + 0.000782878387045064*G0_15 - 0.00381653213684465*G0_16 + 0.0102426588971728*G0_17 - 0.00137003717732885*G0_18 + 9.78597983806293e-05*G0_19 - 0.00280531422024477*G0_20;
    A[4] = 0.00020720181310459*G0_0 - 0.000958243145743146*G0_1 + 0.000462681126743624*G0_2 - 0.00958373625474319*G0_3 + 0.0220771705146705*G0_4 - 0.0134785562302923*G0_5 + 0.00770482812583507*G0_6 - 0.00144832501603335*G0_7 + 0.0028183621933622*G0_8 - 0.00135698920421143*G0_9 + 0.00576068013133986*G0_10 - 4.56679059109598e-05*G0_11 - 0.00135698920421143*G0_12 + 0.00294884192453639*G0_13 - 0.00735253285166481*G0_14 + 0.00313151354818019*G0_15 - 0.00548014870931537*G0_16 - 0.00143527704291594*G0_17 - 0.000587158790283786*G0_18 + 0.00528442911255411*G0_19 + 0.00508870951579285*G0_20;
    A[5] = 0.000207201813104588*G0_0 + 0.000462681126743627*G0_1 - 0.000958243145743145*G0_2 + 0.00770482812583507*G0_3 - 0.0134785562302923*G0_4 + 0.0220771705146705*G0_5 - 0.0095837362547432*G0_6 - 4.5667905910956e-05*G0_7 - 0.00135698920421143*G0_8 + 0.00294884192453637*G0_9 - 0.0073525328516648*G0_10 - 0.00144832501603335*G0_11 + 0.0028183621933622*G0_12 - 0.00135698920421143*G0_13 + 0.00576068013133986*G0_14 + 0.00313151354818024*G0_15 - 0.000587158790283786*G0_16 + 0.00508870951579287*G0_17 - 0.00548014870931539*G0_18 + 0.00528442911255411*G0_19 - 0.00143527704291595*G0_20;
    A[6] = 0.000363647010782428*G0_0 - 2.29644326866565e-05*G0_1 + 0.00118136348605098*G0_2 - 0.00396984582097429*G0_3 + 0.00770482812583507*G0_4 - 0.0095837362547432*G0_5 + 0.0147050657033296*G0_6 - 0.00248237688558869*G0_7 + 0.00576068013133985*G0_8 - 0.0073525328516648*G0_9 + 0.00735253285166479*G0_10 - 0.000411011153198652*G0_11 - 0.00144832501603336*G0_12 - 4.56679059109556e-05*G0_13 - 0.0024823768855887*G0_14 + 0.000782878387045034*G0_15 - 0.00137003717732884*G0_16 - 0.00280531422024479*G0_17 - 0.00381653213684462*G0_18 + 9.78597983806358e-05*G0_19 + 0.0102426588971728*G0_20;
    A[7] = 0.00118136348605098*G0_0 + 0.000363647010782428*G0_1 - 2.29644326866538e-05*G0_2 - 0.000411011153198656*G0_3 - 0.00144832501603335*G0_4 - 4.5667905910956e-05*G0_5 - 0.00248237688558869*G0_6 + 0.0147050657033296*G0_7 - 0.00958373625474319*G0_8 + 0.00770482812583506*G0_9 - 0.0039698458209743*G0_10 + 0.00735253285166479*G0_11 - 0.00735253285166479*G0_12 + 0.00576068013133985*G0_13 - 0.00248237688558869*G0_14 + 0.0102426588971728*G0_15 - 0.00381653213684464*G0_16 + 0.000782878387045047*G0_17 + 9.78597983806228e-05*G0_18 - 0.00137003717732884*G0_19 - 0.00280531422024477*G0_20;
    A[8] = -0.000958243145743139*G0_0 + 0.00020720181310459*G0_1 + 0.000462681126743625*G0_2 - 0.00144832501603334*G0_3 + 0.0028183621933622*G0_4 - 0.00135698920421143*G0_5 + 0.00576068013133985*G0_6 - 0.00958373625474319*G0_7 + 0.0220771705146705*G0_8 - 0.0134785562302923*G0_9 + 0.00770482812583508*G0_10 - 0.00735253285166479*G0_11 + 0.00294884192453636*G0_12 - 0.00135698920421142*G0_13 - 4.56679059109612e-05*G0_14 - 0.00143527704291594*G0_15 - 0.00548014870931537*G0_16 + 0.00313151354818022*G0_17 + 0.00528442911255412*G0_18 - 0.000587158790283785*G0_19 + 0.00508870951579284*G0_20;
    A[9] = 0.000462681126743622*G0_0 + 0.000207201813104592*G0_1 - 0.000958243145743145*G0_2 - 4.56679059109587e-05*G0_3 - 0.00135698920421143*G0_4 + 0.00294884192453637*G0_5 - 0.0073525328516648*G0_6 + 0.00770482812583506*G0_7 - 0.0134785562302923*G0_8 + 0.0220771705146705*G0_9 - 0.00958373625474322*G0_10 + 0.00576068013133985*G0_11 - 0.00135698920421142*G0_12 + 0.00281836219336219*G0_13 - 0.00144832501603335*G0_14 + 0.00508870951579286*G0_15 - 0.000587158790283796*G0_16 + 0.00313151354818022*G0_17 + 0.00528442911255409*G0_18 - 0.00548014870931537*G0_19 - 0.00143527704291591*G0_20;
    A[10] = -2.29644326866518e-05*G0_0 + 0.000363647010782426*G0_1 + 0.00118136348605099*G0_2 - 0.00248237688558869*G0_3 + 0.00576068013133986*G0_4 - 0.0073525328516648*G0_5 + 0.00735253285166479*G0_6 - 0.0039698458209743*G0_7 + 0.00770482812583508*G0_8 - 0.00958373625474322*G0_9 + 0.0147050657033296*G0_10 - 0.00248237688558869*G0_11 - 4.56679059109657e-05*G0_12 - 0.00144832501603335*G0_13 - 0.000411011153198654*G0_14 - 0.0028053142202448*G0_15 - 0.00137003717732885*G0_16 + 0.000782878387045044*G0_17 + 9.78597983806445e-05*G0_18 - 0.00381653213684462*G0_19 + 0.0102426588971728*G0_20;
    A[11] = 0.00118136348605098*G0_0 - 2.29644326866551e-05*G0_1 + 0.000363647010782429*G0_2 - 0.0024823768855887*G0_3 - 4.56679059109596e-05*G0_4 - 0.00144832501603335*G0_5 - 0.000411011153198652*G0_6 + 0.00735253285166479*G0_7 - 0.00735253285166479*G0_8 + 0.00576068013133985*G0_9 - 0.00248237688558869*G0_10 + 0.0147050657033296*G0_11 - 0.0095837362547432*G0_12 + 0.00770482812583507*G0_13 - 0.0039698458209743*G0_14 + 0.0102426588971728*G0_15 + 9.78597983806231e-05*G0_16 - 0.00280531422024477*G0_17 - 0.00381653213684464*G0_18 - 0.00137003717732884*G0_19 + 0.000782878387045057*G0_20;
    A[12] = -0.000958243145743143*G0_0 + 0.000462681126743629*G0_1 + 0.000207201813104591*G0_2 + 0.00576068013133987*G0_3 - 0.00135698920421143*G0_4 + 0.0028183621933622*G0_5 - 0.00144832501603336*G0_6 - 0.00735253285166479*G0_7 + 0.00294884192453636*G0_8 - 0.00135698920421142*G0_9 - 4.56679059109653e-05*G0_10 - 0.0095837362547432*G0_11 + 0.0220771705146705*G0_12 - 0.0134785562302924*G0_13 + 0.00770482812583509*G0_14 - 0.00143527704291593*G0_15 + 0.00528442911255412*G0_16 + 0.00508870951579287*G0_17 - 0.00548014870931538*G0_18 - 0.000587158790283803*G0_19 + 0.00313151354818021*G0_20;
    A[13] = 0.000462681126743625*G0_0 - 0.00095824314574315*G0_1 + 0.000207201813104592*G0_2 - 0.00735253285166481*G0_3 + 0.00294884192453639*G0_4 - 0.00135698920421143*G0_5 - 4.56679059109556e-05*G0_6 + 0.00576068013133985*G0_7 - 0.00135698920421142*G0_8 + 0.00281836219336219*G0_9 - 0.00144832501603335*G0_10 + 0.00770482812583507*G0_11 - 0.0134785562302924*G0_12 + 0.0220771705146705*G0_13 - 0.00958373625474323*G0_14 + 0.00508870951579286*G0_15 + 0.00528442911255411*G0_16 - 0.00143527704291593*G0_17 - 0.000587158790283798*G0_18 - 0.00548014870931537*G0_19 + 0.00313151354818022*G0_20;
    A[14] = -2.2964432686652e-05*G0_0 + 0.00118136348605099*G0_1 + 0.000363647010782427*G0_2 + 0.00735253285166482*G0_3 - 0.00735253285166481*G0_4 + 0.00576068013133986*G0_5 - 0.0024823768855887*G0_6 - 0.00248237688558869*G0_7 - 4.56679059109613e-05*G0_8 - 0.00144832501603335*G0_9 - 0.000411011153198654*G0_10 - 0.0039698458209743*G0_11 + 0.00770482812583509*G0_12 - 0.00958373625474323*G0_13 + 0.0147050657033296*G0_14 - 0.00280531422024477*G0_15 + 9.78597983806202e-05*G0_16 + 0.0102426588971728*G0_17 - 0.00137003717732885*G0_18 - 0.00381653213684463*G0_19 + 0.000782878387045049*G0_20;
    A[15] = 0.000892481361231349*G0_0 + 0.000879433388113942*G0_1 + 0.000879433388113943*G0_2 + 0.000782878387045064*G0_3 + 0.00313151354818019*G0_4 + 0.00313151354818024*G0_5 + 0.000782878387045034*G0_6 + 0.0102426588971728*G0_7 - 0.00143527704291594*G0_8 + 0.00508870951579286*G0_9 - 0.0028053142202448*G0_10 + 0.0102426588971728*G0_11 - 0.00143527704291593*G0_12 + 0.00508870951579285*G0_13 - 0.00280531422024477*G0_14 + 0.0704590548340548*G0_15 - 0.0156575677409011*G0_16 + 0.0117431758056758*G0_17 - 0.015657567740901*G0_18 + 0.00391439193522524*G0_19 + 0.0117431758056758*G0_20;
    A[16] = -0.000974683591871097*G0_0 - 0.000974683591871098*G0_1 + 0.000649789061247399*G0_2 - 0.00381653213684465*G0_3 - 0.00548014870931537*G0_4 - 0.000587158790283786*G0_5 - 0.00137003717732884*G0_6 - 0.00381653213684464*G0_7 - 0.00548014870931537*G0_8 - 0.000587158790283797*G0_9 - 0.00137003717732885*G0_10 + 9.78597983806231e-05*G0_11 + 0.00528442911255411*G0_12 + 0.00528442911255411*G0_13 + 9.78597983806202e-05*G0_14 - 0.0156575677409011*G0_15 + 0.0763306427368927*G0_16 - 0.015657567740901*G0_17 - 0.0117431758056758*G0_18 - 0.0117431758056758*G0_19 + 0.00391439193522524*G0_20;
    A[17] = 0.000879433388113943*G0_0 + 0.00089248136123136*G0_1 + 0.000879433388113938*G0_2 + 0.0102426588971728*G0_3 - 0.00143527704291595*G0_4 + 0.00508870951579287*G0_5 - 0.00280531422024479*G0_6 + 0.000782878387045047*G0_7 + 0.00313151354818022*G0_8 + 0.00313151354818022*G0_9 + 0.000782878387045045*G0_10 - 0.00280531422024477*G0_11 + 0.00508870951579287*G0_12 - 0.00143527704291593*G0_13 + 0.0102426588971728*G0_14 + 0.0117431758056758*G0_15 - 0.015657567740901*G0_16 + 0.0704590548340548*G0_17 + 0.00391439193522526*G0_18 - 0.0156575677409011*G0_19 + 0.0117431758056758*G0_20;
    A[18] = -0.000974683591871086*G0_0 + 0.000649789061247394*G0_1 - 0.000974683591871097*G0_2 - 0.00137003717732885*G0_3 - 0.000587158790283786*G0_4 - 0.00548014870931539*G0_5 - 0.00381653213684462*G0_6 + 9.7859798380623e-05*G0_7 + 0.00528442911255412*G0_8 + 0.00528442911255409*G0_9 + 9.78597983806444e-05*G0_10 - 0.00381653213684464*G0_11 - 0.00548014870931538*G0_12 - 0.000587158790283799*G0_13 - 0.00137003717732885*G0_14 - 0.015657567740901*G0_15 - 0.0117431758056758*G0_16 + 0.00391439193522525*G0_17 + 0.0763306427368927*G0_18 - 0.0117431758056758*G0_19 - 0.015657567740901*G0_20;
    A[19] = 0.000649789061247384*G0_0 - 0.000974683591871091*G0_1 - 0.000974683591871099*G0_2 + 9.78597983806301e-05*G0_3 + 0.00528442911255411*G0_4 + 0.00528442911255411*G0_5 + 9.78597983806356e-05*G0_6 - 0.00137003717732884*G0_7 - 0.000587158790283785*G0_8 - 0.00548014870931537*G0_9 - 0.00381653213684462*G0_10 - 0.00137003717732884*G0_11 - 0.000587158790283803*G0_12 - 0.00548014870931537*G0_13 - 0.00381653213684463*G0_14 + 0.00391439193522524*G0_15 - 0.0117431758056758*G0_16 - 0.0156575677409011*G0_17 - 0.0117431758056758*G0_18 + 0.0763306427368927*G0_19 - 0.0156575677409011*G0_20;
    A[20] = 0.000879433388113938*G0_0 + 0.00087943338811394*G0_1 + 0.000892481361231361*G0_2 - 0.00280531422024477*G0_3 + 0.00508870951579285*G0_4 - 0.00143527704291595*G0_5 + 0.0102426588971728*G0_6 - 0.00280531422024477*G0_7 + 0.00508870951579284*G0_8 - 0.00143527704291591*G0_9 + 0.0102426588971728*G0_10 + 0.000782878387045057*G0_11 + 0.00313151354818021*G0_12 + 0.00313151354818022*G0_13 + 0.000782878387045048*G0_14 + 0.0117431758056758*G0_15 + 0.00391439193522524*G0_16 + 0.0117431758056758*G0_17 - 0.015657567740901*G0_18 - 0.0156575677409011*G0_19 + 0.0704590548340547*G0_20;
}


poisson2d_5_form_0::poisson2d_5_form_0() : ufc::form()
{
    // Do nothing
}

poisson2d_5_form_0::~poisson2d_5_form_0()
{
    // Do nothing
}

const char * poisson2d_5_form_0::signature() const
{
    return "1bc0138e7fa5eaefa938690a0c6b17c679fa6f1074cbd4bd4fd681067ecd02d9cd0c91bacb45d126c7920a72e5a1d2bfbf0ff52559cede2485079e696c379f69";
}

std::size_t poisson2d_5_form_0::rank() const
{
    return 2;
}

std::size_t poisson2d_5_form_0::num_coefficients() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({});
    return position[i];
}

ufc::finite_element * poisson2d_5_form_0::create_coordinate_finite_element() const
{
    return new poisson2d_5_finite_element_1();
}

ufc::dofmap * poisson2d_5_form_0::create_coordinate_dofmap() const
{
    return new poisson2d_5_dofmap_1();
}

ufc::coordinate_mapping * poisson2d_5_form_0::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * poisson2d_5_form_0::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_2();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_2();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * poisson2d_5_form_0::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_2();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_2();
        break;
      }
    }
    
    return 0;
}

std::size_t poisson2d_5_form_0::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_0::max_overlap_subdomain_id() const
{
    return 0;
}

bool poisson2d_5_form_0::has_cell_integrals() const
{
    return true;
}

bool poisson2d_5_form_0::has_exterior_facet_integrals() const
{
    return false;
}

bool poisson2d_5_form_0::has_interior_facet_integrals() const
{
    return false;
}

bool poisson2d_5_form_0::has_vertex_integrals() const
{
    return false;
}

bool poisson2d_5_form_0::has_custom_integrals() const
{
    return false;
}

bool poisson2d_5_form_0::has_cutcell_integrals() const
{
    return false;
}

bool poisson2d_5_form_0::has_interface_integrals() const
{
    return false;
}

bool poisson2d_5_form_0::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * poisson2d_5_form_0::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * poisson2d_5_form_0::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * poisson2d_5_form_0::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * poisson2d_5_form_0::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * poisson2d_5_form_0::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * poisson2d_5_form_0::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * poisson2d_5_form_0::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * poisson2d_5_form_0::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * poisson2d_5_form_0::create_default_cell_integral() const
{
    return new poisson2d_5_cell_integral_0_otherwise();
}

ufc::exterior_facet_integral * poisson2d_5_form_0::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * poisson2d_5_form_0::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * poisson2d_5_form_0::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * poisson2d_5_form_0::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * poisson2d_5_form_0::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * poisson2d_5_form_0::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * poisson2d_5_form_0::create_default_overlap_integral() const
{
    return 0;
}


poisson2d_5_form_1::poisson2d_5_form_1() : ufc::form()
{
    // Do nothing
}

poisson2d_5_form_1::~poisson2d_5_form_1()
{
    // Do nothing
}

const char * poisson2d_5_form_1::signature() const
{
    return "e1b9a9ae891a7b0463aa644c4f13f4cae623032c35d10c0ba56a4e1f2880e4bfd3c5cd6996b2b4a5c0f17169305c79e0e36b85378f8ffd1d2ced662503db7bee";
}

std::size_t poisson2d_5_form_1::rank() const
{
    return 1;
}

std::size_t poisson2d_5_form_1::num_coefficients() const
{
    return 1;
}

std::size_t poisson2d_5_form_1::original_coefficient_position(std::size_t i) const
{
    static const std::vector<std::size_t> position({0});
    return position[i];
}

ufc::finite_element * poisson2d_5_form_1::create_coordinate_finite_element() const
{
    return new poisson2d_5_finite_element_1();
}

ufc::dofmap * poisson2d_5_form_1::create_coordinate_dofmap() const
{
    return new poisson2d_5_dofmap_1();
}

ufc::coordinate_mapping * poisson2d_5_form_1::create_coordinate_mapping() const
{
    return nullptr;
}

ufc::finite_element * poisson2d_5_form_1::create_finite_element(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_finite_element_2();
        break;
      }
    case 1:
      {
        return new poisson2d_5_finite_element_2();
        break;
      }
    }
    
    return 0;
}

ufc::dofmap * poisson2d_5_form_1::create_dofmap(std::size_t i) const
{
    switch (i)
    {
    case 0:
      {
        return new poisson2d_5_dofmap_2();
        break;
      }
    case 1:
      {
        return new poisson2d_5_dofmap_2();
        break;
      }
    }
    
    return 0;
}

std::size_t poisson2d_5_form_1::max_cell_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_1::max_exterior_facet_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_1::max_interior_facet_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_1::max_vertex_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_1::max_custom_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_1::max_cutcell_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_1::max_interface_subdomain_id() const
{
    return 0;
}

std::size_t poisson2d_5_form_1::max_overlap_subdomain_id() const
{
    return 0;
}

bool poisson2d_5_form_1::has_cell_integrals() const
{
    return true;
}

bool poisson2d_5_form_1::has_exterior_facet_integrals() const
{
    return false;
}

bool poisson2d_5_form_1::has_interior_facet_integrals() const
{
    return false;
}

bool poisson2d_5_form_1::has_vertex_integrals() const
{
    return false;
}

bool poisson2d_5_form_1::has_custom_integrals() const
{
    return false;
}

bool poisson2d_5_form_1::has_cutcell_integrals() const
{
    return false;
}

bool poisson2d_5_form_1::has_interface_integrals() const
{
    return false;
}

bool poisson2d_5_form_1::has_overlap_integrals() const
{
    return false;
}

ufc::cell_integral * poisson2d_5_form_1::create_cell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::exterior_facet_integral * poisson2d_5_form_1::create_exterior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interior_facet_integral * poisson2d_5_form_1::create_interior_facet_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::vertex_integral * poisson2d_5_form_1::create_vertex_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::custom_integral * poisson2d_5_form_1::create_custom_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cutcell_integral * poisson2d_5_form_1::create_cutcell_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::interface_integral * poisson2d_5_form_1::create_interface_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::overlap_integral * poisson2d_5_form_1::create_overlap_integral(std::size_t subdomain_id) const
{
    return 0;
}

ufc::cell_integral * poisson2d_5_form_1::create_default_cell_integral() const
{
    return new poisson2d_5_cell_integral_1_otherwise();
}

ufc::exterior_facet_integral * poisson2d_5_form_1::create_default_exterior_facet_integral() const
{
    return 0;
}

ufc::interior_facet_integral * poisson2d_5_form_1::create_default_interior_facet_integral() const
{
    return 0;
}

ufc::vertex_integral * poisson2d_5_form_1::create_default_vertex_integral() const
{
    return 0;
}

ufc::custom_integral * poisson2d_5_form_1::create_default_custom_integral() const
{
    return 0;
}

ufc::cutcell_integral * poisson2d_5_form_1::create_default_cutcell_integral() const
{
    return 0;
}

ufc::interface_integral * poisson2d_5_form_1::create_default_interface_integral() const
{
    return 0;
}

ufc::overlap_integral * poisson2d_5_form_1::create_default_overlap_integral() const
{
    return 0;
}

