/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz                                      *
 *   peter.penz@gmx.at                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BOOKMARK_H
#define BOOKMARK_H

#include <kurl.h>
#include <qstring.h>

/**
 * @brief A bookmark is represented by a name, a URL and an icon.
 *
 * Dolphin differs between editable bookmarks which may be modified
 * by the user and noneditable bookmarks. Noneditable bookmarks
 * are part of the default configuration (e. g. Home, Root and System).
 *
 * @author Peter Penz <peter.penz@gmx.at>
 */
class Bookmark
{
public:
    Bookmark();
    Bookmark(const QString& name,
             const KURL& url,
             const QString& icon,
             bool editable = true);

    virtual ~Bookmark();

    void setName(const QString& name) { m_name = name; }
    const QString& name() const { return m_name; }

    void setURL(const KURL& url) { m_url = url; }
    const KURL& url() const { return m_url; }

    void setIcon(const QString& icon) { m_icon = icon; }
    const QString& icon() const { return m_icon; }

    bool isEditable() const { return m_editable; }

private:
    bool m_editable;
    QString m_name;
    KURL m_url;
    QString m_icon;
};

#endif
