import java.util.*;
import java.text.*;
import org.gnu.gtk.*;
import java.io.File;
import java.lang.Thread;

/**
 * Bridge between the text mode Domesday application and the graphical
 * Domesdaygui program. This will be responsible for calling the domesday
 * program and handling all responses (via the {@link UserInterface} interface.
 * 
 * <br><br>$Id: Bridge.java,v 1.3 2002/09/30 10:59:49 howama Exp $
 */
public class Bridge extends Thread implements UserInterface{
	/**
	 * TODO: More output in progress stages - error counts, etc 
	 */

	/** "GuiStrings" localisation messages */
	ResourceBundle messages = null;

	/**
	 * If true, the main program is running, generating the index (and so there
	 * will be many messages relating to this). If false, any messages received
	 * will be errors in other areas, most probably loading the project.
	 */
	private boolean isRunning = false;

	/** parent window */
	Window window;

	/** 
	 * Creates bridge the object
	 * @param l10n "GUIStringstrings" resource
	 */
	public Bridge(ResourceBundle l10n, Window parent){
		messages = l10n;
		window = parent;
	}
			
	/**
	 * This is called whenever an error occurs. Note that these may nt be fatal
	 * errors. 
	 * @param message The full formatted message, as will appear in the log
	 * @param errorNo The number of the error, to be cross referenced with
	 * documentation.
	 * @param resourceID identifier for the resource in MainStrings.properties
	 * @param params Additional parameters supplied by the caller.
	 */
	public void error(String message, int errorNo, String resourceID, Object[] params){
		// FIXME - is this thread safe ??? 
		System.out.println( "   ERR ("+errorNo+") "  + message);
		if (!isRunning){
			MessageDialog dlg = new MessageDialog( window, DialogFlags.MODAL, MessageType.ERROR, ButtonsType.CLOSE, message);
			dlg.run();
			dlg.destroy();
		}
	}
	
	/**
	 * This is called whenever a warning is issued. Note that these may nt be fatal
	 * errors. 
	 * @param message The full formatted message, as will appear in the log
	 * @param errorNo The number of the error, to be cross referenced with
	 * documentation.
	 * @param resourceID identifier for the resource in MainStrings.properties
	 * @param params Additional parameters supplied by the caller.
	 */
	public void warning(String message, int warningNo, String resourceID, Object[] params){
		// todo thread safe??
		System.out.println( "   WARN ("+warningNo+") "  + message);
		if (!isRunning){
			MessageDialog dlg = new MessageDialog( window, DialogFlags.MODAL, MessageType.WARNING, ButtonsType.CLOSE, message);
			dlg.run();
			dlg.destroy();
		}
	}
	
	/**
	 * This indicates that the scanning of the files is about to begin
	 */
	public void startScan(){
		progress.startScan();
	}

	private int fileCount = 0;
	private String currentFile = null;
	/**
	 * This is a progress report for the scaning of the files.
	 * @param complete Number of files scaned so far.
	 */
	public void scanProgress(String current){
		fileCount++;
		currentFile = current;
		progress.scanProgress(current, fileCount);
	}

	/**
	 * This indicates that the scanning of the files has completed and the
	 * output is about to be generated.
	 */
	public void startOutputGenerate(){
		currentFile = null;
		progress.startOutputGen();
	}

	public void finished(){
	}

	public ProgressPage progress;
	public void setProgress(ProgressPage page){
		progress = page;
	}

	/**
	 * Generates the index
	 */
	public void run(){
		isRunning = true;
		try{
			AnyIndexGen generator = null;				
			if (DomesdayGUI.project.getEnumSetting("INDEX_TYPE").equals("INDEX_TYPE_SITE_MAP")){
				generator = new SitemapGen(DomesdayGUI.log, DomesdayGUI.project);
			}else if (DomesdayGUI.project.getEnumSetting("INDEX_TYPE").equals("INDEX_TYPE_ORDERED_LIST")){
				generator = new OrderedListGen(DomesdayGUI.log, DomesdayGUI.project);
			}else{
				// I'm not wasting resource space on this. It will never happen
				throw new RuntimeException("no generator found - this really shouldn't happen");
			}
			File result = new File ( DomesdayGUI.project.getStringSetting( "OUTPUT_FILENAME"));
			if ( result.exists()){
				// TODO - confirm overwrite
			}
			generator.generate();
		}catch(IllegalVariableException e){
			e.printStackTrace();
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
		}catch(gnu.regexp.REException e){
			e.printStackTrace();
			DomesdayGUI.log.addError(202, "GENERATE_ERROR", new Object[] {e.toString()} );
			return;
		}catch(Exception e){
			e.printStackTrace();		
			DomesdayGUI.log.addError(901, "UNKNOWN_ERROR", new Object[] {e.toString()});
		}
		isRunning = false;
		progress.complete();
	}
}
