import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * A page to determine which type of index should be used: hierarchical site map
 * or sequential list.
 * <p>This is a simple radiobutton group.
 */
public class IndexTypePage extends WizardPage{

	/**
	 * Constructs a new Type page
	 */
	public IndexTypePage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("IndexType"));
	}
	
	/** if true, previous setting was sitemap */
	private boolean isSitemap = true;

	/**	Button for sitemap setting */
	private static RadioButton siteMap = null;
	/** button for ordered list setting */
	private static RadioButton orderedList = null;
	/** Listener for changeing of the radio group */
	private static ToggleListener toggleHandler;

	/**
	 * Constructs the widgets on the page.
	 */
	protected void customise(){		
		VBox mainVBox = new VBox(false, 5);

		Label head = new Label(  DomesdayGUI.messages.getString("IndexTypeHead") );
		head.setLineWrap(true);
		mainVBox.add(head);		
		
		siteMap = new RadioButton(null, DomesdayGUI.messages.getString("SiteMap"), true );
		mainVBox.add(siteMap);
		Label desc = new Label( DomesdayGUI.messages.getString("SiteMapDesc") );
		desc.setLineWrap(true);
		mainVBox.add(desc);
		orderedList = new RadioButton(siteMap,  DomesdayGUI.messages.getString("OrderedList"), true );
		mainVBox.add(orderedList);						
		desc = new Label( DomesdayGUI.messages.getString("OrderedListDesc") );
		desc.setLineWrap(true);
		mainVBox.add(desc);

		toggleHandler = new ToggleHandler();
		siteMap.addListener( (ToggleListener) toggleHandler);

		mainVBox.showAll();
		content =  mainVBox;
		System.out.println("Customised index type page");
	}

	/**
	 * Loads the setting from the project
	 */
	protected void preShow(){
		try{
			isSitemap = DomesdayGUI.project.getEnumSetting("INDEX_TYPE").equals("INDEX_TYPE_SITE_MAP");
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
		orderedList.setState(!isSitemap);
		siteMap.setState(isSitemap);
	}

	/**
	 * Listener for changing of the choice
	 */
	private class ToggleHandler implements ToggleListener{
		/**
		 * If the setting has changed, we will record this in the project and
		 * also update the treeview.
		 */
		public void toggleEvent(ToggleEvent event){
			boolean changed = false;
			if (siteMap.getState()){
				if (!isSitemap){ 
					changed = true; 
					isSitemap = true;
				}
			}else{
				if (isSitemap){ 
					changed = true; 
					isSitemap = false;
				}
			}
			if (changed == true){
				try{
				if (isSitemap){
					DomesdayGUI.project.storeSettingByVar("INDEX_TYPE", "INDEX_TYPE_SITE_MAP");
				}else{
					DomesdayGUI.project.storeSettingByVar("INDEX_TYPE", "INDEX_TYPE_ORDERED_LIST");
				}
				}catch(IllegalVariableException e){
					DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
					e.printStackTrace();
				}
				((DomesdayGUI) wizard).changeIndexType();
			}
		}
	}
}
