import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * A simple screen giving an introduction to the program.
 */
public class WelcomePage extends WizardPage{

	/**
	 * Constructs a new welcome page
	 */
	public WelcomePage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("WelcomeTitle"));
	}

	private static Label version;
	/**
	 * Adds the widgets to the page.
	 */
	protected void customise(){		
		VBox mainVBox = new VBox(false, 5);

		Label titleLbl = new Label("...");
		titleLbl.setJustification(Justification.CENTER );
		titleLbl.setMarkup("<span size=\"xx-large\" weight=\"heavy\">Domesday</span>");
		mainVBox.packStart(titleLbl, false, false, 0);

		version = new Label("Version "+IGLog.INDEXGEN_VERSION);
		version.setJustification(Justification.CENTER);
		mainVBox.packStart(version, false, false, 0);		
		

		Label intro = new Label( DomesdayGUI.messages.getString("WelcomeIntro"));
		intro.setLineWrap(true);
		mainVBox.packStart(intro, true, true, 10);

		Label end = new Label( DomesdayGUI.messages.getString("WelcomeEnd"));
		end.setLineWrap(true);
		mainVBox.packStart(end, true, true, 10);

		mainVBox.showAll();
		content =  mainVBox;
	}

}
