
import java.io.*;
import java.util.Date;
import java.text.*;
import java.util.*;
import gnu.regexp.*;

/**
 * Main class for the Domesday Application (previously known as Domesday).
 *
 * <p>This will act as the text based interface, mainly available for batch mode 
 * and unattended operation.
 * 
 * <a href="http://www.tildemh.com/sw/indexgen/">www.tildemh.com/sw/domesday/</a>
 * <br><br>$Id: Domesday.java,v 1.5 2002/09/24 14:32:49 howama Exp $
 * 
 * @author Mark Howard
 */
public class Domesday{
	private static final int LOGLEVEL = 6;

	
	//static String language = new String("en");
    //static String country = new String("GB");
	//static Locale currentLocale = new Locale(language, country);
	static Locale currentLocale = Locale.getDefault();
    static ResourceBundle messages = ResourceBundle.getBundle("MainStrings",currentLocale);
	
	public static void main(String[] args){
		/*
		 * Parse arguments
		 */
		int i = args.length;
		boolean interaction = true;
		boolean quiet = false;

		if (i == 0 ){  printHelp("USEAGE");  System.exit(0); }
		if (args[0].equals( messages.getString("OPTION_VERSION"))
		 ){  printVersion(); System.exit(0); }
		if (args[0].equals( messages.getString("OPTION_HELP") ) 
				|| args[0].equals( messages.getString("OPTION_HELP_SHORT") ) ){  
			printHelp("USEAGE"); 
			System.exit(1); 
		}

		String projectSettings = args[i-1];
		for ( int indx = 0; indx<i-1; indx++)
		    {
			    if (args[indx].equalsIgnoreCase( messages.getString("OPTION_QUIET") ))
				{
				    quiet=true; continue;
				}
			    else if (args[indx].equalsIgnoreCase( messages.getString("OPTION_NO_INTERACTION") ) )
				{
				    interaction = false;
				}
			    else {
				    /*option unknown*/
				     printHelp("OPTION_UNKNOWN"); System.exit(0);
				  }
		    }
		
		IGLog log = null;
		if (LOGLEVEL >8){ System.out.println("TEMP : " + System.getProperty("java.io.tmpdir")); }
		
		try{
			log = new IGLog(
					getLogFileName(), 
					messages, 
					(UserInterface) new TextInterface( messages, quiet) );
		}catch(IOException e){
			System.out.println( messages.getString("LOG_START_ERROR" ));
			System.out.println(e.toString());
			System.exit(100);
		}
		try{
			// Load Project
			Project proj = new Project(log);
			if (!quiet)
				System.out.println(messages.getString("LOADING_PROJECT"));
			try{
				proj.load(projectSettings);
			}catch(IllegalVariableException e){
				log.addError(20, "PROJ_LOAD_ERROR", new Object[] {e.getMessage()});
				return;
			}catch(IOException e){
				log.addError(20, "PROJ_LOAD_ERROR", new Object[] {e.getMessage()});
				return;
			}
			
			AnyIndexGen generator = null;				
			if (proj.getEnumSetting("INDEX_TYPE").equals("INDEX_TYPE_SITE_MAP")){
				generator = new SitemapGen(log, proj);
			}else if (proj.getEnumSetting("INDEX_TYPE").equals("INDEX_TYPE_ORDERED_LIST")){
				generator = new OrderedListGen(log, proj);
			}else{
				// I'm not wasting resource space on this. It will never happen
				throw new Exception("no generator found - this really shouldn't happen");
			}

			if ( interaction){
				File result = new File ( proj.getStringSetting( "OUTPUT_FILENAME"));
				if ( result.exists()){
					System.out.print( IGLog.formatResource( "OVERWRITE", new Object[] { proj.getStringSetting( "OUTPUT_FILENAME") }) );
					byte userInput[] = new byte[1];
					try{
	       				int bytesRead = System.in.read( userInput, 0, 1);
					}catch( IOException e ){
						log.addError(24, "USER_INPUT_ERROR", new Object[] {e.toString()});
						return;
					}
					String userInputLine = new String( userInput);
					if (!(userInputLine.equalsIgnoreCase("Y"))){
					    System.out.println(messages.getString("OVERWRITE2"));
					    return;
					}
				}
			}

			try{
				generator.generate();
				// TODO: handle these better.
			}catch(IOException e){
				log.addError(202, "GENERATE_ERROR", new Object[] {e.toString()} );
				e.printStackTrace();
				return;
			}catch(gnu.regexp.REException e){
				log.addError(202, "GENERATE_ERROR", new Object[] {e.toString()} );
				e.printStackTrace();
				return;
			}catch(Exception e){
				log.addError(901, "UNKNOWN_ERROR", new Object[] {e.toString()});
				e.printStackTrace();
				return;
			}
			IGLog.ui.finished();
	
		}catch(IllegalVariableException e){
			log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}catch(Exception e){
			log.addError(901, "UNKNOWN_ERROR", new Object[] {e.toString()});
			e.printStackTrace();
		}finally{
			try{
				log.close();
			}catch(IOException e){
				System.out.println("IO ERROR: "+e);
				e.printStackTrace();
			}
		}
	}

	
	public static void printHelp( String messageType){
		System.out.println(messages.getString(messageType));
	}

	public static void printVersion(){
		System.out.println("Domesday "+IGLog.INDEXGEN_VERSION);
	}

	public static String getLogFileName(){
		File newFile;
		int fileEnd = 1;
		DateFormat formatDate = new SimpleDateFormat("yyyyMMdd");
		newFile = new File( System.getProperty("user.dir") 
				+ System.getProperty("file.separator") 
				+ "domesday-"
				+ formatDate.format(new Date())  
				+ "-" + fileEnd
				+ ".log" );
		while ( newFile.exists()){
		   fileEnd++;
			newFile = new File( System.getProperty("user.dir") +
				System.getProperty("file.separator") 
				+ "domesday-"
				+ formatDate.format(new Date())  
				+ "-" + fileEnd
				+ ".log" );
		 }
	    return System.getProperty("user.dir") +
				System.getProperty("file.separator") 
				+ "domesday-"
				+ formatDate.format(new Date())  
				+ "-" + fileEnd
				+ ".log"  ;
	}

}

/*
 * $Log: Domesday.java,v $
 * Revision 1.5  2002/09/24 14:32:49  howama
 * various changes, bugfixes, etc
 *
 * Revision 1.4  2002/09/23 10:37:27  howama
 * various changes
 *
 * Revision 1.3  2002/09/20 18:11:09  howama
 * bug fixes, more gui work, random changes...
 *
 * Revision 1.2  2002/09/11 13:22:25  howama
 * bug fixes
 *
 * Revision 1.1  2002/09/11 11:50:46  howama
 * renamed
 *
 * Revision 1.14  2002/09/06 11:44:04  howama
 * merged command line options by Eugene <team_pro@gala.net>.
 * More ui work
 * Changed log position
 *
 * Revision 1.13  2002/09/05 14:01:40  howama
 * new log methods for erros
 *
 * Revision 1.12  2002/09/04 20:08:48  howama
 * user interface work
 *
 * Revision 1.11  2002/08/31 15:27:56  howama
 * various changes
 *
 * Revision 1.10  2002/08/20 13:24:55  howama
 * added rb to log
 *
 * Revision 1.9  2002/08/20 09:18:20  howama
 * various
 *
 * Revision 1.8  2002/08/09 16:09:45  howama
 * creates the generator classes. now calls the important methods
 *
 * Revision 1.7  2002/08/08 17:24:43  howama
 * updates
 *
 * Revision 1.6  2002/07/24 09:24:21  howama
 * updated javadoc docs
 *
 * Revision 1.5  2002/07/17 15:11:58  howama
 * various
 *
 * Revision 1.4  2002/07/12 14:07:31  howama
 * updates
 *
 * Revision 1.3  2002/07/08 16:17:42  howama
 * Parameter Parsing, starting log, starting the process.
 *
 * Revision 1.2  2002/07/05 13:05:33  howama
 * more work
 *
 */
