import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;

/**
 * About page - shows authors and such like
 */
public class AboutPage extends WizardPage{

	/**
	 * Constructs a new about page
	 */
	public AboutPage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("AboutTitle"));
	}

	/**
	 * Adds the widgets to the page.
	 */
	protected void customise(){		
		VBox mainVBox = new VBox(false, 0);
		Label all = new Label( "Developer Mailing list <indexgenerator-devel@lists.sf.net>" );
		all.setSelectable(true);
		mainVBox.add(all);

		Label titleLbl = new Label(DomesdayGUI.messages.getString("AboutMainDev"));
		titleLbl.setUseMarkup(true);
		titleLbl.setJustification(Justification.LEFT);
		mainVBox.add(titleLbl);
		Label mh = new Label( "Mark Howard <mh@tildemh.com>\nStefan Drees <sdrees@sdrees2.de>\nBen Secrest <blsecres@trellis.net>" );
		mh.setSelectable(true);
		mh.setJustification(Justification.LEFT);
		mainVBox.add(mh);

		Label devTitle = new Label(DomesdayGUI.messages.getString("AboutGUIDev"));
		devTitle.setUseMarkup(true);
		devTitle.setJustification(Justification.LEFT);
		mainVBox.add(devTitle);
		mh = new Label( "Mark Howard <mh@tildemh.com>" );
		mh.setSelectable(true);
		mainVBox.add(mh);

		Label transTitle = new Label( DomesdayGUI.messages.getString("AboutTrans"));
		transTitle.setUseMarkup(true);
		transTitle.setJustification(Justification.LEFT);
		mainVBox.add(transTitle);
		mainVBox.add( new Label("We need help...") );
		
		Label thanksTitle = new Label( DomesdayGUI.messages.getString("AboutThanks"));
		thanksTitle.setUseMarkup(true);
		thanksTitle.setJustification(Justification.LEFT);
		mainVBox.add(thanksTitle);
		Label jg = new Label( "Java-Gnome Project <http://java-gnome.sf.net>\noro <http://>" );
		mainVBox.add(jg);
		
		mainVBox.showAll();
		content =  mainVBox;
		System.out.println("Customised AboutPage");
	}

}
