import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class Creators(BasicComicModule):
    latestUrl = 'http://www.creators.com/comics_show.cfm?ComicName=%s'
    imageSearch = re.compile(r'<img alt="[^"]+" src="(\d{4}/.+?/.+?\..+?)">')
    prevSearch = re.compile(r'<a href="(comics_show\.cfm\?next=\d+&ComicName=.+?)" Title="Previous Comic"')
    help = 'Index format: unsupported'

    submodules = {
        'Archie': 'arc',
        'AskShagg': 'shg',
        'ForHeavensSake': 'hev',
        'Rugrats': 'rug',
        'StateOfTheUnion': 'sou',
        'TheDinetteSet': 'din',
        'TheMeaningOfLila': 'lil',
        'WeePals': 'wee',
        'Zack Hill': 'zhi',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        submodule = self.submodules[submodule]
        self.latestUrl = self.latestUrl % (submodule,)
        self.name = 'Creators' + '/' + submodule
