import re
from dosage import util
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class UComics(BasicComicModule):
    homepage = 'http://www.ucomics.com/'
    baseUrl = 'http://www.ucomics.com/%s'
    latestUrl = '/'
    imageUrl = '/%s/'
    imageSearch = re.compile(r'(http://images.ucomics.com/comics/.+?/\d{4}/.+?\d{6}.gif)')
    prevSearch = re.compile(r'<a href = "(http://www\.ucomics\.com/.+?/\d{4}/\d{2}/\d{2}/)"(?: onClick="this\.href=FCx\(this\.href\);")?>(?:previous date|<IMG SRC="http://images\.ucomics\.com/images/mul/prevpage)')
    help = 'Index format: yyyy/mm/dd'

    submodules = (
        '9to5',
        'adamathome',
        'animalcrackers',
        'animatedoliphant',
        'annie',
        'anntelnaes',
        'baldo',
        'barbarabrandon',
        'bensargent',
        'bigtop',
        'billdeore',
        'bobthesquirrel',
        'boondocks',
        'bornlucky',
        'bottomliners',
        'boundandgagged',
        'brendastarr',
        'brewsterrockit',
        'broomhilda',
        'brucehammond',
        'calvinandhobbes',
        'cathy',
        'catswithhands',
        'chanlowe',
        'citizendog',
        'clearbluewater',
        'cleats',
        'closetohome',
        'compu-toon',
        'cornered',
        'danasummers',
        'danwasserman',
        'davidhorsey',
        'dicklocher',
        'dicktracy',
        'dickwright',
        'donwright',
        'doodles',
        'doonesbury',
        'dougmarlette',
        'drewsheneman',
        'duplex',
        'facesinthenews',
        'forbetterorforworse',
        'foxtrot',
        'frankandernest',
        'fredbasset',
        'garfield',
        'garyvarvel',
        'gasolinealley',
        'gilthorp',
        'glennmccoy',
        'heartofthecity',
        'helen',
        'housebroken',
        'hubertandabby',
        'inthebleachers',
        'jackhiggins',
        'jackohman',
        'jeffdanziger',
        'kudzu',
        'lacucaracha',
        'laloalcaraz',
        'lola',
        'looseparts',
        'lostsheep',
        'luckycow',
        'mattdavies',
        'meehanstreak',
        'misterboffo',
        'mixedmedia',
        'mullets',
        'muttandjeff',
        'neurotica',
        'nonsequitur',
        'oddlyenough',
        'overboard',
        'patoliphant',
        'paulconrad',
        'pepe',
        'pluggers',
        'poochcafe',
        'popculture',
        'preteena',
        'pricklycity',
        'reallifeadventures',
        'reynoldsunwrapped',
        'shoe',
        'shoecabbage',
        'smallworld',
        'stevesack',
        'stonesoup',
        'stuartcarlson',
        'sylvia',
        'tankmcnamara',
        'tedrall',
        'thebigpicture',
        'theelderberries',
        'thefifthwave',
        'thefuscobrothers',
        'themiddletons',
        'thequigmans',
        'tomthedancingbug',
        'tomtoles',
        'tonyauth',
        'walthandelsman',
        'waynestayskal',
        'willynethel',
        'ziggy',
    )

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = self.baseUrl % submodule
        self.latestUrl = self.baseUrl + self.latestUrl
        self.imageUrl = self.baseUrl + self.imageUrl
        self.name = 'UComics' + '/' + submodule
    
    def fetchSubmodules(cls):
        exclude = (
            'dearabby',
        )
        submoduleSearch = re.compile(r'<option value="http://www\.ucomics\.com/([^"^/]+)/?"(?: class="drop")?>')
        matches = util.fetchManyMatches(cls.homepage, (submoduleSearch,))[0]

        def fetchSubmodule(module):
            try:
                return util.fetchUrl(cls.baseUrl % module, cls.prevSearch)
            except:
                return False
        return [module for module in matches if fetchSubmodule(module) and module not in exclude]
    fetchSubmodules = classmethod(fetchSubmodules)

