import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class DominicDeegan(BasicComicModule):
    latestUrl = 'http://www.dominic-deegan.com/index.cgi'
    imageUrl = 'http://www.dominic-deegan.com/index.cgi?date=%s'
    imageSearch = re.compile(r'"(http://www.dominic-deegan.com/comics/[^"]*?)"', re.IGNORECASE)
    prevSearch = re.compile(r'"(http://www.dominic-deegan.com/+?index.cgi\?date=[0-9]+?)">Previous Comic', re.IGNORECASE)
    help = 'Index format: yyyymmdd'

    def getFilename(self, imageUrl, pageUrl):
        a = re.search('/(?:deegan)([^/]*)',imageUrl)
        if a:
            return a.groups()[0]
        return None
