import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin
from dosage.util import getQueryParams

class DrunkDuck(BasicComicModule, BounceMixin):
    imageUrl = 'index.php?i=%s'
    # these are all a little bit fuzzy to match as much different designed pages as possible...
    imageSearch = re.compile(r"<img src='(\./[^./]+\.[a-z]{3,4})' border=0>", re.IGNORECASE)
    linkSearchRe = r"<a href=['\"](/[^/]*/index.php\?i=\d+)['\"]>(?:<span[^>]*>)?[\s\n]*<img[^>]*src=['\"][^'\"]*gfx/[^'\"]*(?:%s)[^'\"/]*\.[a-z]{3,4}['\"]"
    prevSearch = re.compile(linkSearchRe % "pcomic|prev|back|image007", re.IGNORECASE)
    nextSearch = re.compile(linkSearchRe % "ncomic|next|4ward|forward|image008|fore", re.IGNORECASE)
    help = 'Index format: xxxxx (some increasing number)'

    submodules = {
        '00_Wings': 1,
        '0SugarStars0': 1,
        '20_Galaxies': 1,
        '32_Bit_Orchestra': 1,
        '3rd_Party_Fantasy': 1,
        '4th_Period_Java': 1,
        'AACMAW': 1,
        'adventurer': 1,
        'Adventures_in_Suburbia': 1,
        'Adventures_of_Link': 1,
        'Al_De_Baran': 1,
        'Alpha_Glitch': 1,
        'amazingyetrandom': 1,
        'Ant_Hill': 1,
        'Anti_Glory': 1,
        'asexualgoddess': 1,
        'A_Sonic_Comic': 1,
        'A_Twisted_Mind': 1,
        'Avalanche_Avenue': 1,
        'Avril_Foxxy': 1,
        'Backstage': 1,
        'Ballad_Tavern_and_Winery': 1,
        'Big_Screw': 1,
        'Bitter_Man_Comix': 1,
        'Black_Heart': 1,
        'Broken_Glass': 1,
        'Brutus': 1,
        'btc': 1,
        'Bunny_Love': 1,
        'CCC_Presents': 1,
        'ChaoScape': 1,
        'Chicks_Cats_and_Cookies': 1,
        'Choose_Your_Character': 1,
        'Closer_To_Insanity': 1,
        'Coathangers_and_Hammers': 1,
        'Code_Black': 1,
        'Col_Angus_Takes_All': 1,
        'College_Fuzz': 1,
        'College_Zoo': 1,
        'Consoles': 1,
        'Crazy_Duck': 1,
        'Culture_Shock': 1,
        'Cyco_Studios': 1,
        'Dead_Days': 1,
        'Defy_the_Dress_Code': 1,
        'Disenchanted_Youths_of_America': 1,
        'Dogs_Eye_View': 1,
        'Drawing_From_Life': 1,
        'Dregs_of_the_Empire': 1,
        'Dribble_For_Kids': 1,
        'DriveWhatDrivesYou': 1,
        'Drunk_Duck_Special': 1,
        'dudewtf': 1,
        'Earthbound': 1,
        'Eclectica': 1,
        'Elijah_and_Azuu': 1, # yeah, image007 and image008, right...
        'Entropy_Comics': 1,
        'fallaparts_parts': 1,
        'FFF': 1,
        'Fizz': 1,
        'Fluffy_Phils_Funatorium': 1,
        'forbetterorforawesome': 1,
        'Four_Swords_Mis_Adventures': 1,
        'Free_Form_Insanity': 1,
        'Frightmoore_University': 1,
        'from_Paint': 1,
        'Fusion': 1,
        'Fuzzball_and_Silver': 1,
        'gbcinc': 1,
        'GCF_Chronicles': 1,
        'Grey_Life': 1,
        'Gundam_Wang': 1,
        'High_Impact_Wrestling': 1,
        'Holy_Zen': 1,
        'How_to_Make_a_Sprite_Comic_in_Eight_Easy_Bits': 1,
        'HypHEN': 1,
        'id_ego_and_psyche': 1,
        'Interrobang': 1,
        'Is_it_Con_Yet': 1,
        'I_suk': 1,
        'Its_All_Goyim': 1,
        'Jared_Smith_Presents_Insomnia': 1,
        'Jayce_and_Friends': 1,
        'Joel_Bedfords_Movie_Grabs': 1,
        'KDL_comic': 1,
        'Kong_Comic': 1,
        'Kreiger': 1,
        'Laugh_It_Off': 1,
        'Legacy_of_Kain_Laugh_Reaver': 1,
        'Locoma': 1,
        'lumber': 1,
        'Mad_Comics': 1,
        'maddland': 1,
        'Mad_World': 1,
        'Magic_Girls_VCX': 1,
        'Mahrs_Miscellaneous_Mishaps': 1,
        'megaman_the_endless_parody': 1,
        'Mental_For_Rental': 1,
        'MIKYAGU': 1,
        'Mooks': 1,
        'Mopery': 1,
        'MT_COMICS_': 1,
        'Myself_and_Them_2': 1,
        'My_Stupid_Pathetic_Webcomic': 1,
        'n3crom4nc3rsh4m4nspiri7': 1,
        'NapsterDotBoat': 1,
        'NEIGHBORS': 1,
        'Neurotica': 1,
        'Nightshade_Komiks': 1,
        'Ninja_Weekly': 1,
        'No_4th_Wall_to_Break': 1,
        'No_Room_For_Magic': 1,
        'Oh_Stalker_of_Mine': 1,
        'Operation_SciFi': 1,
        'Opossums': 1,
        'Oshkosh_and_Josh': 1,
        'Otaku_Life': 1,
        'PaperbagKid': 1,
        'Period': 1,
        'Pig_Related': 1,
        'PopCherryWag': 1,
        'Prima_Macto': 1,
        'Psychic_Headache': 1,
        'Puppetry': 1,
        'Puppet_Show': 1,
        'qwerty': 1,
        'Randomania': 1,
        'Random_Crap': 1,
        'randomness': 1,
        'Random_Thoughts': 1,
        'Reality_Challenged': 1,
        'Realm_of_Shadow': 1,
        'Sack_O_Puppies': 1,
        'Salvation_of_Morrowind': 1,
        'SAMURAI_TAKEOVER': 1,
        'Screwball_Islands': 1,
        'Setbacks': 1,
        'shadow_system': 1,
        'Shagy_Comics': 1,
        'shorts': 1,
        'Slither_and_Friends': 1,
        'Smiley_Joe': 1,
        'So_Fantastic_Pork_Show_9oCLOCK': 1,
        'Songs_of_An_Angel': 1,
        'spoiled_rotten_brats': 1,
        'Starving_Artists': 1,
        'Stewart_Hall': 1,
        'Sticky': 1,
        'StickyAndBlobO': 1,
        'SwordInHand': 1,
        'Tachyphagia': 1,
        'takes_one_to_know_one': 1,
        'Tales_From_Tyrone': 1,
        'TalesOfTheInquisition': 1,
        'Tards': 1,
        'Teh_Funnies': 1,
        'TGComics': 1,
        'that_crazy_indian': 1,
        'The_Adventures_of_Spiffy_Bunny': 1,
        'The_Adventures_of_Vindibudd_Superhero_In_Training': 1,
        'The_Black_Rose': 1,
        'The_Bologna_Sandwitch': 1,
        'The_comic_you_could_not_care_less_about': 1,
        'The_Emoties': 1,
        'The_Flat_Earth_Society': 1,
        'The_Heroes_and_Heroines_Academy': 1,
        'The_Legend_of_the_Blue_Apple': 1,
        'The_Life_And_Times_Of_Mr_Bubbles': 1,
        'The_Loping_Purple_Buffalo': 1,
        'The_Reign_of_Cruella': 1,
        'TheRevolutionaries': 1,
        'The_Roach_Ranch': 1,
        'The_Shadows_of_Suikoden': 1,
        'The_Strip_with_No_Name': 1,
        'The_Tao_of_Geek': 1,
        'The_Tavern': 1,
        'The_Whovian_Observer': 1,
        'The_Wings_of_Change': 1,
        'The_Wonder_That_Is_Trig_Class': 1,
        'Tim': 1,
        'Too_Far': 1,
        'TriforceTrio': 1,
        'trythesoup': 1,
        'Turbo_Trak': 1,
        'undecided': 1,
        'Venus': 1,
        'Villainy_Minor': 1,
        'Ville_Life': 1,
        'Wade_In_The_Deep_End': 1,
        'Walker_and_Milo': 1,
        'Wander': 1,
        'Watch_Out_For_Snakes': 1,
        'WeirdStar': 1,
        'What_I_Learned_Today': 1,
        'Wintergreen': 1,
        'World_Dictator': 1,
        'WTCNS': 1,
        'Yuri_and_Nate': 1,
        'Z7': 1,
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = 'http://www.drunkduck.com/' + submodule + '/'
        self.imageUrl = self.baseUrl + self.imageUrl
        self.name = 'DrunkDuck' + '/' + submodule

    def getFilename(self, imageUrl, pageUrl):
        '''DrunkDunk changed their image naming schema 2 times: In the first
        schema the comic file name was determined by the artist, this was
        replaced on 2003-10-28. The second schema consists of the 10 digit UNIX
        time stamp of the upload, followed by a part determined by the artist.
        Test shows that this naming schema tends to get out of sequence when
        the artist replaces older strips. The third scheme was introduced
        somewhere between 2005-07-30 and 2005-08-04 and the image filename is
        now only a 128-bit hex string (md5?). So we replace this whole mess
        with the number that is used in the page URL - this one does hopefully
        not change afterwards.'''
        nr = getQueryParams(pageUrl)['i'][0]
        imgmatch = re.compile(r'/\d{10}([^/]*)\.[a-z]*$', re.IGNORECASE).search(imageUrl)
        imgname = re.compile(r'/([^/]*)\.[a-z]*$', re.IGNORECASE).search(imageUrl).group(1)
        if re.compile(r'^[a-f0-9]{32}$').search(imgname) != None:
            filename = nr
        elif imgmatch != None:
            filename = nr + '_' + imgmatch.group(1)
        else:
            filename = nr + '_' + imgname
        return filename

