#tested for catchup about 5 deep, the ctrl-c out. 06/03/05 `ns`

import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class KeenSpot(BasicComicModule):
    imageUrl = 'd/%s.html'
    imageSearch = re.compile(r'<img[^>]+?src="([^"]*?comics/.+?)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="([^"]*?d/\d{8}\.html)"[^>]*>(?:<img[^>]+?(?:name="previous_day"|alt="Previous"|src="[^"]*back[^"]*")|Previous comic)', re.IGNORECASE)
    help = 'Index format: yyyymmdd'

    submodules = {
#  Strips currently updating according to KeenSpot 2006/03/05
        'AbbysAgency': 'http://www.abbysagency.us/',
        'Adventurers': 'http://www.adventurers-comic.com/',
        'Alice': 'http://www.alicecomics.com/',
        'AlienDice': 'http://www.aliendice.com/',
        'AntiHeroForHire': 'http://www.antiheroforhire.com/',
        'Banished': 'http://www.banishedonline.com/',
#       'BonusStage': 'http://www.bonusstages.com/', not working
        'BoxJamsDoodle': 'http://boxjamsdoodle.com/',
        'BrunoTheBandit': 'http://www.brunothebandit.com/',
        'Candi': 'http://www.candicomics.com/',
        'ClanOfTheCats': 'http://www.clanofthecats.com/',
        'CollegeRoomiesFromHell': 'http://www.crfh.net/',
        'CountYourSheep': 'http://www.countyoursheep.com/',
        'DevilsPanties':'http://devilspanties.keenspot.com/',
        'DownToEarth': 'http://www.downtoearthcomic.com/',
        'ElGoonishShive': 'http://elgoonishshive.com/',
        'ElGoonishShiveFiller': 'http://www.egscomics.com/Filler/',
        'ElGoonishShiveNP': 'http://www.egscomics.com/egsnp/',
        'EverythingJake': 'http://www.everythingjake.com/',
#       'EvilJoshAndBilly': 'http://eviljoshandbilly.keentoons.com/', not working
        'FriendlyHostility': 'http://friendlyhostility.com/',
        'FunnyFarm': 'http://www.funnyfarmcomics.com/',
        'GamingGuardians': 'http://gamingguardians.com/',
        'GeebasOnParade': 'http://geebasonparade.keenspot.com/',
        'GeneCatlow': 'http://www.genecatlow.com/',
        'GeneralProtectionFault': 'http://www.gpf-comics.com/',
        'GodMode': 'http://www.godmodeonline.com/',
        'InsideTheBox': 'http://boxcomics.com/',
#        'KeenToons': ' http://www.keentoons.com/', not working
        'Landis': 'http://elisalandis.com/',
        'LostAndFound': 'http://www.lostandfoundcomic.com/',
#       'Manifestations': 'http://www.newshounds.com/manifestations/index.html', won't work pay site
        'NoRoomForMagic': 'http://noroomformagic.com/',
        'PennyAndAggie': 'http://pennyandaggie.com/',
        'QueenOfWands': 'http://www.queenofwands.net/',
#        'RoadWaffles': 'http://roadwaffles.com/', # not working
        'SinFest': 'http://www.sinfest.net/',
        'SoapOnARope': 'http://www.soaprope.com/',
        'SoreThumbs': 'http://www.sorethumbsonline.com/',
#       'SpaceTree': 'http://spacetree.com/', not working
        'SSDD': 'http://poisonedminds.com/',
        'Striptease': 'http://www.stripteasecomic.com/',
        'SuburbanJungle': 'http://www.suburbanjungle.com/',
        'TakingUpSpace': 'http://takingupspace.keenspot.com/',
        'TheDevilsPanties': 'http://devilspanties.keenspot.com/',
        'ToddAndPenguin': 'http://www.toddandpenguin.com/',
        'TwoLumps': 'http://www.twolumps.net/',
        'UberSoft': 'http://www.ubersoft.net/',
        'WanderingOnes': 'http://wanderingones.com/',
#        'YouDamnKid': 'http://www.youdamnkid.com/', not working
        'Zap': 'http://www.zapinspace.com/',
        'ZebraGirl': 'http://zebragirl.keenspot.com/',
        'Zortic': 'http://www.zortic.com/',

# miniseries strips
        'BasilFlintMiniseries': 'http://basilflint.keenspot.com/',
        'BlackPlague': 'http://blackplague.keenspot.com/',
        'CruelFate': 'http://cruelfate.keenspot.com/',
        'IllegalElian': 'http://illegalelian.keenspot.com/',
        'KeenonballRun': 'http://keenonballrun.keenspot.com/',
        'PCsDayOut': 'http://pc.keenspot.com/',
        'Sam': 'http://sam.keenspot.com/',
        'TheScrantonvilleKids': 'http://scrantonvillekids.keenspot.com/',
        'TheSilveryCentipede': 'http://silverycentipede.keenspot.com/',
        'Timmy': 'http://timmy.keenspot.com/',
        'TreasureHunters': 'http://treasurehunters.keenspot.com/',
        'UltimateAsshole': 'http://ultimateasshole.keenspot.com/',

# Strips ended according to KeenSpot 2006/03/05
        'Andiewear': 'http://andiewear.com/',
        'Avalon': 'http://www.avalonhigh.com/',
        'AwesomeGamerz': 'http://awesomegamerz.com/',
#        'BasilFlint': 'http://www.basilflint.com/', not working
        'Bobbins': 'http://bobbins.org/',
        'BoyMeetsBoy': 'http://boymeetsboy.keenspot.com/',
        'CoolCatStudios': 'http://www.coolcatstudio.com/',
        'ExploitationNow': 'http://www.exploitationnow.com/',
#       'Frankenstudent': 'http://frankenstudent.com/', not working
        'JoeAverage': 'http://www.joeaverage.org/',
#        'LimitedSpace': 'http://www.limitedspace.org/', note not working
        'Lizard': 'http://www.lizardcomics.com/',
#       'Melpomene': 'http://clanofthecats.com/Melpomene/',  pay site
        'MenInHats': 'http://www.meninhats.com/',
        'PurplePussy': 'http://www.purplepussy.net/',
        'SillyConeV': 'http://www.sillyconev.com/',
        'Shmorky': 'http://www.shmorky.com/',
        'SporkMan': 'http://www.sporkman.com/',
        'TheClassMenagerie': 'http://www.theclassm.com/',

# Strips on hiatus or sporadic updates (keenspot 2006/03/05)
        'Ashfield': 'http://ashfieldonline.com/',
        'ChoppingBlock': 'http://choppingblock.org/',
        'EatTheRoses': 'http://eattheroses.com/',
#        'ElfLife': 'http://www.elflife.com/', not working
        'ElfOnlyInn': 'http://www.elfonlyinn.net/',
        'FatJesus': 'http://fat-jesus.com/',
        'FelicityFlint': 'http://www.secretagentgirl.org/',
        'FilthyLies': 'http://www.filthylies.net/',
#        'HoundsHome': 'http://houndshome.com/',  dead, archives offline
#        'JustAnotherVice': 'http://justanothervice.com/', one image
        'LookWhatIBroughtHome': 'http://lookwhatibroughthome.com/',
        'MadAboutU': 'http://madaboutu.keenspot.com/',
#        'MrChuckShow': 'http://mrchuckshow.com/', not working (no image match)
        'NaughtFramed': 'http://www.damonk.com/',  # called Framed
        'Owlie': 'http://owliecomics.com/',
        'RPGWorld': 'http://www.rpgworldcomic.com/',
        'SexAndViolence': 'http://mrbang.net/',
        'SkirtingDanger': 'http://www.skirtingdanger.com/',
        'VigilanteHo': 'http://www.vigilanteho.com/',

# Strips not mentioned anywhere (KeenSpot 2006/03/05)
#        'BadlyDrawnKitties': 'http://www.badlydrawnkitties.com/', not mentioned or working
        'Flem': 'http://www.flemcomics.com/', # not mentioned
        'Ghastly': 'http://www.ghastlycomic.com/',  # not officially Keenspot ?
        'TheShadows': 'http://www.alicecomics.com/', #not mentioned

# Duplicates
# DUPE   'UberSoft': 'http://www.ubersoft.net/',  see HelpDesk

# ComicGenesis comics
        '24fps': 'http://filmbuff.comicgenesis.com/',
        '2WayMirror': 'http://tande.comicgenesis.com/',
        'ANT': 'http://ant.comicgenesis.com/',
        '1007': 'http://loot.comicgenesis.com/',
        '13thLabour': 'http://the13labour.comicgen.com/',
        '8to1': 'http://yeahduff.comicgen.com/',
        'AGeekTragedy': 'http://geektragedy.comicgenesis.com/',
        'AOMP': 'http://aomp.comicgenesis.com/',
        'AThinLine': 'http://thinline.comicgenesis.com/',
        'Ace147': 'http://ace147.comicgenesis.com/',
        'AlphaLuna': 'http://alphaluna.comicgenesis.com/',
        'AltaModaMetro': 'http://metro.comicgenesis.com/',
        'AlternateDelusions': 'http://altdelusions.comicgen.com/',
        'AndShineHeavenNow': 'http://hellsing.comicgenesis.com/',
        'AngelTheDemoness': 'http://angelthedemoness.comicgenesis.com/',
        'AnywhereButHere': 'http://www.abh-comic.com/',
        'ApocalypseWow': 'http://endofdayspress.comicgenesis.com/',
        'Apotheosis': 'http://apotheosis.comicgenesis.com/',
        'Aquatica': 'http://aquatica.comicgenesis.com/',
        'Arcanetimes': 'http://arcanetimes.comicgen.com/',
        'AtaraxiaTheatre': 'http://ataraxia.comicgenesis.com/',
        'Atavism': 'http://atavism.comicgenesis.com/',
        'BadAssMuthas': 'http://mrdaveryan.comicgenesis.com/',
        'BeautifulSkies': 'http://bskies.comicgenesis.com/',
        'BeforeDawn': 'http://beforedawn.comicgenesis.com/',
        'BeyondReality': 'http://orion.comicgenesis.com/',
        'BlackTapestries': 'http://blacktapestries.comicgen.com/',
        'Blackaby': 'http://blackaby.comicgenesis.com/',
        'BlacklightTwilight': 'http://nekkoxiii.comicgenesis.com/',
        'Blindworks': 'http://blindworks.comicgenesis.com/',
        'BlueEyedDevil': 'http://blueeyeddevil.comicgenesis.com/',
        'BoomerExpress': 'http://www.boomerexpress.com/',
        'BrainCramp': 'http://braincramp.comicgen.com/',
        'Burgundycomics': 'http://bci.stripspace.com/',
        'CatboyAtTheCon': 'http://trades.comicgenesis.com/',
        'ChatRouge': 'http://chatrouge.stripspace.com/',
        'Cimmerian': 'http://cimmerian.comicgenesis.com/',
        'CircleArcadiaKnightsOfTheGoddess': 'http://arcadia.comicgenesis.com/',
        'CoilingSpine': 'http://www.coilingspine.com/',
        'ColdServings': 'http://www.coldservings.com/',
        'ComicCreatorz': 'http://creatorz.comicgenesis.com/',
        'ConfessionsOfAnEnglishCatburglar': 'http://catburglars.comicgenesis.com/',
        'Cortland': 'http://www.cortlandcomic.com/',
        'CrossStreetBlues': 'http://crossstreet.comicgenesis.com/',
        'CrystalHearts': 'http://chs.comicgenesis.com/',
        'Darken': 'http://www.darkencomic.com/',
        'DasienSuperheroWebcomic': 'http://www.dasiencomic.com/',
        'DayDream': 'http://manganese.comicgenesis.com/',
        'Defectivity': 'http://defectivity.comicgenesis.com/',
        'DementedEmu': 'http://dementedemu.comicgenesis.com/',
        'DexLives': 'http://dexlives.comicgenesis.com/',
        'DigitalWar': 'http://www.digitalwar.co.uk/',
        'DimBulbComics': 'http://dimbulbcomics.comicgenesis.com/',
        'DimensionHopping': 'http://dimensionhopping.comicgenesis.com/',
        'DistantScreaming': 'http://distantscreaming.comicgenesis.com/',
        'DocHyperion': 'http://dochyperion.comicgenesis.com/',
        'DonAndDoll': 'http://donanddoll.comicgenesis.com/',
        'DownwardBound': 'http://downwardbound.comicgenesis.com/',
        'DragonKingdoms': 'http://dragonkingdoms.comicgenesis.com/',
        'DragonMail': 'http://dragonmail.comicgenesis.com/',
        'Dragonaur': 'http://dragonaur.comicgen.com/',
        'DumbAngel': 'http://dumbangel.comicgenesis.com/',
        'DysonsCreek': 'http://dysonscreek.comicgen.com/',
        'EarthBound': 'http://earthbound2.comicgenesis.com/',
        'Echzeon': 'http://echzeon.comicgenesis.com/',
        'EdibleDirt': 'http://catmydog.comicgenesis.com/',
        'EitherWay': 'http://deadspace.comicgenesis.com/',
        'EmergencyExit': 'http://www.eecomics.net/',
        'EmperorOfOrphans': 'http://emperoroforphans.comicgenesis.com/',
        'ErrantVenture': 'http://errantventure.comicgenesis.com/',
        'EveOfCloves': 'http://eveofcloves.comicgenesis.com/',
        'FallenAngelsUsedBooks': 'http://www.faubcomic.com/',
        'FamiliarBlue': 'http://familiarblue.comicgen.com/',
        'Feyenne': 'http://feyenne.comicgen.com/',
        'Filler': 'http://filler.comicgenesis.com/',
        'FistofTheSarariman': 'http://fots.comicgenesis.com/',
        'FoxfireChronicles': 'http://foxfire.comicgenesis.com/',
        'FoxTails': 'http://foxtails.comicgenesis.com/',
        'FreedomFries': 'http://freedomfries.comicgenesis.com/',
        'FromTheSouthToTheStars': 'http://south.comicgenesis.com/',
        'GTC': 'http://gtc.comicgen.com/',
        'Game Over': 'http://gameover.comicgenesis.com/',
        'Ghoul': 'http://ghoul.comicgenesis.com/',
        'GirlFromBOLT.': 'http://bolt.comicgenesis.com/',
        'Gnerds2000': 'http://gnerds.comicgenesis.com/',
        'GoForIt': 'http://goforit.comicgen.com/',
        'GoblinHollow': 'http://utlt.comicgenesis.com/',
        'Godlike': 'http://godlike.comicgenesis.com/',
        'Godsboxers': 'http://godsboxers.comicgenesis.com/',
        'GreenAvenger': 'http://www.green-avenger.com/',
        'GunmetalAnnie': 'http://mercuryhat.comicgenesis.com/',
        'HaloParty': 'http://haloparty.comicgenesis.com/',
        'HamstaPowah': 'http://hamstapowah.comicgenesis.com/',
        'Hellroy': 'http://hellroy.comicgen.com/',
        'HelpIsOnThe Way': 'http://openwound.comicgenesis.com/',
        'HilariousHenry': 'http://hilarioushenry.comicgenesis.com/',
        'Hopscotch': 'http://hopscotch.comicgenesis.com/',
        'IEatFood': 'http://ieatfood.comicgen.com/',
        'ITalkToTheWind': 'http://talk.comicgenesis.com/',
        'InAPerfectWorld': 'http://iapw.comicgenesis.com/',
        'Indavo': 'http://indavo.comicgenesis.com/',
        'IndefensiblePositions': 'http://indepos.comicgenesis.com/',
        'InternetFriends': 'http://internetfriends.comicgen.com/',
        'JWalkin': 'http://jwalkin.comicgenesis.com/',
        'JimBobComics': 'http://falos.comicgenesis.com/',
        'JunkRIOT': 'http://junkriot.comicgen.com/',
        'JustAnEscape': 'http://justanescape.comicgenesis.com/',
        'LabBratz': 'http://labbratz.comicgenesis.com/',
        'LangLang': 'http://langlang.comicgenesis.com/',
        'LastManStanding': 'http://www.lms-comic.com/',
        'LeanOnMe': 'http://jadaze.comicgenesis.com/',
        'LegostarGalactica': 'http://legostargalactica.comicgen.com/',
        'Lowroad75': 'http://lowroad75.comicgenesis.com/',
        'MadWorld': 'http://madworld.comicgenesis.com/',
        'Malcolm': 'http://www.malcolmcomics.com/',
        'MariposaRevelation': 'http://mariposa.comicgenesis.com/',
        'McDuffies': 'http://mcduffies.comicgenesis.com/',
        'MediocreGothBoi': 'http://gothboi.comicgenesis.com/',
        'MegaCrap': 'http://megacrap.comicgenesis.com/',
        'MichikoMonagatari': 'http://isukiyomi.comicgenesis.com/',
        'ModernDayWitchdoctor': 'http://witchdoctor.comicgenesis.com/',
        'Monkey': 'http://monkey.comicgenesis.com/',
        'MortalitysEnd': 'http://mortalitysend.comicgenesis.com/',
        'MousesTail': 'http://mouse.comicgenesis.com/',
        'MusicOfTheWoods': 'http://sumimasen.comicgenesis.com/',
        'NieceWeb': 'http://www.nieceweb.com/',
        'NileIncarnate': 'http://nileincarnate.comicgenesis.com/',
        'NinjaVerses': 'http://www.ninjaverses.net/',
        'Ninjatopia': 'http://whiteninja.comicgenesis.com/',
        'NipAndTuck': 'http://nipandtuck.comicgenesis.com/',
        'NobTheBlob': 'http://nobtheblob.comicgen.com/',
        'NyuterranChronicles': 'http://www.nyuterra.com/',
        'ObscuredBySpecies': 'http://www.obscuredbyspecies.com/',
        'OffCampus': 'http://theoc.comicgenesis.com/',
        'OneOverZero': 'http://oneoverzero.comicgenesis.com/',
        'OperationNEKO': 'http://operationneko.comicgen.com/',
        'PANDECT': 'http://pandect.comicgenesis.com/',
        'Pals': 'http://pals.comicgen.com/',
        'PanicHighSchool': 'http://panichighschool.comicgenesis.com/',
        'Peno': 'http://peno.comicgen.com/',
        'Picatrix': 'http://picatrix.comicgen.com/',
        'PointGuardian': 'http://www.pointguardian.com/',
        'PokemonX': 'http://pokemonx.comicgenesis.com/',
        'Prismatic': 'http://prismatic.comicgenesis.com/',
        'ProfessionalThievery': 'http://pthievery.comicgenesis.com/',
        'Project5': 'http://project5.comicgenesis.com/',
        'PsychoticKiss': 'http://psychotickiss.comicgenesis.com/',
        'Pylon': 'http://pylon.comicgen.com/',
        'Queer': 'http://queer.comicgenesis.com/',
        'RallyHippo': 'http://annie.comicgenesis.com/',
        'Rangers': 'http://rangers.comicgenesis.com/',
        'ReadyOrNot': 'http://ron.comicgen.com/',
        'ReasonedCognition': 'http://www.reasonedcognition.com/',
        'RecklessYouth': 'http://recklessyouth.comicgen.com/',
        'Remembrance': 'http://remembrance.comicgenesis.com/',
        'RoguesOfClwydRhan': 'http://rocr.comicgenesis.com/',
        'RoleOfTheDie': 'http://www.roleofthedie.com/',
        'SaturdayMorningBreakfastCereal': 'http://smbc.comicgenesis.com/',
        'Saturnalia': 'http://saturnalia.comicgenesis.com/',
        'SavannDuh': 'http://savannduh.comicgenesis.com/',
        'ScandalSheet': 'http://scandalsheet.comicgenesis.com/',
        'Scatterplot': 'http://scatterplot.comicgenesis.com/',
        'SchoolSpirit': 'http://www.schoolspiritcomic.com/',
        'Scrued': 'http://www.scrued.com/',
        'SeriouslySuzy': 'http://suzy.comicgen.com/',
        'SexPercussions': 'http://sexpercussions.comicgenesis.com/',
        'Shifters': 'http://shifters.comicgen.com/',
        'Shijin': 'http://gutterflower.comicgenesis.com/',
        'ShonenAiKudasai!': 'http://kudasai.stripspace.com/',
        'Shy': 'http://shy.comicgenesis.com/',
        'SiegelDerDoppelseele': 'http://siegel.comicgenesis.com/',
        'SinisterBedfellows': 'http://mckenzee.comicgenesis.com/',
        'SixSeconds': 'http://sixseconds.comicgenesis.com/',
        'SoKeiItHurts': 'http://sokeiithurts.comicgenesis.com/',
        'Spacial': 'http://spacial.comicgenesis.com/',
        'SpellBinder': 'http://wizard.comicgenesis.com/',
        'SpritescapeFantasy': 'http://spritescape.comicgenesis.com/',
        'SpritevilleUSA': 'http://spriteville.comicgen.com/',
        'SquidNinja': 'http://www.squidninja.com/',
        'Stalag99': 'http://www.stalag99.net/',
        'StalkingMillionaries': 'http://packrat.comicgenesis.com/',
        'StandardDeviation': 'http://codered.comicgenesis.com/',
        'StarBored': 'http://oosterwijk.comicgenesis.com/',
        'StrangeCandy': 'http://www.strangecandy.net/',
        'SuicideForHire': 'http://suicideforhire.comicgenesis.com/',
        'SundaeConnection': 'http://sundaeconnection.comicgen.com/',
        'Superfightfight': 'http://superfightfight.comicgenesis.com/',
        'SurrealKins': 'http://www.surreal-kins.com/',
        'TAVision': 'http://tav.comicgenesis.com/',
        'TalesOfAReceptionist': 'http://toar.comicgenesis.com/',
        'TalesOfPylea': 'http://talesofpylea.comicgenesis.com/',
        'TalesOfTheQuestor': 'http://npc.comicgenesis.com/',
        'TangsWeeklyComic': 'http://tang.comicgenesis.com/',
        'Tankd': 'http://tanked.comicgenesis.com/',
        'Tansocks': 'http://tansocks.comicgenesis.com/',
        'Tehuti': 'http://tehuti.comicgenesis.com/',
        'TexAndJenny': 'http://texandjenny.comicgen.com/',
        'Thatguy': 'http://thatguy.comicgenesis.com/',
        'The6GUYSInMyHead': 'http://www.6guys.com/',
        'TheAdventuresOfMattandChris': 'http://matthewabel.comicgenesis.com/',
        'TheAvatar': 'http://theavatar.comicgenesis.com./',
        'TheCrowAlicesynaege': 'http://fourmages.comicgen.com/',
        'TheDuchessMew': 'http://duchessmew.comicgenesis.com/',
        'TheElvenExploration': 'http://www.theelven.com/',
        'TheEndOfThings': 'http://endofthings.comicgen.com/',
        'TheFreneticAdventuresOfFredBarlowe': 'http://fredbarlowe.comicgenesis.com/',
        'TheGreenAvenger': 'http://www.green-avenger.com/',
        'TheLongestSojourn': 'http://longestsojourn.comicgenesis.com/',
        'TheLounge': 'http://thelounge.comicgenesis.com/',
        'TheMansionOfE': 'http://mansionofe.comicgen.com/',
        'TheMenagerie': 'http://menagerie.comicgenesis.com/',
        'TheMintWhelpSaga': 'http://mintwhelp.comicgenesis.com/',
        'TheMysteriousDrX': 'http://obeydrx.comicgen.com/',
        'TheNakedElf': 'http://nakedelf.comicgenesis.com/',
        'TheNutcracker': 'http://nutcracker.comicgenesis.com/',
        'ThePrinceOfCastles': 'http://princeofcastles.comicgenesis.com/',
        'ThePursuitOfThePast': 'http://pursuit.comicgenesis.com/',
        'TheRubyPearl': 'http://rubypearl.comicgenesis.com/',
        'TheVermilionCage': 'http://vermilioncage.comicgen.com/',
        'TheVolet': 'http://volet.comicgenesis.com/',
        'TheWarOfWinds': 'http://warofwinds.comicgenesis.com/',
        'ThinginessOfChaos': 'http://thinginess.comicgenesis.com/',
        'ThirdCity': 'http://cityonedge.comicgen.com/',
        'TonjaSteele': 'http://tonjasteele.comicgenesis.com/',
        'Torio': 'http://torio.comicgen.com/',
        'ToyDivision': 'http://toydivision.comicgenesis.com/',
        'Transplant': 'http://transplant.comicgenesis.com/',
        'TriquetraCats': 'http://triquetracats.comicgenesis.com/',
        'Tsukiyo': 'http://tsukiyo.comicgenesis.com/',
        'TurboNinjaBastard': 'http://tnb.comicgen.com/',
        'TypeMismatch': 'http://typemismatch.comicgenesis.com/',
        'VengeanceAnd Wrath': 'http://vengeanceandwrath.comicgenesis.com/',
        'VenusEnvy': 'http://venusenvy.comicgenesis.com/',
        'Wacoon': 'http://wacoon.comicgenesis.com/',
        'WaistHigh': 'http://waisthigh.comicgenesis.com/',
        'WarningBucketsOfBlood': 'http://chaoticcomics.comicgen.com/',
        'WelcomeToLemonHouseApartment': 'http://llewenayah.comicgenesis.com/',
        'Werechild': 'http://werechild.comicgenesis.com',
        'Wereworld': 'http://wereworld.comicgenesis.com/',
        'WorldOfFenninRo': 'http://wofr.comicgenesis.com/',
        'WorldWarp': 'http://ivstudios.comicgen.com/',
        'WouldBeAngelsWouldBeGods': 'http://nekomimi.webcomicspace.com/',
        'XCHOPSTICKSxNeo': 'http://chopsticksneo.comicgen.com/',
        'YOSH': 'http://yosh.comicgen.com/',
        'Zoology': 'http://thezoo.comicgenesis.com/',
    }

    latestUrls = {
        'Alice': 'http://www.alicecomics.com/today.html',
        'Bobbins': 'http://bobbins.org/d/20020603.html',
        'CoolCatStudios': 'http://www.coolcatstudio.com/d/20020415.html',
        'CruelFate': 'http://cruelfate.keenspot.com/d/20000630.html',
#        'ElfLife': 'http://www.elflife.com/today.html',
        'IllegalElian': 'http://illegalelian.keenspot.com/d/20000531.html',
        'TheSilveryCentipede': 'http://silverycentipede.keenspot.com/d/20000428.html',
        'TheShadows': 'http://www.alicecomics.com/shadows.html',
#        'YouDamnKid': 'http://www.youdamnkid.com/ydk.html',
# ComicGenesis comics
        'ToyDivision': 'http://toydivision.comicgenesis.com/index2.html',
        'Shy': 'http://shy.comicgenesis.com/welcome.htm',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = self.submodules[submodule]
        self.latestUrl = self.latestUrls.get(submodule, baseUrl)
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'KeenSpot' + '/' + submodule
