import re
from dosage import util
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class UComicsEspanol(BasicComicModule):
    homepage = 'http://www.ucomics.com/'
    baseUrl = 'http://www.ucomics.com/espanol/%s'
    latestUrl = '/'
    imageUrl = '/%s/'
    imageSearch = re.compile(r'(http://images.ucomics.com/comics/.+?/\d{4}/.+?\d{6}.gif)')
    prevSearch = re.compile(r'<a href *= *"(http://www\.ucomics\.com/.+?/\d{4}/\d{2}/\d{2}/)"(?: onClick="this\.href=FCx\(this\.href\);")?>(?:previous date|anterior|<IMG SRC="http://images\.ucomics\.com/images/mul/prevpage)')
    help = 'Index format: yyyy/mm/dd'

    submodules = (
        'baldoespanol',
        'bcespanol',
        'calvinandhobbesespanol',
        'cathyespanol',
        'condorito',
        'foxtrotespanol',
        'fredbassetespanol',
        'garfieldespanol',
        'gaturro',
        'gingermeggsespanol',
        'heathcliffespanol',
        'modestyblaise',
        'overboardespanol',
        'pepe',
        'poochcafeespanol',
        'sigmund',
        'tutelandia',
        'wizardofidespanol',
        'yennyespanol',
        'ziggyespanol',
    )

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = self.baseUrl % submodule
        self.latestUrl = self.baseUrl + self.latestUrl
        self.imageUrl = self.baseUrl + self.imageUrl
        self.name = 'UComicsEspanol' + '/' + submodule

    def fetchSubmodules(cls):
        exclude = (
            'dearabby',
        )
        submoduleSearch = re.compile(r'<option value="http://www\.ucomics\.com/espanol/([^"^/]+)/?"(?: class="drop")?>')
        matches = util.fetchManyMatches(cls.homepage, (submoduleSearch,))[0]

        def fetchSubmodule(module):
            try:
                return util.fetchUrl(cls.baseUrl % module, cls.prevSearch)
            except:
                return False
        return [module for module in matches if fetchSubmodule(module) and module not in exclude]
    fetchSubmodules = classmethod(fetchSubmodules)

