import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule
from dosage.util import fetchUrl, getQueryParams

class CatAndGirl(BasicComicModule):
    latestUrl = 'http://catandgirl.com/'
    imageUrl = 'http://catandgirl.com/view.php?loc=%s'
    imageSearch = re.compile(r'<img src="(archive/[^"\n]+)', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="(view.php\?loc=\d+)"><img src="prev.gif"', re.IGNORECASE)
    help = 'Index format: n'

    def getFilename(self, imageUrl, pageUrl):
        if pageUrl == self.latestUrl:
            prevUrl = fetchUrl(self.latestUrl, self.prevSearch)
            index = int(getQueryParams(prevUrl)['loc'][0]) + 1
        else:
            index = int(getQueryParams(pageUrl)['loc'][0])
        title = imageUrl.split('/')[-1].split('.')[0]
        return '%03d-%s' % (index, title)
