/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#include "opt.h"
#include "proto.h"
#include "results.h"
#include "scan_trigger.h"
#include "scan_windows.h"

#include <memory>
#include <cstdio>
#include <unistd.h>

static bool ms_start (subnets&);
static void ms_open (scan_host_t *);

void
proto_ms_windows_register (void)
{
  proto_register ("ms_windows", ms_start, ms_open);
}

static void ms_open (scan_host_t *)
{
}

class scan_ms_windows : public scan_windows_version {
public:
  scan_ms_windows(event_queue&, ipv4_t);
  virtual void result(windows_type);
};

scan_ms_windows::scan_ms_windows(event_queue& q, ipv4_t host)
  : scan_windows_version(q, host, opt_port)
{
  set_relative_timeout(opt_connect_timeout);
}

void
scan_ms_windows::result(windows_type type)
{
  char *msg = 0;

  switch (type) {
  case windows_me:
    msg = "Windows 98/Me";
    break;
  case windows_xp:
    msg = "Windows XP";
    break;
  case windows_nt:
    msg = "Windows NT";
    break;
  case windows_2000:
    msg = "Windows 2000";
    break;
  case unix_dce:
    if (opt_verbose) {
      msg = "UNIX DCE RPC implementation";
    }
    break;
  case other_dce:
    if (opt_verbose) {
      msg = "other DCE RPC implementation";
    }
    break;
  case unknown:
    if (opt_verbose) {
      msg = "unknown network server";
    }
    break;
  }

  if (msg) {
    results_add(ticks_get_cached(), host(), 0, msg, strlen(msg));
  }
}

static
bool ms_start(subnets& n)
{
  if (opt_receive && opt_receive[0]) {
    fprintf (stderr, "%s: --receive is not supported by this module\n",
             opt_program);
    exit (EXIT_FAILURE);
  }

  if (opt_banner_size) {
    fprintf (stderr, "%s: --banner is not supported by this module.\n",
             opt_program);
    exit (EXIT_FAILURE);
  }

  if (opt_send && (opt_send[0] != 0)) {
    fprintf (stderr, "%s: --send is not supported by this module.\n",
             opt_program);
    exit (EXIT_FAILURE);
  }

  std::auto_ptr<event_queue> q(event_queue::create(opt_fd_count));
  scan_trigger::default_handler<scan_ms_windows> th;
  scan_trigger t(*q, n, th, opt_fd_count, opt_add_timeout, opt_add_burst);

  q->run();
  return false;
}


// arch-tag: 8e811c4d-2146-4810-9a9e-3de687c03b39
