/* doscan - Denial Of Service Capable Auditing of Networks       -*- C++ -*-
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SCAN_WINDOWS_H
#define SCAN_WINDOWS_H

#include "scan_tcp.h"

#include <string>

class scan_windows_version : public tcp_half_duplex_handler {
  bool enough_dcom_data(int state, const std::string& data);
  // Returns true if data contains enough data for a DCOM reply.  If
  // not, a read requested is posted (with the given state).

public:
  scan_windows_version(event_queue&, ipv4_t host, unsigned short port = 135);

  virtual void ready(int state, int error, const std::string& data);

  // This is called prior to the termination of this handler and can
  // be used to trigger further actions (such as adding additional
  // handlers to the queue).

  typedef enum {
    windows_me, windows_xp, windows_nt, windows_2000,
    unix_dce, other_dce, unknown
  } windows_type;

  virtual void result(windows_type) = 0;
};

#endif // SCAN_WINDOWS_H

// arch-tag: 92621601-b0a7-4c1e-b282-15806aa49ba6
