CREATE TABLE dc_pref (
pref_id varchar(255) NOT NULL ,
user_id varchar(32) NULL ,
pref_ws varchar(32) NOT NULL DEFAULT 'system' ,
pref_value text NULL DEFAULT NULL,
pref_type varchar(8) NOT NULL DEFAULT 'string' ,
pref_label text NULL ,
CONSTRAINT dc_uk_pref UNIQUE (pref_ws,pref_id,user_id) 
);
CREATE TABLE dc_spamrule (
rule_id integer NOT NULL ,
blog_id varchar(32) NULL ,
rule_type varchar(16) NOT NULL DEFAULT 'word' ,
rule_content varchar(128) NOT NULL ,
CONSTRAINT dc_pk_spamrule PRIMARY KEY (rule_id) 
);

INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('doclinks', NULL, 'dashboard', '1', 'boolean', '');
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('dcnews', NULL, 'dashboard', '1', 'boolean', '');
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('quickentry', NULL, 'dashboard', '1', 'boolean', '');
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('nodragdrop', NULL, 'accessibility', '0', 'boolean', '');
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('enhanceduploader', NULL, 'interface', '0', 'boolean', '');
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g000', NULL, 'favorites', 'a:8:{s:4:"name";s:8:"new_post";s:5:"title";s:9:"New entry";s:3:"url";s:8:"post.php";s:10:"small-icon";s:20:"images/menu/edit.png";s:10:"large-icon";s:22:"images/menu/edit-b.png";s:11:"permissions";s:18:"usage,contentadmin";s:2:"id";N;s:5:"class";s:13:"menu-new-post";}', 'string', NULL);
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g001', NULL, 'favorites', 'a:8:{s:4:"name";s:5:"posts";s:5:"title";s:7:"Entries";s:3:"url";s:9:"posts.php";s:10:"small-icon";s:23:"images/menu/entries.png";s:10:"large-icon";s:25:"images/menu/entries-b.png";s:11:"permissions";s:18:"usage,contentadmin";s:2:"id";N;s:5:"class";N;}', 'string', NULL);
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g002', NULL, 'favorites', 'a:8:{s:4:"name";s:8:"comments";s:5:"title";s:8:"Comments";s:3:"url";s:12:"comments.php";s:10:"small-icon";s:24:"images/menu/comments.png";s:10:"large-icon";s:26:"images/menu/comments-b.png";s:11:"permissions";s:18:"usage,contentadmin";s:2:"id";N;s:5:"class";N;}', 'string', NULL);
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g003', NULL, 'favorites', 'a:8:{s:4:"name";s:5:"prefs";s:5:"title";s:14:"My preferences";s:3:"url";s:15:"preferences.php";s:10:"small-icon";s:25:"images/menu/user-pref.png";s:10:"large-icon";s:27:"images/menu/user-pref-b.png";s:11:"permissions";s:1:"*";s:2:"id";N;s:5:"class";N;}', 'string', NULL);
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g004', NULL, 'favorites', 'a:8:{s:4:"name";s:9:"blog_pref";s:5:"title";s:13:"Blog settings";s:3:"url";s:13:"blog_pref.php";s:10:"small-icon";s:25:"images/menu/blog-pref.png";s:10:"large-icon";s:27:"images/menu/blog-pref-b.png";s:11:"permissions";s:5:"admin";s:2:"id";N;s:5:"class";N;}', 'string', NULL);
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g005', NULL, 'favorites', 'a:8:{s:4:"name";s:10:"blog_theme";s:5:"title";s:15:"Blog appearance";s:3:"url";s:14:"blog_theme.php";s:10:"small-icon";s:22:"images/menu/themes.png";s:10:"large-icon";s:28:"images/menu/blog-theme-b.png";s:11:"permissions";s:5:"admin";s:2:"id";N;s:5:"class";N;}', 'string', NULL);
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g006', NULL, 'favorites', 'a:8:{s:4:"name";s:5:"pages";s:5:"title";s:5:"Pages";s:3:"url";s:18:"plugin.php?p=pages";s:10:"small-icon";s:27:"index.php?pf=pages/icon.png";s:10:"large-icon";s:31:"index.php?pf=pages/icon-big.png";s:11:"permissions";s:18:"contentadmin,pages";s:2:"id";N;s:5:"class";N;}', 'string', NULL);
INSERT INTO `dc_pref` (`pref_id`, `user_id`, `pref_ws`, `pref_value`, `pref_type`, `pref_label`) VALUES('g007', NULL, 'favorites', 'a:8:{s:4:"name";s:8:"blogroll";s:5:"title";s:8:"Blogroll";s:3:"url";s:21:"plugin.php?p=blogroll";s:10:"small-icon";s:36:"index.php?pf=blogroll/icon-small.png";s:10:"large-icon";s:30:"index.php?pf=blogroll/icon.png";s:11:"permissions";s:18:"usage,contentadmin";s:2:"id";N;s:5:"class";N;}', 'string', NULL);

INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('allow_comments', NULL, 'system', '1', 'boolean', 'Allow comments on blog');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('allow_trackbacks', NULL, 'system', '1', 'boolean', 'Allow trackbacks on blog');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('comments_nofollow', NULL, 'system', '1', 'boolean', 'Add rel="nofollow" to comments URLs');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('comments_pub', NULL, 'system', '1', 'boolean', 'Publish comments immediately');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('comments_ttl', NULL, 'system', '0', 'integer', 'Number of days to keep comments open (0 means no ttl)');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('copyright_notice', NULL, 'system', '', 'string', 'Copyright notice (simple text)');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('date_format', NULL, 'system', '%A, %B %e %Y', 'string', 'Date format. See PHP strftime function for patterns');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('editor', NULL, 'system', '', 'string', 'Person responsible of the content');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('enable_html_filter', NULL, 'system', '0', 'boolean', 'Enable HTML filter');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('enable_xmlrpc', NULL, 'system', '0', 'boolean', 'Enable XML/RPC interface');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('lang', NULL, 'system', 'en', 'string', 'Default blog language');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('media_exclusion', NULL, 'system', '/\\.php$/i', 'string', 'File name exclusion pattern in media manager. (PCRE value)');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('media_img_m_size', NULL, 'system', '448', 'integer', 'Image medium size in media manager');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('media_img_s_size', NULL, 'system', '240', 'integer', 'Image small size in media manager');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('media_img_t_size', NULL, 'system', '100', 'integer', 'Image thumbnail size in media manager');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('media_img_title_pattern', NULL, 'system', 'Title ;; Date(%b %Y) ;; separator(, )', 'string', 'Pattern to set image title when you insert it in a post');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('nb_post_per_page', NULL, 'system', '20', 'integer', 'Number of entries on home page and category pages');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('nb_post_per_feed', NULL, 'system', '20', 'integer', 'Number of entries on feeds');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('nb_comment_per_feed', NULL, 'system', '20', 'integer', 'Number of comments on feeds');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('post_url_format', NULL, 'system', '{y}/{m}/{d}/{t}', 'string', 'Post URL format. {y}: year, {m}: month, {d}: day, {id}: post id, {t}: entry title');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('public_path', NULL, 'system', '/var/lib/dotclear/web/public', 'string', 'Path to public directory, begins with a / for a full system path');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('public_url', NULL, 'system', '/dotclear/public', 'string', 'URL to public directory');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('robots_policy', NULL, 'system', 'INDEX,FOLLOW', 'string', 'Search engines robots policy');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('short_feed_items', NULL, 'system', '0', 'boolean', 'Display short feed items');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('theme', NULL, 'system', 'default', 'string', 'Blog theme');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('themes_path', NULL, 'system', '/var/lib/dotclear/web/themes', 'string', 'Themes root path');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('themes_url', NULL, 'system', '/dotclear/themes', 'string', 'Themes root URL');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('time_format', NULL, 'system', '%H:%M', 'string', 'Time format. See PHP strftime function for patterns');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('tpl_allow_php', NULL, 'system', '0', 'boolean', 'Allow PHP code in templates');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('tpl_use_cache', NULL, 'system', '1', 'boolean', 'Use template caching');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('trackbacks_pub', NULL, 'system', '1', 'boolean', 'Publish trackbacks immediately');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('trackbacks_ttl', NULL, 'system', '0', 'integer', 'Number of days to keep trackbacks open (0 means no ttl)');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('url_scan', NULL, 'system', 'query_string', 'string', 'URL handle mode (path_info or query_string)');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('use_smilies', NULL, 'system', '0', 'boolean', 'Show smilies on entries and comments');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('wiki_comments', NULL, 'system', '0', 'boolean', 'Allow commenters to use a subset of wiki syntax');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('lang', 'default', 'system', 'fr', 'string', 'Default blog language');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('public_url', 'default', 'system', '/dotclear/public', 'string', 'URL to public directory');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('themes_url', 'default', 'system', '/dotclear/themes', 'string', 'Themes root URL');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('date_format', 'default', 'system', '%A %e %B %Y', 'string', 'Date format. See PHP strftime function for patterns');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('antispam_moderation_ttl', NULL, 'antispam', '0', 'integer', 'Antispam Moderation TTL (days)');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('blowup_style', NULL, 'themes', '', 'string', 'Blow Up  custom style');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('simpleMenu', NULL, 'system', 'a:2:{i:0;a:3:{s:5:"label";s:4:"Home";s:5:"descr";s:12:"Recent posts";s:3:"url";s:24:"/dotclear/index.php?";}i:1;a:3:{s:5:"label";s:8:"Archives";s:5:"descr";s:0:"";s:3:"url";s:31:"/dotclear/index.php?archive";}}', 'string', 'simpleMenu default menu');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('dainstaller_plugins_xml', NULL, 'dainstaller', 'http://update.dotaddict.org/dc2/plugins.xml', 'string', 'Plugins XML feed location');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('dainstaller_themes_xml', NULL, 'dainstaller', 'http://update.dotaddict.org/dc2/themes.xml', 'string', 'Themes XML feed location');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('dainstaller_allow_multi_install', NULL, 'dainstaller', '0', 'boolean', 'Allow the multi-installation');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('widgets_nav', 'default', 'widgets', '', 'string', 'Navigation widgets');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('widgets_extra', 'default', 'widgets', '', 'string', 'Extra widgets');
INSERT INTO `dc_setting` (`setting_id`, `blog_id`, `setting_ns`, `setting_value`, `setting_type`, `setting_label`) VALUES('widgets_custom', 'default', 'widgets', '', 'string', 'Custom widgets');

INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(1, NULL, 'word', '/-credit(\\s+|$)/');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(2, NULL, 'word', '/-digest(\\s+|$)/');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(3, NULL, 'word', '/-loan(\\s+|$)/');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(4, NULL, 'word', '/-online(\\s+|$)/');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(5, NULL, 'word', '4u');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(6, NULL, 'word', 'adipex');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(7, NULL, 'word', 'advicer');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(8, NULL, 'word', 'ambien');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(9, NULL, 'word', 'baccarat');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(10, NULL, 'word', 'baccarrat');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(11, NULL, 'word', 'blackjack');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(12, NULL, 'word', 'bllogspot');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(13, NULL, 'word', 'bolobomb');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(14, NULL, 'word', 'booker');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(15, NULL, 'word', 'byob');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(16, NULL, 'word', 'car-rental-e-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(17, NULL, 'word', 'car-rentals-e-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(18, NULL, 'word', 'carisoprodol');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(19, NULL, 'word', 'cash');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(20, NULL, 'word', 'casino');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(21, NULL, 'word', 'casinos');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(22, NULL, 'word', 'chatroom');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(23, NULL, 'word', 'cialis');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(24, NULL, 'word', 'craps');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(25, NULL, 'word', 'credit-card');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(26, NULL, 'word', 'credit-report-4u');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(27, NULL, 'word', 'cwas');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(28, NULL, 'word', 'cyclen');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(29, NULL, 'word', 'cyclobenzaprine');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(30, NULL, 'word', 'dating-e-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(31, NULL, 'word', 'day-trading');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(32, NULL, 'word', 'debt');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(33, NULL, 'word', 'digest-');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(34, NULL, 'word', 'discount');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(35, NULL, 'word', 'discreetordering');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(36, NULL, 'word', 'duty-free');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(37, NULL, 'word', 'dutyfree');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(38, NULL, 'word', 'estate');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(39, NULL, 'word', 'favourits');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(40, NULL, 'word', 'fioricet');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(41, NULL, 'word', 'flowers-leading-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(42, NULL, 'word', 'freenet');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(43, NULL, 'word', 'freenet-shopping');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(44, NULL, 'word', 'gambling');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(45, NULL, 'word', 'gamias');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(46, NULL, 'word', 'health-insurancedeals-4u');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(47, NULL, 'word', 'holdem');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(48, NULL, 'word', 'holdempoker');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(49, NULL, 'word', 'holdemsoftware');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(50, NULL, 'word', 'holdemtexasturbowilson');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(51, NULL, 'word', 'hotel-dealse-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(52, NULL, 'word', 'hotele-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(53, NULL, 'word', 'hotelse-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(54, NULL, 'word', 'incest');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(55, NULL, 'word', 'insurance-quotesdeals-4u');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(56, NULL, 'word', 'insurancedeals-4u');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(57, NULL, 'word', 'jrcreations');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(58, NULL, 'word', 'levitra');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(59, NULL, 'word', 'macinstruct');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(60, NULL, 'word', 'mortgage');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(61, NULL, 'word', 'online-gambling');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(62, NULL, 'word', 'onlinegambling-4u');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(63, NULL, 'word', 'ottawavalleyag');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(64, NULL, 'word', 'ownsthis');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(65, NULL, 'word', 'palm-texas-holdem-game');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(66, NULL, 'word', 'paxil');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(67, NULL, 'word', 'pharmacy');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(68, NULL, 'word', 'phentermine');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(69, NULL, 'word', 'pills');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(70, NULL, 'word', 'poker');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(71, NULL, 'word', 'poker-chip');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(72, NULL, 'word', 'poze');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(73, NULL, 'word', 'prescription');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(74, NULL, 'word', 'rarehomes');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(75, NULL, 'word', 'refund');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(76, NULL, 'word', 'rental-car-e-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(77, NULL, 'word', 'roulette');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(78, NULL, 'word', 'shemale');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(79, NULL, 'word', 'slot');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(80, NULL, 'word', 'slot-machine');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(81, NULL, 'word', 'soma');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(82, NULL, 'word', 'taboo');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(83, NULL, 'word', 'tamiflu');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(84, NULL, 'word', 'texas-holdem');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(85, NULL, 'word', 'thorcarlson');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(86, NULL, 'word', 'top-e-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(87, NULL, 'word', 'top-site');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(88, NULL, 'word', 'tramadol');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(89, NULL, 'word', 'trim-spa');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(90, NULL, 'word', 'ultram');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(91, NULL, 'word', 'v1h');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(92, NULL, 'word', 'vacuum');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(93, NULL, 'word', 'valeofglamorganconservatives');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(94, NULL, 'word', 'viagra');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(95, NULL, 'word', 'vicodin');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(96, NULL, 'word', 'vioxx');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(97, NULL, 'word', 'xanax');
INSERT INTO `dc_spamrule` (`rule_id`, `blog_id`, `rule_type`, `rule_content`) VALUES(98, NULL, 'word', 'zolus');

UPDATE dc_version SET version = '2.5.0' WHERE module='core';
