/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 *	$Id: cdinfo.h,v 1.4 2003/02/14 13:30:14 bstard Exp $
 */

#undef	DEBUG

#include <stdio.h>		/* printf() */
#include <getopt.h>		/* getopt() */
#include <errno.h>		/* error numbers */
#include <unistd.h>		/* read(), write(), close(), STDIN_FILENO */
#include <sys/types.h>		/* open() */
#include <sys/stat.h>		/* open() */
#include <fcntl.h>		/* open(), O_RDONLY */
#include <ctype.h>		/* tolower() */
#include <string.h>		/* strrchr() */
#include "iso9660.h"		/* iso9660 structures & definitions (mkisofs)*/
#include "drip.h"


#define	STD_CHANNEL	stdout
#define	HELP_CHANNEL	stdout
#define	ERROR_CHANNEL	stderr
#define	VERSION_CHANNEL	stdout
#define	DEBUG_CHANNEL	stderr

#define	DEFAULT_INPUT_FILE	"/dev/cdrom"

#define	ISO_BLOCK_SIZE	2048
#define	ISO_PD_BLOCK	16			/* PD = primary desciptor */
#define	ISO_PD_OFFSET	ISO_PD_BLOCK*ISO_BLOCK_SIZE

#ifndef	CD_SECS
#define	CD_SECS		60
#endif
#ifndef	CD_FRAMES
#define	CD_FRAMES	75
#endif

#define	ISO_STR( A )	iso_str( (A), sizeof(A) )

#define	RETVAL_OK	0
#define	RETVAL_OPTION	1
#define	RETVAL_ERROR	2

#define	VERSION_NUMBER		"0.02.01"
#define	DATE_OF_LAST_MOD	"2000-12-19"
#define	MY_EMAIL_ADDRESS	"Steffen Solyga <solyga@absinth.net>"


/* Proto's */
ssize_t my_read(int fd, void* buf, size_t nbtr);
long iso_num_733( char* p);
char* iso_str(char* p, int n);
char* iso_date(char* p);
int fra2min(int f);
int fra2sec(int f);
int fra2fra(int f);
char* basename(const char* filename);
int cdinfo(drip_config *Config);
