/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "../config.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
/* libdvdread includes */
#include <dvdread/dvd_reader.h>
#include <dvdread/ifo_types.h>
#include <dvdread/ifo_read.h>
#include <dvdread/nav_read.h>
#include <dvdread/nav_print.h>
/* Other */
#include <stdlib.h>

//#include <dmalloc.h>

#ifndef DRIP
#define DRIP

#define DRIP_LD "Drip"        /* Regulair Drip log domain, locks */
#define DRIP_CB_LD "DripCB"   /* CallBack log domain, does not lock */
//#define DRIP_UNLOCKED_LD "DripUnlocked"
//#define DEBUG               /* Enables debug status */
#define CONFIG_VERSION "10"   /* Used for config file version structure */
#define DVDTITLE_VERSION "7"  /* Used for checking cache description structure */
// #define LM_SENSORS         /* Enables lm-sensors monitoring, and pauses Drip if CPU > 50deg celcius */
#define AMAX 2                /* Max number of audio channels in output avi */
#define RANGE 400             /* Max amount of 'titles' Drip can handle */
#define RANGE_VTS 32         
#define RANGE_VT 32
#define RANGE_PC RANGE
#define RANGE_CHAP 128

typedef enum {
    DVDTITLE_DVDDISK,
    DVDTITLE_DVDIMAGE,
    DVDTITLE_DRIPCACHE,
    DVDTITLE_DVD2VCDDISK,
    DVDTITLE_DRIPCACHE2VCD,
    MPEG_PLAIN,
    UNKNOWN
} cmode_t;

typedef enum {
    VIDEO_CODEC,
    AUDIO_CODEC,
    UNKNOWN_CODEC
} codecT;

typedef struct _codecS codecS;
struct _codecS {
    GString *ctype;
    glong ccodec;
    codecT cav;
    GString *cmodule;
    GString *cdescription;
    guint length;
    gpointer ci;  // itypeless pointer to Avifile CodeInfo
};

// Struct for holding user selection of dvd chapters
typedef struct _selected_chapters_t selected_chapters_t;
struct _selected_chapters_t {
    gint VTS;
    gint VT;
    gint PC;
    gint CHAP;
    gint CHAP_TOTAL;
    gint ANGL;
    gfloat frames;
};

typedef struct _drip_config drip_config;
// TODO: all config in one struct seems not to be perfect...
struct _drip_config {
    GString *DVDdevice;
    dvd_reader_t* DVDhandle;
    GString *DVDsource;
    GString *DIVXfileUser;
    GString *DIVXfileFormatted;
    GString *start_directory;
    gint DVD_TitleSets;
    gint DVD_Total_Titles;
    gint DVD_Total_ChapterSequences;
    gint VTS_Titles[RANGE];
    gint VT_Chapters[RANGE];
    gint VT_Angles[RANGE];
    gdouble VTS_Aspects[RANGE];
    gint VT_is_DVDtitle[RANGE];
    gint CS[RANGE];
    GString *CS_files[RANGE][RANGE];
    gint CS_current;
    gint VT_belongs_to_VTS[RANGE];
    gint CS_belongs_to_VT[RANGE];
    gint CS_starts_at_Chapter[RANGE];
    gint CS_Chapters[RANGE];
    gint VT_is_Title_of_VTS[RANGE];
    GList *selected_chapters[RANGE];
    gfloat selected_chapters_frames[RANGE];
    gint CURRENT_AVIFILE;
    gboolean useDVDdevice;
    glong maxsize;
    glong in_width;
    glong in_height;
    glong set_width;
    glong set_height;
    gint angle;
    gint out_width;
    gint out_height;
    gboolean hyper_zoom;
    gdouble framerate;
    gint video_bitrate;
    gint video_stream;
    gint audio_bitrate; /* -1 = auto */
    gint audio_1st_stream;
    gint audio_2nd_stream;
    gboolean audio_norm;
    gint encoding_video_codec;
    gint encoding_audio_codec;
    gboolean autoclip;
    gint autoclip_frames;
    gboolean deinterlace;
    gboolean pulldown;
    gint cliptop;
    gint clipbottom;
    gint clipright;
    gint clipleft;
    gint blurradius;
    gboolean eject_dvdrom;
    gboolean use_dvddb;
    gint nice;
    gint cpus;
    gint PipeRead;
    cmode_t conversion_mode;
    gboolean encode;
    GString *track_dir;
    GString *CACHElocation;
    gboolean cache_delete_on_exit;
    GString *cached_files[RANGE];
    gboolean cache_chunk;
    gboolean done_warning;
    gint audio_channels_in_dvd[RANGE];
    GString *audio_channel_names[RANGE][8];
    gint audio_channel_types[RANGE][8];
    gint subpictures_in_dvd[RANGE];
    GString *subpicture_names[RANGE][32];
    gint subpicture_stream;
    GString* clutfile;
    gboolean create_iso;
    gboolean debug_log;
    gint frames2encode[RANGE];
    gint mainwindow_X,mainwindow_Y;
    GString* DVDvolumeid;
    GString* DVDpublisher;
    GString* DVDpreparer;
    GString* DVDcreationdate;
    glong DVDvolumesize_MB;
    gint codecs_amount;
    codecS* codecs;
    gdouble progres_size;
    gboolean two_audio_channels_support;
    GString *audio_preferedA;
    GString *audio_preferedB;
    GString *spu_preferedA;
    GString *spu_preferedB;
    gint anum; // amount of audio channels in generated avi
    gboolean audio_2nd_enabled;
};

typedef struct _rip rip;
struct _rip {
    gchar *dir;
    gchar *track;
    guint nr;
};

extern gboolean booted;
extern drip_config Config;
extern GString *status_action;
extern guint status_perc;
extern GtkWidget *appbar1;
extern gboolean converting;
extern guint log_handler_drip_id;
extern GtkWidget *textscreen;
extern gboolean corba;
extern gint log_file;
extern GtkWidget *gpixmap;
extern GtkWidget *hbox_main;
extern GtkWidget *combo_entry_divx_filename;
extern GtkWidget *fileentry_divx;

#endif //#ifndef DRIP

#ifdef __cplusplus
extern "C" {
#endif
void log_handler(const gchar *log_domain,GLogLevelFlags log_level,const gchar *message,gpointer user_data);
int mpeg2divx(drip_config *Config,int mpegfiles,char *files[]);
gchar* detect_dvdrom(void);
gboolean drip_domain(void);
void drip_init(void);
void terminate(gboolean hard,gboolean lock);
void drip_lock(const gchar *location);
void drip_unlock(const gchar *location);
gboolean DVDsymlink(void);
#ifdef __cplusplus
}
#endif

/* encoding time passed */
extern gboolean encoding_time;
extern gboolean quit_converting;
/* iso making flag */
extern gboolean making_iso;
extern gboolean encoding;
extern gboolean encoding_paused;
extern gboolean stopped;
extern GtkWidget *mainwindow;
extern GtkWidget *plugin_GUI_socket;
extern GtkWidget *checkbutton_active;
extern gdouble SCRframe; // Drip's System Clock Referance value
extern gdouble PTSframe; 

#ifdef LM_SENSORS
/* heat monitor thread */
extern pthread_t heatthread;
extern gint heatthread_id;
#endif /* LM_SENSORS */

extern glong writeout_frames_countdown;
