#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Bookmarks Dialog

import os.path
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drProperty import *

def CheckBranch(tree, branch):
	t = tree.GetItemText(branch)
	isfolder = (t[0] == '>')
	if isfolder:
		ccount = tree.GetChildrenCount(branch, 0)
		if (ccount < 1):
			tree.SetBadBranch(branch)
			return 0
		else:
			b, cookie = tree.GetFirstChild(branch, 1)
			rvalue = CheckBranch(tree, b)
			x = 1
			while (x < ccount):
				b, cookie = tree.GetNextChild(branch, cookie)
				rvalue = rvalue and CheckBranch(tree, b)
				x = x + 1
			return rvalue
	return 1

def CreateBranchString(tree, branch, tablevel):	
	t = tree.GetItemText(branch)
	isfolder = (t[0] == '>')
	x = 0
	y = ""
	while (x < tablevel):
		y = y + '\t'
		x = x + 1
	y = y + t + "\n"
	s = y
	if isfolder:
		ccount = tree.GetChildrenCount(branch, 0)
		if (ccount > 0):
			b, cookie = tree.GetFirstChild(branch, 1)
			s = s + CreateBranchString(tree, b, (tablevel + 1))
			x = 1
			while (x < ccount):
				b, cookie = tree.GetNextChild(branch, cookie)
				s = s + CreateBranchString(tree, b, (tablevel + 1))
				x = x + 1
	return s

def BuildTreeFromString(tree, branch, thestring):
	line = " "
	roots = [branch]
	rootindex = 0
	lastCount = 1
	i = 0
	lastI = 0
	#Skip the First Line
	i = thestring.find('\n')
	if (i > -1):
		line = thestring[0:(i + 1)]
		lastI = i + 1
	thestring = thestring[lastI:]
	#Get On With It!
	while (len(line) > 0):
		i = thestring.find('\n')
		if (i > -1):
			line = thestring[0:(i + 1)]
			lastI = i + 1
			thestring = thestring[lastI:]
			c = line.count('\t')
			line = line[c:].rstrip()
			while (lastCount > c):
				roots.pop()
				rootindex = rootindex - 1
				lastCount = lastCount - 1
			currentItem = tree.AppendItem(roots[rootindex], line)
			if (line[0] == '>'):
				tree.SetItemImage(currentItem, 0, wxTreeItemIcon_Normal)
				tree.SetItemImage(currentItem, 1, wxTreeItemIcon_Expanded)
				roots.append(currentItem)
				rootindex = rootindex + 1
			else:
				tree.SetItemImage(currentItem, 2, wxTreeItemIcon_Normal)
				tree.SetItemImage(currentItem, 2, wxTreeItemIcon_Selected)
			lastCount = c
		else:
			line = ""

def WriteBranch(tree, branch, filehandle, tablevel):
	t = tree.GetItemText(branch)
	isfolder = (t[0] == '>')
	x = 0
	y = ""
	while (x < tablevel):
		y = y + '\t'
		x = x + 1
	y = y + t + "\n"
	filehandle.write(y)
	if isfolder:
		ccount = tree.GetChildrenCount(branch, 0)
		if (ccount > 0):
			b, cookie = tree.GetFirstChild(branch, 1)
			WriteBranch(tree, b, filehandle, (tablevel + 1))
			x = 1
			while (x < ccount):
				b, cookie = tree.GetNextChild(branch, cookie)
				WriteBranch(tree, b, filehandle, (tablevel + 1))
				x = x + 1

class drTree(wxTreeCtrl):
	def __init__(self, parent, id, point, size, style):
		wxTreeCtrl.__init__(self, parent, id, point, size, style)
		
		style = self.GetGrandParent().prefs.bookmarksstyle
		yarrr = convertStyleStringTowxFontArray(style)
		
		imagesize = (16,16)
		
		self.imagelist = wxImageList(imagesize[0], imagesize[1])
		self.images = [wxArtProvider_GetBitmap(wxART_FOLDER, wxART_OTHER, imagesize), \
		wxArtProvider_GetBitmap(wxART_FILE_OPEN, wxART_OTHER, imagesize), \
		wxArtProvider_GetBitmap(wxART_GO_FORWARD, wxART_OTHER, imagesize)]
		
		map(self.imagelist.Add, self.images)
		
		self.SetImageList(self.imagelist)
		
		w = wxFont(yarrr[1], wxNORMAL, wxNORMAL, wxNORMAL, yarrr[2])
		
		w.SetFaceName(yarrr[0])
		
		if (yarrr[3]):
			w.SetWeight(wxBOLD)
		else:
			w.SetWeight(wxNORMAL)
		if (yarrr[4]):
			w.SetStyle(wxITALIC)
		else:
			w.SetStyle(wxNORMAL)
		
		self.SetFont(w)
					
		f = convertColorPropertyToColorArray(getStyleProperty("fore", style))
		b = convertColorPropertyToColorArray(getStyleProperty("back", style))
				
		self.TextColor = wxColour(f[0], f[1], f[2])
		
		self.SetForegroundColour(self.TextColor)
							
		self.badbranch = 0
		self.dragging = 0
		self.draggingId = self.GetRootItem()
		self.dragString = ""
		
		self.SetBackgroundColour(wxColour(b[0], b[1], b[2]))

		self.editing = 0

		EVT_TREE_BEGIN_DRAG(self, id, self.OnBeginDrag)
		EVT_TREE_ITEM_ACTIVATED(self, id, self.OnItemActivated)
		EVT_LEFT_UP(self, self.OnLeftUp)
		EVT_MOTION(self, self.OnMotion)
		
	def GetBadBranch(self):
		return self.badbranch		
				
	def OnBeginDrag(self, event):				
		self.draggingId = self.GetSelection()
		if (self.draggingId == self.GetRootItem()) or (not self.draggingId.IsOk()):
			return
				
		t = self.GetItemText(self.draggingId)
		if (t[0] == '>'):
			self.dragString = CreateBranchString(self, self.draggingId, 0)
		
		self.SetCursor(wxStockCursor(wxCURSOR_HAND))
		self.dragging = 1
					
	def OnItemActivated(self, event):
		sel = self.GetSelection()
		if (not sel.IsOk()):
			return
		self.editing = 1
		self.EditLabel(sel)
		
	def OnLeftUp(self, event):
		self.SetCursor(wxSTANDARD_CURSOR)
		if (self.dragging):
			self.dragging = 0
			item, flags = self.HitTest(event.GetPosition())
			if (item.IsOk()):
				if (item == self.draggingId):
					return
				t = self.GetItemText(item)
				olditem = self.GetItemParent(item)
				if not (t[0] == '>'):
					olditem = item
					item = self.GetItemParent(item)
				newbranch = self.InsertItem(item, olditem, self.GetItemText(self.draggingId))
				self.SetItemImage(newbranch, 2, wxTreeItemIcon_Normal)
				self.SetItemImage(newbranch, 2, wxTreeItemIcon_Selected)
				if (len(self.dragString) > 0):
					BuildTreeFromString(self, newbranch, self.dragString)
				self.Delete(self.draggingId)
				self.SelectItem(newbranch)
			self.dragString = ""
	
	def OnMotion(self, event):
		if (self.dragging):		
			sel, flags = self.HitTest(event.GetPosition())			
			if (sel.IsOk()):
				self.SelectItem(sel)						
		event.Skip()
		
	def SetBadBranch(self, branch):
		self.badbranch = branch	

class drBookmarksDialog(wxDialog):

	def __init__(self, parent, bookmarksfile):
		wxDialog.__init__(self, parent, -1, ("Edit Bookmarks"), wxPoint(50, 50), wxSize(425, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
		
		self.ID_ADD = 1001
		self.ID_ADD_FOLDER = 1002
		self.ID_REMOVE = 1003
		self.ID_SAVE = 1005
		
		self.theSizer = wxBoxSizer(wxVERTICAL)
		
		self.cmdSizer = wxBoxSizer(wxHORIZONTAL)
		
		self.homedirectory = parent.homedirectory
		self.wildcard = parent.wildcard
		self.bookmarksfile = bookmarksfile
		
		self.btnAdd = wxButton(self, self.ID_ADD, "&Add")
		self.btnAddFolder = wxButton(self, self.ID_ADD_FOLDER, "Add &Folder")
		self.btnRemove = wxButton(self, self.ID_REMOVE, "&Remove")
		self.btnSave = wxButton(self, self.ID_SAVE, "&Save")
		
		self.cmdSizer.Add(self.btnAdd, 0, wxSHAPED)
		self.cmdSizer.Add(self.btnAddFolder, 0, wxSHAPED)
		self.cmdSizer.Add(self.btnRemove, 0, wxSHAPED)
		self.cmdSizer.Add(self.btnSave, 0, wxSHAPED)

		self.theSizer.Add(self.cmdSizer, 0, wxSHAPED | wxALIGN_CENTER)
		
		self.parent = parent
		
		self.bookmarkstree = drTree(self, -1, wxPoint(0, 0), wxSize(400, 200), wxTR_DEFAULT_STYLE | wxTR_EDIT_LABELS)
		self.theSizer.Add(self.bookmarkstree, 9, wxEXPAND)
	
		root = self.bookmarkstree.AddRoot(">Bookmarks")

		self.bookmarkstree.SetItemImage(root, 0, wxTreeItemIcon_Normal)
		self.bookmarkstree.SetItemImage(root, 1, wxTreeItemIcon_Expanded)
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0, wxSHAPED | wxALIGN_CENTER)
		self.btnClose.SetDefault()
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
		
		self.initialize()
		
		self.bookmarkstree.Expand(root)
		
		EVT_BUTTON(self, self.ID_ADD, self.OnbtnAdd)
		EVT_BUTTON(self, self.ID_ADD_FOLDER, self.OnbtnAddFolder)
		EVT_BUTTON(self, self.ID_REMOVE, self.OnbtnRemove)
		EVT_BUTTON(self, self.ID_SAVE, self.OnbtnSave)
		EVT_BUTTON(self, 101, self.OnbtnClose)
	
	def initialize(self):
		if (os.path.exists(self.bookmarksfile)):
			try:
				f = open(self.bookmarksfile, 'r')
				BuildTreeFromString(self.bookmarkstree, self.bookmarkstree.GetRootItem(), f.read())
				f.close()
			except:
				d = wxScrolledMessageDialog(self.parent, ("Your bookmarks file is a tad messed up.\n"), "Error")
				d.ShowModal()
				d.Destroy()
				
	def OnbtnAdd(self, event):
		sel = self.bookmarkstree.GetSelection()
		if (not sel.IsOk()):
			return
		if (self.bookmarkstree.GetItemText(sel)[0] == '>'):
			d = wxSingleChoiceDialog(self, "Add Bookmark:", "Add Bookmark", ["Type It In", "Select File", "Select Directory"], wxOK|wxCANCEL)
			d.SetSize(wxSize(250, 200))
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_OK):
				s = d.GetStringSelection()
				currentItem = None
				if (s == "Type It In"):
					d = wxTextEntryDialog(self, 'Enter Bookmark:', 'Add Bookmark', '')
					if (d.ShowModal() == wxID_OK):
						v = d.GetValue()
						currentItem = self.bookmarkstree.AppendItem(sel, v)
					d.Destroy()
				elif (s == "Select Directory"):
					d = wxDirDialog(self, "Select Directory:", style=wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON|wxMAXIMIZE_BOX|wxTHICK_FRAME)
					if (len(self.parent.ddirectory) > 0):
						try:
							d.SetPath(self.parent.ddirectory)			
						except:
							de = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.ddirectory), "DrPython Error")
							de.ShowModal()
							de.Destroy()
					if d.ShowModal() == wxID_OK:
						currentItem = self.bookmarkstree.AppendItem(sel, d.GetPath())
					d.Destroy()
				else:
					dlg = wxFileDialog(self, "Select File", "", "", self.wildcard, wxOPEN|wxHIDE_READONLY)
					if (len(self.parent.ddirectory) > 0):
						try:
							dlg.SetDirectory(self.parent.ddirectory)			
						except:
							d = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.ddirectory), "DrPython Error")
							d.ShowModal()
							d.Destroy()
					if (dlg.ShowModal() == wxID_OK):
						currentItem = self.bookmarkstree.AppendItem(sel, dlg.GetPath().replace("\\", "/"))
					dlg.Destroy()
					
				if currentItem is not None:
					self.bookmarkstree.SetItemImage(currentItem, 2, wxTreeItemIcon_Normal)
					self.bookmarkstree.SetItemImage(currentItem, 2, wxTreeItemIcon_Selected)
		else:
			d = wxScrolledMessageDialog(self, "You can only add a bookmark to a folder.\nSelect either \"Bookmarks\", or a folder.", "Bad Bookmark Folder")
			d.ShowModal()
			d.Destroy()
		
	def OnbtnAddFolder(self, event):
		sel = self.bookmarkstree.GetSelection()
		if (not sel.IsOk()):
			return
		if (self.bookmarkstree.GetItemText(sel)[0] == '>'):
			d = wxTextEntryDialog(self, 'Enter Bookmark Folder:', 'Add Bookmark Folder', '')
			if (d.ShowModal() == wxID_OK):
				v = d.GetValue()
				item = self.bookmarkstree.AppendItem(self.bookmarkstree.GetSelection(), ">" + v)
				self.bookmarkstree.SetItemImage(item, 0, wxTreeItemIcon_Normal)
				self.bookmarkstree.SetItemImage(item, 1, wxTreeItemIcon_Expanded)
			d.Destroy()
		else:
			d = wxScrolledMessageDialog(self, "You can only add a folder to another folder.\nSelect either \"Bookmarks\", or a folder.", "Bad Bookmark Folder")
			d.ShowModal()
			d.Destroy()
		
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnbtnRemove(self, event):
		sel = self.bookmarkstree.GetSelection()
		if (not sel.IsOk()):
			return
		if (sel == self.bookmarkstree.GetRootItem()):
			d = wxScrolledMessageDialog(self, "You can't remove the Root Item.\n", "Mistake")
			d.ShowModal()
			d.Destroy()
			return			
		t = self.bookmarkstree.GetItemText(sel)
		message = "This will remove the bookmark: " + t
		if (self.bookmarkstree.GetItemText(sel)[0] == '>'):
			message = "This will remove all bookmarks in folder: " + t + "!"
		d = wxMessageDialog(self, (message + "\nAre you sure you want to do this?"), "DrPython", wxYES_NO | wxICON_QUESTION)
		answer = d.ShowModal()
		d.Destroy()
		if (answer == wxID_NO):
			return
		try:	
			self.bookmarkstree.Delete(sel)
		except:
			d = wxScrolledMessageDialog(self, ("Something went wrong trying to remove that item....\nWhat's it called....\nOh yes: " + t + "\n"), "Error")
			d.ShowModal()
			d.Destroy()
			return	
	
	def OnbtnSave(self, event):
		if (not os.path.exists(self.homedirectory)):
			d = wxScrolledMessageDialog(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			d.ShowModal()
			d.Destroy()
			return
		try:
			root = self.bookmarkstree.GetRootItem()
			if not CheckBranch(self.bookmarkstree, root):
				text = ""
				sel = 0
				try:
					sel = self.bookmarkstree.GetBadBranch()
					text = self.bookmarkstree.GetItemText(sel)
				except:
					text = "<ERROR:LINE 250 or so>"					
				d = wxScrolledMessageDialog(self, ("Folder " + text + " does not have any bookmarks.\nAll folders must have bookmarks in them.\n"), "Mistake")
				d.ShowModal()
				d.Destroy()
				if (text == "<ERROR:LINE 250 or so>"):
					return
				self.bookmarkstree.SelectItem(sel)
				return				
			if (self.bookmarkstree.GetChildrenCount(root) < 1):
				d = wxScrolledMessageDialog(self, ("Nothing to write!\n"), "Mistake")
				d.ShowModal()
				d.Destroy()
				return
			f = open(self.bookmarksfile, 'w')
			WriteBranch(self.bookmarkstree, root, f, 0)
			f.close()			
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + self.bookmarksfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
		if self.parent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully wrote to:\n"  + self.bookmarksfile), "Saved Bookmarks")
			d.ShowModal()
			d.Destroy()	