#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Documentation Bookmarks Menu

import os.path
from wxPython.wx import *
from drProperty import *
from wxPython.lib.dialogs import wxScrolledMessageDialog

class drDocsBookmarksMenu(wxMenu):
	def __init__(self, parent):
		wxMenu.__init__(self)
				
		self.ID_EDIT_BOOKMARKS = 3010

		self.ID_BOOKMARK_BASE = 15000

		self.ID_BOOKMARK_MENU = 1199
				
		self.bookmarks = []
		
		self.wildcard = parent.wildcard
		
		self.parent = parent
		self.homedirectory = parent.homedirectory
		
		self.setupMenu()
		
		self.loadBookmarks()
		
		
	def loadBookmarks(self):
		bookfile = self.homedirectory + "/documentation.bookmarks.dat"
		if (os.path.exists(bookfile)):
			try:
				#Read from the file
				f = open(bookfile, 'r')
				folders = [self]
				folderindex = 0
				menuTitles = []
				menuTitleindex = -1
				lastCount = 1
				bookmarkcount = 0
				#Skip the First Line
				line = f.readline()
				#Initialize
				line = f.readline()
				while (len(line) > 0):
					c = line.count('\t')
					line = line[c:].rstrip()
					while (lastCount > c):
						folders[(folderindex - 1)].AppendMenu(self.ID_BOOKMARK_MENU, menuTitles.pop(), folders.pop())					
						folderindex = folderindex - 1
						menuTitleindex = menuTitleindex - 1
						lastCount = lastCount - 1
					if (line[0] == '>'):
						folders.append(wxMenu())
						menuTitles.append(line[1:])
						folderindex = folderindex + 1
						menuTitleindex = menuTitleindex + 1
					else:
						self.bookmarks.append(line)
						EVT_MENU(self.parent, (self.ID_BOOKMARK_BASE + bookmarkcount), self.OnBookmark)
						folders[folderindex].Append((self.ID_BOOKMARK_BASE + bookmarkcount), line, line)
						bookmarkcount = bookmarkcount + 1
					lastCount = c
					line = f.readline()
				f.close()
				#Add any menus not yet added:
				c = 1
				while (lastCount > c):
					folders[(folderindex - 1)].AppendMenu(self.ID_BOOKMARK_MENU, menuTitles.pop(), folders.pop())					
					folderindex = folderindex - 1
					menuTitleindex = menuTitleindex - 1
					lastCount = lastCount - 1
			except:
				d = wxScrolledMessageDialog(self.parent, ("Your bookmarks file is a tad messed up.\n"), "Error")
				d.ShowModal()
				d.Destroy()
		
	def OnBookmark(self, event):
		bookmarkindex = event.GetId() - self.ID_BOOKMARK_BASE
		wxExecute((self.parent.prefs.documentationbrowser + " " + self.bookmarks[bookmarkindex]), wxEXEC_ASYNC)
		
	def OnEditBookmarks(self, event):	
		from drBookmarksDialog import drBookmarksDialog
		d = drBookmarksDialog(self.parent,(self.homedirectory + "/documentation.bookmarks.dat"))
		d.ShowModal()
		d.Destroy()
		self.reloadBookmarks()
	
	def setupMenu(self):		
		self.Append(self.ID_EDIT_BOOKMARKS, "&Edit Bookmarks...", " Edit Bookmarks")
		self.AppendSeparator()
		
		EVT_MENU(self.parent, self.ID_EDIT_BOOKMARKS, self.OnEditBookmarks)
	
	def reloadBookmarks(self):		
		mnuitems = self.GetMenuItems()
		num = len(mnuitems)
		x = 0
		while (x < num):
			self.Remove(mnuitems[x].GetId())
			mnuitems[x].Destroy()
			x = x + 1
		self.bookmarks = []
		self.setupMenu()
		self.loadBookmarks()
			