#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Dynamic DrScript Dialog

import os.path, traceback, sys
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drText import DrText

def getTraceBackString():
	slist = traceback.format_tb(sys.exc_info()[2])
	l = len(slist)
	x = 0
	rstring = ""
	while x < l:
		rstring = rstring + slist[x]
		x = x + 1
	return str(sys.exc_info()[0]) + ":\n\n" + str(sys.exc_info()[1]) + "\n\n" + rstring

class drDynamicDrScriptDialog(wxDialog):

	def __init__(self, parent):
		wxDialog.__init__(self, parent, -1, ("Dynamic DrScript"), wxPoint(50, 50), wxSize(425, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
				
		self.theSizer = wxBoxSizer(wxVERTICAL)

		self.parent = parent
		
		self.txtScript = DrText(self, -1, self.parent, 1)
		self.txtScript.SetupPrefsDocument()
		self.theSizer.Add(self.txtScript, 9, wxEXPAND)
		
		self.commandSizer = wxBoxSizer(wxHORIZONTAL)
				
		self.btnClose = wxButton(self, 101, "&Close")
		self.btnOk = wxButton(self, 102, "&Ok")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.commandSizer.Add(self.btnClose, 0,  wxSHAPED | wxALIGN_CENTER)
		self.commandSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.commandSizer.Add(self.btnOk, 0,  wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.commandSizer, 0, wxSHAPED | wxALIGN_CENTER)
		self.btnOk.SetDefault()

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
	
		EVT_BUTTON(self, 101, self.OnbtnClose)
		EVT_BUTTON(self, 102, self.OnbtnOk)
		
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnbtnOk(self, event):
		value = self.txtScript.GetText()
		if (value.find("DrFilename") > -1):
			value = value.replace("DrFilename", "self.parent.filename")
		if (value.find("DrScript") > -1):
			value = value.replace("DrScript", "self.parent.DrScript")
		if (value.find("DrDocument") > -1):
			value = value.replace("DrDocument", "self.parent.txtDocument")
		if (value.find("DrPrompt") > -1):
			value = value.replace("DrPrompt", "self.parent.txtPrompt")
		if (value.find("DrFrame") > -1):
			value = value.replace("DrFrame", "self.parent")
			
		try:
			code = compile((value + '\n'), "Dynamic DrScript", 'exec')
		except:
			d = wxScrolledMessageDialog(self.parent, ("Error compiling dynamic script.\n\nTraceback:\n\n" + getTraceBackString()), "Error", wxDefaultPosition, wxSize(550,300))
			d.ShowModal()
			d.Destroy() 
			return
		
		try:
			exec(code)
		except:
			d = wxScrolledMessageDialog(self.parent, ("Error running dynamic script.\n\nTraceback:\n\n" + getTraceBackString()), "Error", wxDefaultPosition, wxSize(550,300))
			d.ShowModal()
			d.Destroy()
			return