#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Edit Startup Script

from wxPython.wx import *

class drEditStartupScript(wxFrame):

	def __init__(self, parent, title, theText):
		wxFrame.__init__(self, parent, -1, ("Browse: " + title), wxPoint(50, 50), wxSize(425, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
		
		self.theSizer = wxBoxSizer(wxVERTICAL)

		self.classtree = drTree(self, -1, wxPoint(0, 0), wxSize(400, 200), wxTR_DEFAULT_STYLE|wxTR_HIDE_ROOT)
		self.theSizer.Add(self.classtree, 9, wxEXPAND)		
		
		self.root = self.classtree.AddRoot("")
				
		self.targetText = theText
		
		self.ItemsIndex = []
		
		self.ItemsPos = []
		
		self.Browse()
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(self.btnClose, 1,  wxEXPAND)
		self.btnClose.SetDefault()

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
	
		EVT_BUTTON(self, 101, self.OnbtnClose)
		
	def Browse(self):
		RootArray = [self.root]
		Roots = [self.root]
		currentRoot = 0
		Indents = [0]
		currentIndent = 0
		l = len(self.targetText)
		x = 0
		line = ""
		while (x < l):	
			line = line + self.targetText[x]
			if (self.targetText[x] == '\n') or (x == (l - 1)):
				t = InspectLine(line)
				if (len(t) > 0):
					indent = GetCount(line)
					while (indent < Indents[currentIndent]):
						Roots.pop()
						currentRoot = currentRoot - 1
						Indents.pop()
						currentIndent = currentIndent - 1
					if (t.find("class ") == 0) or (t.find("def ") == 0):
						Indents.append(indent + 1)
						currentIndent = currentIndent + 1
						Roots.append(self.classtree.AppendItem(Roots[currentRoot], t))
						currentRoot = currentRoot + 1						
						RootArray.append(Roots[currentRoot])
						self.ItemsIndex.append(Roots[currentRoot])
						self.ItemsPos.append(x - (len(t) + 1))
				line = ""
			x = x + 1
		
		if (self.GetParent().prefs.classbrowserissorted):
			self.classtree.SortChildren(self.root)	
			x = 0
			l = len(RootArray)
			while (x < l):			
				self.classtree.SortChildren(RootArray[x])
				x = x + 1
		
	def OnbtnClose(self, event):
		self.Close(1)