#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#FindReplaceInFiles Dialog

from wxPython.wx import *
from wxPython.stc import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
import os, re, os.path, shutil

#**********************************************************************

class drMultipleItemQuestionDialog(wxDialog):

	def __init__(self, parent, title, results, iteritems):
		wxDialog.__init__(self, parent, -1, title, wxPoint(50, 50), wxSize(425, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
		
		self.theSizer = wxBoxSizer(wxVERTICAL)

		self.commandSizer = wxBoxSizer(wxHORIZONTAL)

		self.boxItems = wxListBox(self, 405)
		self.boxItems.AppendItems(results)
		
		self.iteritems = iteritems

		self.theSizer.Add(self.boxItems, 1, wxEXPAND)		
				
		self.btnClose = wxButton(self, 401, "&Cancel")
		self.btnOk = wxButton(self, 402, "&Ok")
		
		self.commandSizer.Add(self.btnClose, 0, wxALIGN_LEFT | wxSHAPED)
		self.commandSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.commandSizer.Add(self.btnOk, 0, wxALIGN_RIGHT | wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.commandSizer, 0, wxALIGN_CENTER | wxSHAPED)
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
	
		self.answer = 0
		
		EVT_LISTBOX_DCLICK(self, 405, self.OnRemoveItem)
		EVT_BUTTON(self, 401, self.OnbtnClose)
		EVT_BUTTON(self, 402, self.OnbtnOk)
	
	def GetAnswer(self):
		return self.answer
	
	def GetResults(self):
		return self.iteritems
		
	def OnbtnClose(self, event):
		self.answer = 0
		self.EndModal(0)				
				
	def OnbtnOk(self, event):
		self.answer = 1
		self.EndModal(0)
		
	def OnRemoveItem(self, event):
		d = wxMessageDialog(self, "Remove Match (" + self.boxItems.GetStringSelection() + ")?", "Remove", wxYES_NO | wxICON_QUESTION)
		answer = d.ShowModal()
		d.Destroy()
		if answer == wxID_YES:
			i = self.boxItems.GetSelection()
			self.iteritems.pop(i)
			self.boxItems.Delete(i)

#**********************************************************************
#Taken from the findf script I wrote to use in bash:

def createRE(query):
	x = createREString(query)
	x =  x + '$'
	#$ = only snarf the end.
	return re.compile(x, re.IGNORECASE)

def createREString(query):
	returnstr = ""
	query = query.replace('.', "\\.")
	if (query.find("*") == -1):
		if (len(query) > 0):
			return query
		else:
			return ""
	l = query.find("*")
	while (l > -1):
		if (l > 0):
			temp = query[0:l]
			returnstr = returnstr + temp + ".*"
			query = query[(l + 1):]
		else:
			returnstr = returnstr + ".*"
			query = query[1:]
		l = query.find("*")
	if (len(query) > 0):
		returnstr = returnstr + query
	return returnstr

def runDirRE(finder, cdir, dir_data, query, subdir):
	l = len(dir_data)
	x = 0

	matches = []

	#For each entry in the directory, see if it matches.

	while (x < l):
		filename = os.path.normpath(cdir + "/" + dir_data[x])
		v = query.match(dir_data[x])
		if (v is not None):
			if (len(v.group()) > 0):
				try:
					f = file(filename, 'r')
					text = f.read()
					f.close()
					y = finder.search(text)
					if finder is not None:
						if len(y.group()) > 0:
							matches.append(filename)
				except: 
					pass	
		if subdir:
			if (not os.path.islink(filename)):
				if (os.path.isdir(filename)):
					try:
						matches.extend(runDirRE(finder, filename, os.listdir(filename), query, subdir))
					except:
						#Skip it.
						pass
		x = x + 1

	return matches


def runDir(findtext, cdir, dir_data, query, subdir, case):
	l = len(dir_data)
	x = 0

	matches = []

	#For each entry in the directory, see if it matches.

	while (x < l):
		filename = os.path.normpath(cdir + "/" + dir_data[x])
		v = query.match(dir_data[x])
		if (v is not None):
			if (len(v.group()) > 0):
				try:
					f = file(filename, 'r')
					text = f.read()
					if not case:
						text = text.lower()
					f.close()
					if text.find(findtext) > -1:
						matches.append(filename)
				except: 
					pass	
		if subdir:
			if (not os.path.islink(filename)):
				if (os.path.isdir(filename)):
					try:
						matches.extend(runDir(findtext, filename, os.listdir(filename), query, subdir, case))
					except:
						#Skip it.
						pass
		x = x + 1

	return matches
	
#Replace:

def runDirReplaceRE(finder, replacetext, cdir, dir_data, query, subdir, frameprompt, backupfiles):
	l = len(dir_data)
	x = 0

	targets = []
	matches = []
	userchoseyes = 0
	#For each entry in the directory, see if it matches.

	while (x < l):
		filename = os.path.normpath(cdir + "/" + dir_data[x])
		v = query.match(dir_data[x])
		if (v is not None):
			if (len(v.group()) > 0):
				try:
					f = file(filename, 'r')
					text = f.read()
					f.close()
					y = finder.search(text)
					if y is not None:
						if len(y.group()) > 0:
							t = re.finditer(finder, text)
							if frameprompt is not None:								
								try:
									item = t.next()							
								except:
									item = None
								results = []
								items = []
								while item is not None:
									if len(item.group()) > 0:
										results.append(str(item.start()) + ": " + item.group())
										items.append(item)
									try:
										item = t.next()
									except:
										item = None								
								d = drMultipleItemQuestionDialog(frameprompt, ("Replace In " + filename), results, items)
								d.ShowModal()
								answer = d.GetAnswer()
								results = d.GetResults()
								d.Destroy()
							elif frameprompt is None:
								try:
									item = t.next()							
								except:
									item = None
								results = []
								items = []
								while item is not None:
									if len(item.group()) > 0:
										results.append(str(item.start()) + ": " + item.group())
										items.append(item)
									try:
										item = t.next()
									except:
										item = None	
								results = items
							if (frameprompt is None) or answer:								
								#text = re.sub(finder, replacetext, text)
								starter = 0
								for result in results:
									text = text[:result.start()+starter] + replacetext + text[result.end()+starter:]
									starter = starter + len(replacetext) - (result.end() - result.start())
								if backupfiles:
									shutil.copyfile(filename, filename+".bak")
								f = file(filename, 'wb')
								f.write(text)
								f.close()
								targets.append(results)
								matches.append(filename)						
				except:
					import sys, traceback
					slist = traceback.format_tb(sys.exc_info()[2])
					l = len(slist)
					x = 0
					rstring = ""
					while x < l:
						rstring = rstring + slist[x]
						x = x + 1
					print "Traceback (most recent call last):\n" + rstring \
					+ str(sys.exc_info()[0]).lstrip("exceptions.") + ": " + str(sys.exc_info()[1])

					pass	
		if subdir:
			if (not os.path.islink(filename)):
				if (os.path.isdir(filename)):
					try:
						matchlist, targetlist = runDirReplaceRE(finder, replacetext, filename, os.listdir(filename), query, subdir, frameprompt, backupfiles)
						matches.extend(matchlist)
						targets.extend(targetlist)
					except:
						#Skip it.
						pass
		x = x + 1

	return matches, targets
	
#**********************************************************************

class drFindTextCtrl(wxTextCtrl):
	def __init__(self, parent, id, value, pos, size):
		wxTextCtrl.__init__(self, parent, id, value, pos, size)		
		
		EVT_CHAR(self, self.OnChar)
		
	def OnChar(self, event):
		if (event.GetKeyCode() == WXK_ESCAPE):
			self.GetParent().OnbtnCancel(event)
		elif (event.GetKeyCode() == WXK_RETURN):
			self.GetParent().OnbtnFind(event)
		else:
			event.Skip()
				
#**********************************************************************

class drFindReplaceInFilesDialog(wxFrame):
	def __init__(self, parent, id, title, IsReplace = 0):
		wxFrame.__init__(self, parent, id, title, wxPoint(50, 50), wxSize(640, 480), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
		
		self.parent = parent
		
		panel = drFindReplaceInFilesPanel(self, id, title, parent, IsReplace)
		
class drFindReplaceInFilesPanel(wxPanel):
	def __init__(self, parent, id, title, grandparent, IsReplace = 0):
		wxPanel.__init__(self, parent, id)
		
		self.parent = parent
		self.grandparent = grandparent
		
		self.ID_FIND = 1001
		self.ID_CANCEL = 1002
		
		self.ID_BROWSE = 1005
		
		self.ID_CHK_REGEX = 1010
		self.ID_CREATERE = 1011
		
		self.ID_CLEAR_FIND = 1020
		
		self.ID_RESULTS = 1030
		
		self.commandSizer = wxBoxSizer(wxVERTICAL)

		self.IsReplace = IsReplace		
		
		self.txtDirectory = wxTextCtrl(self, -1, self.grandparent.ddirectory, wxDefaultPosition, wxSize(350, -1))
		self.btnBrowse = wxButton(self, self.ID_BROWSE, "Browse")
		
		self.txtPattern = wxTextCtrl(self, -1, "*.*", wxDefaultPosition, wxSize(350, -1))
		
		self.txtSearchFor = drFindTextCtrl(self, -1, "", wxDefaultPosition, wxSize(350, -1))		
		self.btnClearFind = wxButton(self, self.ID_CLEAR_FIND, "Clear")		
				
		if (IsReplace):
			self.ID_CLEAR_REPLACE = 1021
			
			self.ID_UNDO_REPLACE = 1040
		
			self.txtReplaceWith = drFindTextCtrl(self, -1, "", wxDefaultPosition, wxSize(350, -1))		
			self.btnClearReplace = wxButton(self, self.ID_CLEAR_REPLACE, "Clear")
			
			self.btnUndo = wxButton(self, self.ID_UNDO_REPLACE, "  Undo Replace  ")
			
			self.chkPromptOnReplace  = wxCheckBox(self, -1, "Prompt on Replace   ")
			
			self.replacetrail = []
		
			self.filetrail = []
			
			self.replacetext = ""
									
			#Prefs
			self.chkPromptOnReplace.SetValue(grandparent.prefs.findreplaceinfilespromptonreplace)
		
		self.chkMatchCase = wxCheckBox(self, -1, "Match Case")
		self.chkRegularExpression = wxCheckBox(self, self.ID_CHK_REGEX, "RegularExpression")
		self.btnCreateRE = wxButton(self, self.ID_CREATERE, " &Create ")
			
		self.chkSubDirectories = wxCheckBox(self, -1, "Subdirectories")
		
		self.boxresults = wxListBox(self, self.ID_RESULTS, wxDefaultPosition, wxSize(200, -1))
				
		#Prefs
		self.chkSubDirectories.SetValue(1)
		if IsReplace:
			self.chkRegularExpression.SetValue(1)
			self.chkRegularExpression.Enable(0)
			self.btnCreateRE.Enable(1)
		else:
			self.chkRegularExpression.SetValue(grandparent.prefs.findreplaceinfilesregularexpression)
			self.btnCreateRE.Enable(grandparent.prefs.findreplaceinfilesregularexpression)
		self.chkMatchCase.SetValue(grandparent.prefs.findreplaceinfilesmatchcase)
		self.chkSubDirectories.SetValue(grandparent.prefs.findreplaceinfilessubdirectories)				
		
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		self.commandSizer.Add(self.chkRegularExpression, 0, wxSHAPED)
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		self.commandSizer.Add(self.btnCreateRE, 0, wxSHAPED)
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
	
		self.commandSizer.Add(self.chkMatchCase, 0, wxSHAPED)
		self.commandSizer.Add(self.chkSubDirectories, 0, wxSHAPED)
		if IsReplace:
			self.commandSizer.Add(self.chkPromptOnReplace, 0, wxSHAPED)
				
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)		
		
		self.btnFind = wxButton(self, self.ID_FIND, "&Ok")
		self.btnCancel = wxButton(self, self.ID_CANCEL, "&Cancel")
		
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		self.commandSizer.Add(self.btnFind, 0, wxSHAPED)
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		if IsReplace:
			self.commandSizer.Add(self.btnUndo, 0, wxSHAPED)
			self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		self.commandSizer.Add(self.btnCancel, 0, wxSHAPED)
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		self.commandSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		
		self.txtResults = wxTextCtrl(self, -1, "", wxDefaultPosition, wxSize(350, -1), wxTE_READONLY)
								
		self.boxSizer = wxBoxSizer(wxHORIZONTAL)
		self.boxSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
		self.boxSizer.Add(self.commandSizer, 0, wxSHAPED)
		self.boxSizer.Add(self.boxresults, 3, wxEXPAND)		
		
		self.topSizer = wxFlexGridSizer(3, 3, 5, 5)
		self.topSizer.Add(wxStaticText(self, -1, "Directory:"), 0, wxSHAPED)
		self.topSizer.Add(self.txtDirectory, 0, wxSHAPED)
		self.topSizer.Add(self.btnBrowse, 0, wxSHAPED)
		
		self.topSizer.Add(wxStaticText(self, -1, "File Pattern:"), 0, wxSHAPED)
		self.topSizer.Add(self.txtPattern, 0, wxSHAPED)
		self.topSizer.Add(wxStaticText(self, -1, "    "), 0, wxSHAPED)
				
		self.topSizer.Add(wxStaticText(self, -1, "Search For: "), 0, wxSHAPED)
		self.topSizer.Add(self.txtSearchFor, 0, wxSHAPED)
		self.topSizer.Add(self.btnClearFind, 0, wxSHAPED)
		
		if (IsReplace):
			self.topSizer.Add(wxStaticText(self, -1, "Replace With: "), 0, wxSHAPED)
			self.topSizer.Add(self.txtReplaceWith, 0, wxSHAPED)
			self.topSizer.Add(self.btnClearReplace, 0, wxSHAPED)
		
		self.theSizer = wxBoxSizer(wxVERTICAL)
		self.theSizer.Add(self.topSizer, 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.boxSizer, 1, wxEXPAND)
		self.theSizer.Add(self.txtResults, 0, wxALIGN_CENTER | wxEXPAND)
				
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)				
				
		self.btnFind.SetDefault()
		self.txtSearchFor.SetFocus()
				
				
		EVT_BUTTON(self, self.ID_BROWSE, self.OnbtnBrowse)
		EVT_BUTTON(self, self.ID_CANCEL, self.OnbtnCancel)	
		EVT_BUTTON(self, self.ID_FIND, self.OnbtnFind)
		EVT_BUTTON(self, self.ID_CREATERE, self.OnbtnCreateRE)
	
		EVT_LISTBOX_DCLICK(self, self.ID_RESULTS, self.OnActivateItem)
	
		EVT_CHECKBOX(self, self.ID_CHK_REGEX, self.OnCheckRegularExpression)
				
		EVT_BUTTON(self, self.ID_CLEAR_FIND, self.OnbtnClearFind)
		if (IsReplace):
			EVT_BUTTON(self, self.ID_CLEAR_REPLACE, self.OnbtnClearReplace)
			EVT_BUTTON(self, self.ID_UNDO_REPLACE, self.OnbtnUndoReplace)
	
	def OnActivateItem(self, event):
		fname = self.boxresults.GetStringSelection().replace("\\", "/")
		
		#First check to see if the file is already open:
		for window in self.grandparent.app.windowlist:			
			try:
				i = window.filenameArray.index(fname)
				
				window.Raise()
				window.SetFocus()
				window.setDocumentTo(i)
				
				self.grandparent.Finder.reset()
				
				if self.chkMatchCase.GetValue():
					self.grandparent.Finder.findflags = wxSTC_FIND_MATCHCASE
				self.grandparent.Finder.findtext = self.txtSearchFor.GetValue()
				self.grandparent.Finder.targetEnd = self.grandparent.txtDocument.GetLength()
				self.grandparent.Finder.RE = self.chkRegularExpression.GetValue()
				
				if self.IsReplace:
					if len(self.replacetrail) > 0:
						self.grandparent.Finder.findtext = self.replacetext		
				
				window.txtDocument.SetFocus()				
				return
			except:
				pass
			
		old = self.grandparent.filename
		self.grandparent.filename = fname
		self.grandparent.DestroyRecentFileMenu()
		if (len(old) > 0) or (self.grandparent.txtDocument.GetModify()):
	    		self.grandparent.OpenFile(True)
			if not self.grandparent.prefs.mdi:
				self.grandparent.filename = old
		else:
	    		self.grandparent.OpenFile(False)
		self.grandparent.CreateRecentFileMenu()
		
		self.grandparent.Finder.reset()
		
		if self.chkMatchCase.GetValue():
			self.grandparent.Finder.findflags = wxSTC_FIND_MATCHCASE
		self.grandparent.Finder.findtext = self.txtSearchFor.GetValue()
		self.grandparent.Finder.targetEnd = self.grandparent.txtDocument.GetLength()
		self.grandparent.Finder.RE = self.chkRegularExpression.GetValue()
		
		if self.IsReplace:
			if len(self.replacetrail) > 0:
				self.grandparent.Finder.findtext = self.replacetext		
		
		self.grandparent.OnMenuFindNext(event)
				
		self.grandparent.Raise()
		self.grandparent.SetFocus()
		self.grandparent.txtDocument.SetFocus()
			
	def OnbtnBrowse(self, event):
		d = wxDirDialog(self, "Select Directory:", style=wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON|wxMAXIMIZE_BOX|wxTHICK_FRAME)
		if d.ShowModal() == wxID_OK:
        		self.txtDirectory.SetValue(d.GetPath())
    		d.Destroy()
	
	def OnbtnCancel(self, event):
		self.parent.Close(1)
	
	def OnbtnClearFind(self, event):
		self.txtSearchFor.SetValue("")
		self.txtSearchFor.SetFocus()
		
	def OnbtnClearReplace(self, event):
		self.txtReplaceWith.SetValue("")
		self.txtReplaceWith.SetFocus()
	
	def OnbtnCreateRE(self, event):
		from drRegularExpressionDialog import drRegularExpressionDialog
		d = drRegularExpressionDialog(self, -1, "Create Regular Expression", 0, 1)
		d.Show()
						
	def OnbtnFind(self, event):
		self.txtResults.SetValue("Searching...")
		
		wxYield()
		
		q = createRE(self.txtPattern.GetValue())
		
		subdir = self.chkSubDirectories.GetValue()
		
		if not os.path.exists(self.txtDirectory.GetValue()):
			d = wxScrolledMessageDialog(self, 'Directory "' + self.txtDirectory.GetValue() + '" does not exist', "Error")
			d.ShowModal()
			d.Destroy()
			self.txtResults.SetValue("Done.")
			return
		
		if self.IsReplace:
			if self.grandparent.prefs.enablewarnings:
				d = wxMessageDialog(self, "This will Replace \"" + self.txtSearchFor.GetValue() \
				+ "\" with \"" +  self.txtReplaceWith.GetValue() + "\" in files of type: \""\
				+ self.txtPattern.GetValue() + "\" in the directory: \"" + self.txtDirectory.GetValue() + "\"."\
				+ "\nAre you sure you want to do this?", "Replace in Files", wxYES_NO | wxICON_QUESTION)
				answer = d.ShowModal()
				d.Destroy()
				if (answer == wxID_NO):
					return
			
			case = self.chkMatchCase.GetValue()
			if self.chkRegularExpression.GetValue():
				if case:
					x = 0
				else:
					x = re.IGNORECASE
				finder = re.compile(self.txtSearchFor.GetValue(), x)
				
				if self.chkPromptOnReplace.GetValue():
					frame = self.parent
				else:
					frame = None
				
				filelist, self.replacetrail = runDirReplaceRE(finder, self.txtReplaceWith.GetValue(), self.txtDirectory.GetValue(), os.listdir(self.txtDirectory.GetValue()), q, subdir, frame, self.grandparent.prefs.findreplaceinfilesbackupbeforereplace)
				
				self.filetrail = filelist
				
				self.replacetext = self.txtReplaceWith.GetValue()
		else:
					
			case = self.chkMatchCase.GetValue()
			if self.chkRegularExpression.GetValue():
				if case:
					x = 0
				else:
					x = re.IGNORECASE
				finder = re.compile(self.txtSearchFor.GetValue(), x)
			
				filelist = runDirRE(finder, self.txtDirectory.GetValue(), os.listdir(self.txtDirectory.GetValue()), q, subdir)
			else:
				if case:
					findtext = self.txtSearchFor.GetValue()
				else:
					findtext = self.txtSearchFor.GetValue().lower()
				filelist = runDir(findtext, self.txtDirectory.GetValue(), os.listdir(self.txtDirectory.GetValue()), q, subdir, case)
		
		filelist.sort()						
		self.boxresults.Set(filelist)
		self.txtResults.SetValue(str(len(filelist)) + " Files Found")
	
	def OnbtnUndoReplace(self, event):
		if len(self.replacetrail) > 0:
			d = wxMessageDialog(self, "This will Undo the Last Replace In Files Operation.\nAre you sure you want to do this?", "Undo Replace in Files", wxYES_NO | wxICON_QUESTION)
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_YES):
				lenreplace = len(self.replacetext)
				try:
					x = 0
					l = len(self.filetrail)
					while x < l:
						f = file(self.filetrail[x], 'r')
						text = f.read()
						f.close()
						for item in self.replacetrail[x]:
							text = text[:item.start()] + item.group() + text[item.start()+lenreplace:]
						f = file(self.filetrail[x], 'wb')
						f.write(text)
						f.close()
						x = x + 1
				
					self.replacetrail = []
					self.filetrail = []
				except:
					pass
					
	def OnCheckRegularExpression(self, event):
		usingRegularExpressions = self.chkRegularExpression.GetValue()
		self.btnCreateRE.Enable(usingRegularExpressions)		