#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#GetKey Dialog

from wxPython.wx import *

class drGetTextCtrl(wxTextCtrl):
	def __init__(self, parent, ignorestring, grandparent):
		wxTextCtrl.__init__(self, parent, -1, "Hit A Key", wxDefaultPosition, wxDefaultSize)
		
		self.ancestor = grandparent
		
		self.allowControl = not (ignorestring.find("Control") > -1)
		self.allowShift = not (ignorestring.find("Shift") > -1)
		self.allowMeta = not (ignorestring.find("Meta") > -1)
		self.allowAlt = not (ignorestring.find("Alt") > -1)
		
		EVT_KEY_DOWN(self, self.OnKeyDown)
		
	def OnKeyDown(self, event):
		keystr = ""
		keycode = event.GetKeyCode()
		if event.ControlDown() and event.AltDown() and ancestor.prefs.europeankeyboard:
			event.Skip()
			return
		if (keycode == WXK_CONTROL) or (keycode == 309) or (keycode == WXK_SHIFT):
			return
		if (event.ControlDown()) and self.allowControl:
			keystr = "Control,"
		if (event.ShiftDown()) and self.allowShift:
			keystr = keystr + "Shift,"
		if (event.MetaDown()) and self.allowMeta:
			keystr = keystr + "Meta,"
		if (event.AltDown()) and self.allowAlt:
			keystr = keystr + "Alt,"
		keystr = keystr + " #" + str(keycode)
		self.SetValue(keystr)

class drGetKeyDialog(wxDialog):

	def __init__(self, parent, ignorestring, grandparent):
		wxDialog.__init__(self, parent, -1, ("Hit A Key"), wxPoint(50, 50), wxSize(200, 150), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
					
		self.theSizer = wxBoxSizer(wxVERTICAL)					
						
		self.txtKey = drGetTextCtrl(self, ignorestring, grandparent)		
		self.theSizer.Add(self.txtKey, 1, wxEXPAND)
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(self.btnClose, 1, wxEXPAND)
				
		self.SetAutoLayout(True)		
		self.SetSizer(self.theSizer)
		
		self.txtKey.SetFocus()
		
		EVT_BUTTON(self, 101, self.OnbtnClose)
		
	def GetKeyString(self):
		y = self.txtKey.GetValue()
		if (y == "Hit A Key"):
			return ""
		return y
		
	def OnbtnClose(self, event):
		self.EndModal(0)