#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#drLogger Menu

import os.path
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drPrefsFile import ExtractPreferenceFromText

def updateloggers(loggerfile, paths, titles):
	l = len(paths)
	x = 0
	f = open(loggerfile, 'w')
	while (x < l):
		f.write("<path>" + paths[x] + "</path><title>" + titles[x] + "</title>\n")
		x = x + 1
	f.close()

class drLoggerMenu(wxMenu):
	def __init__(self, parent):
		wxMenu.__init__(self)
				
		self.ID_ADD_LOGGER = 5001
		self.ID_NEW_LOGGER = 5002
		self.ID_EDIT_LOGGER = 5003
		self.ID_REMOVE_LOGGER = 5004
		
		self.ID_LOGGERS_BASE = 4500
						
		self.parent = parent
		self.homedirectory = parent.homedirectory
		self.wildcard = parent.wildcard
				
		self.loggerscount = 0
		self.loggers = []
		self.titles = []
		
		self.setupMenu()
		
		self.loadloggers()
		
	def loadloggers(self):
		loggersfile = self.homedirectory + "/drloggers.dat"
		if (os.path.exists(loggersfile)):
			try:
				#Read from the file
				f = open(loggersfile, 'r')
				self.loggerscount = 0
				#Initialize
				line = f.readline()
				while (len(line) > 0):
					line_path = ExtractPreferenceFromText(line, "path")
					line_title = ExtractPreferenceFromText(line, "title")
					if (os.path.exists(line_path)):
						self.Append((self.ID_LOGGERS_BASE + self.loggerscount), "Insert "+line_title, "Insert "+line_title)
						EVT_MENU(self.parent, (self.ID_LOGGERS_BASE + self.loggerscount), self.OnLogger)
						self.loggers.append(line_path)
						self.titles.append(line_title)
						self.loggerscount = self.loggerscount + 1
					line = f.readline()
				f.close()
			except:
				d = wxScrolledMessageDialog(self.parent, ("Your drloggers file is a tad messed up.\n"), "Error")
				d.ShowModal()
				d.Destroy()
		
	def OnAddLogger(self, event):
		loggersfile = self.homedirectory + "/drloggers.dat"
		dlg = wxFileDialog(self.parent, "Select Logger File", "", "", self.wildcard, wxOPEN|wxHIDE_READONLY)
		if (len(self.parent.prefs.defaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.parent.prefs.defaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.prefs.defaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			filen = dlg.GetPath().replace("\\", "/")
			d = wxTextEntryDialog(self.parent, 'Enter Logger Title:', 'Add DrLogger: Title', '')
			title = ""
			if (d.ShowModal() == wxID_OK):
				title = d.GetValue()
			d.Destroy()
			if (len(title) < 1):
				d = wxScrolledMessageDialog(self.parent, ("Bad logger title.\nDrPython will politely ignore your request to add this logger."), "Error")
				d.ShowModal()
				d.Destroy()
				return				
			self.Append((self.ID_LOGGERS_BASE + self.loggerscount), "Insert "+title, "Insert "+title)
			EVT_MENU(self.parent, (self.ID_LOGGERS_BASE + self.loggerscount), self.OnLogger)
			self.loggers.append(filen)
			self.titles.append(title)
						
			self.loggerscount = self.loggerscount + 1
			try:
				f = open(loggersfile, 'a')
				f.write("<path>" + filen + "</path><title>" + title + "</title>\n")
				f.close()
				
			except:
				d = wxScrolledMessageDialog(self.parent, ("Problem saving logger.\n"), "Error")
				d.ShowModal()
				d.Destroy()
		dlg.Destroy()
		
	def OnEditLogger(self, event):
		if (len(self.loggers) > 0):
			d = wxSingleChoiceDialog(self.parent, "Select the Logger to Edit:", "Edit Logger", self.titles, wxOK|wxCANCEL)
			d.SetSize(wxSize(250, 250))
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_OK):
				i = d.GetSelection()
				old = self.parent.filename
				self.parent.filename = self.loggers[i].replace("\\", "/")
				if (len(old) > 0) or (self.parent.txtDocument.GetModify()):
					self.parent.OpenFile(True, False)
					self.parent.filename = old
				else:
					self.parent.OpenFile(False, False)
		else:	
			d = wxScrolledMessageDialog(self.parent, ("There aren't any loggers to edit.\nTry \"New Logger\" or \"Add Logger\" Instead."), "Error")
			d.ShowModal()
			d.Destroy()		
	
	def OnNewLogger(self, event):
		loggersfile = self.homedirectory + "/drloggers.dat"
		dlg = wxFileDialog(self.parent, "Save New Logger File As", "", "", self.wildcard, wxSAVE|wxOVERWRITE_PROMPT)
		if (len(self.parent.prefs.defaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.parent.prefs.defaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.prefs.defaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			filen = dlg.GetPath().replace("\\", "/")
			d = wxTextEntryDialog(self.parent, "Enter Logger Title:", "Add DrLogger: Title", "")
			title = ""
			if (d.ShowModal() == wxID_OK):
				title = d.GetValue()
			d.Destroy()
			if (len(title) < 1):
				d = wxScrolledMessageDialog(self.parent, ("Bad logger title.\nDrPython will politely ignore your request to add this logger."), "Error")
				d.ShowModal()
				d.Destroy()
				return		
						
			cfile = file(filen, 'wb')
			cfile.write("#DrPythonLoggerDefined\n\
#Please Try Not To Remove These Comments Manually\n\
def DrPythonLogger(*args):\n\
\tf = file(\"" + self.parent.logfile + "\", 'a')\n\
\tmap(f.write, args)\n\
\tf.close()\n\
DrPythonLogger()\n\
#Please Try Not To Remove These Comments Manually\n\
#EndDrPythonLoggerDefined\n")
			cfile.close()
							
			self.Append((self.ID_LOGGERS_BASE + self.loggerscount), "Insert "+title, "Insert "+title)
			EVT_MENU(self.parent, (self.ID_LOGGERS_BASE + self.loggerscount), self.OnLogger)
			self.loggers.append(filen)
			self.titles.append(title)
						
			self.loggerscount = self.loggerscount + 1
			try:
				f = open(loggersfile, 'a')
				f.write("<path>" + filen + "</path><title>" + title + "</title>\n")
				f.close()
			except:
				d = wxScrolledMessageDialog(self.parent, ("Problem saving logger.\n"), "Error")
				d.ShowModal()
				d.Destroy()				
			
			old = self.parent.filename
			self.parent.filename = filen
			if (len(old) > 0) or (self.parent.txtDocument.GetModify()):
				self.parent.OpenFile(True, False)
				self.parent.filename = old
			else:
				self.parent.OpenFile(False, False)	
		dlg.Destroy()
		
		
	def OnRemoveLogger(self, event):
		oldlength = len(self.loggers)
		if (oldlength > 0):
			d = wxSingleChoiceDialog(self.parent, "Select the Logger to Remove:", "Remove Logger", self.titles, wxOK|wxCANCEL)
			d.SetSize(wxSize(250, 250))
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_OK):
				i = d.GetSelection()
				self.loggers.pop(i)
				self.titles.pop(i)
				self.loggerscount = self.loggerscount - 1
				try:
					updateloggers((self.homedirectory + "/drloggers.dat"), self.loggers, self.titles)			
					self.reloadloggers(oldlength)
				except:
					d = wxScrolledMessageDialog(self.parent, ("Error Saving Changes to DrLoggers.\n"), "Error")
					d.ShowModal()
					d.Destroy()
		else:			
			d = wxScrolledMessageDialog(self.parent, ("There aren't any loggers to remove.\n"), "Error")
			d.ShowModal()
			d.Destroy()

	def OnLogger(self, event):
		loggerindex = event.GetId() - self.ID_LOGGERS_BASE
		pos = self.parent.txtDocument.GetCurrentPos()
		linenumber = self.parent.txtDocument.GetCurrentLine()
		if (self.parent.txtDocument.GetText().find("#DrPythonLoggerDefined") == -1):
			f = open(self.loggers[loggerindex], 'r')
			loggertext = f.read()
			f.close()
			topos = 0
			text = self.parent.txtDocument.GetText()
			if (text.find("#!/") == 0):
				topos = text.find('\n') + 1
			self.parent.txtDocument.InsertText(topos, loggertext)
			pos = pos + len(loggertext)
			linenumber = self.parent.txtDocument.LineFromPosition(pos)
		self.parent.txtDocument.InsertText(pos, ("DrPythonLogger()"))
		self.parent.txtDocument.ScrollToLine(linenumber)
		self.parent.txtDocument.GotoPos(pos + 15)
	
	def setupMenu(self):		
		self.Append(self.ID_ADD_LOGGER, "&Add Logger...", " Add Logger")
		self.Append(self.ID_NEW_LOGGER, "&New Logger...", " Create New Logger")
		self.Append(self.ID_EDIT_LOGGER, "&Edit Logger...", "  Edit Logger")
		self.Append(self.ID_REMOVE_LOGGER, "&Remove Logger...", " Remove Logger")
		self.AppendSeparator()	
		
		EVT_MENU(self.parent, self.ID_ADD_LOGGER, self.OnAddLogger)
		EVT_MENU(self.parent, self.ID_NEW_LOGGER, self.OnNewLogger)
		EVT_MENU(self.parent, self.ID_EDIT_LOGGER, self.OnEditLogger)
		EVT_MENU(self.parent, self.ID_REMOVE_LOGGER, self.OnRemoveLogger)
				
	def reloadloggers(self, oldlength):
		mnuitems = self.GetMenuItems()
		num = len(mnuitems)
		x = 0
		while (x < num):
			self.Remove(mnuitems[x].GetId())
			mnuitems[x].Destroy()
			x = x + 1
		self.loggers = []
		self.titles = []
		self.setupMenu()
		self.loadloggers()