#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#PopUp

from wxPython.stc import *

def GetMenuList():
	#All Possible Items to Add to the PopUp Menu:
	return ["<Insert Separator>", "New", "Open", "Save", "Save As", "Save Prompt Output To File", "Reload File", \
	"Restore From Backup", "Close", "Close All Tabs", "Close All Other Tabs", \
	"Print Setup", "Print File", "Print Prompt", "Exit", \
	"Next Tab", "Previous Tab", "First Tab", "Last Tab", \
	"Find", "Find Next", "Find Previous", \
	"Replace", "Switcheroo", \
	"Find In Files", "Replace In Files", \
	"Insert Regular Expression", "Go To", \
	"Comment", "UnComment", "Indent", "Dedent", \
	"Uppercase", "Lowercase", "Undo", "Redo", "Copy", "Cut", "Paste", \
	"Select All", "Select None", "Zoom In", "Zoom Out", "Fold All", "Expand All", \
	"Chop Beginning", "Chop End", "Find And Complete", \
	"Show Class Browser", "Toggle View Whitespace", "Toggle Prompt", "Clear Prompt", \
	"Run", "Set Arguments", "Python", "Run With Debugger", "End", \
	"Set Log File", "Insert Logger", "Insert String Logger", "Insert Arbitrary Arguments Logger", \
	"Remove All Loggers", \
	"Add Breakpoint", "Remove Breakpoint", "Remove All Breakpoints", "Preferences", \
	"Help", "View Python Docs", "View WxWidgets Docs", "View Regular Expression Howto", "Delete"]
	
def SetUpPopUpActions(frame):

	actiondictionary = {"New":frame.OnNew, "Open":frame.OnOpen, "Save":frame.OnSave, "Save As":frame.OnSaveAs, \
	"Save Prompt Output To File":frame.OnSavePrompt, "Reload File":frame.OnReload, \
	"Restore From Backup":frame.OnRestoreFromBackup, "Close":frame.OnClose, \
	"Close All Tabs":frame.OnCloseAllTabs, "Close All Other Tabs":frame.OnCloseAllOtherTabs, \
	"Print Setup":frame.OnPrintSetup, "Print File":frame.OnPrint, "Print Prompt":frame.OnPrintPrompt, \
	"Exit":frame.OnExit, \
	"Find":frame.OnMenuFind, "Find Next":frame.OnMenuFindNext, "Find Previous":frame.OnMenuFindPrevious, \
	"Replace":frame.OnMenuReplace, "Switcheroo":frame.OnMenuSwitcheroo, \
	"Find In Files":frame.OnMenuFindInFiles, "Replace In Files":frame.OnMenuReplaceInFiles, \
	"Insert Regular Expression":frame.OnInsertRegEx, "Go To":frame.OnGoTo, \
	"Comment":frame.OnCommentRegion, "UnComment":frame.OnUnCommentRegion, \
	"Chop Beginning":frame.OnChopBeginning, "Chop End":frame.OnChopEnd, \
	"Find And Complete":frame.OnFindAndComplete, \
	"Indent":frame.OnIndentRegion, "Dedent":frame.OnDedentRegion, \
	"Select None":frame.OnSelectNone, "Fold All":frame.OnFoldAll, "Expand All":frame.OnExpandAll, \
	"Show Class Browser":frame.OnShowClassBrowser, "Toggle View Whitespace":frame.OnToggleViewWhiteSpace, \
	"Toggle Prompt":frame.OnTogglePrompt, "Clear Prompt":frame.OnClearPrompt, \
	"Run":frame.OnRun, "Set Arguments":frame.OnSetArgs, "Python":frame.OnPython,\
	"Run With Debugger":frame.OnRunWithDebugger, "End":frame.OnEnd, \
	"Set Log File":frame.OnSetLogFile, "Insert Logger":frame.OnAddLogger, \
	"Insert String Logger":frame.OnAddStringLogger, "Insert Arbitrary Arguments Logger":frame.OnAddArbitraryArgLogger, \
	"Remove All Loggers":frame.OnRemoveAllLoggers, \
	"Add Breakpoint":frame.OnAddBreakpoint, "Remove Breakpoint":frame.OnRemoveBreakpoint, \
	"Remove All Breakpoints":frame.OnRemoveAllBreakpoints, "Preferences":frame.OnPrefs, \
	"Help":frame.OnViewHelp, "View Python Docs":frame.OnViewPythonDocs, "View WxWidgets Docs":frame.OnViewWxWidgetsDocs,\
	"View Regular Expression Howto":frame.OnViewREHowtoDocs}
			
	builtinactiondictionary = {"Delete":wxSTC_CMD_CLEAR, "Uppercase":wxSTC_CMD_UPPERCASE, \
	"Lowercase":wxSTC_CMD_LOWERCASE, "Undo":wxSTC_CMD_UNDO, "Redo":wxSTC_CMD_REDO, \
	"Copy":wxSTC_CMD_COPY, "Cut":wxSTC_CMD_CUT, "Paste":wxSTC_CMD_PASTE, \
	"Select All":wxSTC_CMD_SELECTALL, "Zoom In":wxSTC_CMD_ZOOMIN, "Zoom Out":wxSTC_CMD_ZOOMOUT}
	
	return actiondictionary, builtinactiondictionary