#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Pop Up Menu Dialog

import os.path
from wxPython.wx import *
from wxPython.stc import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
import drPopUp

class drPopUpMenuDialog(wxDialog):

	def __init__(self, parent):
		wxDialog.__init__(self, parent, -1, ("Customize Pop Up Menu"), wxPoint(50, 50), wxSize(550, 300), wxDEFAULT_DIALOG_STYLE | wxTHICK_FRAME)
				
		wxYield()
		
		self.ID_PROGRAM = 1001
		self.ID_POPUP = 1002
		
		self.ID_ADD = 1003
		self.ID_REMOVE = 1004
		self.ID_UPDATE = 1005
		self.ID_SAVE = 1006
		
		self.ID_UP = 1111
		self.ID_DOWN = 2222
				
		self.theSizer = wxFlexGridSizer(5, 4, 5, 10)
		self.menubuttonSizer = wxBoxSizer(wxVERTICAL)
		
		self.homedirectory = parent.homedirectory
		
		popupmenulist = []
		
		map(popupmenulist.append, parent.popupmenulist)
		
		if len(popupmenulist) < 1:
				popupmenulist = ["<ROOT>", "Undo", "Redo", "<Separator>", "Cut", "Copy", "Paste", "Delete", "<Separator>", "Select All"]
		else:
			popupmenulist.insert(0, "<ROOT>")
		
		
		programmenulist = drPopUp.GetMenuList()
		
		l = len(popupmenulist)
		x = 0
		while x < l:
			try:
				i = programmenulist.index(popupmenulist[x])
				programmenulist.pop(i)
			except:
				pass
			x = x + 1
		
		self.programmenu = wxListBox(self, self.ID_PROGRAM, wxDefaultPosition, wxSize(200, -1), programmenulist)
		
		self.popupmenu = wxListBox(self, self.ID_POPUP, wxDefaultPosition, wxSize(200, -1), popupmenulist)
		
		self.btnUp = wxButton(self, self.ID_UP, " Up ")
		self.btnAdd = wxButton(self, self.ID_ADD, " ---> ")
		self.btnRemove = wxButton(self, self.ID_REMOVE, " Remove ")
		self.btnDown = wxButton(self, self.ID_DOWN, " Down ")
		
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnAdd, 0, wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnUp, 0, wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnDown, 0, wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnRemove, 0, wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Not Yet Added:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Pop Up Menu:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.programmenu, 0, wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.menubuttonSizer, 0, wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.popupmenu, 0,  wxSHAPED | wxALIGN_CENTER)
		
		self.parent = parent
								
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
				
		self.btnUpdate = wxButton(self, self.ID_UPDATE, "&Update")
		self.btnSave = wxButton(self, self.ID_SAVE, "&Save")
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0,  wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.btnUpdate, 0,  wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.btnSave, 0,  wxSHAPED | wxALIGN_CENTER)
		self.btnClose.SetDefault()

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
	
		EVT_BUTTON(self, self.ID_UP, self.OnbtnUp)
		EVT_BUTTON(self, self.ID_ADD, self.OnbtnAdd)
		EVT_BUTTON(self, self.ID_REMOVE, self.OnbtnRemove)
		EVT_BUTTON(self, self.ID_DOWN, self.OnbtnDown)
		EVT_BUTTON(self, self.ID_UPDATE, self.OnbtnUpdate)
		EVT_BUTTON(self, self.ID_SAVE, self.OnbtnSave)
		EVT_BUTTON(self, 101, self.OnbtnClose)
				
	def OnbtnAdd(self, event):	
		tselection = self.programmenu.GetStringSelection()
		tsel = self.programmenu.GetSelection()
		if tsel == -1:
			d = wxScrolledMessageDialog(self, "Nothing Selected to Add", "Mistake")
			d.ShowModal()
			d.Destroy()
			return	
		separator = (tselection == "<Insert Separator>")
		if separator:
			tselection = "<Separator>"	
		sel = self.popupmenu.GetSelection()
		if sel == -1:
			sel = sel + 1			
		self.popupmenu.InsertItems([tselection], sel+1)
		self.popupmenu.SetSelection(sel+1)
		if not separator:
			self.programmenu.Delete(tsel)
			self.programmenu.SetSelection(tsel-1)
	
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnbtnDown(self, event):
		sel = self.popupmenu.GetSelection()
		if sel < self.popupmenu.GetCount()-1 and sel > 0:
			txt = self.popupmenu.GetString(sel)
			self.popupmenu.Delete(sel)
			self.popupmenu.InsertItems([txt], sel+1)
			self.popupmenu.SetSelection(sel+1)
	
	def OnbtnRemove(self, event):
		sel = self.popupmenu.GetSelection()
		selection = self.popupmenu.GetStringSelection()
		if not sel:			
			d = wxScrolledMessageDialog(self, "You cannot remove the root item.", "Mistake")
			d.ShowModal()
			d.Destroy()
			return
		if sel == -1:
			d = wxScrolledMessageDialog(self, "Nothing Selected to Remove", "Mistake")
			d.ShowModal()
			d.Destroy()
			return

		self.popupmenu.Delete(sel)
		self.programmenu.Append(selection)
		self.popupmenu.SetSelection(sel-1)
	
	def OnbtnUp(self, event):
		sel = self.popupmenu.GetSelection()		
		if sel > 1:
			txt = self.popupmenu.GetString(sel)
			self.popupmenu.Delete(sel)
			self.popupmenu.InsertItems([txt], sel-1)
			self.popupmenu.SetSelection(sel-1)
	
	def OnbtnUpdate(self, event):
		y = 0
		c = self.popupmenu.GetCount()
		
		popupmenulist = []
		
		while y < c:
			pop = self.popupmenu.GetString(y)
			if not pop == "<ROOT>":
				popupmenulist.append(pop)
			y = y + 1
		
		self.parent.popupmenulist = popupmenulist
					
		if self.parent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully updated the current instance of DrPython.\nClick Save to make it permanent."), "Updated Pop Up Menu")
			d.ShowModal()
			d.Destroy()
		
	def OnbtnSave(self, event):
		y = 0
		c = self.popupmenu.GetCount()
		
		popupmenustring = ""
		
		while y < c:
			pop = self.popupmenu.GetString(y)
			if not pop == "<ROOT>":
				popupmenustring = popupmenustring + pop + "\n"
			y = y + 1			
	
		if (not os.path.exists(self.homedirectory)):
			d = wxScrolledMessageDialog(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			d.ShowModal()
			d.Destroy()
			return
		popupfile = self.homedirectory + "/popupmenu.dat"
		try:			
			f = file(popupfile, 'w')
			f.write(popupmenustring)
			f.close()	
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + popupfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
		if self.parent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully wrote to:\n"  + popupfile + "\nClick Update to update the current instance of DrPython."), "Saved Pop Up Menu")
			d.ShowModal()
			d.Destroy()