#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Preferences

#LongLineCol from Chris McDonough
#Changed name from longlinecol to doclonglinecol

class drPreferences:

	def __init__(self, platform_is_windows):
		self.platform_is_windows = platform_is_windows
		
		#General Settings
		self.windowwidth = 640
		self.windowheight = 480
		self.iconsize = 24
		self.iconfile = ""
		self.recentfileslimit = 10
		self.tabwidth = 4
		self.mdi = 0
		self.checkeol = 1
		self.eolmode = 0
		self.encoding = 3
		self.customencoding = "<None>"
		self.pythonargs = ""
		self.defaultdirectory = ""
		self.enablefeedback = 1
		self.enablewarnings = 1
		self.alwayspromptonexit = 0
		self.backupfileonsave = 1
		self.autogotofortraceback = 0
		#utf-8 auto detect limodou 2004/04/14
		self.autodetectutf8encoding = 1
		#end limodou
		
		#Document Settings
		self.docmarginwidth = 41
		self.docwordwrap = 0
		self.docautoindent = 1
		self.docusetabs = 1
		self.docwhitespaceisvisible = 0
		self.docfolding = 0
		self.docusestyles = 1
		self.docuseindentationguides = 0
		self.doclonglinecol = 0
		self.docscrollextrapage = 0
		self.docdefaultsyntaxhighlighting = 0
		self.doconlyusedefaultsyntaxhighlighting = 0
		
		self.PythonStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		self.CPPStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		self.HTMLStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		
		self.PythonStyleArray[0] = "fore:#000000,back:#FFFFFF,size:12,face:lucida"
		self.PythonStyleArray[1] = "fore:#000000,back:#82AEE3,size:12,face:lucida"
		if (self.platform_is_windows):
			self.PythonStyleArray[0] = "fore:#000000,back:#FFFFFF,size:8,face:Courier New"
			self.PythonStyleArray[1] = "fore:#000000,back:#82AEE3,size:8,face:Courier New"
		self.PythonStyleArray[2] = "fore:#000000,back:#00D2FF,bold"
		self.PythonStyleArray[3] = "fore:#FFFFFF,back:#FF0000,bold"
		self.PythonStyleArray[4] = "fore:#007f08,back:#ffffff"
		self.PythonStyleArray[5] = "fore:#b200ac,back:#ffffff"
		self.PythonStyleArray[6] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.PythonStyleArray[7] = "fore:#e80300,back:#ffffff"
		self.PythonStyleArray[8] = "fore:#000000,back:#ffffff,bold"
		self.PythonStyleArray[9] = "fore:#0027c4,back:#ffffff"
		self.PythonStyleArray[10] = "fore:#204D71,back:#ffffff,bold"
		self.PythonStyleArray[11] = "fore:#007f08,back:#ffffff"
		self.PythonStyleArray[12] = "fore:#7B8184,back:#FFFFFF,bold"
		self.PythonStyleArray[13] = "#000000"
		self.PythonStyleArray[14] = "fore:#000000,back:#FF7900"
		self.PythonStyleArray[15] = "fore:#000000,back:#82AEE3"
		self.PythonStyleArray[16] = "#82AEE3"
		
		self.CPPStyleArray[0] = "fore:#000000,back:#FFFFFF,size:12,face:lucida"
		self.CPPStyleArray[1] = "fore:#000000,back:#82AEE3,size:12,face:lucida"
		if (self.platform_is_windows):
			self.CPPStyleArray[0] = "fore:#000000,back:#FFFFFF,size:8,face:Courier New"
			self.CPPStyleArray[1] = "fore:#000000,back:#82AEE3,size:8,face:Courier New"
		self.CPPStyleArray[2] = "fore:#000000,back:#00D2FF,bold"
		self.CPPStyleArray[3] = "fore:#FFFFFF,back:#FF0000,bold"
		self.CPPStyleArray[4] = "fore:#007f08,back:#ffffff"
		self.CPPStyleArray[5] = "fore:#b200ac,back:#ffffff"
		self.CPPStyleArray[6] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.CPPStyleArray[7] = "fore:#e80300,back:#ffffff"
		self.CPPStyleArray[8] = "fore:#000000,back:#ffffff,bold"
		self.CPPStyleArray[9] = "fore:#2050C6,back:#ffffff,"
		self.CPPStyleArray[10] = "fore:#003D22,back:#ffffff"
		self.CPPStyleArray[11] = "fore:#008500,back:#FFFFFF"
		self.CPPStyleArray[12] = "fore:#338144,back:#5FFFFF,bold"
		self.CPPStyleArray[13] = "fore:#330044,back:#5FFFFF"
		self.CPPStyleArray[14] = "#000000"
		self.CPPStyleArray[15] = "fore:#000000,back:#FF7900"
		self.CPPStyleArray[16] = "fore:#000000,back:#82AEE3"
		self.CPPStyleArray[17] = "#82AEE3"
		
		self.HTMLStyleArray[0] = "fore:#000000,back:#FFFFFF,size:12,face:lucida"
		self.HTMLStyleArray[1] = "fore:#000000,back:#82AEE3,size:12,face:lucida"
		if (self.platform_is_windows):
			self.HTMLStyleArray[0] = "fore:#000000,back:#FFFFFF,size:8,face:Courier New"
			self.HTMLStyleArray[1] = "fore:#000000,back:#82AEE3,size:8,face:Courier New"
		self.HTMLStyleArray[2] = "fore:#000000,back:#00D2FF,bold"
		self.HTMLStyleArray[3] = "fore:#FFFFFF,back:#FF0000,bold"
		self.HTMLStyleArray[4] = "fore:#000000,back:#ffffff,bold"
		self.HTMLStyleArray[5] = "fore:#0000FF,back:#FFFFFF,bold"
		self.HTMLStyleArray[6] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.HTMLStyleArray[7] = "fore:#FF0000,back:#ffff00,bold"
		self.HTMLStyleArray[8] = "fore:#0000FF,back:#ffffff"
		self.HTMLStyleArray[9] = "fore:#003100,back:#ffffff"
		self.HTMLStyleArray[10] = "fore:#204D71,back:#ffffff,bold"
		self.HTMLStyleArray[11] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.HTMLStyleArray[12] = "fore:#7B8184,back:#FFFFFF,bold"
		self.HTMLStyleArray[13] = "fore:#000000,back:#FFF7C2,bold"
		self.HTMLStyleArray[14] = "fore:#000081,back:#FFE48D,bold"
		self.HTMLStyleArray[15] = "fore:#006E00,back:#FFE48D,bold"
		self.HTMLStyleArray[16] = "fore:#00812A,back:#CEF0FF,bold"
		self.HTMLStyleArray[17] = "fore:#000000,back:#C2FFE8,bold"
		self.HTMLStyleArray[18] = "#000000"
		self.HTMLStyleArray[19] = "fore:#000000,back:#FF7900"
		self.HTMLStyleArray[20] = "fore:#000000,back:#82AEE3"
		self.HTMLStyleArray[21] = "#82AEE3"
		
		self.txtDocumentStyleArray = self.PythonStyleArray
		
		#Prompt Settings
		self.promptisvisible = 0
		self.promptmarginwidth = 0
		self.promptsize = 60		
		self.promptusetabs = 1
		self.promptwordwrap = 1
		self.promptwhitespaceisvisible = 0		
		self.promptusestyles = 1
		self.promptscrollextrapage = 0
		self.txtPromptStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		self.txtPromptStyleArray[0] = "fore:#FFFFFF,back:#000000,size:12,face:fixed"
		if (self.platform_is_windows):
			self.txtPromptStyleArray[0] = "fore:#FFFFFF,back:#000000,size:8,face:Courier New"
		self.txtPromptStyleArray[1] = "fore:#FFFFFF,back:#710000"
		self.txtPromptStyleArray[2] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[3] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[4] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[5] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[6] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[7] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[8] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[9] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[10] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[11] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[12] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[13] = "#FFFFFF"
		self.txtPromptStyleArray[14] = "fore:#000000,back:#FF7900"
		
		#Find/Replace Settings
		self.findreplaceregularexpression = 0
		self.findreplacematchcase = 0
		self.findreplacefindbackwards = 0
		self.findreplacewholeword = 0
		self.findreplaceinselection = 0
		self.findreplacefromcursor = 0
		self.findreplacepromptonreplace = 1
						
		#Find/Replace In Files Settings
		self.findreplaceinfilesregularexpression = 0
		self.findreplaceinfilesmatchcase = 1
		self.findreplaceinfilespromptonreplace = 1
		self.findreplaceinfilessubdirectories = 0
		self.findreplaceinfilesbackupbeforereplace = 1
		
		#Sessions
		self.sessionsrecentsessionslimit = 10
		self.sessionsdefaultdirectory = "<DEFAULT>"
		
		#Class Browser Settings
		self.classbrowsercloseonactivate = 0
		self.classbrowserissorted = 0
		self.classbrowserstyle = "fore:#000000,back:#FFFFFF,size:12,face:fixed,bold"
		if (self.platform_is_windows):
			self.classbrowserstyle = "fore:#000000,back:#FFFFFF,size:8,face:Arial,bold"				
		
		#Bookmarks Settings
		self.bookmarksstyle = "fore:#000000,back:#FFFFFF,size:12,face:fixed,bold"
		if (self.platform_is_windows):
			self.bookmarksstyle = "fore:#000000,back:#FFFFFF,size:8,face:Arial,bold"
		
		#DrScript Settings
		self.drscriptdefaultdirectory = ""
		self.drscriptstyle = "fore:#000000,back:#FFFFFF,size:12,face:fixed,bold"
		if (self.platform_is_windows):
			self.drscriptstyle = "fore:#000000,back:#FFFFFF,size:8,face:Arial,bold"
		self.drscriptloadexamples = 1
		
		#Shell Settings
		self.drshelldefaultcommanddirectory = "<Current Directory>"
		self.drshelldefaultcommandarguments = "<Current File>"
		self.drshellruninpromptbydefault = 1
		self.drshellstyle = "fore:#000000,back:#FFFFFF,size:12,face:fixed,bold"
		if (self.platform_is_windows):
			self.drshellstyle = "fore:#000000,back:#FFFFFF,size:8,face:Arial,bold"
		
		#Theme Settings
		self.themesdefaultdirectory = ""
		
		#Printing Settings
		self.printdoclinenumbers = 1
		self.printpromptlinenumbers = 0
		self.printtabwidth = 8
		
		#Documentation Settings
		self.documentationviewhelpwithbrowser = 0
		self.documentationbrowser = "mozilla"
		if (self.platform_is_windows):
			self.documentationbrowser = "c:/Program Files/Internet Explorer/iexplore.exe"
		self.documentationpythonlocation = "http://www.python.org/doc/current/"
		self.documentationwxwidgetslocation = "http://www.wxwidgets.org/docs.htm"
		self.documentationrehowtolocation = "http://www.amk.ca/python/howto/regex/"
		
	def reset(self):
		self.__init__(self.platform_is_windows)
		
	def resetjust(self, target):
		defaults = drPreferences(self.platform_is_windows)
		
		if target == "General":	
			#General Settings
			self.windowwidth = defaults.windowwidth
			self.windowheight = defaults.windowheight
			self.iconsize = defaults.iconsize
			self.iconfile = defaults.iconfile
			self.recentfileslimit = defaults.recentfileslimit
			self.tabwidth = defaults.tabwidth
			self.mdi = defaults.mdi
			self.pythonargs = defaults.pythonargs
			self.encoding = defaults.encoding
			self.customencoding = defaults.customencoding 
			self.defaultdirectory = defaults.defaultdirectory
			self.enablefeedback = defaults.enablefeedback
			self.enablewarnings = defaults.enablewarnings
			self.alwayspromptonexit = defaults.alwayspromptonexit
			self.backupfileonsave = defaults.backupfileonsave
			self.autogotofortraceback = defaults.autogotofortraceback
			#utf-8 auto detect limodou 2004/04/14
			self.autodetectutf8encoding = defaults.autodetectutf8encoding
			#end limodou
			
		elif target == "Line Endings":
			self.checkeol = defaults.checkeol
			self.eolmode = defaults.eolmode
			
		elif target == "Document":
			#Document Settings
			self.docmarginwidth = defaults.docmarginwidth
			self.docwordwrap = defaults.docwordwrap
			self.docautoindent = defaults.docautoindent		
			self.docusetabs = defaults.docusetabs
			self.docwhitespaceisvisible = defaults.docwhitespaceisvisible
			self.docfolding = defaults.docfolding
			self.docusestyles = defaults.docusestyles		
			self.docuseindentationguides = defaults.docuseindentationguides
			self.doclonglinecol = defaults.doclonglinecol
			self.docscrollextrapage = defaults.docscrollextrapage
			self.docdefaultsyntaxhighlighting = defaults.docdefaultsyntaxhighlighting
			self.doconlyusedefaultsyntaxhighlighting = defaults.doconlyusedefaultsyntaxhighlighting
			
			self.PythonStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
			x = 0
			l = len(self.PythonStyleArray)
			while (x < l):
				self.PythonStyleArray[x] = defaults.PythonStyleArray[x]
				x = x + 1
				
			self.CPPStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
			x = 0
			l = len(self.CPPStyleArray)
			while (x < l):
				self.CPPStyleArray[x] = defaults.CPPStyleArray[x]
				x = x + 1				
			
			self.HTMLStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
			x = 0
			l = len(self.HTMLStyleArray)
			while (x < l):
				self.HTMLStyleArray[x] = defaults.HTMLStyleArray[x]
				x = x + 1
			
			if self.docdefaultsyntaxhighlighting == 1:
				self.txtDocumentStyleArray = self.CPPStyleArray
			elif self.docdefaultsyntaxhighlighting == 2:
				self.txtDocumentStyleArray = self.HTMLStyleArray
			else:
				self.txtDocumentStyleArray = self.PythonStyleArray
					
		elif target == "Prompt":
			#Prompt Settings
			self.promptisvisible = defaults.promptisvisible
			self.promptmarginwidth = defaults.promptmarginwidth
			self.promptusetabs = defaults.promptusetabs
			self.promptsize = defaults.promptsize
			self.promptwordwrap = defaults.promptwordwrap
			self.promptwhitespaceisvisible = defaults.promptwhitespaceisvisible
			self.promptusestyles = defaults.promptusestyles
			self.promptscrollextrapage = defaults.promptscrollextrapage
			self.txtPromptStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
			x = 0
			l = len(self.txtPromptStyleArray)
			while (x < l):
				self.txtPromptStyleArray[x] = defaults.txtPromptStyleArray[x]
				x = x + 1
	
		elif target == "Find/Replace":
			#Find/Replace Settings
			self.findreplaceregularexpression = defaults.findreplaceregularexpression
			self.findreplacematchcase = defaults.findreplacematchcase
			self.findreplacefindbackwards = defaults.findreplacefindbackwards
			self.findreplacewholeword = defaults.findreplacewholeword
			self.findreplaceinselection = defaults.findreplaceinselection
			self.findreplacefromcursor = defaults.findreplacefromcursor
			self.findreplacepromptonreplace = defaults.findreplacepromptonreplace
		
		elif target == "Find/Replace In Files":
			#Find/Replace In Files Settings
			self.findreplaceinfilesregularexpression = defaults.findreplaceinfilesregularexpression
			self.findreplaceinfilesmatchcase = defaults.findreplaceinfilesmatchcase
			self.findreplaceinfilespromptonreplace = defaults.findreplaceinfilespromptonreplace
			self.findreplaceinfilessubdirectories = defaults.findreplaceinfilessubdirectories
			self.findreplaceinfilesbackupbeforereplace = defaults.findreplaceinfilesbackupbeforereplace
			
		elif target == "Sessions":
			#Sessions
			self.sessionsrecentsessionslimit = defaults.sessionsrecentsessionslimit
			self.sessionsdefaultdirectory = defaults.sessionsdefaultdirectory
			
		elif target == "Class Browser":		
			#Class Browser Settings
			self.classbrowsercloseonactivate = defaults.classbrowsercloseonactivate
			self.classbrowserissorted = defaults.classbrowserissorted
			self.classbrowserstyle = defaults.classbrowserstyle
			
		elif target == "Bookmarks":
			#Bookmarks Settings
			self.bookmarksstyle = defaults.bookmarksstyle
			
		elif target == "DrScript":
			#DrScript Settings
			self.drscriptdefaultdirectory = defaults.drscriptdefaultdirectory
			self.drscriptstyle = defaults.drscriptstyle
			self.drscriptloadexamples = defaults.drscriptloadexamples
		
		elif target == "Shell":
			#Shell Settings
			self.drshelldefaultcommanddirectory = defaults.drshelldefaultcommanddirectory
			self.drshelldefaultcommandarguments = defaults.drshelldefaultcommandarguments
			self.drshellruninpromptbydefault = defaults.drshellruninpromptbydefault
			self.drshellstyle = defaults.drshellstyle
			
		elif target == "Themes":
			#Theme Settings
			self.themesdefaultdirectory = defaults.themesdefaultdirectory
			
		elif target == "Printing":
			#Printing Settings
			self.printdoclinenumbers = defaults.printdoclinenumbers
			self.printpromptlinenumbers = defaults.printpromptlinenumbers
			self.printtabwidth = defaults.printtabwidth
			
		elif target == "Documentation":
			#Documentation Settings
			self.documentationviewhelpwithbrowser = defaults.documentationviewhelpwithbrowser
			self.documentationbrowser = defaults.documentationbrowser
			self.documentationpythonlocation = defaults.documentationpythonlocation
			self.documentationwxwidgetslocation = defaults.documentationwxwidgetslocation
			self.documentationrehowtolocation = defaults.documentationrehowtolocation			
		
	def Copy(self, target):
		self.platform_is_windows = target.platform_is_windows
		
		#General Settings
		self.windowwidth = target.windowwidth
		self.windowheight = target.windowheight
		self.iconsize = target.iconsize
		self.iconfile = target.iconfile
		self.recentfileslimit = target.recentfileslimit
		self.tabwidth = target.tabwidth
		self.mdi = target.mdi
		self.checkeol = target.checkeol
		self.eolmode = target.eolmode
		self.encoding = target.encoding
		self.customencoding = target.customencoding 
		self.pythonargs = target.pythonargs
		self.defaultdirectory = target.defaultdirectory
		self.enablefeedback = target.enablefeedback
		self.enablewarnings = target.enablewarnings
		self.alwayspromptonexit = target.alwayspromptonexit
		self.backupfileonsave = target.backupfileonsave
		self.autogotofortraceback = target.autogotofortraceback
		#utf-8 auto detect limodou 2004/04/14
		self.autodetectutf8encoding = target.autodetectutf8encoding
		#end limodou
		
		#Document Settings
		self.docmarginwidth = target.docmarginwidth
		self.docwordwrap = target.docwordwrap
		self.docautoindent = target.docautoindent		
		self.docusetabs = target.docusetabs
		self.docwhitespaceisvisible = target.docwhitespaceisvisible
		self.docfolding = target.docfolding
		self.docusestyles = target.docusestyles		
		self.docuseindentationguides = target.docuseindentationguides
		self.doclonglinecol = target.doclonglinecol
		self.docscrollextrapage = target.docscrollextrapage
		self.docdefaultsyntaxhighlighting = target.docdefaultsyntaxhighlighting
		self.doconlyusedefaultsyntaxhighlighting = target.doconlyusedefaultsyntaxhighlighting
				
		self.PythonStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		x = 0
		l = len(self.PythonStyleArray)
		while (x < l):
			self.PythonStyleArray[x] = target.PythonStyleArray[x]
			x = x + 1
			
		self.CPPStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		x = 0
		l = len(self.CPPStyleArray)
		while (x < l):
			self.CPPStyleArray[x] = target.CPPStyleArray[x]
			x = x + 1				
		
		self.HTMLStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		x = 0
		l = len(self.HTMLStyleArray)
		while (x < l):
			self.HTMLStyleArray[x] = target.HTMLStyleArray[x]
			x = x + 1
		
		if self.docdefaultsyntaxhighlighting == 1:
			self.txtDocumentStyleArray = self.CPPStyleArray
		elif self.docdefaultsyntaxhighlighting == 2:
			self.txtDocumentStyleArray = self.HTMLStyleArray
		else:
			self.txtDocumentStyleArray = self.PythonStyleArray
				
		#Prompt Settings
		self.promptisvisible = target.promptisvisible
		self.promptmarginwidth = target.promptmarginwidth		
		self.promptusetabs = target.promptusetabs
		self.promptsize = target.promptsize
		self.promptwordwrap = target.promptwordwrap
		self.promptwhitespaceisvisible = target.promptwhitespaceisvisible
		self.promptusestyles = target.promptusestyles
		self.promptscrollextrapage = target.promptscrollextrapage
		self.txtPromptStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		x = 0
		l = len(self.txtPromptStyleArray)
		while (x < l):
			self.txtPromptStyleArray[x] = target.txtPromptStyleArray[x]
			x = x + 1

		#Find/Replace Settings
		self.findreplaceregularexpression = target.findreplaceregularexpression
		self.findreplacematchcase = target.findreplacematchcase
		self.findreplacefindbackwards = target.findreplacefindbackwards
		self.findreplacewholeword = target.findreplacewholeword
		self.findreplaceinselection = target.findreplaceinselection
		self.findreplacefromcursor = target.findreplacefromcursor
		self.findreplacepromptonreplace = target.findreplacepromptonreplace
		
		#Find/Replace In Files Settings
		self.findreplaceinfilesregularexpression = target.findreplaceinfilesregularexpression
		self.findreplaceinfilesmatchcase = target.findreplaceinfilesmatchcase
		self.findreplaceinfilespromptonreplace = target.findreplaceinfilespromptonreplace
		self.findreplaceinfilessubdirectories = target.findreplaceinfilessubdirectories
		self.findreplaceinfilesbackupbeforereplace = target.findreplaceinfilesbackupbeforereplace
		
		#Sessions
		self.sessionsrecentsessionslimit = target.sessionsrecentsessionslimit
		self.sessionsdefaultdirectory = target.sessionsdefaultdirectory
				
		#Class Browser Settings
		self.classbrowsercloseonactivate = target.classbrowsercloseonactivate
		self.classbrowserissorted = target.classbrowserissorted
		self.classbrowserstyle = target.classbrowserstyle
		
		#Bookmarks Settings
		self.bookmarksstyle = target.bookmarksstyle
		
		#DrScript Settings
		self.drscriptdefaultdirectory = target.drscriptdefaultdirectory
		self.drscriptstyle = target.drscriptstyle
		self.drscriptloadexamples = target.drscriptloadexamples
		
		#Shell Settings
		self.drshelldefaultcommanddirectory = target.drshelldefaultcommanddirectory
		self.drshelldefaultcommandarguments = target.drshelldefaultcommandarguments
		self.drshellruninpromptbydefault = target.drshellruninpromptbydefault
		self.drshellstyle = target.drshellstyle
		
		#Theme Settings
		self.themesdefaultdirectory = target.themesdefaultdirectory
		
		#Printing Settings
		self.printdoclinenumbers = target.printdoclinenumbers
		self.printpromptlinenumbers = target.printpromptlinenumbers
		self.printtabwidth = target.printtabwidth
		
		#Documentation Settings
		self.documentationviewhelpwithbrowser = target.documentationviewhelpwithbrowser
		self.documentationbrowser = target.documentationbrowser
		self.documentationpythonlocation = target.documentationpythonlocation
		self.documentationwxwidgetslocation = target.documentationwxwidgetslocation
		self.documentationrehowtolocation = target.documentationrehowtolocation
