#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
import os, os.path
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drBoolean import *
from drProperty import *
import drPrefsFile
from drStyleDialog import drStyleDialog
from drPreferences import drPreferences

class GeneralPanel(wxScrolledWindow):

	def __init__(self, parent, id):

		wxScrolledWindow.__init__(self, parent, id)
				
		self.EnableScrolling(True, True)
		
		self.SetScrollbars(10, 10, 30, 30)
				
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)		
		
		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")

		#TextCtrl Size Patch John Bell
		self.txtwindowwidth = wxTextCtrl(self, self.GetGrandParent().ID_WINDOWWIDTH, str(self.GetGrandParent().prefs.windowwidth), wxPoint(225, 215), wxSize(50, -1))
		
		self.txtwindowheight = wxTextCtrl(self, self.GetGrandParent().ID_WINDOWHEIGHT, str(self.GetGrandParent().prefs.windowheight), wxPoint(225, 215), wxSize(50, -1))
		
		self.boxiconsize = wxChoice(self, self.GetGrandParent().ID_ICON_SIZE, wxPoint(225, 135), wxSize(-1, -1), ["0", "16", "24"])
		
		self.txticonfile = wxTextCtrl(self, -1, self.GetGrandParent().prefs.iconfile,  wxPoint(15, 325), wxSize(250, -1))	

		self.chkmdi = wxCheckBox(self, self.GetGrandParent().ID_MDI, "")
		
		self.btnBrowseIcon = wxButton(self, self.GetGrandParent().ID_ICON_FILE_BROWSE, " &Browse ")
		
		self.txtRecentFiles = wxTextCtrl(self, self.GetGrandParent().ID_TXT_RECENT_FILES, str(self.GetGrandParent().prefs.recentfileslimit), wxPoint(225, 175), wxSize(35, -1))

		self.txttabwidth = wxTextCtrl(self, self.GetGrandParent().ID_TXT_TAB_WIDTH, str(self.GetGrandParent().prefs.tabwidth), wxPoint(225, 215), wxSize(35, -1))

		self.txtpythonargs = wxTextCtrl(self, -1, self.GetGrandParent().prefs.pythonargs, wxPoint(225, 255), wxSize(55, -1))

		self.boxencoding = wxChoice(self, -1, wxPoint(225, 135), wxSize(-1, -1), ["Default", "ASCII", "UTF-8", "Custom"])
		
		self.txtcustomencoding = wxTextCtrl(self, -1, self.GetGrandParent().prefs.customencoding, wxPoint(225, 255), wxSize(55, -1))

		self.txtdefaultdirectory = wxTextCtrl(self, -1, self.GetGrandParent().prefs.defaultdirectory,  wxPoint(15, 325), wxSize(250, -1))	

		self.btnBrowse = wxButton(self, self.GetGrandParent().ID_FILE_BROWSE, " &Browse ")
		
		self.chkenablefeedback = wxCheckBox(self, -1, "")
		
		self.chkenablewarnings = wxCheckBox(self, -1, "")
		
		self.chkalwayspromptonexit = wxCheckBox(self, -1, "")
		
		self.chkbackupfileonsave = wxCheckBox(self, -1, "")
		
		self.chkautogotofortraceback = wxCheckBox(self, -1, "")
		
		#utf-8 auto detect limodou 2004/04/14
		self.chkautodetectutf8encoding = wxCheckBox(self, -1, "")
		#end limodou
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Window Width:"),1,wxSHAPED)
		self.theSizer.Add(self.txtwindowwidth,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Window Height:"),1,wxSHAPED)
		self.theSizer.Add(self.txtwindowheight,1,wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Max number of recent files:"),1,wxSHAPED)
		self.theSizer.Add(self.txtRecentFiles,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Tab width:"),1,wxSHAPED)
		self.theSizer.Add(self.txttabwidth,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "MDI:"),1,wxSHAPED)
		self.theSizer.Add(self.chkmdi,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Python arguments (eg \"-i\"):"),1,wxSHAPED)
		self.theSizer.Add(self.txtpythonargs,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Encoding:"),1,wxSHAPED)
		self.theSizer.Add(self.boxencoding,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Custom Encoding:"),1,wxSHAPED)
		self.theSizer.Add(self.txtcustomencoding,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		
		#Moved by DrPython
		#utf-8 auto detect support limodou 2004/04/14
		self.theSizer.Add(wxStaticText(self, -1, "Auto Detect UTF-8 Encoding:"),1,wxSHAPED)
		self.theSizer.Add(self.chkautodetectutf8encoding,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		#end limodou
		
		self.theSizer.Add(wxStaticText(self, -1, "Icon size:"),1,wxSHAPED)
		self.theSizer.Add(self.boxiconsize,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Icon File:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txticonfile,1,wxSHAPED)
		self.theSizer.Add(self.btnBrowseIcon,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Default Directory:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtdefaultdirectory,1,wxSHAPED)
		self.theSizer.Add(self.btnBrowse,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Enable Feedback Messages:"),1,wxSHAPED)
		self.theSizer.Add(self.chkenablefeedback,1,wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Enable Warnings:"),1,wxSHAPED)
		self.theSizer.Add(self.chkenablewarnings,1,wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Always Prompt On Exit:"),1,wxSHAPED)
		self.theSizer.Add(self.chkalwayspromptonexit,1,wxSHAPED)			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Backup File On Save:"),1,wxSHAPED)
		self.theSizer.Add(self.chkbackupfileonsave,1,wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Auto Goto For Traceback:"),1,wxSHAPED)
		self.theSizer.Add(self.chkautogotofortraceback,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)

		self.reset()

		EVT_TEXT(self, self.GetGrandParent().ID_WINDOWWIDTH, self.OntxtWindowWidth)
		EVT_TEXT(self, self.GetGrandParent().ID_WINDOWHEIGHT, self.OntxtWindowHeight)
		EVT_TEXT(self, self.GetGrandParent().ID_TXT_RECENT_FILES, self.OntxtRecentFiles)
		EVT_TEXT(self, self.GetGrandParent().ID_TXT_TAB_WIDTH, self.Ontxttabwidth)
		EVT_CHECKBOX(self, self.GetGrandParent().ID_MDI, self.OnMdiChecked)
		EVT_BUTTON(self, self.GetGrandParent().ID_ICON_FILE_BROWSE, self.OnbtnBrowseIcon)
		EVT_BUTTON(self, self.GetGrandParent().ID_FILE_BROWSE, self.OnbtnBrowse)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		
	def reset(self):
	
		self.txtwindowwidth.SetValue(str(self.GetGrandParent().prefs.windowwidth))
		
		self.txtwindowheight.SetValue(str(self.GetGrandParent().prefs.windowheight))
		
		self.txtRecentFiles.SetValue(str(self.GetGrandParent().prefs.recentfileslimit))
			
		if (self.GetGrandParent().prefs.iconsize == 24):
			self.boxiconsize.SetSelection(2)
		elif (self.GetGrandParent().prefs.iconsize == 16):
			self.boxiconsize.SetSelection(1)
		else:
			self.boxiconsize.SetSelection(0)
		
		self.boxencoding.SetSelection(self.GetGrandParent().prefs.encoding)
		
		self.txtcustomencoding.SetValue(self.GetGrandParent().prefs.customencoding)
		
		self.txticonfile.SetValue(self.GetGrandParent().prefs.iconfile)
			
		self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.tabwidth))

		self.chkmdi.SetValue(self.GetGrandParent().prefs.mdi)

		self.txtpythonargs.SetValue(self.GetGrandParent().prefs.pythonargs)

		self.txtdefaultdirectory.SetValue(self.GetGrandParent().prefs.defaultdirectory)		
					
		self.chkenablefeedback.SetValue(self.GetGrandParent().prefs.enablefeedback)
		
		self.chkenablewarnings.SetValue(self.GetGrandParent().prefs.enablewarnings)
		
		self.chkalwayspromptonexit.SetValue(self.GetGrandParent().prefs.alwayspromptonexit)
		
		self.chkbackupfileonsave.SetValue(self.GetGrandParent().prefs.backupfileonsave)
		
		self.chkautogotofortraceback.SetValue(self.GetGrandParent().prefs.autogotofortraceback)
		
		#utf-8 auto detect limodou 2004/04/14
		self.chkautodetectutf8encoding.SetValue(self.GetGrandParent().prefs.autodetectutf8encoding)
		#end limodou
		
	def OnbtnBrowseIcon(self, event):
		dlg = wxFileDialog(self, "Select Icon File", "", "", "DrPython Icon Set (*.dis)|*.dis|All files (*)|*", wxOPEN|wxHIDE_READONLY)
		if (len(self.GetGrandParent().prefs.themesdefaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.GetGrandParent().prefs.themesdefaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self, ("Error Setting Default Directory To: " + self.GetGrandParent().prefs.themesdefaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			self.txticonfile.SetValue(dlg.GetPath())
		dlg.Destroy()
		
	def OnbtnBrowse(self, event):
		d = wxDirDialog(self, "Select Default Directory:", style=wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON|wxMAXIMIZE_BOX|wxTHICK_FRAME)
		if d.ShowModal() == wxID_OK:
        		self.txtdefaultdirectory.SetValue(d.GetPath())
    		d.Destroy()			
	
	def OnMdiChecked(self, event):
		if self.GetGrandParent().GetParent().prefs.enablewarnings:
			d = wxScrolledMessageDialog(self, ("Warning:\n\nChanging the MDI state will cause DrPython to reload all open files in this window.\n\nBe Sure to SAVE all files BEFORE changing this preference."), "Warning")
			d.ShowModal()
			d.Destroy()
		
	def OntxtRecentFiles(self, event):
		x = self.txtRecentFiles.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)
		except ValueError:
			d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Positive Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")
			d.ShowModal()
			d.Destroy()
			self.txtRecentFiles.SetValue(str(self.GetGrandParent().prefs.recentfileslimit))
			return
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()	
			self.txtRecentFiles.SetValue(str(self.GetGrandParent().prefs.recentfileslimit))
			return
		if (y > 25):
			d = wxScrolledMessageDialog(self, ("DrPython does not recommend going this high.  You can of course..."), "Hmmmm")
			d.ShowModal()
			d.Destroy()		
	
	def Ontxttabwidth(self, event):
		x = self.txttabwidth.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)
		except ValueError:
			d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Positive Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.tabwidth))
			return
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.tabwidth))
			return
		if (y > 1024):
			d = wxScrolledMessageDialog(self, ("DrPython does not recommend going this high.  You can of course..."), "Hmmmm")
			d.ShowModal()
			d.Destroy()	
	
	def OntxtWindow(self, event, txt, target):
		x = txt.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)	
		except ValueError:
			if not (x == '-'):
				d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Actual Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")				
				d.ShowModal()
				d.Destroy()
				txt.SetValue(str(target))
			return
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()	
			txt.SetValue(str(target))
			return
					
	def OntxtWindowWidth(self, event):
		self.OntxtWindow(event, self.txtwindowwidth, self.GetGrandParent().prefs.windowwidth)
	
	def OntxtWindowHeight(self, event):
		self.OntxtWindow(event, self.txtwindowheight, self.GetGrandParent().prefs.windowheight)

class DocumentPanel(wxScrolledWindow):

	def __init__(self, parent, id):
		wxScrolledWindow.__init__(self, parent, id)			
				
		self.EnableScrolling(True, True)
		
		self.SetScrollbars(10, 10, 30, 30)
		
		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.txtmarginwidth = wxTextCtrl(self, self.GetGrandParent().ID_DOC_MARGIN_WIDTH, str(self.GetGrandParent().prefs.docmarginwidth), wxPoint(225, 215), wxSize(35, -1))
					
		self.chkdocautoindent = wxCheckBox(self, -1, "")
		
		self.chkdocusetabs = wxCheckBox(self, -1, "")
		
		self.chkdocwordwrap = wxCheckBox(self, -1, "")

		self.chkWhitespace = wxCheckBox(self, -1, "")
		
		self.chkfolding = wxCheckBox(self, -1, "")	
		
		self.chkuseindentationguides = wxCheckBox(self, -1, "")
		
		#Chris McDonough (I added txt prefix, update for local constants)
		self.txtdoclonglinecol = wxTextCtrl(self, self.GetGrandParent().ID_LONGLINE_COL, str(self.GetGrandParent().prefs.doclonglinecol), wxPoint(225, 215), wxSize(35, -1))
		#/Chris McDonough
		
		self.chkscrollextrapage = wxCheckBox(self, -1, "")
		
		self.radusestyles = wxRadioBox(self, -1, "Styles:", wxDefaultPosition, wxDefaultSize, ["Don't Use Styles", "Use Styles", "Only Use \"Normal\", \"Caret Foreground\""], 1, wxRA_SPECIFY_COLS)	
		
		self.boxdefaultsyntaxhighlighting = wxChoice(self, -1, wxPoint(225, 135), wxSize(-1, -1), ["Python", "C/C++", "HTML"])
		
		self.chkonlyusedefaultsyntaxhighlighting = wxCheckBox(self, -1, "")
	
		i = self.GetGrandParent().parent.txtDocument.currentlanguage
		if i > 2:
			i = 0
		self.boxLanguage = wxChoice(self, self.GetGrandParent().ID_DOC_LANGUAGE, wxPoint(225, 135), wxSize(-1, -1), ["Python", "C/C++", "HTML"])				
		self.boxLanguage.SetSelection(i)
		
		self.boxTextType = wxChoice(self, self.GetGrandParent().ID_TEXT_TYPE, wxPoint(15, 40), wxSize(-1, -1))

		self.btnStyle = wxButton(self, self.GetGrandParent().ID_FILE_STYLE, " Edit Text Style ")
		self.btnApplyProperty = wxButton(self, self.GetGrandParent().ID_APPLY_PROPERTY, " Apply Text Property To All Styles ")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Line Number Margin Width:"),1,wxSHAPED)
		self.theSizer.Add(self.txtmarginwidth,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Autoindent:"),1,wxSHAPED)
		self.theSizer.Add(self.chkdocautoindent,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Use Tabs:"),1,wxSHAPED)
		self.theSizer.Add(self.chkdocusetabs,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Word Wrap:"),1,wxSHAPED)
		self.theSizer.Add(self.chkdocwordwrap,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Whitespace is visible on startup:"),1,wxSHAPED)
		self.theSizer.Add(self.chkWhitespace ,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Folding:"),1,wxSHAPED)
		self.theSizer.Add(self.chkfolding ,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Use Indentation guides:"),1,wxSHAPED)
		self.theSizer.Add(self.chkuseindentationguides ,1,wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		
		#Chris McDonough (I added txt prefix, update for local constants)
		self.theSizer.Add(wxStaticText(self, -1, "Long Line Indicator Column:"),1,wxSHAPED)
 		self.theSizer.Add(self.txtdoclonglinecol,1,wxSHAPED)
 		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		#/Chris McDonough
		
		self.theSizer.Add(wxStaticText(self, -1, "Scroll Extra Page:"),1,wxSHAPED)
		self.theSizer.Add(self.chkscrollextrapage ,1,wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.radusestyles,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Default Syntax Highlighting:"), 1, wxSHAPED)
		self.theSizer.Add(self.boxdefaultsyntaxhighlighting,1,wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Only Use Default Syntax Highlighting"), 1, wxSHAPED)
		self.theSizer.Add(self.chkonlyusedefaultsyntaxhighlighting,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Select text type to edit:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.boxLanguage,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.boxTextType,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnStyle,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnApplyProperty,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		
		#Buffer
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
		
		self.reset()	
		
		self.OnSelectLanguage(None)	
		
		EVT_TEXT(self, self.GetGrandParent().ID_DOC_MARGIN_WIDTH, self.Ontxtmarginwidth)
		EVT_TEXT(self, self.GetGrandParent().ID_LONGLINE_COL, self.Ontxtdoclonglinecol)
		EVT_BUTTON(self, self.GetGrandParent().ID_FILE_STYLE, self.OnbtnStyle)
		EVT_BUTTON(self, self.GetGrandParent().ID_APPLY_PROPERTY, self.OnbtnApplyProperty)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		EVT_CHOICE(self, self.GetGrandParent().ID_DOC_LANGUAGE, self.OnSelectLanguage)

	def reset(self):
			
		self.txtmarginwidth.SetValue(str(self.GetGrandParent().prefs.docmarginwidth))
		
		self.chkdocautoindent.SetValue(self.GetGrandParent().prefs.docautoindent)
	
		self.chkdocusetabs.SetValue(self.GetGrandParent().prefs.docusetabs)
		
		self.chkdocwordwrap.SetValue(self.GetGrandParent().prefs.docwordwrap)

		self.chkWhitespace.SetValue(self.GetGrandParent().prefs.docwhitespaceisvisible)	
			
		self.chkfolding.SetValue(self.GetGrandParent().prefs.docfolding)	
	
		self.chkuseindentationguides.SetValue(self.GetGrandParent().prefs.docuseindentationguides)
	
		self.chkscrollextrapage.SetValue(self.GetGrandParent().prefs.docscrollextrapage)
	
		self.boxdefaultsyntaxhighlighting.SetSelection(self.GetGrandParent().prefs.docdefaultsyntaxhighlighting)
	
		self.chkonlyusedefaultsyntaxhighlighting.SetValue(self.GetGrandParent().prefs.doconlyusedefaultsyntaxhighlighting)
	
		self.radusestyles.SetSelection(self.GetGrandParent().prefs.docusestyles)		
	
	def Ontxtdoclonglinecol(self, event):
		#Chris McDonough (Edited to allow for negative numbers)
		x = self.txtdoclonglinecol.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)
		except ValueError:
			if not x == "-":
				d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Actual Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")
				d.ShowModal()
				d.Destroy()
				self.txtdoclonglinecol.SetValue(str(self.GetGrandParent().prefs.doclonglinecol))
				return
			y = 0			
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()
			self.txtdoclonglinecol.SetValue(str(self.GetGrandParent().prefs.doclonglinecol))
			return
		if (y > 1024):
			d = wxScrolledMessageDialog(self, ("DrPython does not recommend going this high.  You can of course..."), "Hmmmm")
			d.ShowModal()
			d.Destroy()
	
	def Ontxtmarginwidth(self, event):
		x = self.txtmarginwidth.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)
		except ValueError:
			d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Positive Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.docmarginwidth))
			return
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.docmarginwidth))
			return
		if (y > 1024):
			d = wxScrolledMessageDialog(self, ("DrPython does not recommend going this high.  You can of course..."), "Hmmmm")
			d.ShowModal()
			d.Destroy()			
		
	def OnbtnStyle(self, event):	
		current = self.boxTextType.GetSelection()
		seltext = self.boxTextType.GetStringSelection()
		ChangeSpec = 0
		
		ttstring = self.targetArray[current]
		if (seltext == "Caret Foreground") or (seltext == "Long Line Indicator"):
			ChangeSpec = 1
			ttstring = "fore:" + ttstring
		elif (seltext == "Selection") or (seltext == "Folding"):
			ChangeSpec = 2
		d = drStyleDialog(self, -1, ("Style: " + seltext), ttstring, self.targetArray[0], ChangeSpec)

		d.ShowModal()

		if (d.ClickedOk()):	
			self.targetArray.pop(current)
			if (ChangeSpec == 0):
				self.targetArray.insert(current, d.GetStyleString())
			elif (ChangeSpec == 1):
				self.targetArray.insert(current, d.GetForeground())
			elif (ChangeSpec == 2):
				self.targetArray.insert(current, d.GetColorString())
		
		d.Destroy()
			
	def OnbtnApplyProperty(self, event):
		d = wxMessageDialog(self, "This will set a property (either font, size, foreground or background) for all text styles\n(except for line number, caret foreground and selection)\nto the property for normal text.\nAre you sure you want to do this?", "DrPython", wxYES_NO | wxICON_QUESTION)
		d = wxSingleChoiceDialog(self, "Select the property you wish to apply to all styles:", "Apply Property To All Styles", ["Font", "Size", "Background", "Foreground"], wxOK|wxCANCEL)
		answer = d.ShowModal()
		d.Destroy()
		if (answer == wxID_OK):		
			#ignore caret foreground, selection, folding style: (last three items)
			l = len(self.targetArray) - 3
			#Ignore default text for all, and line number text for bg/fg (first two items)
			x = 2
			s = d.GetStringSelection()
			if (s == "Font"):
				prop = "face"
				dummy = ",face:terminal"
				x = 1
			elif (s == "Size"):
				prop = "size"
				dummy = ",size:10"
				x = 1
			elif (s == "Background"):
				prop = "back"
				dummy = ",back:#FFFFFF"
			elif (s == "Foreground"):
				prop = "fore"
				dummy = ",fore:#000000"		
			bstring = getStyleProperty(prop, self.targetArray[0])
			while (x < l):
				tstring = self.targetArray[x]
				self.targetArray.pop(x)
				try:
					tstring.index(prop)
				except:
					tstring = tstring + dummy
				self.targetArray.insert(x, setStyleProperty(prop, tstring, bstring))
				x = x + 1

	def OnSelectLanguage(self, event):
		sel = self.boxLanguage.GetSelection()
		
		l = self.boxTextType.GetCount()
		x = l - 1
		while x > -1:
			self.boxTextType.Delete(x)
			x = x - 1
			
		if sel == 1:
			self.targetArray = self.GetGrandParent().prefs.CPPStyleArray
			array = ["Normal", "Line Number (Margin)", "Brace-Selected (Match)", "Brace-Selected (No Match)", "Character", "Preprocessor", "Comment", "Verbatim", "Keyword", "Number", "Operator", "String", "Regex", "UUID", "Caret Foreground", "Selection", "Folding", "Long Line Indicator"]
		elif sel == 2:
			self.targetArray = self.GetGrandParent().prefs.HTMLStyleArray
			array = ["Normal", "Line Number (Margin)", "Brace-Selected (Match)", "Brace-Selected (No Match)", "Tag", "Unkown Tag", "Atrribute", "Unkown Attribute", "Number", "String", "Character (Single Quoted String)", "Comment", "Entity", "Tag End", "XML Start", "XML End", "Script", "Value", "Caret Foreground", "Selection", "Folding", "Long Line Indicator"]
		else:
			self.targetArray = self.GetGrandParent().prefs.PythonStyleArray
			array = ["Normal", "Line Number (Margin)", "Brace-Selected (Match)", "Brace-Selected (No Match)", "Character (Single Quoted String)", "Class Name", "Comment", "Function Name", "Keyword", "Number", "Operator", "String", "Triple Quoted String", "Caret Foreground", "Selection", "Folding", "Long Line Indicator"]
			
		l = len(array)
		x = 0
		while x < l:
			self.boxTextType.Append(array[x])
			x = x + 1
		self.boxTextType.SetSelection(0)
		
class PromptPanel(wxScrolledWindow):

	def __init__(self, parent, id):

		wxScrolledWindow.__init__(self, parent, id)
		
		self.EnableScrolling(True, True)
		
		self.SetScrollbars(18, 10, 30, 30)		

		self.textlist = ["Normal", "Line Number (Margin)", "Brace-Selected (Match)", "Brace-Selected (No Match)", "Character (Single Quoted String)", "Class Name", "Comment", "Function Name", "Keyword", "Number", "Operator", "String", "Triple Quoted String", "Caret Foreground", "Selection"]

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.txtmarginwidth = wxTextCtrl(self, self.GetGrandParent().ID_PROMPT_MARGIN_WIDTH, str(self.GetGrandParent().prefs.promptmarginwidth), wxPoint(225, 215), wxSize(35, -1))

		self.chkVisible = wxCheckBox(self, -1, "")
		
		self.chkpromptusetabs = wxCheckBox(self, -1, "")

		self.chkwordwrap = wxCheckBox(self, -1, "")

		self.chkWhitespace = wxCheckBox(self, -1, "")
		
		self.chkscrollextrapage = wxCheckBox(self, -1, "")
			
		self.sldrSize =  wxSlider(self, -1, self.GetGrandParent().prefs.promptsize, 25, 100, wxPoint(150, 55), wxSize(75, -1), wxSL_HORIZONTAL | wxSL_AUTOTICKS | wxSL_LABELS )
		self.sldrSize.SetTickFreq(25, 1)

		self.radusestyles = wxRadioBox(self, -1, "Styles:", wxDefaultPosition, wxDefaultSize, ["Don't Use Styles", "Use Styles", "Only Use \"Normal\", \"Caret Foreground\""], 1, wxRA_SPECIFY_COLS)	

		self.boxTextType = wxChoice(self, self.GetGrandParent().ID_PROMPT_TEXT_TYPE, wxPoint(15, 40), wxSize(-1, -1), self.textlist)
		self.boxTextType.SetSelection(0)

		self.btnStyle = wxButton(self, self.GetGrandParent().ID_PROMPT_STYLE, " Edit Text Style ")
		self.btnApplyProperty = wxButton(self, self.GetGrandParent().ID_PROMPT_APPLY_PROPERTY, " Apply Text Property To All Styles ")

		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Line Number Margin Width:"),1,wxSHAPED)
		self.theSizer.Add(self.txtmarginwidth,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Visible on startup:"),1,wxSHAPED)
		self.theSizer.Add(self.chkVisible, 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Use Tabs:"),1,wxSHAPED)
		self.theSizer.Add(self.chkpromptusetabs,1,wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Word Wrap:"),1,wxSHAPED)
		self.theSizer.Add(self.chkwordwrap,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Whitespace is visible on startup:"),1,wxSHAPED)
		self.theSizer.Add(self.chkWhitespace ,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Scroll Extra Page:"),1,wxSHAPED)
		self.theSizer.Add(self.chkscrollextrapage ,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Vertical size:"),1,wxSHAPED)
		self.theSizer.Add(self.sldrSize, 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.radusestyles ,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Select text type to edit:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.boxTextType,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnStyle,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnApplyProperty,1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)

		#Buffer
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
			
		self.reset()

		EVT_TEXT(self, self.GetGrandParent().ID_PROMPT_MARGIN_WIDTH, self.Ontxtmarginwidth)
		EVT_BUTTON(self, self.GetGrandParent().ID_PROMPT_STYLE, self.OnbtnStyle)			
		EVT_BUTTON(self, self.GetGrandParent().ID_PROMPT_APPLY_PROPERTY, self.OnbtnApplyProperty)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
	
	def reset(self):
			
		self.txtmarginwidth.SetValue(str(self.GetGrandParent().prefs.promptmarginwidth))
		
		self.chkVisible.SetValue(self.GetGrandParent().prefs.promptisvisible)

		self.chkpromptusetabs.SetValue(self.GetGrandParent().prefs.promptusetabs)

		self.chkwordwrap.SetValue(self.GetGrandParent().prefs.promptwordwrap)

		self.chkWhitespace.SetValue(self.GetGrandParent().prefs.promptwhitespaceisvisible)	
		
		self.sldrSize.SetValue(self.GetGrandParent().prefs.promptsize)	
		
		self.chkscrollextrapage.SetValue(self.GetGrandParent().prefs.promptscrollextrapage)
	
		self.radusestyles.SetSelection(self.GetGrandParent().prefs.promptusestyles)
	
	def Ontxtmarginwidth(self, event):
		x = self.txtmarginwidth.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)
		except ValueError:
			d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Positive Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.promptmarginwidth))
			return
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.promptmarginwidth))
			return
		if (y > 1024):
			d = wxScrolledMessageDialog(self, ("DrPython does not recommend going this high.  You can of course..."), "Hmmmm")
			d.ShowModal()
			d.Destroy()
		
	def OnbtnStyle(self, event):
		current = self.boxTextType.GetSelection()
		seltext = self.boxTextType.GetStringSelection()
		ChangeSpec = 0
		ttstring = self.GetGrandParent().prefs.txtPromptStyleArray[current]
		if (seltext == "Caret Foreground"):
			ChangeSpec = 1
			ttstring = "fore:" + ttstring
		if (current > 13):
			ChangeSpec = 2
		d = drStyleDialog(self, -1, ("Prompt Style: " + seltext), ttstring, self.GetGrandParent().prefs.txtPromptStyleArray[0], ChangeSpec)

		d.ShowModal()		

		if (d.ClickedOk()):
			self.GetGrandParent().prefs.txtPromptStyleArray.pop(current)	
			if (current > 13):
				self.GetGrandParent().prefs.txtPromptStyleArray.insert(current, d.GetColorString())
			elif (ChangeSpec == 0):
				self.GetGrandParent().prefs.txtPromptStyleArray.insert(current, d.GetStyleString())
			elif (ChangeSpec == 1):				
				self.GetGrandParent().prefs.txtPromptStyleArray.insert(current, d.GetForeground())
		
		d.Destroy()
	
	def OnbtnApplyProperty(self, event):
		d = wxMessageDialog(self, "This will set a property (either font, size, foreground or background) for all text styles\n(except for line number, caret foreground and selection)\nto the property for normal text.\nAre you sure you want to do this?", "DrPython", wxYES_NO | wxICON_QUESTION)
		d = wxSingleChoiceDialog(self, "Select the property you wish to apply to all styles:", "Apply Property To All Styles", ["Font", "Size", "Background", "Foreground"], wxOK|wxCANCEL)
		answer = d.ShowModal()
		d.Destroy()
		if (answer == wxID_OK):
			s = d.GetStringSelection()
			if (s == "Font"):
				prop = "face"
				dummy = ",face:terminal"
			elif (s == "Size"):
				prop = "size"
				dummy = ",size:10"
			elif (s == "Background"):
				prop = "back"
				dummy = ",back:#000000"
			elif (s == "Foreground"):
				prop = "fore"
				dummy = ",fore:#FFFFFF"
			l = len(self.GetGrandParent().prefs.txtPromptStyleArray) - 3		
			#ignore caret foreground, selections
			x = 2
			#Ignore default text, and line number text (0, and 1)
			bstring = getStyleProperty(prop, self.GetGrandParent().prefs.txtPromptStyleArray[0])
			while (x < l):
				tstring = self.GetGrandParent().prefs.txtPromptStyleArray[x]
				self.GetGrandParent().prefs.txtPromptStyleArray.pop(x)
				try:
					tstring.index(prop)
				except:
					tstring = tstring + dummy
				self.GetGrandParent().prefs.txtPromptStyleArray.insert(x, setStyleProperty(prop, tstring, bstring))
				x = x + 1			

class FindReplacePanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
				
		self.chkregularexpression = wxCheckBox(self, -1, "")
		self.chkmatchcase = wxCheckBox(self, -1, "")
		self.chkfindbackwards = wxCheckBox(self, -1, "")
		self.chkwholeword = wxCheckBox(self, -1, "")
		self.chkinselection = wxCheckBox(self, -1, "")
		self.chkfromcursor = wxCheckBox(self, -1, "")
		self.chkpromptonreplace = wxCheckBox(self, -1, "")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Regular Expression:"),1,wxSHAPED)
		self.theSizer.Add(self.chkregularexpression, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Match Case:"),1,wxSHAPED)
		self.theSizer.Add(self.chkmatchcase, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Find Backwards:"),1,wxSHAPED)
		self.theSizer.Add(self.chkfindbackwards, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Whole Word:"),1,wxSHAPED)
		self.theSizer.Add(self.chkwholeword, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "In Selection:"),1,wxSHAPED)
		self.theSizer.Add(self.chkinselection, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "From Cursor:"),1,wxSHAPED)
		self.theSizer.Add(self.chkfromcursor, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Prompt On Replace:"),1,wxSHAPED)
		self.theSizer.Add(self.chkpromptonreplace, 1, wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
			
		self.reset()
		
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
			
	def reset(self):

		self.chkregularexpression.SetValue(self.GetGrandParent().prefs.findreplaceregularexpression)
		self.chkmatchcase.SetValue(self.GetGrandParent().prefs.findreplacematchcase)
		self.chkfindbackwards.SetValue(self.GetGrandParent().prefs.findreplacefindbackwards)
		self.chkwholeword.SetValue(self.GetGrandParent().prefs.findreplacewholeword)
		self.chkinselection.SetValue(self.GetGrandParent().prefs.findreplaceinselection)
		self.chkfromcursor.SetValue(self.GetGrandParent().prefs.findreplacefromcursor)
		self.chkpromptonreplace.SetValue(self.GetGrandParent().prefs.findreplacepromptonreplace)

class FindReplaceInFilesPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
				
		self.chkregularexpression = wxCheckBox(self, -1, "")
		self.chkmatchcase = wxCheckBox(self, -1, "")
		self.chkpromptonreplace = wxCheckBox(self, -1, "")
		self.chksubdirectories = wxCheckBox(self, -1, "")
		self.chkbackupbeforereplace = wxCheckBox(self, -1, "")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Regular Expression:"),1,wxSHAPED)
		self.theSizer.Add(self.chkregularexpression, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Match Case:"),1,wxSHAPED)
		self.theSizer.Add(self.chkmatchcase, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Prompt On Replace:"),1,wxSHAPED)
		self.theSizer.Add(self.chkpromptonreplace, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Subdirectories:"),1,wxSHAPED)
		self.theSizer.Add(self.chksubdirectories, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Backup Before Replace:"),1,wxSHAPED)
		self.theSizer.Add(self.chkbackupbeforereplace, 1, wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
			
		self.reset()
		
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
			
	def reset(self):

		self.chkregularexpression.SetValue(self.GetGrandParent().prefs.findreplaceinfilesregularexpression)
		self.chkmatchcase.SetValue(self.GetGrandParent().prefs.findreplaceinfilesmatchcase)
		self.chksubdirectories.SetValue(self.GetGrandParent().prefs.findreplaceinfilessubdirectories)
		self.chkbackupbeforereplace.SetValue(self.GetGrandParent().prefs.findreplaceinfilesbackupbeforereplace)
		self.chkpromptonreplace.SetValue(self.GetGrandParent().prefs.findreplaceinfilespromptonreplace)

class SessionsPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)
		
		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.txtdefaultdirectory = wxTextCtrl(self, -1, self.GetGrandParent().prefs.sessionsdefaultdirectory,  wxPoint(15, 325), wxSize(250, -1))	
		
		self.txtRecentSessions = wxTextCtrl(self, self.GetGrandParent().ID_TXT_RECENT_FILES, str(self.GetGrandParent().prefs.sessionsrecentsessionslimit), wxPoint(225, 175), wxSize(35, -1))
		
		self.btnBrowse = wxButton(self, self.GetGrandParent().ID_DRSCRIPT_BROWSE, " &Browse ")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1, wxSHAPED)
				
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Default Directory:"), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtdefaultdirectory,1, wxSHAPED)
		self.theSizer.Add(self.btnBrowse,1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Recent Sessions Limit:"),1,wxSHAPED)
		self.theSizer.Add(self.txtRecentSessions, 1, wxSHAPED)
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
		
		self.reset()
					
		EVT_TEXT(self, self.GetGrandParent().ID_TXT_RECENT_FILES, self.OntxtRecentSessions)
		EVT_BUTTON(self, self.GetGrandParent().ID_DRSCRIPT_BROWSE, self.OnbtnBrowse)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		
	def reset(self):
		self.txtdefaultdirectory.SetValue(self.GetGrandParent().prefs.sessionsdefaultdirectory)		
		self.txtRecentSessions.SetValue(str(self.GetGrandParent().prefs.sessionsrecentsessionslimit))

	def OnbtnBrowse(self, event):
		d = wxDirDialog(self, "Select Default Directory For Sessions:", style=wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON|wxMAXIMIZE_BOX|wxTHICK_FRAME)
		if d.ShowModal() == wxID_OK:
        		self.txtdefaultdirectory.SetValue(d.GetPath())
    		d.Destroy()	
			
	def OntxtRecentSessions(self, event):
		x = self.txtRecentSessions.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)
		except ValueError:
			d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Positive Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")
			d.ShowModal()
			d.Destroy()
			self.txtRecentSessions.SetValue(str(self.GetGrandParent().prefs.sessionsrecentsessionslimit))
			return
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()	
			self.txtRecentSessions.SetValue(str(self.GetGrandParent().prefs.sessionsrecentsessionslimit))
			return
		if (y > 25):
			d = wxScrolledMessageDialog(self, ("DrPython does not recommend going this high.  You can of course..."), "Hmmmm")
			d.ShowModal()
			d.Destroy()	

class LineEndingsPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.chkCheckFormat = wxCheckBox(self, -1, "")
		
		self.radFormat = wxChoice(self, -1, wxPoint(15, 80), wxDefaultSize, [" Unix ('\\n')  "," DOS/Windows ('\\r\\n')  "," Mac ('\\r')  "])		
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Check Line Ending Format on Open:"),1,wxSHAPED)
		self.theSizer.Add(self.chkCheckFormat, 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Line Ending Format:"),1,wxSHAPED)
		self.theSizer.Add(self.radFormat, 1, wxSHAPED)		

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
			
		self.reset()
		
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
			
	def reset(self):

		self.chkCheckFormat.SetValue(self.GetGrandParent().prefs.checkeol)
		
		try:
			self.radFormat.SetSelection(self.GetGrandParent().prefs.eolmode)
		except:
			d = wxScrolledMessageDialog(self, ("FOOL!  What have you done?\n  The eolmode is messed up.\nDon't know why either.\nBest E-Mail the Doctor.\n(And be verbose when you do!)"), "Foolish Error")
			d.ShowModal()
			d.Destroy()

class ClassBrowserPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)
		
		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.chkcloseonactivate = wxCheckBox(self, -1, "")

		self.chkissorted = wxCheckBox(self, -1, "")

		self.btnStyle = wxButton(self, self.GetGrandParent().ID_CLASS_BROWSER_STYLE, " Edit Class Browser Style ")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Close On Activate:"),1,wxSHAPED)
		self.theSizer.Add(self.chkcloseonactivate, 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Sorted (Alphabetical):"),1,wxSHAPED)
		self.theSizer.Add(self.chkissorted, 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnStyle, 1, wxSHAPED)		

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
			
		self.reset()	
					
		EVT_BUTTON(self, self.GetGrandParent().ID_CLASS_BROWSER_STYLE, self.OnbtnStyle)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		
	def reset(self):
		self.chkcloseonactivate.SetValue(self.GetGrandParent().prefs.classbrowsercloseonactivate)
		self.chkissorted.SetValue(self.GetGrandParent().prefs.classbrowserissorted)
			
	def OnbtnStyle(self, event):		
		d = drStyleDialog(self, -1, ("Style: Class Browser"), self.GetGrandParent().prefs.classbrowserstyle, self.GetGrandParent().prefs.classbrowserstyle)

		d.ShowModal()	
		if (d.ClickedOk()):
			self.GetGrandParent().prefs.classbrowserstyle = d.GetStyleString()
			
		d.Destroy()

class BookmarksPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.btnStyle = wxButton(self, self.GetGrandParent().ID_BOOKMARKS_STYLE, " Edit Bookmarks Style ")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnStyle, 1, wxSHAPED)		

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
					
		EVT_BUTTON(self, self.GetGrandParent().ID_BOOKMARKS_STYLE, self.OnbtnStyle)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
					
	def OnbtnStyle(self, event):		
		d = drStyleDialog(self, -1, ("Style: Bookmarks"), self.GetGrandParent().prefs.bookmarksstyle, self.GetGrandParent().prefs.bookmarksstyle)

		d.ShowModal()	
		if (d.ClickedOk()):
			self.GetGrandParent().prefs.bookmarksstyle = d.GetStyleString()
		d.Destroy()

class DrScriptPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)
		
		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.txtdefaultdirectory = wxTextCtrl(self, -1, self.GetGrandParent().prefs.drscriptdefaultdirectory,  wxPoint(15, 325), wxSize(250, -1))	
		
		self.chkloadexamples = wxCheckBox(self, -1, "")
		
		self.btnBrowse = wxButton(self, self.GetGrandParent().ID_DRSCRIPT_BROWSE, " &Browse ")
		
		self.btnStyle = wxButton(self, self.GetGrandParent().ID_DRSCRIPT_STYLE, " Edit DrScript Style ")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1, wxSHAPED)
		
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnStyle, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
				
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Default Directory:"), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtdefaultdirectory,1, wxSHAPED)
		self.theSizer.Add(self.btnBrowse,1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Load Example Scripts:"),1,wxSHAPED)
		self.theSizer.Add(self.chkloadexamples, 1, wxSHAPED)
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
		
		self.reset()
					
		EVT_BUTTON(self, self.GetGrandParent().ID_DRSCRIPT_BROWSE, self.OnbtnBrowse)
		EVT_BUTTON(self, self.GetGrandParent().ID_DRSCRIPT_STYLE, self.OnbtnStyle)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		
	def reset(self):
		self.txtdefaultdirectory.SetValue(self.GetGrandParent().prefs.drscriptdefaultdirectory)	
		self.chkloadexamples.SetValue(self.GetGrandParent().prefs.drscriptloadexamples)

	def OnbtnBrowse(self, event):
		d = wxDirDialog(self, "Select Default Directory For DrScript:", style=wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON|wxMAXIMIZE_BOX|wxTHICK_FRAME)
		if d.ShowModal() == wxID_OK:
        		self.txtdefaultdirectory.SetValue(d.GetPath())
    		d.Destroy()
		
	def OnbtnStyle(self, event):		
		d = drStyleDialog(self, -1, ("Style: DrScript"), self.GetGrandParent().prefs.drscriptstyle, self.GetGrandParent().prefs.drscriptstyle)

		d.ShowModal()	
		if (d.ClickedOk()):
			self.GetGrandParent().prefs.drscriptstyle = d.GetStyleString()
		d.Destroy()

class ShellPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)
		
		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.txtdefaultcommanddirectory = wxTextCtrl(self, -1, self.GetGrandParent().prefs.drshelldefaultcommanddirectory,  wxPoint(15, 325), wxSize(250, -1))
		
		self.txtdefaultcommandarguments = wxTextCtrl(self, -1, self.GetGrandParent().prefs.drshelldefaultcommandarguments,  wxPoint(15, 325), wxSize(250, -1))
		
		self.chkruninpromptbydefault = wxCheckBox(self, -1, "")
				
		self.btnStyle = wxButton(self, self.GetGrandParent().ID_SHELL_STYLE, " Edit Shell Style ")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1, wxSHAPED)
		
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.btnStyle, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
				
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Default Command Directory:"), 1, wxSHAPED)		
		self.theSizer.Add(self.txtdefaultcommanddirectory,1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Default Command Arguments:"), 1, wxSHAPED)		
		self.theSizer.Add(self.txtdefaultcommandarguments,1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Run In Prompt By Default:"), 1, wxSHAPED)		
		self.theSizer.Add(self.chkruninpromptbydefault,1, wxSHAPED)
		
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
		
		self.reset()
					
		EVT_BUTTON(self, self.GetGrandParent().ID_SHELL_STYLE, self.OnbtnStyle)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		
	def reset(self):		
		self.txtdefaultcommanddirectory.SetValue(self.GetGrandParent().prefs.drshelldefaultcommanddirectory)
		
		self.txtdefaultcommandarguments.SetValue(self.GetGrandParent().prefs.drshelldefaultcommandarguments)
		
		self.chkruninpromptbydefault.SetValue(self.GetGrandParent().prefs.drshellruninpromptbydefault)

	def OnbtnStyle(self, event):		
		d = drStyleDialog(self, -1, ("Style: Shell"), self.GetGrandParent().prefs.drshellstyle, self.GetGrandParent().prefs.drshellstyle)

		d.ShowModal()	
		if (d.ClickedOk()):
			self.GetGrandParent().prefs.drshellstyle = d.GetStyleString()
		d.Destroy()

class ThemesPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)
		
		self.txtdefaultdirectory = wxTextCtrl(self, -1, self.GetGrandParent().prefs.themesdefaultdirectory,  wxPoint(15, 325), wxSize(250, -1))	

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.btnBrowse = wxButton(self, self.GetGrandParent().ID_DRSCRIPT_BROWSE, " &Browse ")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Default Directory:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtdefaultdirectory,1,wxSHAPED)
		self.theSizer.Add(self.btnBrowse,1,wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
		
		self.reset()
					
		EVT_BUTTON(self, self.GetGrandParent().ID_DRSCRIPT_BROWSE, self.OnbtnBrowse)
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		
	def reset(self):
		self.txtdefaultdirectory.SetValue(self.GetGrandParent().prefs.themesdefaultdirectory)	
							
	def OnbtnBrowse(self, event):
		d = wxDirDialog(self, "Select Default Directory For Themes:", style=wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON|wxMAXIMIZE_BOX|wxTHICK_FRAME)
		if d.ShowModal() == wxID_OK:
        		self.txtdefaultdirectory.SetValue(d.GetPath())
    		d.Destroy()

class PrintPanel(wxPanel):

	def __init__(self, parent, id):

		wxPanel.__init__(self, parent, id)

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.chkdoclinenumbers = wxCheckBox(self, -1, "")
		self.chkpromptlinenumbers = wxCheckBox(self, -1, "")

		self.txttabwidth = wxTextCtrl(self, self.GetGrandParent().ID_PRINT_TAB_WIDTH, str(self.GetGrandParent().prefs.printtabwidth), wxPoint(225, 215), wxSize(35, -1))
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Document Line Numbers:"),1,wxSHAPED)
		self.theSizer.Add(self.chkdoclinenumbers, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Prompt Line Numbers:"),1,wxSHAPED)
		self.theSizer.Add(self.chkpromptlinenumbers, 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Tab Width:"),1,wxSHAPED)
		self.theSizer.Add(self.txttabwidth, 1, wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
			
		self.reset()
		
		EVT_TEXT(self, self.GetGrandParent().ID_PRINT_TAB_WIDTH, self.Ontxttabwidth)	
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		
	def reset(self):
		self.chkdoclinenumbers.SetValue(self.GetGrandParent().prefs.printdoclinenumbers)
		self.chkpromptlinenumbers.SetValue(self.GetGrandParent().prefs.printpromptlinenumbers)
		self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.printtabwidth))		
	
	def Ontxttabwidth(self, event):
		x = self.txttabwidth.GetValue()
		if (len(x) < 1):
			return
		try:
			y = int(x)
		except ValueError:
			d = wxScrolledMessageDialog(self, ("Whatever you are trying to do... Stop it.\nIt won't work.  Positive Numbers only please.\nDrPython will reset to the value last loaded."), "Value Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.printtabwidth))
			return
		except TypeError:
			d = wxScrolledMessageDialog(self, ("\"" + y + "\" is not an integer (a number, eg 2, 4, 568)\nDrPython will reset to the value last loaded."), "Type Error")
			d.ShowModal()
			d.Destroy()
			self.txttabwidth.SetValue(str(self.GetGrandParent().prefs.printtabwidth))
			return
		if (y > 32):
			d = wxScrolledMessageDialog(self, ("DrPython does not recommend going this high.  You can of course..."), "Hmmmm")
			d.ShowModal()
			d.Destroy()

class DocumentationPanel(wxScrolledWindow):

	def __init__(self, parent, id):

		wxScrolledWindow.__init__(self, parent, id)
				
		self.EnableScrolling(True, True)
		
		self.SetScrollbars(10, 10, 30, 30)

		self.btnBrowse = wxButton(self, self.GetGrandParent().ID_DOCUMENTATION_BROWSE, " &Browse ")

		self.btnResetPanel = wxButton(self, self.GetGrandParent().ID_RESET_PANEL, " Reset Panel ")
		
		self.chkviewhelpwithbrowser = wxCheckBox(self, -1, "")

		self.txtbrowser = wxTextCtrl(self, -1, "", wxPoint(225, 215), wxSize(250, -1))
		
		self.txtpython = wxTextCtrl(self, -1, "", wxPoint(225, 215), wxSize(250, -1))
		
		self.txtwxwidgets = wxTextCtrl(self, -1, "", wxPoint(225, 215), wxSize(250, -1))
		
		self.txtrehowto = wxTextCtrl(self, -1, "", wxPoint(225, 215), wxSize(250, -1))
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Reset Just These Preferences:"), 1, wxSHAPED)	
		self.theSizer.Add(self.btnResetPanel,1,wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "View Help With Browser:"),1,wxSHAPED)
		self.theSizer.Add(self.chkviewhelpwithbrowser, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Browser:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtbrowser, 1, wxSHAPED)
		self.theSizer.Add(self.btnBrowse, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Python Docs:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtpython, 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "WxWidgets Docs:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtwxwidgets, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Regular Expression Howto:"),1,wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		self.theSizer.Add(self.txtrehowto, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)	
			
		self.reset()		
		
		if self.GetGrandParent().prefs.platform_is_windows:
			self.wildcard = "Program File (*.exe)|*.exe|All files (*)|*"
		else:
			self.wildcard = "All files (*)|*"			
				
		EVT_BUTTON(self, self.GetGrandParent().ID_RESET_PANEL, self.GetGrandParent().OnbtnResetPanel)
		EVT_BUTTON(self, self.GetGrandParent().ID_DOCUMENTATION_BROWSE, self.OnbtnBrowse)
	
	def reset(self):
		self.chkviewhelpwithbrowser.SetValue(self.GetGrandParent().prefs.documentationviewhelpwithbrowser)
		self.txtbrowser.SetValue(self.GetGrandParent().prefs.documentationbrowser)		
		self.txtpython.SetValue(self.GetGrandParent().prefs.documentationpythonlocation)		
		self.txtwxwidgets.SetValue(self.GetGrandParent().prefs.documentationwxwidgetslocation)
		self.txtrehowto.SetValue(self.GetGrandParent().prefs.documentationrehowtolocation)
		
	def OnbtnBrowse(self, event):
		dlg = wxFileDialog(self, "Select A Browser", "", "", self.wildcard, wxOPEN|wxHIDE_READONLY)
		if (dlg.ShowModal() == wxID_OK):
			self.txtbrowser.SetValue(dlg.GetPath())
		dlg.Destroy()
		
class drPrefsDialog(wxDialog):

	def __init__(self, parent, id, title):

		wxDialog.__init__(self, parent, id, title, wxPoint(50, 50), wxSize(450, 335), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
				
		wxYield()
		
		self.parent = parent
		
		self.ID_CLOSE = 101
		
		self.ID_RESET = 102
		
		self.ID_UPDATE = 103
		
		self.ID_SAVE = 104
		
		self.ID_MDI = 105
		
		self.ID_FILE_BROWSE = 109
		
		self.ID_ICON_FILE_BROWSE = 1090
		
		self.ID_TEXT_TYPE = 110
		
		self.ID_FILE_STYLE = 111
		
		self.ID_APPLY_PROPERTY = 112
		
		self.ID_DOC_MARGIN_WIDTH = 113
		
		self.ID_LONGLINE_COL = 116
		
		self.ID_DOC_LANGUAGE = 350
		
		self.ID_ICON_SIZE = 350
		
		self.ID_WINDOWWIDTH = 1001
		self.ID_WINDOWHEIGHT = 1002
		
		self.ID_PROMPT_STYLE = 1140
		self.ID_PROMPT_MARGIN_WIDTH = 115
		self.ID_PROMPT_TEXT_TYPE = 117
		self.ID_PROMPT_APPLY_PROPERTY = 118
		
		self.ID_CLASS_BROWSER_STYLE = 201
		
		self.ID_BOOKMARKS_STYLE = 202
		
		self.ID_DRSCRIPT_STYLE = 203		
		self.ID_DRSCRIPT_BROWSE = 211
		
		self.ID_SHELL_STYLE = 204
		
		self.ID_THEME_BROWSE = 221
		
		self.ID_PRINT_TAB_WIDTH = 251
		
		self.ID_DOCUMENTATION_BROWSE = 231
		
		self.ID_TXT_RECENT_FILES = 301
		self.ID_TXT_TAB_WIDTH = 302
		self.ID_USE_TABS = 303
		
		self.ID_RESET_PANEL = 405

		self.homedirectory = parent.homedirectory
		
		self.prefs = drPreferences(parent.prefs.platform_is_windows)
		self.prefs.Copy(parent.prefs)
		self.oldprefs = drPreferences(parent.prefs.platform_is_windows)
		self.oldprefs.Copy(parent.prefs)

		self.theSizer = wxBoxSizer(wxVERTICAL)

		self.nbPrefs = wxNotebook(self, -1, wxPoint(0, 0), wxSize(450, 255))
				
		self.pnlGeneral = GeneralPanel(self.nbPrefs, -1)
		self.pnlGeneral.SetName("General")

		self.pnlDocument = DocumentPanel(self.nbPrefs, -1)
		self.pnlDocument.SetName("Document")

		self.pnlPrompt = PromptPanel(self.nbPrefs, -1)
		self.pnlPrompt.SetName("Prompt")
		
		self.pnlFindReplace = FindReplacePanel(self.nbPrefs, -1)
		self.pnlFindReplace.SetName("Find/Replace")
		
		self.pnlFindReplaceInFiles = FindReplaceInFilesPanel(self.nbPrefs, -1)
		self.pnlFindReplaceInFiles.SetName("Find/Replace In Files")
		
		self.pnlSessions = SessionsPanel(self.nbPrefs, -1)
		self.pnlSessions.SetName("Sessions")
		
		self.pnlLineEndings = LineEndingsPanel(self.nbPrefs, -1)
		self.pnlLineEndings.SetName("Line Endings")
		
		self.pnlClassBrowser = ClassBrowserPanel(self.nbPrefs, -1)
		self.pnlClassBrowser.SetName("Class Browser")
		
		self.pnlBookmarks = BookmarksPanel(self.nbPrefs, -1)
		self.pnlBookmarks.SetName("Bookmarks")
		
		self.pnlDrScript = DrScriptPanel(self.nbPrefs, -1)
		self.pnlDrScript.SetName("DrScript")
		
		self.pnlShell = ShellPanel(self.nbPrefs, -1)
		self.pnlShell.SetName("Shell")
		
		self.pnlThemes = ThemesPanel(self.nbPrefs, -1)
		self.pnlThemes.SetName("Themes")
		
		self.pnlPrint = PrintPanel(self.nbPrefs, -1)
		self.pnlPrint.SetName("Printing")
			
		self.pnlDocumentation = DocumentationPanel(self.nbPrefs, -1)	
		self.pnlDocumentation.SetName("Documentation")	

		self.nbPrefs.AddPage(self.pnlGeneral, "General")

		self.nbPrefs.AddPage(self.pnlDocument, "Document")

		self.nbPrefs.AddPage(self.pnlPrompt, "Prompt")
		
		self.nbPrefs.AddPage(self.pnlFindReplace, "Find/Replace")
		
		self.nbPrefs.AddPage(self.pnlFindReplaceInFiles, "Find/Replace In Files")
		
		self.nbPrefs.AddPage(self.pnlSessions, "Sessions")
		
		self.nbPrefs.AddPage(self.pnlLineEndings, "Line Endings")
		
		self.nbPrefs.AddPage(self.pnlPrint, "Printing")
		
		self.nbPrefs.AddPage(self.pnlClassBrowser, "Class Browser")
		
		self.nbPrefs.AddPage(self.pnlBookmarks, "Bookmarks")
		
		self.nbPrefs.AddPage(self.pnlDrScript, "DrScript")
		
		self.nbPrefs.AddPage(self.pnlShell, "Shell")
		
		self.nbPrefs.AddPage(self.pnlThemes, "Themes")
		
		self.nbPrefs.AddPage(self.pnlDocumentation, "Documentation")

		self.theSizer.Add(self.nbPrefs, 9, wxEXPAND)
				
		self.buttonSizer = wxBoxSizer(wxHORIZONTAL)

		self.btnCancel = wxButton(self, self.ID_CLOSE, "   &Close   ")

		self.btnCancel.SetDefault()	

		#Have dialog box pop up:  reset to file in your home directory, or program defaults?
		self.btnReset = wxButton(self, self.ID_RESET, "   &Reset All   ")

	   	self.btnUpdate = wxButton(self, self.ID_UPDATE, "   &Update   ")

		self.btnSave = wxButton(self, self.ID_SAVE, "   &Save   ")

		self.buttonSizer.Add(self.btnCancel, 0, wxSHAPED)
		self.buttonSizer.Add(self.btnReset, 0, wxSHAPED)
		self.buttonSizer.Add(self.btnUpdate, 0, wxSHAPED)
		self.buttonSizer.Add(self.btnSave, 0, wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.buttonSizer, 0, wxSHAPED | wxALIGN_CENTER)
				
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)

		EVT_BUTTON(self, self.ID_CLOSE, self.OnbtnClose)	
		EVT_BUTTON(self, self.ID_RESET, self.OnbtnReset)
		EVT_BUTTON(self, self.ID_UPDATE, self.OnbtnUpdate)
		EVT_BUTTON(self, self.ID_SAVE, self.OnbtnSave)

	def OnbtnClose(self, event):
		self.EndModal(0)
		
	def OnbtnReset(self, event):		
		d = wxMessageDialog(self, "This will reset all preferences to the program default.\n(You still need to click update and/or save)\nAre you sure you want to do this?", "Reset Preferences", wxYES_NO | wxICON_QUESTION)
		answer = d.ShowModal()
		d.Destroy()
		if (answer == wxID_YES):
		
			self.prefs.reset()
			
			self.pnlGeneral.reset()
			self.pnlDocument.reset()
			self.pnlPrompt.reset()
			self.pnlFindReplace.reset()
			self.pnlLineEndings.reset()
			self.pnlClassBrowser.reset()
			self.pnlDrScript.reset()
			self.pnlThemes.reset()
			self.pnlPrint.reset()
	
	def OnbtnResetPanel(self, event):		
		d = wxMessageDialog(self, "This will reset all of this panel's preferences to the program default.\n(You still need to click update and/or save)\nAre you sure you want to do this?", "Reset Panel Preferences", wxYES_NO | wxICON_QUESTION)
		answer = d.ShowModal()
		d.Destroy()
		if (answer == wxID_YES):
			panel = event.GetEventObject().GetParent()
			self.prefs.resetjust(panel.GetName())
			panel.reset()
			
	def OnbtnUpdate(self, event):
		self.GetParent().prefs = self.GetPreferences()
		self.GetParent().updatePrefs(self.oldprefs)
		self.oldprefs.Copy(self.prefs)
		if self.GetParent().prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully updated the current instance of DrPython.\nClick Save to make it permanent."), "Updated Preferences")
			d.ShowModal()
			d.Destroy()
		
	def OnbtnSave(self, event):
		if (not os.path.exists(self.homedirectory)):
			d = wxScrolledMessageDialog(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			d.ShowModal()
			d.Destroy()
			return
		preffile = self.homedirectory + "/preferences.dat"
		try:					
			drPrefsFile.WritePreferences(self.GetPreferences(), preffile)
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + preffile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
		if self.GetParent().prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully wrote to:\n"  + preffile + "\nClick Update to update the current instance of DrPython."), "Saved Preferences")
			d.ShowModal()
			d.Destroy()	
		
	def GetPreferences(self):
		#General
		self.prefs.windowwidth = self.pnlGeneral.txtwindowwidth.GetValue()
		if (len(self.prefs.windowwidth) < 1):
			self.prefs.windowwidth = self.oldprefs.windowwidth
		self.prefs.windowwidth = int(self.prefs.windowwidth)
		self.prefs.windowheight = self.pnlGeneral.txtwindowheight.GetValue()
		if (len(self.prefs.windowheight) < 1):
			self.prefs.windowheight = self.oldprefs.windowheight
		self.prefs.windowheight = int(self.prefs.windowheight)
		self.prefs.recentfileslimit = self.pnlGeneral.txtRecentFiles.GetValue()
		if (len(self.prefs.recentfileslimit) < 1):
			self.prefs.recentfileslimit = self.oldprefs.recentfileslimit
		self.prefs.recentfileslimit = int(self.prefs.recentfileslimit)
		self.prefs.tabwidth = self.pnlGeneral.txttabwidth.GetValue()
		if (len(self.prefs.tabwidth) < 1):
			self.prefs.tabwidth = self.oldprefs.tabwidth
		self.prefs.tabwidth = int(self.prefs.tabwidth)
		self.prefs.mdi = int(self.pnlGeneral.chkmdi.GetValue())
		self.prefs.iconsize = int(self.pnlGeneral.boxiconsize.GetStringSelection())
		self.prefs.pythonargs = self.pnlGeneral.txtpythonargs.GetValue()
		self.prefs.encoding = self.pnlGeneral.boxencoding.GetSelection()
		self.prefs.customencoding = self.pnlGeneral.txtcustomencoding.GetValue()
		self.prefs.iconfile = self.pnlGeneral.txticonfile.GetValue()
		self.prefs.defaultdirectory = self.pnlGeneral.txtdefaultdirectory.GetValue()			
		self.prefs.enablefeedback = int(self.pnlGeneral.chkenablefeedback.GetValue())		
		self.prefs.enablewarnings = int(self.pnlGeneral.chkenablewarnings.GetValue())
		self.prefs.alwayspromptonexit = int(self.pnlGeneral.chkalwayspromptonexit.GetValue())		
		self.prefs.backupfileonsave = int(self.pnlGeneral.chkbackupfileonsave.GetValue())
		self.prefs.autogotofortraceback = int(self.pnlGeneral.chkautogotofortraceback.GetValue())
		#utf-8 auto detect limodou 2004/04/14
		self.prefs.autodetectutf8encoding = int(self.pnlGeneral.chkautodetectutf8encoding.GetValue())
		#end limodou
		
		#Document
		self.prefs.docmarginwidth = self.pnlDocument.txtmarginwidth.GetValue()
		if (len(self.prefs.docmarginwidth) < 1):
			self.prefs.docmarginwidth = self.oldprefs.docmarginwidth
		self.prefs.docmarginwidth = int(self.prefs.docmarginwidth)
		self.prefs.docautoindent = int(self.pnlDocument.chkdocautoindent.GetValue())
		self.prefs.docwordwrap = int(self.pnlDocument.chkdocwordwrap.GetValue())
		self.prefs.docusetabs = int(self.pnlDocument.chkdocusetabs.GetValue())
		self.prefs.docwhitespaceisvisible = int(self.pnlDocument.chkWhitespace.GetValue())
		self.prefs.docfolding = int(self.pnlDocument.chkfolding.GetValue())
		self.prefs.docusestyles = self.pnlDocument.radusestyles.GetSelection()
		self.prefs.docuseindentationguides = int(self.pnlDocument.chkuseindentationguides.GetValue())
		#Chris McDonough (I added the txt prefix)
 		self.prefs.doclonglinecol = self.pnlDocument.txtdoclonglinecol.GetValue()
 		if len(self.prefs.doclonglinecol) < 1:
 			self.prefs.doclonglinecol = self.oldprefs.doclonglinecol
 		self.prefs.doclonglinecol = int(self.prefs.doclonglinecol)
		#/Chris McDonough
		self.prefs.docscrollextrapage = int(self.pnlDocument.chkscrollextrapage.GetValue())		
		self.prefs.docdefaultsyntaxhighlighting = self.pnlDocument.boxdefaultsyntaxhighlighting.GetSelection()
		self.prefs.doconlyusedefaultsyntaxhighlighting = self.pnlDocument.chkonlyusedefaultsyntaxhighlighting.GetValue()
		
		#Prompt
		self.prefs.promptmarginwidth = self.pnlPrompt.txtmarginwidth.GetValue()
		if (len(self.prefs.promptmarginwidth) < 1):
			self.prefs.promptmarginwidth = self.oldprefs.promptmarginwidth
		self.prefs.promptmarginwidth = int(self.prefs.promptmarginwidth)
		self.prefs.promptusetabs = int(self.pnlPrompt.chkpromptusetabs.GetValue())
		self.prefs.promptisvisible = int(self.pnlPrompt.chkVisible.GetValue())
		self.prefs.promptsize = int(self.pnlPrompt.sldrSize.GetValue())
		self.prefs.promptwordwrap = int(self.pnlPrompt.chkwordwrap.GetValue())
		self.prefs.promptwhitespaceisvisible = int(self.pnlPrompt.chkWhitespace.GetValue())
		self.prefs.promptusestyles = self.pnlPrompt.radusestyles.GetSelection()
		self.prefs.promptscrollextrapage = int(self.pnlPrompt.chkscrollextrapage.GetValue())
		
		#Find/Replace
		self.prefs.findreplaceregularexpression = int(self.pnlFindReplace.chkregularexpression.GetValue())
		self.prefs.findreplacematchcase = int(self.pnlFindReplace.chkmatchcase.GetValue())
		self.prefs.findreplacefindbackwards = int(self.pnlFindReplace.chkfindbackwards.GetValue())
		self.prefs.findreplacewholeword = int(self.pnlFindReplace.chkwholeword.GetValue())
		self.prefs.findreplaceinselection = int(self.pnlFindReplace.chkinselection.GetValue())
		self.prefs.findreplacefromcursor = int(self.pnlFindReplace.chkfromcursor.GetValue())
		self.prefs.findreplacepromptonreplace = int(self.pnlFindReplace.chkpromptonreplace.GetValue())		
		
		#Find/Replace In Files
		self.prefs.findreplaceinfilesregularexpression = int(self.pnlFindReplaceInFiles.chkregularexpression.GetValue())
		self.prefs.findreplaceinfilesmatchcase = int(self.pnlFindReplaceInFiles.chkmatchcase.GetValue())
		self.prefs.findreplaceinfilespromptonreplace = int(self.pnlFindReplaceInFiles.chkpromptonreplace.GetValue())	
		self.prefs.findreplaceinfilessubdirectories = int(self.pnlFindReplaceInFiles.chksubdirectories.GetValue())	
		self.prefs.findreplaceinfilesbackupbeforereplace = int(self.pnlFindReplaceInFiles.chkbackupbeforereplace.GetValue()	)
		
		#Sessions
		self.prefs.sessionsdefaultdirectory = self.pnlSessions.txtdefaultdirectory.GetValue()
		self.prefs.sessionsrecentsessionslimit = int(self.pnlSessions.txtRecentSessions.GetValue())
		
		#Line Endings
		self.prefs.checkeol = int(self.pnlLineEndings.chkCheckFormat.GetValue())
		self.prefs.eolmode = self.pnlLineEndings.radFormat.GetSelection()
		
		#Class Browser
		self.prefs.classbrowsercloseonactivate = int(self.pnlClassBrowser.chkcloseonactivate.GetValue())
		self.prefs.classbrowserissorted = int(self.pnlClassBrowser.chkissorted.GetValue())		
		
		#DrScript
		self.prefs.drscriptdefaultdirectory = self.pnlDrScript.txtdefaultdirectory.GetValue()
		self.prefs.drscriptloadexamples = int(self.pnlDrScript.chkloadexamples.GetValue())
		
		#Shell
		self.prefs.drshelldefaultcommanddirectory = self.pnlShell.txtdefaultcommanddirectory.GetValue()
		self.prefs.drshelldefaultcommandarguments = self.pnlShell.txtdefaultcommandarguments.GetValue()
		self.prefs.drshellruninpromptbydefault = int(self.pnlShell.chkruninpromptbydefault.GetValue())
		
		#Themes
		self.prefs.themesdefaultdirectory = self.pnlThemes.txtdefaultdirectory.GetValue()
		
		#Printing
		self.prefs.printdoclinenumbers = int(self.pnlPrint.chkdoclinenumbers.GetValue())
		self.prefs.printpromptlinenumbers = int(self.pnlPrint.chkpromptlinenumbers.GetValue())
		self.prefs.printtabwidth = self.pnlPrint.txttabwidth.GetValue()
		if (len(self.prefs.printtabwidth) < 1):
			self.prefs.printtabwidth = self.oldprefs.printtabwidth
		self.prefs.printtabwidth = int(self.prefs.printtabwidth)
		
		#Documentation
		self.prefs.documentationviewhelpwithbrowser = int(self.pnlDocumentation.chkviewhelpwithbrowser.GetValue())
		self.prefs.documentationbrowser = self.pnlDocumentation.txtbrowser.GetValue()
		self.prefs.documentationpythonlocation = self.pnlDocumentation.txtpython.GetValue()
		self.prefs.documentationwxwidgetslocation = self.pnlDocumentation.txtwxwidgets.GetValue()
		self.prefs.documentationrehowtolocation = self.pnlDocumentation.txtrehowto.GetValue()
		
		return self.prefs