#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Preferences

#LongLineCol from Chris McDonough
#Changed "doc.longlinecol" to "doc.long.line.col"

def GetPreference(pref, prefsfile):
	#Handle exceptions in parent function.
	fin = open(prefsfile, 'r')	
	text = fin.read()		
	fin.close()
	
	#Test File:
	if (text.find("drpython") < 0):
		return -1
	
	return ExtractPreferenceFromText(text, pref)

def GetPrefFromText(oldvalue, text, targetpref, integer = False):
	if (integer):
		pref = ExtractPreferenceFromText(text, targetpref)
		if (len(pref) > 0):
			return SafeInt(pref)
	else:
		pref = ExtractPreferenceFromText(text, targetpref)
		if (len(pref) > 0):
			return pref
	return oldvalue

		
def ExtractPreferenceFromText(text, pref):
	try:
		start = text.index("<" + pref + ">") + len(pref) + 2
		end = text.index("</" + pref + ">")
	
		return text[start:end]
	except:
		return ""

def ReadPreferences(prefs, prefsfile, THEME = 0):
	#Handle exceptions in parent function.
	#sets prefs for parent frame.
	#Use GetPrefFromText(oldpref, text, prefstring) for string prefs
	#Use GetPrefFromText(oldpref, text, prefstring, True) for int prefs
	#Use ExtractPreferenceFromText(text, prefstring) for prefs where and empty
	#string is a valid value.
	
	fin = open(prefsfile, 'r')
	text = fin.read()		
	fin.close()
		
	#Test File:
	if (text.find("drpython") < 0):
		return -1
			
	#Get General Settings
	if (not THEME):	
		prefs.windowwidth = GetPrefFromText(prefs.windowwidth, text, "window.width", True)
		prefs.windowheight = GetPrefFromText(prefs.windowheight, text, "window.height", True)
		prefs.iconsize = GetPrefFromText(prefs.iconsize, text, "icon.size", True)
		prefs.mdi = GetPrefFromText(prefs.mdi, text, "mdi", True)
		prefs.enablefeedback = GetPrefFromText(prefs.enablefeedback, text, "enable.feedback", True)
		prefs.enablewarnings = GetPrefFromText(prefs.enablewarnings, text, "enable.warnings", True)
		prefs.alwayspromptonexit = GetPrefFromText(prefs.alwayspromptonexit, text, "always.prompt.on.exit", True)
		prefs.backupfileonsave = GetPrefFromText(prefs.backupfileonsave, text, "backup.file.on.save", True)
		prefs.autogotofortraceback = GetPrefFromText(prefs.autogotofortraceback, text, "auto.goto.for.traceback", True)
		#utf-8 auto detect limodou 2004/04/14
		prefs.autodetectutf8encoding = GetPrefFromText(prefs.autodetectutf8encoding, text, "auto.detect.utf8.encoding", True)
		#end limodou
		
	prefs.iconfile = ExtractPreferenceFromText(text, "icon.file")	
	
	if (not THEME):	
		prefs.recentfileslimit = GetPrefFromText(prefs.recentfileslimit, text, "max.recent.files", True)
		prefs.tabwidth = GetPrefFromText(prefs.tabwidth, text, "tab.width", True)
		prefs.checkeol = GetPrefFromText(prefs.checkeol, text, "check.line.ending.type", True)
		prefs.eolmode = GetPrefFromText(prefs.eolmode, text, "line.ending.type", True)
		prefs.pythonargs = GetPrefFromText(prefs.pythonargs, text, "python.arguments")
		prefs.encoding = GetPrefFromText(prefs.encoding, text, "encoding", True)
		prefs.customencoding = GetPrefFromText(prefs.customencoding, text, "custom.encoding")
		prefs.defaultdirectory = ExtractPreferenceFromText(text, "default.directory")
			
	#Get Document Settings
	if (not THEME):
		prefs.docmarginwidth = GetPrefFromText(prefs.docmarginwidth, text, "doc.margin.width", True)
		prefs.docwordwrap = GetPrefFromText(prefs.docwordwrap, text, "doc.wordwrap", True)
		prefs.docautoindent = GetPrefFromText(prefs.docautoindent, text, "doc.autoindent", True)
		prefs.docusetabs = GetPrefFromText(prefs.docusetabs, text, "doc.use.tabs", True)
		prefs.docwhitespaceisvisible = GetPrefFromText(prefs.docwhitespaceisvisible, text, "doc.whitespace.is.visible.on.startup", True)
		prefs.docfolding = GetPrefFromText(prefs.docfolding, text, "doc.folding", True)
		prefs.docusestyles = GetPrefFromText(prefs.docusestyles, text, "doc.use.styles", True)
		prefs.docuseindentationguides = GetPrefFromText(prefs.docuseindentationguides, text, "doc.use.indentation.guides", True)
		prefs.doclonglinecol = GetPrefFromText(prefs.doclonglinecol, text, "doc.long.line.col", True)
		prefs.docscrollextrapage = GetPrefFromText(prefs.docscrollextrapage , text, "doc.scroll.extra.page", True)
		prefs.docdefaultsyntaxhighlighting = GetPrefFromText(prefs.docdefaultsyntaxhighlighting , text, "doc.default.syntax.highlighting", True)
		prefs.doconlyusedefaultsyntaxhighlighting = GetPrefFromText(prefs.doconlyusedefaultsyntaxhighlighting , text, "doc.only.use.default.syntax.highlighting", True)
	#Python
	prefs.PythonStyleArray[0] = GetPrefFromText(prefs.PythonStyleArray[0], text, "doc.style.normal")
	prefs.PythonStyleArray[1] = GetPrefFromText(prefs.PythonStyleArray[1], text, "doc.style.linenumber")
	prefs.PythonStyleArray[2] = GetPrefFromText(prefs.PythonStyleArray[2], text, "doc.style.brace.match")
	prefs.PythonStyleArray[3] = GetPrefFromText(prefs.PythonStyleArray[3], text, "doc.style.brace.nomatch")
	prefs.PythonStyleArray[4] = GetPrefFromText(prefs.PythonStyleArray[4], text, "doc.style.character")
	prefs.PythonStyleArray[5] = GetPrefFromText(prefs.PythonStyleArray[5], text, "doc.style.class")
	prefs.PythonStyleArray[6] = GetPrefFromText(prefs.PythonStyleArray[6], text, "doc.style.comment")
	prefs.PythonStyleArray[7] = GetPrefFromText(prefs.PythonStyleArray[7], text, "doc.style.definition")
	prefs.PythonStyleArray[8] = GetPrefFromText(prefs.PythonStyleArray[8], text, "doc.style.keyword")
	prefs.PythonStyleArray[9] = GetPrefFromText(prefs.PythonStyleArray[9], text, "doc.style.number")
	prefs.PythonStyleArray[10] = GetPrefFromText(prefs.PythonStyleArray[10], text, "doc.style.operator")
	prefs.PythonStyleArray[11] = GetPrefFromText(prefs.PythonStyleArray[11], text, "doc.style.string")
	prefs.PythonStyleArray[12] = GetPrefFromText(prefs.PythonStyleArray[12], text, "doc.style.triple.string")
	prefs.PythonStyleArray[13] = GetPrefFromText(prefs.PythonStyleArray[13], text, "doc.style.caret")
	prefs.PythonStyleArray[14] = GetPrefFromText(prefs.PythonStyleArray[14], text, "doc.style.selection")
	prefs.PythonStyleArray[15] = GetPrefFromText(prefs.PythonStyleArray[15], text, "doc.style.folding")
	prefs.PythonStyleArray[16] = GetPrefFromText(prefs.PythonStyleArray[16], text, "doc.style.longlinecol")
	
	#C/C++
	prefs.CPPStyleArray[0] = GetPrefFromText(prefs.CPPStyleArray[0], text, "doc.cstyle.normal")
	prefs.CPPStyleArray[1] = GetPrefFromText(prefs.CPPStyleArray[1], text, "doc.cstyle.linenumber")
	prefs.CPPStyleArray[2] = GetPrefFromText(prefs.CPPStyleArray[2], text, "doc.cstyle.brace.match")
	prefs.CPPStyleArray[3] = GetPrefFromText(prefs.CPPStyleArray[3], text, "doc.cstyle.brace.nomatch")
	prefs.CPPStyleArray[4] = GetPrefFromText(prefs.CPPStyleArray[4], text, "doc.cstyle.character")
	prefs.CPPStyleArray[5] = GetPrefFromText(prefs.CPPStyleArray[5], text, "doc.cstyle.preprocessor")
	prefs.CPPStyleArray[6] = GetPrefFromText(prefs.CPPStyleArray[6], text, "doc.cstyle.comment")
	prefs.CPPStyleArray[7] = GetPrefFromText(prefs.CPPStyleArray[7], text, "doc.cstyle.verbatim")
	prefs.CPPStyleArray[8] = GetPrefFromText(prefs.CPPStyleArray[8], text, "doc.cstyle.keyword")
	prefs.CPPStyleArray[9] = GetPrefFromText(prefs.CPPStyleArray[9], text, "doc.cstyle.number")
	prefs.CPPStyleArray[10] = GetPrefFromText(prefs.CPPStyleArray[10], text, "doc.cstyle.operator")
	prefs.CPPStyleArray[11] = GetPrefFromText(prefs.CPPStyleArray[11], text, "doc.cstyle.string")
	prefs.CPPStyleArray[12] = GetPrefFromText(prefs.CPPStyleArray[12], text, "doc.cstyle.regex")
	prefs.CPPStyleArray[13] = GetPrefFromText(prefs.CPPStyleArray[13], text, "doc.cstyle.uuid")
	prefs.CPPStyleArray[14] = GetPrefFromText(prefs.CPPStyleArray[14], text, "doc.cstyle.caret")
	prefs.CPPStyleArray[15] = GetPrefFromText(prefs.CPPStyleArray[15], text, "doc.cstyle.selection")
	prefs.CPPStyleArray[16] = GetPrefFromText(prefs.CPPStyleArray[16], text, "doc.cstyle.folding")	
	prefs.CPPStyleArray[17] = GetPrefFromText(prefs.CPPStyleArray[17], text, "doc.cstyle.longlinecol")
	
	#HTML
	prefs.HTMLStyleArray[0] = GetPrefFromText(prefs.HTMLStyleArray[0], text, "doc.htmlstyle.normal")
	prefs.HTMLStyleArray[1] = GetPrefFromText(prefs.HTMLStyleArray[1], text, "doc.htmlstyle.linenumber")
	prefs.HTMLStyleArray[2] = GetPrefFromText(prefs.HTMLStyleArray[2], text, "doc.htmlstyle.brace.match")
	prefs.HTMLStyleArray[3] = GetPrefFromText(prefs.HTMLStyleArray[3], text, "doc.htmlstyle.brace.nomatch")
	prefs.HTMLStyleArray[4] = GetPrefFromText(prefs.HTMLStyleArray[4], text, "doc.htmlstyle.tag")
	prefs.HTMLStyleArray[5] = GetPrefFromText(prefs.HTMLStyleArray[5], text, "doc.htmlstyle.unknown.tag")
	prefs.HTMLStyleArray[6] = GetPrefFromText(prefs.HTMLStyleArray[6], text, "doc.htmlstyle.attribute")
	prefs.HTMLStyleArray[7] = GetPrefFromText(prefs.HTMLStyleArray[7], text, "doc.htmlstyle.unknown.attribute")
	prefs.HTMLStyleArray[8] = GetPrefFromText(prefs.HTMLStyleArray[8], text, "doc.htmlstyle.number")
	prefs.HTMLStyleArray[9] = GetPrefFromText(prefs.HTMLStyleArray[9], text, "doc.htmlstyle.string")
	prefs.HTMLStyleArray[10] = GetPrefFromText(prefs.HTMLStyleArray[10], text, "doc.htmlstyle.character")
	prefs.HTMLStyleArray[11] = GetPrefFromText(prefs.HTMLStyleArray[11], text, "doc.htmlstyle.comment")
	prefs.HTMLStyleArray[12] = GetPrefFromText(prefs.HTMLStyleArray[12], text, "doc.htmlstyle.entity")
	prefs.HTMLStyleArray[13] = GetPrefFromText(prefs.HTMLStyleArray[13], text, "doc.htmlstyle.tag.end")
	prefs.HTMLStyleArray[14] = GetPrefFromText(prefs.HTMLStyleArray[14], text, "doc.htmlstyle.xml.start")
	prefs.HTMLStyleArray[15] = GetPrefFromText(prefs.HTMLStyleArray[15], text, "doc.htmlstyle.xml.end")
	prefs.HTMLStyleArray[16] = GetPrefFromText(prefs.HTMLStyleArray[16], text, "doc.htmlstyle.script")
	prefs.HTMLStyleArray[17] = GetPrefFromText(prefs.HTMLStyleArray[17], text, "doc.htmlstyle.value")
	prefs.HTMLStyleArray[18] = GetPrefFromText(prefs.HTMLStyleArray[18], text, "doc.htmlstyle.caret")
	prefs.HTMLStyleArray[19] = GetPrefFromText(prefs.HTMLStyleArray[19], text, "doc.htmlstyle.selection")
	prefs.HTMLStyleArray[20] = GetPrefFromText(prefs.HTMLStyleArray[20], text, "doc.htmlstyle.folding")
	prefs.HTMLStyleArray[21] = GetPrefFromText(prefs.HTMLStyleArray[21], text, "doc.htmlstyle.longlinecol")
	
	#Get Prompt Settings
	if (not THEME):
		prefs.promptmarginwidth = GetPrefFromText(prefs.promptmarginwidth, text, "prompt.margin.width", True)
		prefs.promptisvisible = GetPrefFromText(prefs.promptisvisible, text, "prompt.is.visible.on.startup", True)
		prefs.promptsize = GetPrefFromText(prefs.promptsize, text, "prompt.size", True)
		prefs.promptusetabs = GetPrefFromText(prefs.promptusetabs, text, "prompt.use.tabs", True)
		prefs.promptwordwrap = GetPrefFromText(prefs.promptwordwrap, text, "prompt.wordwrap", True)
		prefs.promptwhitespaceisvisible = GetPrefFromText(prefs.promptwhitespaceisvisible, text, "prompt.whitespace.is.visible.on.startup", True)
		prefs.promptusestyles = GetPrefFromText(prefs.promptusestyles, text, "prompt.use.styles", True)
		prefs.promptscrollextrapage = GetPrefFromText(prefs.promptscrollextrapage , text, "prompt.scroll.extra.page", True)
	prefs.txtPromptStyleArray[0] = GetPrefFromText(prefs.txtPromptStyleArray[0], text, "prompt.style.normal")
	prefs.txtPromptStyleArray[1] = GetPrefFromText(prefs.txtPromptStyleArray[1], text, "prompt.style.linenumber")
	prefs.txtPromptStyleArray[2] = GetPrefFromText(prefs.txtPromptStyleArray[2], text, "prompt.style.brace.match")
	prefs.txtPromptStyleArray[3] = GetPrefFromText(prefs.txtPromptStyleArray[3], text, "prompt.style.brace.nomatch")
	prefs.txtPromptStyleArray[4] = GetPrefFromText(prefs.txtPromptStyleArray[4], text, "prompt.style.character")
	prefs.txtPromptStyleArray[5] = GetPrefFromText(prefs.txtPromptStyleArray[5], text, "prompt.style.class")
	prefs.txtPromptStyleArray[6] = GetPrefFromText(prefs.txtPromptStyleArray[6], text, "prompt.style.comment")
	prefs.txtPromptStyleArray[7] = GetPrefFromText(prefs.txtPromptStyleArray[7], text, "prompt.style.definition")
	prefs.txtPromptStyleArray[8] = GetPrefFromText(prefs.txtPromptStyleArray[8], text, "prompt.style.keyword")
	prefs.txtPromptStyleArray[9] = GetPrefFromText(prefs.txtPromptStyleArray[9], text, "prompt.style.number")
	prefs.txtPromptStyleArray[10] = GetPrefFromText(prefs.txtPromptStyleArray[10], text, "prompt.style.operator")
	prefs.txtPromptStyleArray[11] = GetPrefFromText(prefs.txtPromptStyleArray[11], text, "prompt.style.string")
	prefs.txtPromptStyleArray[12] = GetPrefFromText(prefs.txtPromptStyleArray[12], text, "prompt.style.triple.string")
	prefs.txtPromptStyleArray[13] = GetPrefFromText(prefs.txtPromptStyleArray[13], text, "prompt.style.caret")
	prefs.txtPromptStyleArray[14] = GetPrefFromText(prefs.txtPromptStyleArray[14], text, "prompt.style.selection")
	
	if (not THEME):
		#Find/Replace Settings
		prefs.findreplaceregularexpression = GetPrefFromText(prefs.findreplaceregularexpression, text, "find.replace.regular.expression", True)
		prefs.findreplacematchcase = GetPrefFromText(prefs.findreplacematchcase, text, "find.replace.match.case", True)
		prefs.findreplacebackwards = GetPrefFromText(prefs.findreplacefindbackwards, text, "find.replace.find.backwards", True)
		prefs.findreplacewholeword = GetPrefFromText(prefs.findreplacewholeword, text, "find.replace.whole.word", True)
		prefs.findreplaceinselection = GetPrefFromText(prefs.findreplaceinselection, text, "find.replace.in.selection", True)
		prefs.findreplacefromcursor = GetPrefFromText(prefs.findreplacefromcursor, text, "find.replace.from.cursor", True)
		prefs.findreplacepromptonreplace = GetPrefFromText(prefs.findreplacepromptonreplace, text, "find.replace.prompt.on.replace", True)
		
		#Find/Replace In Files Settings
		prefs.findreplaceinfilesregularexpression = GetPrefFromText(prefs.findreplaceinfilesregularexpression, text, "find.replace.in.files.regular.expression", True)
		prefs.findreplaceinfilesmatchcase = GetPrefFromText(prefs.findreplaceinfilesmatchcase, text, "find.replace.in.files.match.case", True)
		prefs.findreplaceinfilespromptonreplace = GetPrefFromText(prefs.findreplaceinfilespromptonreplace, text, "find.replace.in.files.prompt.on.replace", True)
		prefs.findreplaceinfilessubdirectories = GetPrefFromText(prefs.findreplaceinfilessubdirectories, text, "find.replace.in.files.subdirectories", True)
		prefs.findreplaceinfilesbackupbeforereplace = GetPrefFromText(prefs.findreplaceinfilesbackupbeforereplace, text, "find.replace.in.files.backup.before.replace", True)
		
		#Sessions
		prefs.sessionsrecentsessionslimit = GetPrefFromText(prefs.sessionsrecentsessionslimit, text, "sessions.recent.sessions.limit", True)
		prefs.sessionsdefaultdirectory = GetPrefFromText(prefs.sessionsdefaultdirectory, text, "sessions.default.directory", False)
		
		#Class Browser
		prefs.classbrowsercloseonactivate = GetPrefFromText(prefs.classbrowsercloseonactivate, text, "classbrowser.close.on.activate", True)
		prefs.classbrowserissorted = GetPrefFromText(prefs.classbrowserissorted, text, "classbrowser.is.sorted", True)
	prefs.classbrowserstyle = GetPrefFromText(prefs.classbrowserstyle, text, "classbrowser.style")
	
	#Bookmarks Settings
	prefs.bookmarksstyle = GetPrefFromText(prefs.bookmarksstyle, text, "bookmarks.style")
	
	
	#DrScript Settings
	prefs.drscriptstyle = GetPrefFromText(prefs.drscriptstyle, text, "drscript.style")
	if (not THEME):
		prefs.drscriptdefaultdirectory = ExtractPreferenceFromText(text, "drscript.default.directory")
		prefs.drscriptloadexamples = GetPrefFromText(prefs.drscriptloadexamples, text, "drscript.load.examples", True)
		
		#Shell Settings
		prefs.drshelldefaultcommanddirectory = GetPrefFromText(prefs.drshelldefaultcommanddirectory, text, "drshell.default.command.directory")
		prefs.drshelldefaultcommandarguments = GetPrefFromText(prefs.drshelldefaultcommandarguments, text, "drshell.default.command.arguments")
		prefs.drshellruninpromptbydefault = GetPrefFromText(prefs.drshellruninpromptbydefault, text, "drshell.run.in.prompt.by.default", True)
	prefs.drshellstyle = GetPrefFromText(prefs.drshellstyle, text, "drshell.style")
	
	if (not THEME):		
		#Theme Settings
		prefs.themesdefaultdirectory = ExtractPreferenceFromText(text, "themes.default.directory")
	
		#Printing
		prefs.printdoclinenumbers = GetPrefFromText(prefs.printdoclinenumbers, text, "print.doc.linenumbers", True)	
		prefs.printpromptlinenumbers = GetPrefFromText(prefs.printpromptlinenumbers, text, "print.prompt.linenumbers", True)
		prefs.printtabwidth = GetPrefFromText(prefs.printtabwidth, text, "print.tab.width", True)

		#Documentation
		prefs.documentationviewhelpwithbrowser = GetPrefFromText(prefs.documentationviewhelpwithbrowser, text, "documentation.view.help.with.browser", True)
		prefs.documentationbrowser = GetPrefFromText(prefs.documentationbrowser, text, "documentation.browser")
		prefs.documentationpythonlocation = GetPrefFromText(prefs.documentationpythonlocation, text, "documentation.python.location")
		prefs.documentationwxwidgetslocation = GetPrefFromText(prefs.documentationwxwidgetslocation, text, "documentation.wxwidgets.location")
		prefs.documentationrehowtolocation = GetPrefFromText(prefs.documentationrehowtolocation, text, "documentation.rehowto.location")

def SafeInt(string):
	if (len(string) > 0):
		try:
			return int(string)
		except:
			return 0
	return 0	

def WritePreferences(prefs, prefsfile, THEME = 0):
	fin = open(prefsfile, 'w')
	
	fin.write("<drpython.version>2.4.6</drpython.version>\n")
	
	#General Settings
	if (not THEME):
		fin.write("<window.width>" + str(prefs.windowwidth) + "</window.width>\n")
		fin.write("<window.height>" + str(prefs.windowheight) + "</window.height>\n")
		fin.write("<icon.size>" + str(prefs.iconsize) + "</icon.size>\n")
		fin.write("<mdi>" + str(prefs.mdi) + "</mdi>\n")
		fin.write("<enable.feedback>" + str(prefs.enablefeedback) + "</enable.feedback>\n")
		fin.write("<enable.warnings>" + str(prefs.enablewarnings) + "</enable.warnings>\n")
		fin.write("<always.prompt.on.exit>" + str(prefs.alwayspromptonexit) + "</always.prompt.on.exit>\n")
		fin.write("<backup.file.on.save>" + str(prefs.backupfileonsave) + "</backup.file.on.save>\n")
		fin.write("<auto.goto.for.traceback>" + str(prefs.autogotofortraceback) + "</auto.goto.for.traceback>\n")
		#utf-8 auto detect limodou 2004/04/14
		fin.write("<auto.detect.utf8.encoding>" + str(prefs.autodetectutf8encoding) + "</auto.detect.utf8.encoding>\n")
		#end limodou
		
	fin.write("<icon.file>" + str(prefs.iconfile) + "</icon.file>\n")
	
	if (not THEME):
		fin.write("<max.recent.files>" + str(prefs.recentfileslimit) + "</max.recent.files>\n")
		fin.write("<tab.width>" + str(prefs.tabwidth) + "</tab.width>\n")
		fin.write("<check.line.ending.type>" + str(prefs.checkeol) + "</check.line.ending.type>\n")
		fin.write("<line.ending.type>" + str(prefs.eolmode) + "</line.ending.type>\n")
		fin.write("<python.arguments>" + str(prefs.pythonargs) + "</python.arguments>\n")
		fin.write("<encoding>" + str(prefs.encoding) + "</encoding>\n")
		fin.write("<custom.encoding>" + prefs.customencoding + "</custom.encoding>\n")
		fin.write("<default.directory>" + str(prefs.defaultdirectory) + "</default.directory>\n")
			
	#Document Settings
	if (not THEME):
		fin.write("<doc.margin.width>" + str(prefs.docmarginwidth) + "</doc.margin.width>\n")
		fin.write("<doc.wordwrap>" + str(prefs.docwordwrap) + "</doc.wordwrap>\n")
		fin.write("<doc.autoindent>" + str(prefs.docautoindent) + "</doc.autoindent>\n")
		fin.write("<doc.use.tabs>" + str(prefs.docusetabs) + "</doc.use.tabs>\n")
		fin.write("<doc.whitespace.is.visible.on.startup>" + str(prefs.docwhitespaceisvisible) + "</doc.whitespace.is.visible.on.startup>\n")
		fin.write("<doc.folding>" + str(prefs.docfolding) + "</doc.folding>\n")
		fin.write("<doc.use.styles>" + str(prefs.docusestyles) + "</doc.use.styles>\n")
		fin.write("<doc.use.indentation.guides>" + str(prefs.docuseindentationguides) + "</doc.use.indentation.guides>\n")
		fin.write("<doc.long.line.col>" + str(prefs.doclonglinecol) + "</doc.long.line.col>\n")
		fin.write("<doc.scroll.extra.page>" + str(prefs.docscrollextrapage) + "</doc.scroll.extra.page>\n")
		fin.write("<doc.default.syntax.highlighting>" + str(prefs.docdefaultsyntaxhighlighting) + "</doc.default.syntax.highlighting>\n")
		fin.write("<doc.only.use.default.syntax.highlighting>" + str(prefs.doconlyusedefaultsyntaxhighlighting) + "</doc.only.use.default.syntax.highlighting>\n")
	#Python
	fin.write("<doc.style.normal>" + prefs.PythonStyleArray[0] + "</doc.style.normal>\n")
	fin.write("<doc.style.linenumber>" + prefs.PythonStyleArray[1] + "</doc.style.linenumber>\n")
	fin.write("<doc.style.brace.match>" + prefs.PythonStyleArray[2] + "</doc.style.brace.match>\n")
	fin.write("<doc.style.brace.nomatch>" + prefs.PythonStyleArray[3] + "</doc.style.brace.nomatch>\n")
	fin.write("<doc.style.character>" + prefs.PythonStyleArray[4] + "</doc.style.character>\n")
	fin.write("<doc.style.class>" + prefs.PythonStyleArray[5] + "</doc.style.class>\n")
	fin.write("<doc.style.comment>" + prefs.PythonStyleArray[6] + "</doc.style.comment>\n")
	fin.write("<doc.style.definition>" + prefs.PythonStyleArray[7] + "</doc.style.definition>\n")
	fin.write("<doc.style.keyword>" + prefs.PythonStyleArray[8] + "</doc.style.keyword>\n")
	fin.write("<doc.style.number>" + prefs.PythonStyleArray[9] + "</doc.style.number>\n")
	fin.write("<doc.style.operator>" + prefs.PythonStyleArray[10] + "</doc.style.operator>\n")
	fin.write("<doc.style.string>" + prefs.PythonStyleArray[11] + "</doc.style.string>\n")
	fin.write("<doc.style.triple.string>" + prefs.PythonStyleArray[12] + "</doc.style.triple.string>\n")
	fin.write("<doc.style.caret>" + prefs.PythonStyleArray[13] + "</doc.style.caret>\n")
	fin.write("<doc.style.selection>" + prefs.PythonStyleArray[14] + "</doc.style.selection>\n")
	fin.write("<doc.style.folding>" + prefs.PythonStyleArray[15] + "</doc.style.folding>\n")
	fin.write("<doc.style.longlinecol>" + prefs.PythonStyleArray[16] + "</doc.style.longlinecol>\n")
	
	#C/C++
	fin.write("<doc.cstyle.normal>" + prefs.CPPStyleArray[0] + "</doc.cstyle.normal>\n")
	fin.write("<doc.cstyle.linenumber>" + prefs.CPPStyleArray[1] + "</doc.cstyle.linenumber>\n")
	fin.write("<doc.cstyle.brace.match>" + prefs.CPPStyleArray[2] + "</doc.cstyle.brace.match>\n")
	fin.write("<doc.cstyle.brace.nomatch>" + prefs.CPPStyleArray[3] + "</doc.cstyle.brace.nomatch>\n")
	fin.write("<doc.cstyle.character>" + prefs.CPPStyleArray[4] + "</doc.cstyle.character>\n")
	fin.write("<doc.cstyle.preprocessor>" + prefs.CPPStyleArray[5] + "</doc.cstyle.preprocessor>\n")
	fin.write("<doc.cstyle.comment>" + prefs.CPPStyleArray[6] + "</doc.cstyle.comment>\n")
	#fix a bug limodou 2004/04/19
	#fin.write("doc.cstyle.verbatim>" + prefs.CPPStyleArray[7] + "</doc.cstyle.verbatim>\n")
	fin.write("<doc.cstyle.verbatim>" + prefs.CPPStyleArray[7] + "</doc.cstyle.verbatim>\n")
	#end limodou
	fin.write("<doc.cstyle.keyword>" + prefs.CPPStyleArray[8] + "</doc.cstyle.keyword>\n")
	fin.write("<doc.cstyle.number>" + prefs.CPPStyleArray[9] + "</doc.cstyle.number>\n")
	fin.write("<doc.cstyle.operator>" + prefs.CPPStyleArray[10] + "</doc.cstyle.operator>\n")
	fin.write("<doc.cstyle.string>" + prefs.CPPStyleArray[11] + "</doc.cstyle.string>\n")
	fin.write("<doc.cstyle.regex>" + prefs.CPPStyleArray[12] + "</doc.cstyle.regex>\n")
	fin.write("<doc.cstyle.uuid>" + prefs.CPPStyleArray[13] + "</doc.cstyle.uuid>\n")
	fin.write("<doc.cstyle.caret>" + prefs.CPPStyleArray[14] + "</doc.cstyle.caret>\n")
	fin.write("<doc.cstyle.selection>" + prefs.CPPStyleArray[15] + "</doc.cstyle.selection>\n")
	fin.write("<doc.cstyle.folding>" + prefs.CPPStyleArray[16] + "</doc.cstyle.folding>\n")
	fin.write("<doc.cstyle.longlinecol>" + prefs.CPPStyleArray[17] + "</doc.cstyle.longlinecol>\n")
	
	#HTML
	fin.write("<doc.htmlstyle.normal>" + prefs.HTMLStyleArray[0] + "</doc.htmlstyle.normal>\n")
	fin.write("<doc.htmlstyle.linenumber>" + prefs.HTMLStyleArray[1] + "</doc.htmlstyle.linenumber>\n")
	fin.write("<doc.htmlstyle.brace.match>" + prefs.HTMLStyleArray[2] + "</doc.htmlstyle.brace.match>\n")
	fin.write("<doc.htmlstyle.brace.nomatch>" + prefs.HTMLStyleArray[3] + "</doc.htmlstyle.brace.nomatch>\n")
	fin.write("<doc.htmlstyle.tag>" + prefs.HTMLStyleArray[4] + "</doc.htmlstyle.tag>\n")
	fin.write("<doc.htmlstyle.unknown.tag>" + prefs.HTMLStyleArray[5] + "</doc.htmlstyle.unknown.tag>\n")
	fin.write("<doc.htmlstyle.attribute>" + prefs.HTMLStyleArray[6] + "</doc.htmlstyle.attribute>\n")
	fin.write("<doc.htmlstyle.unknown.attribute>" + prefs.HTMLStyleArray[7] + "</doc.htmlstyle.unknown.attribute>\n")
	fin.write("<doc.htmlstyle.number>" + prefs.HTMLStyleArray[8] + "</doc.htmlstyle.number>\n")
	fin.write("<doc.htmlstyle.string>" + prefs.HTMLStyleArray[9] + "</doc.htmlstyle.string>\n")
	fin.write("<doc.htmlstyle.character>" + prefs.HTMLStyleArray[10] + "</doc.htmlstyle.character>\n")
	fin.write("<doc.htmlstyle.comment>" + prefs.HTMLStyleArray[11] + "</doc.htmlstyle.comment>\n")
	fin.write("<doc.htmlstyle.entity>" + prefs.HTMLStyleArray[12] + "</doc.htmlstyle.entity>\n")
	fin.write("<doc.htmlstyle.tag.end>" + prefs.HTMLStyleArray[13] + "</doc.htmlstyle.tag.end>\n")
	fin.write("<doc.htmlstyle.xml.start>" + prefs.HTMLStyleArray[14] + "</doc.htmlstyle.xml.start>\n")
	fin.write("<doc.htmlstyle.xml.end>" + prefs.HTMLStyleArray[15] + "</doc.htmlstyle.xml.end>\n")
	fin.write("<doc.htmlstyle.script>" + prefs.HTMLStyleArray[16] + "</doc.htmlstyle.script>\n")
	fin.write("<doc.htmlstyle.value>" + prefs.HTMLStyleArray[17] + "</doc.htmlstyle.value>\n")
	fin.write("<doc.htmlstyle.caret>" + prefs.HTMLStyleArray[18] + "</doc.htmlstyle.caret>\n")
	fin.write("<doc.htmlstyle.selection>" + prefs.HTMLStyleArray[19] + "</doc.htmlstyle.selection>\n")
	fin.write("<doc.htmlstyle.folding>" + prefs.HTMLStyleArray[20] + "</doc.htmlstyle.folding>\n")
	fin.write("<doc.htmlstyle.longlinecol>" + prefs.HTMLStyleArray[21] + "</doc.htmlstyle.longlinecol>\n")
	
	#Prompt Settings
	if (not THEME):
		fin.write("<prompt.margin.width>" + str(prefs.promptmarginwidth) + "</prompt.margin.width>\n")
		fin.write("<prompt.is.visible.on.startup>" + str(prefs.promptisvisible) + "</prompt.is.visible.on.startup>\n")
		fin.write("<prompt.size>" + str(prefs.promptsize) + "</prompt.size>\n")
		fin.write("<prompt.whitespace.is.visible.on.startup>" + str(prefs.promptwhitespaceisvisible) + "</prompt.whitespace.is.visible.on.startup>\n")
		fin.write("<prompt.use.tabs>" + str(prefs.promptusetabs) + "</prompt.use.tabs>\n")
		fin.write("<prompt.wordwrap>" + str(prefs.promptwordwrap) + "</prompt.wordwrap>\n")
		fin.write("<prompt.use.styles>" + str(prefs.promptusestyles) + "</prompt.use.styles>\n")
		fin.write("<prompt.scroll.extra.page>" + str(prefs.promptscrollextrapage) + "</prompt.scroll.extra.page>\n")
	fin.write("<prompt.style.normal>" + prefs.txtPromptStyleArray[0] + "</prompt.style.normal>\n")
	fin.write("<prompt.style.linenumber>" + prefs.txtPromptStyleArray[1] + "</prompt.style.linenumber>\n")
	fin.write("<prompt.style.brace.match>" + prefs.txtPromptStyleArray[2] + "</prompt.style.brace.match>\n")
	fin.write("<prompt.style.brace.nomatch>" + prefs.txtPromptStyleArray[3] + "</prompt.style.brace.nomatch>\n")
	fin.write("<prompt.style.character>" + prefs.txtPromptStyleArray[4] + "</prompt.style.character>\n")
	fin.write("<prompt.style.class>" + prefs.txtPromptStyleArray[5] + "</prompt.style.class>\n")
	fin.write("<prompt.style.comment>" + prefs.txtPromptStyleArray[6] + "</prompt.style.comment>\n")
	fin.write("<prompt.style.definition>" + prefs.txtPromptStyleArray[7] + "</prompt.style.definition>\n")
	fin.write("<prompt.style.keyword>" + prefs.txtPromptStyleArray[8] + "</prompt.style.keyword>\n")
	fin.write("<prompt.style.number>" + prefs.txtPromptStyleArray[9] + "</prompt.style.number>\n")
	fin.write("<prompt.style.operator>" + prefs.txtPromptStyleArray[10] + "</prompt.style.operator>\n")
	fin.write("<prompt.style.string>" + prefs.txtPromptStyleArray[11] + "</prompt.style.string>\n")
	fin.write("<prompt.style.triple.string>" + prefs.txtPromptStyleArray[12] + "</prompt.style.triple.string>\n")
	fin.write("<prompt.style.caret>" + prefs.txtPromptStyleArray[13] + "</prompt.style.caret>\n")
	fin.write("<prompt.style.selection>" + prefs.txtPromptStyleArray[14] + "</prompt.style.selection>\n")
	
	if (not THEME):	
		#Find/Replace Settings
		fin.write("<find.replace.regular.expression>" + str(prefs.findreplaceregularexpression) + "</find.replace.regular.expression>\n")
		fin.write("<find.replace.match.case>" + str(prefs.findreplacematchcase) + "</find.replace.match.case>\n")
		fin.write("<find.replace.find.backwards>" + str(prefs.findreplacefindbackwards) + "</find.replace.find.backwards>\n")
		fin.write("<find.replace.whole.word>" + str(prefs.findreplacewholeword ) + "</find.replace.whole.word>\n")
		fin.write("<find.replace.in.selection>" + str(prefs.findreplaceinselection) + "</find.replace.in.selection>\n")
		fin.write("<find.replace.from.cursor>" + str(prefs.findreplacefromcursor) + "</find.replace.from.cursor>\n")
		fin.write("<find.replace.prompt.on.replace>" + str(prefs.findreplacepromptonreplace) + "</find.replace.prompt.on.replace>\n")
			
		#Find/Replace In Files Settings
		fin.write("<find.replace.in.files.regular.expression>" + str(prefs.findreplaceinfilesregularexpression) + "</find.replace.in.files.regular.expression>\n")
		fin.write("<find.replace.in.files.match.case>" + str(prefs.findreplaceinfilesmatchcase) + "</find.replace.in.files.match.case>\n")
		fin.write("<find.replace.in.files.prompt.on.replace>" + str(prefs.findreplaceinfilespromptonreplace) + "</find.replace.in.files.prompt.on.replace>\n")
		fin.write("<find.replace.in.files.subdirectories>" + str(prefs.findreplaceinfilessubdirectories) + "</find.replace.in.files.subdirectories>\n")
		fin.write("<find.replace.in.files.backup.before.replace>" + str(prefs.findreplaceinfilesbackupbeforereplace) + "</find.replace.in.files.backup.before.replace>\n")
		
		#Sessions
		fin.write("<sessions.recent.sessions.limit>" + str(prefs.sessionsrecentsessionslimit) + "</sessions.recent.sessions.limit>\n")
		fin.write("<sessions.default.directory>" + prefs.sessionsdefaultdirectory + "</sessions.default.directory>\n")
			
		#Class Browser
		fin.write("<classbrowser.close.on.activate>" + str(prefs.classbrowsercloseonactivate) + "</classbrowser.close.on.activate>\n")
		fin.write("<classbrowser.is.sorted>" + str(prefs.classbrowserissorted) + "</classbrowser.is.sorted>\n")
	fin.write("<classbrowser.style>" + prefs.classbrowserstyle + "</classbrowser.style>\n")
	
	#Bookmarks Settings
	fin.write("<bookmarks.style>" + prefs.bookmarksstyle + "</bookmarks.style>\n")

	#DrScript Settings
	fin.write("<drscript.style>" + prefs.drscriptstyle + "</drscript.style>\n")
	if (not THEME):
		fin.write("<drscript.default.directory>" + prefs.drscriptdefaultdirectory + "</drscript.default.directory>\n")
		fin.write("<drscript.load.examples>" + str(prefs.drscriptloadexamples) + "</drscript.load.examples>\n")
		
		#Shell Settings
		fin.write("<drshell.default.command.directory>" + prefs.drshelldefaultcommanddirectory + "</drshell.default.command.directory>\n")
		fin.write("<drshell.default.command.arguments>" + prefs.drshelldefaultcommandarguments + "</drshell.default.command.arguments>\n")
		fin.write("<drshell.run.in.prompt.by.default>" + str(prefs.drshellruninpromptbydefault) + "</drshell.run.in.prompt.by.default>\n")
	fin.write("<drshell.style>" + prefs.drshellstyle + "</drshell.style>\n")
	
	if (not THEME):		
		#Theme Settings
		fin.write("<themes.default.directory>" + prefs.themesdefaultdirectory + "</themes.default.directory>\n")
	
		#Printing
		fin.write("<print.doc.linenumbers>" + str(prefs.printdoclinenumbers) + "</print.doc.linenumbers>\n")
		fin.write("<print.prompt.linenumbers>" + str(prefs.printpromptlinenumbers) + "</print.prompt.linenumbers>\n")
		fin.write("<print.tab.width>" + str(prefs.printtabwidth) + "</print.tab.width>\n")
	
		#Documentation
		fin.write("<documentation.view.help.with.browser>" + str(prefs.documentationviewhelpwithbrowser) + "</documentation.view.help.with.browser>\n")
		fin.write("<documentation.browser>" + prefs.documentationbrowser + "</documentation.browser>\n")
		fin.write("<documentation.python.location>" + prefs.documentationpythonlocation + "</documentation.python.location>\n")
		fin.write("<documentation.wxwidgets.location>" + prefs.documentationwxwidgetslocation + "</documentation.wxwidgets.location>\n")
		fin.write("<documentation.rehowto.location>" + prefs.documentationrehowtolocation + "</documentation.rehowto.location>\n")

	fin.close()
