#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#The Prompt

import sys
from wxPython.wx import *
from wxPython.stc import *
from drProperty import *
from drPopUp import SetUpPopUpActions
import drKeywords

class DrPrompt(wxStyledTextCtrl):
	def __init__(self, parent, id, grandparent):
		wxStyledTextCtrl.__init__(self, parent, id)

		#Maximum Number of Commands to Keep Track of in Prompt
		self.MAX_PROMPT_COMMANDS = 25

		self.grandparent = grandparent

		self.locale = 3

		self.ID_POPUP_BASE = 33000

		self.SetControlCharSymbol(254)

		#Right Click Menu
		self.UsePopUp(0)

		self.CommandArray = []
		self.CommandArrayPos = -1
		
		self.IsVisible = grandparent.prefs.promptisvisible
		
		self.editpoint = 0
		self.writeposition = 0
		
		#Process
		self.process = None
		self.pid = -1
		self.pythonintepreter = 0
		
		self.SetMarginWidth(0, 0)
		self.SetMarginWidth(1, 0)
		self.SetMarginWidth(2, 0)
		
		self.SetMarginType(1, wxSTC_MARGIN_NUMBER)

		EVT_STC_MODIFIED(self, id, self.OnModified)
		EVT_KEY_DOWN(self, self.OnKeyDown)
		EVT_KEY_UP(self, self.OnKeyUp)
		EVT_UPDATE_UI(self, id, self.RunCheck)
		EVT_RIGHT_DOWN(self, self.OnPopUp)
		
		EVT_IDLE(self, self.OnIdle)

	def GetEndOfLineCharacter(self):
		emode = self.GetEOLMode()
		if emode == wxSTC_EOL_CR:
			return '\r'
		elif emode == wxSTC_EOL_CRLF:
			return '\r\n'
		return '\n'

	def OnIdle(self, event):
		if (self.process is not None):
			if self.inputstream.CanRead():				
				text = self.inputstream.read()
				self.GotoPos(self.GetLength())
				self.AddText(text)
				self.writeposition = self.GetLength()
				self.EmptyUndoBuffer()
				self.editpoint = self.GetLength()
			if self.errorstream.CanRead():
				text = self.errorstream.read()
				self.GotoPos(self.GetLength())
				self.AddText(text)		
				self.writeposition = self.GetLength()
				self.EmptyUndoBuffer()
				self.editpoint = self.GetLength()

	def OnKeyDown(self, event):	
		if (not self.grandparent.RunShortcuts(event)):
			keycode = event.GetKeyCode()
			pos = self.GetCurrentPos()
			if (not self.pid == -1):
				if (pos >= self.editpoint) and (keycode == WXK_RETURN):
					text = self.GetTextRange(self.writeposition, self.GetLength())
					l = len(self.CommandArray)
					if (l < self.MAX_PROMPT_COMMANDS):
						self.CommandArray.insert(0, text)
						self.CommandArrayPos = -1
					else:
						self.CommandArray.pop()
						self.CommandArray.insert(0, text)
						self.CommandArrayPos = -1					
					if self.locale == 3:
						encoding = self.grandparent.prefs.customencoding
					else:
						encoding = self.grandparent.encodings[self.locale]
					if not encoding == "<None>":
						try:
							self.outputstream.write((text + '\n').encode(encoding))
							self.GotoPos(self.GetLength())
						except:
							self.AddText("\nDrPython Prompt ERROR:  Encoding: " + str(sys.exc_info()[1]) + "\nTrying without encoding...\n")
							self.outputstream.write(text + '\n')
							self.GotoPos(self.GetLength())						
					else:
							self.outputstream.write(text + '\n')
							self.GotoPos(self.GetLength())						
				if (keycode == WXK_UP):	
					l = len(self.CommandArray)
					if (len(self.CommandArray) > 0):
						if (self.CommandArrayPos + 1) < l:		
							self.GotoPos(self.editpoint)
							self.SetTargetStart(self.editpoint)
							self.SetTargetEnd(self.GetLength())
							self.CommandArrayPos = self.CommandArrayPos + 1
							self.ReplaceTarget(self.CommandArray[self.CommandArrayPos])
					
				elif (keycode == WXK_DOWN):
					if (len(self.CommandArray) > 0):
						self.GotoPos(self.editpoint)
						self.SetTargetStart(self.editpoint)
						self.SetTargetEnd(self.GetLength())
						if (self.CommandArrayPos - 1) > -1:					
							self.CommandArrayPos = self.CommandArrayPos - 1
							self.ReplaceTarget(self.CommandArray[self.CommandArrayPos])
						else:	
							if (self.CommandArrayPos - 1) > -2:		
								self.CommandArrayPos = self.CommandArrayPos - 1
							self.ReplaceTarget("")
			if ((pos > self.editpoint) and (not keycode == WXK_UP)) or ((not keycode == WXK_BACK) and (not keycode == WXK_LEFT) and (not keycode == WXK_UP) and (not keycode == WXK_DOWN)):
				if (pos < self.editpoint):
					if (not keycode == WXK_RIGHT):
						event.Skip()
				else:
					event.Skip()

	def OnKeyUp(self, event):
		keycode = event.GetKeyCode()
		pos = self.GetCurrentPos()
		if keycode == WXK_HOME:
			if (self.GetCurrentPos() < self.editpoint):
				self.GotoPos(self.editpoint)
			return
		elif keycode == WXK_PRIOR:
			if (self.GetCurrentPos() < self.editpoint):
				self.GotoPos(self.editpoint)
			return
		event.Skip()

	def OnModified(self, event):
		if not (self.grandparent.prefs.promptwordwrap):
			ll = self.TextWidth(wxSTC_STYLE_DEFAULT, "OOO")
			x = 0
			spaces = ""
			while (x < self.grandparent.prefs.tabwidth):
				spaces = spaces + " "
				x = x + 1
			current_width = self.GetScrollWidth()
			line = self.GetCurLine()[0].replace('\t', spaces)
			actual_width = self.TextWidth(wxSTC_STYLE_DEFAULT, line)
			if (current_width < actual_width):
				self.SetScrollWidth(actual_width + ll)
				
	def OnPopUp(self, event):
		self.actiondict, self.builtindict = SetUpPopUpActions(self.grandparent)
		
		if len(self.grandparent.popupmenulist) < 1:
			self.grandparent.popupmenulist = ["Undo", "Redo", "<Separator>", "Cut", "Copy", "Paste", "Delete", "<Separator>", "Select All"]		
		
		self.PopUpMenu = wxMenu()
		
		x = 0
		l = len(self.grandparent.popupmenulist)
		while x < l:
			if self.grandparent.popupmenulist[x] == "<Separator>":
				self.PopUpMenu.AppendSeparator()
			else:
				self.PopUpMenu.Append(self.ID_POPUP_BASE+x, self.grandparent.popupmenulist[x])
				EVT_MENU(self, self.ID_POPUP_BASE+x, self.OnPopUpMenu)
			x = x + 1
		self.PopupMenu(self.PopUpMenu, event.GetPosition())
		
		self.PopUpMenu.Destroy()

	def OnPopUpMenu(self, event):
		eid = event.GetId()
		label = self.PopUpMenu.GetLabel(eid)
		
		if label in self.actiondict:
			self.actiondict[label](event)
		elif label in self.builtindict:
			self.CmdKeyExecute(self.builtindict[label])
		elif label.find("Tab") > -1:
			if label == "Next Tab":
				self.grandparent.OnSelectTab(1)
			elif label == "Previous Tab":
				self.grandparent.OnSelectTab(-1)
			elif label == "First Tab":
				self.grandparent.OnSelectTab(0)
			elif label == "Last Tab":
				self.grandparent.OnSelectTab(2)	
							
	def RunCheck(self, event):
		if (self.GetCurrentPos() < self.editpoint) or (self.pid == -1):
			self.SetReadOnly(1)
		else:
			self.SetReadOnly(0)
			
	def SetupPrefsPrompt(self, notmdiupdate = 1):
		self.SetEndAtLastLine(not self.grandparent.prefs.promptscrollextrapage)
		
		#comment limodou 2004/04/16
		#self.locale = self.grandparent.prefs.encoding
		#end limodou
		
		if notmdiupdate:
			self.SetViewWhiteSpace(self.grandparent.prefs.promptwhitespaceisvisible)
			
		if (self.grandparent.prefs.promptwordwrap):
			self.SetWrapMode(wxSTC_WRAP_WORD)
		else:
			self.SetWrapMode(wxSTC_WRAP_NONE)	
		if (self.grandparent.prefs.eolmode == 1):
			self.SetEOLMode(wxSTC_EOL_CRLF)
		elif (self.grandparent.prefs.eolmode == 2):
			self.SetEOLMode(wxSTC_EOL_CR)
		else:
			self.SetEOLMode(wxSTC_EOL_LF)
		self.SetTabWidth(self.grandparent.prefs.tabwidth)
		self.SetUseTabs(self.grandparent.prefs.promptusetabs)
		self.SetMarginWidth(1, self.grandparent.prefs.promptmarginwidth)
		
		if self.grandparent.prefs.promptusestyles:			
				
			self.SetKeyWords(0, drKeywords.GetKeyWords(0))
				
			self.SetLexer(drKeywords.GetLexer(0))	
		
			self.StyleSetSpec(wxSTC_STYLE_DEFAULT, self.grandparent.prefs.txtPromptStyleArray[0])
					
			self.StyleClearAll()

			self.StartStyling(0, 0xff)
			
			self.SetCaretForeground(self.grandparent.prefs.txtPromptStyleArray[13])
			
			if (self.grandparent.prefs.promptusestyles < 2):
				self.StyleSetSpec(wxSTC_STYLE_LINENUMBER, self.grandparent.prefs.txtPromptStyleArray[1])
				self.StyleSetSpec(wxSTC_STYLE_BRACELIGHT, self.grandparent.prefs.txtPromptStyleArray[2])
				self.StyleSetSpec(wxSTC_STYLE_BRACEBAD, self.grandparent.prefs.txtPromptStyleArray[3])
				self.StyleSetSpec(wxSTC_P_CHARACTER, self.grandparent.prefs.txtPromptStyleArray[4])
				self.StyleSetSpec(wxSTC_P_CLASSNAME, self.grandparent.prefs.txtPromptStyleArray[5])
				self.StyleSetSpec(wxSTC_P_COMMENTBLOCK, self.grandparent.prefs.txtPromptStyleArray[6])
				self.StyleSetSpec(wxSTC_P_COMMENTLINE, self.grandparent.prefs.txtPromptStyleArray[6])
				self.StyleSetSpec(wxSTC_P_DEFNAME, self.grandparent.prefs.txtPromptStyleArray[7])
				self.StyleSetSpec(wxSTC_P_WORD, self.grandparent.prefs.txtPromptStyleArray[8])
				self.StyleSetSpec(wxSTC_P_NUMBER, self.grandparent.prefs.txtPromptStyleArray[9])
				self.StyleSetSpec(wxSTC_P_OPERATOR, self.grandparent.prefs.txtPromptStyleArray[10])
				self.StyleSetSpec(wxSTC_P_STRING, self.grandparent.prefs.txtPromptStyleArray[11])
				self.StyleSetSpec(wxSTC_P_STRINGEOL, self.grandparent.prefs.txtPromptStyleArray[11])
				self.StyleSetSpec(wxSTC_P_TRIPLE, self.grandparent.prefs.txtPromptStyleArray[12])
				self.StyleSetSpec(wxSTC_P_TRIPLEDOUBLE, self.grandparent.prefs.txtPromptStyleArray[12])
				
				self.SetSelForeground(1, getStyleProperty("fore", self.grandparent.prefs.txtPromptStyleArray[14]))
				self.SetSelBackground(1, getStyleProperty("back", self.grandparent.prefs.txtPromptStyleArray[14]))
	
	def SetText(self, text):		
		ro = self.GetReadOnly()
		self.SetReadOnly(0)
		wxStyledTextCtrl.SetText(self, text)
		self.SetReadOnly(ro)
				
	def SetSelectedText(self, text):
		ro = self.GetReadOnly()
		self.SetReadOnly(0)
		self.SetTargetStart(self.GetSelectionStart())
		self.SetTargetEnd(self.GetSelectionEnd())
		self.ReplaceTarget(text)
		self.SetReadOnly(ro)