#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Shortcuts Dialog

import os.path
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog, wxMultipleChoiceDialog
from drPrefsFile import ExtractPreferenceFromText
from drGetKeyDialog import drGetKeyDialog
import drShortcutsFile
import drShortcuts

class ShortcutsPanel(wxScrolledWindow):

	def __init__(self, parent, id, homedirectory):
	
		wxScrolledWindow.__init__(self, parent, id)
	
		wxYield()
	
		self.ID_SHORTCUTBASE = 8900
		
		self.ID_IGNORE = 201
				
		self.homedirectory = homedirectory
		
		self.ShortcutList = drShortcutsFile.GetShortcutList()
				
		self.EnableScrolling(True, True)
		
		self.grandparent = self.GetGrandParent()
		
		self.Shortcuts = []
		self.KeycodeArray = []
		
		copyto = self.Shortcuts
		
		def appendandcopy(copyfrom):
			i = len(copyto)
			copyto.append(drShortcuts.drShortcut())
			copyto[i].Copy(copyfrom)

		map(appendandcopy, self.grandparent.Shortcuts)
		map(lambda x: self.KeycodeArray.append(x.Keycode), self.Shortcuts)
		
		self.DrScriptShortcuts = []
		self.DrScriptKeycodeArray = []
		self.DrScriptShortcutList = []
		
		copyto = self.DrScriptShortcuts
			
		map(appendandcopy, self.grandparent.DrScriptShortcuts)
		map(lambda x: self.DrScriptShortcutList.append(x.Name), self.grandparent.DrScriptShortcuts)
		map(lambda x: self.DrScriptKeycodeArray.append(x.Keycode), self.DrScriptShortcuts)
		
		self.DrShellShortcuts = []
		self.DrShellKeycodeArray = []
		self.DrShellShortcutList = []
		
		copyto = self.DrShellShortcuts
			
		map(appendandcopy, self.grandparent.DrShellShortcuts)
		map(lambda x: self.DrShellShortcutList.append(x.Name), self.grandparent.DrShellShortcuts)
		map(lambda x: self.DrShellKeycodeArray.append(x.Keycode), self.DrShellShortcuts)
		
		
		self.ShortcutsIgnoreString = self.grandparent.ShortcutsIgnoreString
				
		self.theSizer = wxBoxSizer(wxVERTICAL)
		theMainSizer = wxBoxSizer(wxHORIZONTAL)
		
		self.SetScrollbars(10, 10, 30, 30)
		
		self.txtArray = []	
		self.txtArrayGetText = []	
				
		self.btnClose = wxButton(self, 101, "&Close")
		theMainSizer.Add(self.btnClose, 0, wxSHAPED)
		
		self.btnReset = wxButton(self, 102, "&Reset")
		theMainSizer.Add(self.btnReset, 0, wxSHAPED)
		
		self.btnUpdate = wxButton(self, 103, "&Update")
		theMainSizer.Add(self.btnUpdate, 0, wxSHAPED)
		
		self.btnSave = wxButton(self, 104, "&Save")
		theMainSizer.Add(self.btnSave, 0, wxSHAPED)
				
		self.theSizer.Add(theMainSizer, 0, wxSHAPED | wxALIGN_CENTER)
				
		self.setupInterface()
		
		self.SetAutoLayout(True)		
		self.SetSizer(self.theSizer)		
		
		EVT_BUTTON(self, 101, self.OnbtnClose)
		EVT_BUTTON(self, 102, self.OnbtnReset)
		EVT_BUTTON(self, 103, self.OnbtnUpdate)
		EVT_BUTTON(self, 104, self.OnbtnSave)
		
	def OnbtnClose(self, event):
		self.GetParent().Close(1)
		
	def OnbtnGetKey(self, event):
		current = (event.GetId() - self.ID_SHORTCUTBASE)
		d = drGetKeyDialog(self, self.txtIgnore.GetValue(), self.grandparent)
		d.ShowModal()
		oldv = self.txtArray[current].GetValue()
		newv = d.GetKeyString()
		d.Destroy()
		try:
			if (len(newv) > 0):
				i = self.txtArrayGetText.index(newv)
				doh = wxScrolledMessageDialog(self, ("Well, the Shortcut \"" + newv + "\" is already being used.\nDrPython will politely ignore your request."), "Shortcut Already Taken")
				doh.ShowModal()
				doh.Destroy()
				return
		except:
			i = 0
		i = self.txtArrayGetText.index(oldv)		
		self.txtArray[current].SetValue(newv)
		self.txtArrayGetText.pop(i)
		self.txtArrayGetText.append(newv)
		
	def OnbtnGetKeyIgnore(self, event):
		d = wxMultipleChoiceDialog(self, "Select the Modifier Keys you wish to ignore:\n\n", "Ignore Modifier Keys", ["Control", "Meta", "Shift", "Alt"])
		answer = d.ShowModal()
		if (answer == wxID_OK):	
			tuply = d.GetValueString()
			leString = ""
			for selection in tuply:
				leString = leString + selection + ","
			self.txtIgnore.SetValue(leString)
		d.Destroy()
		
	def OnbtnReset(self, event):	
		d = wxMessageDialog(self, "This will reset all shortcuts to the program default.\n(You still need to click update and/or save)\nAre you sure you want to do this?", "Reset Shortcuts", wxYES_NO | wxICON_QUESTION)
		answer = d.ShowModal()
		d.Destroy()
		if (answer == wxID_YES):
			self.Shortcuts, self.KeycodeArray, self.ShortcutsIgnoreString = drShortcutsFile.GetDefaultShortcuts()
			self.KeycodeArray, shortcutsActionArray, shortcutsArgumentsArray = drShortcuts.SetShortcuts(self.grandparent, self.Shortcuts, 1)
			self.resetInterface()
		
	def OnbtnSave(self, event):
		if (not os.path.exists(self.homedirectory)):
			d = wxScrolledMessageDialog(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			d.ShowModal()
			d.Destroy()
			return
		shortcutsfile = self.homedirectory + "/shortcuts.dat"
		try:			
			drShortcutsFile.WriteShortcuts(shortcutsfile, self.ShortcutList, self.txtArray, self.txtIgnore.GetValue())
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + shortcutsfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return			
		shortcutsfile = self.homedirectory + "/drscript.shortcuts.dat"
		try:			
			drShortcutsFile.WriteShortcuts(shortcutsfile, self.DrScriptShortcutList, self.txtArray, self.txtIgnore.GetValue(), len(self.ShortcutList))
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + shortcutsfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
			
		shortcutsfile = self.homedirectory + "/drshell.shortcuts.dat"
		try:			
			drShortcutsFile.WriteShortcuts(shortcutsfile, self.DrShellShortcutList, self.txtArray, self.txtIgnore.GetValue(), len(self.ShortcutList) + len(self.DrScriptShortcutList))
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + shortcutsfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
			
		if self.grandparent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully saved shortcuts.\nClick Update to update the current instance of DrPython."), "Saved Shortcuts")
			d.ShowModal()
			d.Destroy()	
		
	def OnbtnUpdate(self, event):

		parentframe = self.grandparent

		ignorestring = self.txtIgnore.GetValue()
		parentframe.ShortcutsIgnoreString = ignorestring
		allowControl = not (ignorestring.find("Control") > -1)
		allowShift = not (ignorestring.find("Shift") > -1)
		allowMeta = not (ignorestring.find("Meta") > -1)
		allowAlt = not (ignorestring.find("Alt") > -1)

		l = len(self.ShortcutList)
		self.Shortcuts = []		
		x = 0
		while (x < l):
			self.Shortcuts.append(drShortcuts.drShortcut())
			self.Shortcuts[x].Name = self.ShortcutList[x]
			value = self.txtArray[x].GetValue()
			target = value.find("#")
			self.Shortcuts[x].Control = ((value.find("Control") > -1) and allowControl)
			self.Shortcuts[x].Shift = ((value.find("Shift") > -1) and allowShift)
			self.Shortcuts[x].Meta = ((value.find("Meta") > -1) and allowMeta)
			self.Shortcuts[x].Alt = ((value.find("Alt") > -1) and allowAlt)
			if (target > -1):
				self.Shortcuts[x].Keycode = value[(target + 1):]
			else:
				self.Shortcuts[x].Keycode = ""
				
			x = x + 1	
		
		y = x		
		x = 0
		self.DrScriptKeycodeArray = []
		l = len(self.DrScriptShortcuts)
		while (x < l):
			value = self.txtArray[y].GetValue()
			target = value.find("#")
			self.DrScriptShortcuts[x].Control = ((value.find("Control") > -1) and allowControl)
			self.DrScriptShortcuts[x].Shift = ((value.find("Shift") > -1) and allowShift)
			self.DrScriptShortcuts[x].Meta = ((value.find("Meta") > -1) and allowMeta)
			self.DrScriptShortcuts[x].Alt = ((value.find("Alt") > -1) and allowAlt)
			if (target > -1):
				self.DrScriptShortcuts[x].Keycode = value[(target + 1):]
			else:
				self.DrScriptShortcuts[x].Keycode = ""
			self.DrScriptKeycodeArray.append(str(self.DrScriptShortcuts[x].Keycode))
			x = x + 1
			y = y + 1
								
		x = 0
		self.DrShellKeycodeArray = []
		l = len(self.DrShellShortcuts)
		while (x < l):
			value = self.txtArray[y].GetValue()
			target = value.find("#")
			self.DrShellShortcuts[x].Control = ((value.find("Control") > -1) and allowControl)
			self.DrShellShortcuts[x].Shift = ((value.find("Shift") > -1) and allowShift)
			self.DrShellShortcuts[x].Meta = ((value.find("Meta") > -1) and allowMeta)
			self.DrShellShortcuts[x].Alt = ((value.find("Alt") > -1) and allowAlt)
			if (target > -1):
				self.DrShellShortcuts[x].Keycode = value[(target + 1):]
			else:
				self.DrShellShortcuts[x].Keycode = ""
			self.DrShellKeycodeArray.append(str(self.DrShellShortcuts[x].Keycode))
			x = x + 1
			y = y + 1
		
		parentframe.Shortcuts = self.Shortcuts
		
		parentframe.ShortcutsActionArray = []
		parentframe.ShortcutsArgumentsArray = []
		drShortcuts.SetSTCBaseShortcuts(parentframe.txtPrompt)
		drShortcuts.SetSTCBaseShortcuts(parentframe.txtDocument)
		parentframe.KeycodeArray, parentframe.ShortcutsActionArray, parentframe.ShortcutsArgumentsArray = drShortcuts.SetShortcuts(parentframe, self.Shortcuts)
		
		parentframe.DrScriptShortcuts = self.DrScriptShortcuts
		parentframe.DrScriptKeycodeArray = self.DrScriptKeycodeArray
		
		parentframe.DrShellShortcuts = self.DrShellShortcuts
		parentframe.DrShellKeycodeArray = self.DrShellKeycodeArray
		
		if parentframe.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully updated the current instance of DrPython.\nClick Save to make it permanent."), "Updated Shortcuts")
			d.ShowModal()
			d.Destroy()	
	
	def resetInterface(self):
		l = len(self.ShortcutList)
		
		self.txtIgnore.SetValue(self.ShortcutsIgnoreString)
		
		x = 0
		le = len(self.Shortcuts)
		while (x < l):
			if (x < le):
				shortcut = self.Shortcuts[x]
			else:
				shortcut = drShortcuts.drShortcut()
				shortcut.Name = self.ShortcutList[x]
			vstring = ""
			if (shortcut.Control):
				vstring = "Control,"
			if (shortcut.Shift):
				vstring = vstring + "Shift,"
			if (shortcut.Meta):
				vstring = vstring + "Meta,"
			if (shortcut.Alt):
				vstring = vstring + "Alt,"
			vstring = vstring + " #" + shortcut.Keycode
			if (len(shortcut.Keycode) < 1):
				vstring = ""
			self.txtArray[x].SetValue(vstring)
			x = x + 1
		
	def setupInterface(self):
		l = len(self.ShortcutList)
		lSC = len(self.Shortcuts)		
		lDSSC = len(self.DrScriptShortcuts)	
		buttonSizer = wxFlexGridSizer((lSC + lDSSC + 4), 4, 5, 10)
									
		#Buffer Row	
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		
		#Ignore Key Row
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		buttonSizer.Add(wxStaticText(self, -1, "Ignore These Keys:"), 1, wxSHAPED)
		self.txtIgnore = wxTextCtrl(self, -1, self.ShortcutsIgnoreString, wxDefaultPosition, wxSize(160, -1))
		buttonSizer.Add(self.txtIgnore,1,wxSHAPED)
		buttonSizer.Add(wxButton(self, self.ID_IGNORE, "Get Key"),1,wxSHAPED)
		EVT_BUTTON(self, self.ID_IGNORE, self.OnbtnGetKeyIgnore)
		
		def addkeyrow(x):
			shortcut = x
			vstring = ""
			if (shortcut.Control):
				vstring = "Control,"
			if (shortcut.Shift):
				vstring = vstring + "Shift,"
			if (shortcut.Meta):
				vstring = vstring + "Meta,"
			if (shortcut.Alt):
				vstring = vstring + "Alt,"
			vstring = vstring + " #" + shortcut.Keycode
			if (len(shortcut.Keycode) < 1):
				vstring = ""
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, x.Name), 1, wxSHAPED)
			i = len(self.txtArray)
			self.txtArray.append(wxTextCtrl(self, -1, vstring, wxDefaultPosition, wxSize(160, -1), wxTE_READONLY))
			self.txtArrayGetText.append(vstring)
			buttonSizer.Add(self.txtArray[i],1,wxSHAPED)
			buttonSizer.Add(wxButton(self, (self.ID_SHORTCUTBASE + i), "Get Key"),1,wxSHAPED)
			EVT_BUTTON(self, (self.ID_SHORTCUTBASE + i), self.OnbtnGetKey)
			
		map(addkeyrow, self.Shortcuts)
		
		y = len(self.Shortcuts)
			
		#Buffer Row	
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		
		if (lDSSC > 0):
		
			#Label Row	
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "DrScript:"), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
			
			#Buffer Row	
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
			map(addkeyrow, self.DrScriptShortcuts)				
				
			#Buffer Row	
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
				
			#Label Row	
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "Shell:"), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)			
			
			#Buffer Row	
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			
			map(addkeyrow, self.DrShellShortcuts)			
				
			#Buffer Row	
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
			buttonSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED)
		
		self.theSizer.Add(buttonSizer, 0, wxSHAPED | wxALIGN_CENTER)
		self.buttonSizer = buttonSizer

class drShortcutsDialog(wxDialog):

	def __init__(self, parent, IS_WINDOWS):
		wxDialog.__init__(self, parent, -1, ("Customize Shortcuts"), wxPoint(50, 50), wxSize(500, 350), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)				
						
		self.pnlShortcuts = ShortcutsPanel(self, -1, parent.homedirectory)
		
		if (IS_WINDOWS):
			#This makes it behave under windows, and sets the proper size.
			self.SetSize(wxSize(525, 350))