#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
from drBoolean import *
from wxPython.wx import *
from wxPython.stc import *
from drProperty import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drPreferences import drPreferences

class drColorPanel(wxPanel):

	def __init__(self, parent, id, point, size, colorstring, fg):
		wxPanel.__init__(self, parent, id, point, size)

		self.ID_COLOR = 105
		self.ID_RED = 106
		self.ID_GREEN = 107
		self.ID_BLUE = 108

		self.txtColor = wxTextCtrl(self, self.ID_COLOR, colorstring, wxPoint(0, 10), wxSize(70, -1))

		self.isForeground = fg

		r = int(colorstring[1:3], 16)
		g = int(colorstring[3:5], 16)
		b = int(colorstring[5:7], 16)		

		self.red = wxSlider(self, self.ID_RED, r, 0, 255, wxPoint(0, 40), wxSize(100, -1), wxSL_HORIZONTAL | wxSL_LABELS )
		self.green = wxSlider(self, self.ID_GREEN, g, 0, 255, wxPoint(0, 70), wxSize(100, -1), wxSL_HORIZONTAL | wxSL_LABELS )
		self.blue = wxSlider(self, self.ID_BLUE, b, 0, 255, wxPoint(0, 100), wxSize(100, -1), wxSL_HORIZONTAL | wxSL_LABELS )

		EVT_SCROLL(self, self.OnScroll)
		EVT_TEXT(self, self.ID_COLOR, self.OnTextChange)

	def OnScroll(self, event):
		i = event.GetId()
		if (i == self.ID_RED):
			r = self.red.GetValue()
			sr = ''
			if (r < 16):
				sr = '0'
			sr = sr + hex(r)[2:]
			sr = sr.upper()
			text = self.txtColor.GetValue()
			if (len(text) is not 7):
				d = wxScrolledMessageDialog(self, ("The text box above should be formatted as follows:\n#0033AA,\nStart with the # character, followed by 6 characters which can be 0-9 or a-f.\nDrPython will ignore any changes to the color until this is fixed."), "Error")
				d.ShowModal()
				d.Destroy()	
				return
			self.txtColor.SetValue(text[0:1] + sr + text[3:])
		if (i == self.ID_GREEN):
			g = self.green.GetValue()
			sr = ''
			if (g < 16):
				sr = '0'
			sr = sr + hex(g)[2:]
			sr = sr.upper()
			text = self.txtColor.GetValue()
			if (len(text) is not 7):
				d = wxScrolledMessageDialog(self, ("The text box above should be formatted as follows:\n#0033AA,\nStart with the # character, followed by 6 characters which can be 0-9 or a-f.\nDrPython will ignore any changes to the color until this is fixed."), "Error")
				d.ShowModal()
				d.Destroy()
				return
			self.txtColor.SetValue(text[0:3] + sr + text[5:])
		if (i == self.ID_BLUE):
			b = self.blue.GetValue()
			sr = ''
			if (b < 16):
				sr = '0'
			sr = sr + hex(b)[2:]
			sr = sr.upper()
			text = self.txtColor.GetValue()
			if (len(text) is not 7):
				d = wxScrolledMessageDialog(self, ("The text box above should be formatted as follows:\n#0033AA,\nStart with the # character, followed by 6 characters which can be 0-9 or a-f.\nDrPython will ignore any changes to the color until this is fixed."), "Error")
				d.ShowModal()
				d.Destroy()
				return
			self.txtColor.SetValue(text[0:5] + sr + text[7:])

	def OnTextChange(self, event):
		v = self.txtColor.GetValue()
		if (len(v) < 1):
			self.red.Enable(False)
			self.green.Enable(False)
			self.blue.Enable(False)
			return
		if (v[0] == "#") and (len(v) == 7):
			#Update Sliders
			self.red.Enable(True)
			self.green.Enable(True)
			self.blue.Enable(True)
			try:
				self.red.SetValue(int(v[1:3], 16))
				self.green.SetValue(int(v[3:5], 16))
				self.blue.SetValue(int(v[5:7], 16))
			except:
				d = wxScrolledMessageDialog(self, ("Bad Color Data.  Should be in the form #00A3F4\nUse only digits 0-9, characters A-F"), "Error")
				d.ShowModal()
				d.Destroy()					
			#Update Parent
			if (self.isForeground):
				self.GetParent().foreground = v
			else:
				self.GetParent().background = v
			self.GetParent().SetColor()
		else:
			self.red.Enable(False)
			self.green.Enable(False)
			self.blue.Enable(False)

class drStyleDialog(wxDialog):

	def __init__(self, parent, id, title, stylestring, defaultstylestring, ChangeSpec = 0):

		wxDialog.__init__(self, parent, id, title, wxPoint(50, 50), wxSize(425, 450))

		self.ID_CANCEL = 101
		self.ID_OK = 102
		
		self.ID_FONTS = 103
		self.ID_SIZE = 104
			
		self.ID_BOLD = 109
		self.ID_ITALIC = 110
		self.ID_UNDERLINE = 111
		
		if (wxPlatform == '__WXMSW__'):
			BTN_Y_POS = 380
		else:
			BTN_Y_POS = 400

		self.Enum = wxFontEnumerator()
		self.Enum.EnumerateFacenames()
		self.FontList = self.Enum.GetFacenames()
		self.FontList.sort()

		self.OK = False

		self.font = getStyleProperty("face", stylestring)
		if (len(self.font) <= 0):
			self.font = getStyleProperty("face", defaultstylestring)
		self.size = getStyleProperty("size", stylestring)
		if (len(self.size) <= 0):
			self.size = getStyleProperty("size", defaultstylestring)
		self.foreground = getStyleProperty("fore", stylestring)
		if (len(self.foreground) <= 0):
			self.foreground = getStyleProperty("fore", defaultstylestring)
		self.background = getStyleProperty("back", stylestring)
		if (len(self.background) <= 0):
			self.background = getStyleProperty("back", defaultstylestring)
		self.bold = getStyleProperty("bold", stylestring)
		self.italic = getStyleProperty("italic", stylestring)
		self.underline = getStyleProperty("underline", stylestring)
		self.txtPreview = wxStyledTextCtrl(self, id, wxPoint(225, 15), wxSize(175, 150))

		if (ChangeSpec > 0):
			self.font = getStyleProperty("face", defaultstylestring)
			self.size = getStyleProperty("size", defaultstylestring)
			if (ChangeSpec == 1):
				self.background = getStyleProperty("back", defaultstylestring)

		try:
			self.FontList.index(self.font)
		except:
				d = wxScrolledMessageDialog(self, ("Current Font is not in the fontlist.  \nSetting to the default."), "Error")
				d.ShowModal()
				d.Destroy()						
				self.font = getStyleProperty("face", drPreferences(self.GetParent().GetGrandParent().prefs.platform_is_windows).txtDocumentStyleArray[0])
				self.size = getStyleProperty("size", drPreferences(self.GetParent().GetGrandParent().prefs.platform_is_windows).txtDocumentStyleArray[0])

		self.txtPreview.SetText("Preview\n()[]{}\n0123")
		self.txtPreview.SetUseHorizontalScrollBar(0)

		self.txtPreview.SetReadOnly(1)
		self.txtPreview.SetMarginWidth(0, 0)
		self.txtPreview.SetMarginWidth(1, 0)
		self.txtPreview.SetMarginWidth(2, 0)

		self.txtPreview.StyleSetSpec(wxSTC_STYLE_DEFAULT, ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline))

		self.txtPreview.StyleClearAll()

		self.txtPreview.StartStyling(0, 0xff)
							
		self.boxFonts = wxListBox(self, self.ID_FONTS, wxPoint(10, 10), wxSize(150, 150), self.FontList)
		
		try:
			self.boxFonts.SetStringSelection(self.font)
		except:
			d = wxScrolledMessageDialog(self, ("Something awful happened trying to \nset the font to the default."), "Error")
			d.ShowModal()
			d.Destroy()	
			self.boxFonts.SetSelection(0)

		self.boxSize = wxComboBox(self, self.ID_SIZE, self.size, wxPoint(10, 175), wxSize(150, 50), ["8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30"])
	
		self.fgPanel = drColorPanel(self, id, wxPoint(10, 200), wxSize(200, 140), self.foreground, True)
		self.bgPanel = drColorPanel(self, id, wxPoint(220, 200), wxSize(200, 140), self.background, False)

		self.chkBold = wxCheckBox(self, self.ID_BOLD, "Bold", wxPoint(10, 345))
		if (len(self.bold) > 0):
			self.chkBold.SetValue(1)
		self.chkItalic = wxCheckBox(self, self.ID_ITALIC, "Italic", wxPoint(110, 345))
		if (len(self.italic) > 0):
			self.chkItalic.SetValue(1)
		self.chkUnderline = wxCheckBox(self, self.ID_UNDERLINE, "Underline", wxPoint(210, 345))
		if (len(self.underline) > 0):
			self.chkUnderline.SetValue(1)

		if (ChangeSpec > 0):
			self.boxFonts.Enable(False)
			self.boxSize.Enable(False)
			self.chkBold.Enable(False)
			self.chkItalic.Enable(False)
			self.chkUnderline.Enable(False)
			if (ChangeSpec == 1):
				self.bgPanel.Enable(False)

		self.btnCancel = wxButton(self, self.ID_CANCEL, "&Cancel", wxPoint(5, BTN_Y_POS), wxSize(-1, -1))
		self.btnCancel.SetDefault()	
		self.btnOk = wxButton(self, self.ID_OK, "&Ok", wxPoint(300, BTN_Y_POS), wxSize(-1, -1))

		EVT_LISTBOX(self, self.ID_FONTS, self.OnFontSelect)
		EVT_COMBOBOX(self, self.ID_SIZE, self.OnSizeSelect)
		EVT_CHECKBOX(self, self.ID_BOLD, self.OnBold) 
		EVT_CHECKBOX(self, self.ID_ITALIC, self.OnItalic) 
		EVT_CHECKBOX(self, self.ID_UNDERLINE, self.OnUnderline)
		EVT_BUTTON(self, self.ID_CANCEL, self.OnbtnCancel)
		EVT_BUTTON(self, self.ID_OK, self.OnbtnOk)			

	def OnFontSelect(self, event):
		self.font = self.boxFonts.GetStringSelection()
		self.txtPreview.StyleSetSpec(wxSTC_STYLE_DEFAULT, ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline))
		self.txtPreview.StyleClearAll()
		self.txtPreview.StartStyling(0, 0xff)

	def OnSizeSelect(self, event):		
		self.size = self.boxSize.GetStringSelection()
		self.txtPreview.StyleSetSpec(wxSTC_STYLE_DEFAULT, ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline))
		self.txtPreview.StyleClearAll()
		self.txtPreview.StartStyling(0, 0xff)

	def SetColor(self):
		self.txtPreview.StyleSetSpec(wxSTC_STYLE_DEFAULT, ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline))
		self.txtPreview.StyleClearAll()
		self.txtPreview.StartStyling(0, 0xff)

	def OnBold(self, event):
		if (self.chkBold.IsChecked()):
			self.bold = "bold"
		else:
			self.bold = ""
		self.txtPreview.StyleResetDefault()
		self.txtPreview.StyleSetSpec(wxSTC_STYLE_DEFAULT, ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline))
		self.txtPreview.StyleClearAll()
		self.txtPreview.StartStyling(0, 0xff)

	def OnItalic(self, event):
		if (self.chkItalic.IsChecked()):
			self.italic = "italic"
		else:
			self.italic = ""
		self.txtPreview.StyleResetDefault()
		self.txtPreview.StyleSetSpec(wxSTC_STYLE_DEFAULT, ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline))
		self.txtPreview.StyleClearAll()
		self.txtPreview.StartStyling(0, 0xff)

	def OnUnderline(self, event):
		if (self.chkUnderline.IsChecked()):
			self.underline = "underline"
		else:
			self.underline = ""
		self.txtPreview.StyleResetDefault()
		self.txtPreview.StyleSetSpec(wxSTC_STYLE_DEFAULT, ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline))
		self.txtPreview.StyleClearAll()
		self.txtPreview.StartStyling(0, 0xff)

	def OnbtnCancel(self, event):
		self.EndModal(0)

	def OnbtnOk(self, event):
		self.OK = True
		self.EndModal(0)

	def ClickedOk(self):
		return self.OK

	def GetColorString(self):
		return ("fore:" + self.foreground + ",back:" + self.background)
		
	def GetForeground(self):
		return self.foreground

	def GetStyleString(self):
		return ("fore:" + self.foreground + ",back:" + self.background + ",size:" + self.size + ",face:" + self.font + "," + self.bold + "," + self.italic + "," + self.underline)