#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Switcheroo Dialog

from wxPython.wx import *

class drSwitcherooDialog(wxDialog):
	def __init__(self, parent, id, title):
		wxDialog.__init__(self, parent, id, title, wxPoint(50, 50), wxSize(375, 275), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)
					
		self.ID_SWITCH = 3001
		self.ID_CANCEL = 3002
		
		self.ID_CHK_REGEX = 1010
		self.ID_CREATERE_A = 1011
		self.ID_CREATERE_B = 1012
				
		self.parent = parent		
								
		self.txtA = wxTextCtrl(self, id, "", wxDefaultPosition, wxSize(175, -1))
		self.txtA.SetFocus()
		self.txtB = wxTextCtrl(self, id, "", wxDefaultPosition, wxSize(175, -1))
				
		self.chkCase = wxCheckBox(self, id, "&Match Case")
		self.chkWholeWord = wxCheckBox(self, id, "Match &Whole Word")
		self.chkInSelection = wxCheckBox(self, id, "In Selection")
		
		#Prefs
		self.chkCase.SetValue(parent.prefs.findreplacematchcase)
		self.chkWholeWord.SetValue(parent.prefs.findreplacewholeword)
		self.chkInSelection.SetValue(parent.prefs.findreplaceinselection)
		
		self.btnSwitch = wxButton(self, self.ID_SWITCH, "&Switch All")
		self.btnSwitch.SetDefault()
		self.btnCancel = wxButton(self, self.ID_CANCEL, "&Cancel")
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)		
		
		#Size Buffer
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
				
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, id, "Switch: "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)		
		self.theSizer.Add(self.txtA, 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)	
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, id, "With: "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)		
		self.theSizer.Add(self.txtB, 1, wxSHAPED)			
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)	
								
		#Size Buffer
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
				
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.chkCase, 1, wxSHAPED)
		self.theSizer.Add(self.chkWholeWord, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.chkInSelection, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)
								
		#Size Buffer
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
				
		self.theSizer.Add(wxStaticText(self, id, "    "), 1, wxSHAPED)		
		self.theSizer.Add(self.btnSwitch, 1, wxSHAPED)
		self.theSizer.Add(self.btnCancel, 1, wxSHAPED)
				
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
		EVT_BUTTON(self, self.ID_SWITCH, self.OnbtnSwitch)
		EVT_BUTTON(self, self.ID_CANCEL, self.OnbtnCancel)
		
		self.textA = ""
		self.textB = ""
		self.flags = wxFR_DOWN
			
	def OnbtnSwitch(self, event):
		self.Show(0)
		a = self.txtA.GetValue()
		b = self.txtB.GetValue()
		if (self.chkCase.IsChecked()):
			self.flags = self.flags + wxFR_MATCHCASE
		if (self.chkWholeWord.IsChecked()):
			self.flags = self.flags + wxFR_WHOLEWORD	
		temp = "DRPYTHONTEMPSWITCHEROO"
		if (len(a) > 0) and (len(b) > 0):
			if (self.chkInSelection.GetValue()):
				start = self.parent.txtDocument.GetSelectionStart()
				end = self.parent.txtDocument.GetSelectionEnd()
				
				self.parent.Finder.SetTargetRange(start, end)
				x = self.parent.Finder.ReplaceAll(a, temp, self.flags)
				end = end + ((len(temp) - len(a)) * x)
				self.parent.Finder.SetTargetRange(start, end)
				x = self.parent.Finder.ReplaceAll(b, a, self.flags)			
				end = end + ((len(a) - len(b)) * x)
				self.parent.Finder.SetTargetRange(start, end)
				self.parent.Finder.ReplaceAll(temp, b, self.flags)				
			else:
				self.parent.Finder.SetTargetRange(0, self.parent.txtDocument.GetTextLength())
				self.parent.Finder.ReplaceAll(a, temp, self.flags)				
				self.parent.Finder.SetTargetRange(0, self.parent.txtDocument.GetTextLength())
				self.parent.Finder.ReplaceAll(b, a, self.flags)
				self.parent.Finder.SetTargetRange(0, self.parent.txtDocument.GetTextLength())
				self.parent.Finder.ReplaceAll(temp, b, self.flags)
		self.Close(1)
	
	def OnbtnCancel(self, event):
		self.Close(1)