#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Themes Menu

import os.path
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
import drPrefsFile
from drPreferences import drPreferences

class drThemeMenu(wxMenu):
	def __init__(self, parent):
		wxMenu.__init__(self)
		
		self.ID_LOAD_THEME = 4001
		self.ID_SAVE_THEME = 4002

		#File Type
		self.wildcard = "DrPython Theme (*.dpt)|*.dpt|All files (*)|*"
		
		self.Append(self.ID_LOAD_THEME, "&Load Theme...", "  Load Theme")
		self.Append(self.ID_SAVE_THEME, "&Save Theme...", " Save Theme")
						
		self.parent = parent
		self.homedirectory = parent.homedirectory
		
		EVT_MENU(self.parent, self.ID_SAVE_THEME, self.OnSaveTheme)
		EVT_MENU(self.parent, self.ID_LOAD_THEME, self.OnLoadTheme)
		
	def OnLoadTheme(self, event):
		dlg = wxFileDialog(self.parent, "Load Theme From", "", "", self.wildcard, wxOPEN|wxHIDE_READONLY)
		if (len(self.parent.prefs.themesdefaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.parent.prefs.themesdefaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.prefs.themesdefaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			themefile = dlg.GetPath().replace("\\", "/")
			try:
				oldprefs = drPreferences(self.parent.prefs.platform_is_windows)
				oldprefs.Copy(self.parent.prefs)	
				drPrefsFile.ReadPreferences(self.parent.prefs, themefile, 1)
				if (not os.path.exists(self.parent.prefs.iconfile)):
					tryfile = dlg.GetDirectory().replace("\\", "/") + "/" + self.parent.prefs.iconfile
					if (os.path.exists(tryfile)):
						self.parent.prefs.iconfile = tryfile
				#Bug Fix: Thanks Cedric Delfosse. (self->self.parent).
				self.parent.updatePrefs(oldprefs)
			except:
				import traceback
				print sys.exc_info()[0] , ":\n\n" , sys.exc_info()[1] , "\n\n" , traceback.format_tb(sys.exc_info()[2])
				d = wxScrolledMessageDialog(self.parent, ("Error with: " + themefile), "Read Error")
				d.ShowModal()
				d.Destroy()
				return
			d = wxMessageDialog(self.parent, "Would you like to use the current theme for your default preferences?", "DrPython Theme", wxYES_NO | wxICON_QUESTION)
			answer = d.ShowModal()
			d.Destroy()
			savedprefs = ""
			if (answer == wxID_YES):				
				drPrefsFile.WritePreferences(self.parent.prefs, self.homedirectory + "/preferences.dat")
				savedprefs = "\nSet Theme As Default."
			if self.parent.prefs.enablefeedback:
				d = wxScrolledMessageDialog(self.parent, ("Successfully Loaded: " + themefile + savedprefs), "Load Success")
				d.ShowModal()
				d.Destroy()
		dlg.Destroy()
		
	def OnSaveTheme(self, event):
		dlg = wxFileDialog(self.parent, "Save Theme As", "", "", self.wildcard, wxSAVE|wxOVERWRITE_PROMPT)
		if (len(self.parent.prefs.themesdefaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.parent.prefs.themesdefaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.prefs.themesdefaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			themefile = dlg.GetPath().replace("\\", "/")
			try:
				theme_prefs = drPreferences(wxPlatform == '__WXMSW__')
				theme_prefs.Copy(self.parent.prefs)
				theme_prefs.iconfile = os.path.basename(theme_prefs.iconfile)
				drPrefsFile.WritePreferences(theme_prefs, themefile, 1)
			except:	
				d = wxScrolledMessageDialog(self.parent, ("There were some problems writing to:\n"  + themefile), "Write Error")
				d.ShowModal()
				d.Destroy()
				return
			if self.parent.prefs.enablefeedback:
				d = wxScrolledMessageDialog(self.parent, ("Successfully Saved: " + themefile + \
				"\n\nNote:  Changed the Icon File from: " + self.parent.prefs.iconfile + \
				" to the relative path: " + theme_prefs.iconfile + "\n\n" + \
				"remember to make sure the icon folders (16, 24) are in a subdirectory of the Theme File.\n\nSee the documentation for details."), "Save Success")
				d.ShowModal()
				d.Destroy()
    		dlg.Destroy()		