#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#ToolBar Menu Dialog

import os.path
from wxPython.wx import *
from wxPython.stc import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
import drPopUp

class drToolBarDialog(wxDialog):

	def __init__(self, parent):
		wxDialog.__init__(self, parent, -1, ("Customize ToolBar"), wxPoint(50, 50), wxSize(550, 300), wxDEFAULT_DIALOG_STYLE | wxTHICK_FRAME)
				
		wxYield()
		
		self.ID_PROGRAM = 1001
		self.ID_POPUP = 1002
		
		self.ID_ADD = 1003
		self.ID_REMOVE = 1004
		self.ID_UPDATE = 1005
		self.ID_SAVE = 1006
		
		self.ID_UP = 1111
		self.ID_DOWN = 2222
				
		self.theSizer = wxFlexGridSizer(5, 4, 5, 10)
		self.menubuttonSizer = wxBoxSizer(wxVERTICAL)
		
		self.homedirectory = parent.homedirectory
		
		ToolBarList = []
		
		map(ToolBarList.append, parent.ToolBarList)
		
		ToolBarList.insert(0, "<ROOT>")
		
		programmenulist = drPopUp.GetMenuList()
		
		l = len(ToolBarList)
		x = 0
		while x < l:
			try:
				i = programmenulist.index(ToolBarList[x])
				programmenulist.pop(i)
			except:
				pass
			x = x + 1
		
		self.programmenu = wxListBox(self, self.ID_PROGRAM, wxDefaultPosition, wxSize(200, -1), programmenulist)
		
		self.toolbaritems = wxListBox(self, self.ID_POPUP, wxDefaultPosition, wxSize(200, -1), ToolBarList)
		
		self.btnUp = wxButton(self, self.ID_UP, " Up ")
		self.btnAdd = wxButton(self, self.ID_ADD, " ---> ")
		self.btnRemove = wxButton(self, self.ID_REMOVE, " Remove ")
		self.btnDown = wxButton(self, self.ID_DOWN, " Down ")
		
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnAdd, 0, wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnUp, 0, wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnDown, 0, wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.menubuttonSizer.Add(self.btnRemove, 0, wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "Not Yet Added:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "ToolBar Items:"), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.programmenu, 0, wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.menubuttonSizer, 0, wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.toolbaritems, 0,  wxSHAPED | wxALIGN_CENTER)
		
		self.parent = parent
								
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
				
		self.btnUpdate = wxButton(self, self.ID_UPDATE, "&Update")
		self.btnSave = wxButton(self, self.ID_SAVE, "&Save")
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0,  wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.btnUpdate, 0,  wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(self.btnSave, 0,  wxSHAPED | wxALIGN_CENTER)
		self.btnClose.SetDefault()

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
	
		EVT_BUTTON(self, self.ID_UP, self.OnbtnUp)
		EVT_BUTTON(self, self.ID_ADD, self.OnbtnAdd)
		EVT_BUTTON(self, self.ID_REMOVE, self.OnbtnRemove)
		EVT_BUTTON(self, self.ID_DOWN, self.OnbtnDown)
		EVT_BUTTON(self, self.ID_UPDATE, self.OnbtnUpdate)
		EVT_BUTTON(self, self.ID_SAVE, self.OnbtnSave)
		EVT_BUTTON(self, 101, self.OnbtnClose)
				
	def OnbtnAdd(self, event):	
		tselection = self.programmenu.GetStringSelection()
		tsel = self.programmenu.GetSelection()
		if tsel == -1:
			d = wxScrolledMessageDialog(self, "Nothing Selected to Add", "Mistake")
			d.ShowModal()
			d.Destroy()
			return	
		separator = (tselection == "<Insert Separator>")
		if separator:
			tselection = "<Separator>"	
		sel = self.toolbaritems.GetSelection()
		if sel == -1:
			sel = sel + 1			
		self.toolbaritems.InsertItems([tselection], sel+1)
		self.toolbaritems.SetSelection(sel+1)
		if not separator:
			self.programmenu.Delete(tsel)
			self.programmenu.SetSelection(tsel-1)
	
	def OnbtnClose(self, event):
		self.Close(1)
		
	def OnbtnDown(self, event):
		sel = self.toolbaritems.GetSelection()
		if sel < self.toolbaritems.GetCount()-1 and sel > 0:
			txt = self.toolbaritems.GetString(sel)
			self.toolbaritems.Delete(sel)
			self.toolbaritems.InsertItems([txt], sel+1)
			self.toolbaritems.SetSelection(sel+1)
	
	def OnbtnRemove(self, event):
		sel = self.toolbaritems.GetSelection()
		selection = self.toolbaritems.GetStringSelection()
		if not sel:			
			d = wxScrolledMessageDialog(self, "You cannot remove the root item.", "Mistake")
			d.ShowModal()
			d.Destroy()
			return
		if sel == -1:
			d = wxScrolledMessageDialog(self, "Nothing Selected to Remove", "Mistake")
			d.ShowModal()
			d.Destroy()
			return

		self.toolbaritems.Delete(sel)
		if not selection == "<Separator>":
			self.programmenu.Append(selection)
		self.toolbaritems.SetSelection(sel-1)
	
	def OnbtnUp(self, event):
		sel = self.toolbaritems.GetSelection()		
		if sel > 1:
			txt = self.toolbaritems.GetString(sel)
			self.toolbaritems.Delete(sel)
			self.toolbaritems.InsertItems([txt], sel-1)
			self.toolbaritems.SetSelection(sel-1)
	
	def OnbtnUpdate(self, event):		
		y = 0
		c = self.toolbaritems.GetCount()
				
		if self.parent.hasToolBar:
			self.parent.DestroyToolBar()
		
		ToolBarList = []
		
		while y < c:
			pop = self.toolbaritems.GetString(y)
			if not pop == "<ROOT>":
				ToolBarList.append(pop)
			y = y + 1
		
		self.parent.ToolBarList = ToolBarList
		
		if self.parent.hasToolBar:
			self.parent.ToolBarIdList = self.parent.SetupToolBar()
			
			thereisafile = (len(self.parent.filename) > 0)
			self.parent.toolbar.EnableTool(self.parent.ID_RELOAD, thereisafile)
			
			if (self.parent.txtPrompt.pid is -1):
				self.parent.toolbar.EnableTool(self.parent.ID_PYTHON, True)
				self.parent.toolbar.EnableTool(self.parent.ID_END, False)
				self.parent.toolbar.EnableTool(self.parent.ID_RUN, thereisafile)
				self.parent.toolbar.EnableTool(self.parent.ID_SET_ARGS, thereisafile)
				self.parent.toolbar.EnableTool(self.parent.ID_PYTHON_DEBUGGER, thereisafile)			
			else:
				self.parent.toolbar.EnableTool(self.parent.ID_PYTHON, False)
				self.parent.toolbar.EnableTool(self.parent.ID_END, True)
				if thereisafile:
					self.parent.toolbar.EnableTool(self.parent.ID_RUN, False)
					self.parent.toolbar.EnableTool(self.parent.ID_SET_ARGS, False)
					self.parent.toolbar.EnableTool(self.parent.ID_PYTHON_DEBUGGER, False)
			
		if self.parent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully updated the current instance of DrPython.\nClick Save to make it permanent."), "Updated ToolBar")
			d.ShowModal()
			d.Destroy()
		
	def OnbtnSave(self, event):
		y = 0
		c = self.toolbaritems.GetCount()
		
		toolbaritemsstring = ""
		
		while y < c:
			pop = self.toolbaritems.GetString(y)
			if not pop == "<ROOT>":
				toolbaritemsstring = toolbaritemsstring + pop + "\n"
			y = y + 1			
	
		if (not os.path.exists(self.homedirectory)):
			d = wxScrolledMessageDialog(self, ("Dude, you've got some problems...\nYour homedirectory (" + self.homedirectory + ") does not exist!\nLet's not bother speculating about how or why.\nRead the help file for this truly screwed up situation.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed this problem."), "Huge Error")
			d.ShowModal()
			d.Destroy()
			return
		toolbarfile = self.homedirectory + "/toolbar.dat"
		try:			
			f = file(toolbarfile, 'w')
			f.write(toolbaritemsstring)
			f.close()
		except IOError:			
			d = wxScrolledMessageDialog(self, ("There were some problems writing to:\n"  + toolbarfile + "\nEither the file is having metaphysical issues, or you do not have permission to write.\nFor metaphysical issues, consult the documentation.\nFor permission issues, change the permissions on the directory to allow yourself write access.\nDrPython will now politely ignore your request to save.\nTry again when you have fixed the problem."), "Write Error")
			d.ShowModal()
			d.Destroy()
			return
		if self.parent.prefs.enablefeedback:
			d = wxScrolledMessageDialog(self, ("Succesfully wrote to:\n"  + toolbarfile + "\nClick Update to update the current instance of DrPython."), "Saved ToolBar")
			d.ShowModal()
			d.Destroy()