#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#ToolBar File

import os.path
import drPrefsFile
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog

def getToolBarList(homedirectory):
	toolbarfile = homedirectory + "/toolbar.dat"
	if not os.path.exists(toolbarfile):
		return ["New", "Open", "Reload File", "Close", "Save", \
		"<Separator>", "Print File", "Print Prompt", \
		"<Separator>", "Find", "Replace", \
		"<Separator>", "<Separator>", "Preferences", "Toggle Prompt", "Toggle View Whitespace", \
		"<Separator>", "<Separator>", "<Separator>", "Run", "Set Arguments", "Python", \
		"Run With Debugger", "End"]
	ToolBarList = []
	f = file(toolbarfile, 'r')
	line = f.readline().rstrip()
	while (len(line) > 0):
		ToolBarList.append(line)
		line = f.readline().rstrip()
	f.close()	
	return ToolBarList

def getBitmapFileDictionary(filename, bitmapNames, defaultbitmapdirectory, iconsize):
	zeDictionary = dict(map(lambda b: [b, 0], bitmapNames))
	iconsizestr = str(iconsize)
	
	useDefault = (len(filename) < 0)
	
	if not useDefault:
		try:
			f = open(filename, 'r')
			text = f.read()
			f.close()
			basepath = os.path.split(filename)[0]
			if (not os.path.exists(basepath + "/" + iconsizestr)):
				useDefault = 1
			else:							
				t = drPrefsFile.ExtractPreferenceFromText(text, "Default")
				themedefault = ""
				if len(t) > 0:		
					themedefault = basepath + "/" + iconsizestr + "/" + t
				if (len(t) < 1) or not os.path.exists(themedefault):
					themedefault = defaultbitmapdirectory + "/" + iconsizestr + "/Default.png"
		except:
			useDefault = 1	
	
	l = len(bitmapNames)
	x = 0
	while (x < l):
		if not bitmapNames[x] == "<Separator>":
			if (useDefault):		
				t = defaultbitmapdirectory + "/" + iconsizestr + "/" + bitmapNames[x] + ".png"
				if not os.path.exists(t):
					t = defaultbitmapdirectory + "/" + iconsizestr + "/Default.png"
			else:
				t = drPrefsFile.ExtractPreferenceFromText(text, bitmapNames[x])
				if (len(t) < 1) or not os.path.exists(basepath + "/" + iconsizestr + "/" + t):
					t = themedefault
				else:
					t = basepath + "/" + iconsizestr + "/" + t
			zeDictionary[bitmapNames[x]] = t
		x = x + 1
		
	return zeDictionary

def AddandReturn(frame, bitmapFileDictionary, IDNUM, count):
	frame.toolbar.AddSimpleTool(IDNUM, wxBitmapFromImage(wxImage(bitmapFileDictionary[frame.ToolBarList[count]], wxBITMAP_TYPE_PNG)), frame.ToolBarList[count], frame.ToolBarList[count])
	return IDNUM

def SetupToolBar(frame):
	try:
		bitmapFileDictionary = getBitmapFileDictionary(frame.prefs.iconfile, frame.ToolBarList, frame.bitmapdirectory, frame.prefs.iconsize) 
		
		frame.toolbar.SetToolBitmapSize(wxSize(frame.prefs.iconsize, frame.prefs.iconsize))
		
		ToolBarIdList = []
		
		x = 0
		l = len(frame.ToolBarList)
		while x < l:
			if frame.ToolBarList[x] == "<Separator>":
				frame.toolbar.AddSeparator()
				ToolBarIdList.append(-300)

			elif frame.ToolBarList[x] == "New":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_NEW, x))
			elif frame.ToolBarList[x] == "Open":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_OPEN, x))
			elif frame.ToolBarList[x] == "Reload File":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_RELOAD, x))
			elif frame.ToolBarList[x] == "Close":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_CLOSE, x))
			elif frame.ToolBarList[x] == "Save":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SAVE, x))
			elif frame.ToolBarList[x] == "Save As":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SAVE_AS, x))
			elif frame.ToolBarList[x] == "Save Prompt Output To File":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SAVE_PROMPT, x))
			elif frame.ToolBarList[x] == "Restore From Backup":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_RESTORE_FROM_BACKUP, x))
			elif frame.ToolBarList[x] == "Close All Tabs":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_CLOSE_ALL, x))
			elif frame.ToolBarList[x] == "Close All Other Tabs":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_CLOSE_ALL_OTHER_TABS, x))
				
			elif frame.ToolBarList[x] == "Print Setup":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PRINT_SETUP, x))
			elif frame.ToolBarList[x] == "Print File":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PRINT, x))
			elif frame.ToolBarList[x] == "Print Prompt":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PRINTPROMPT, x))

			elif frame.ToolBarList[x] == "Exit":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_EXIT, x))
	
			elif frame.ToolBarList[x] == "Next Tab":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_NEXT_TAB, x))
			elif frame.ToolBarList[x] == "Previous Tab":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PREVIOUS_TAB, x))
			elif frame.ToolBarList[x] == "First Tab":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_FIRST_TAB, x))
			elif frame.ToolBarList[x] == "Last Tab":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_LAST_TAB, x))

			elif frame.ToolBarList[x] == "Find":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_FIND, x))
			elif frame.ToolBarList[x] == "Replace":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_REPLACE, x))
			elif frame.ToolBarList[x] == "Switcheroo":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SWITCHEROO, x))
			elif frame.ToolBarList[x] == "Find Next":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_FIND_NEXT, x))
			elif frame.ToolBarList[x] == "Find Previous":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_FIND_PREVIOUS, x))
			elif frame.ToolBarList[x] == "Find In Files":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_FIND_IN_FILES, x))
			elif frame.ToolBarList[x] == "Replace In Files":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_REPLACE_IN_FILES, x))				
			elif frame.ToolBarList[x] == "Insert Regular Expression":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_INSERT_REGEX, x))
			elif frame.ToolBarList[x] == "Go To":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_GOTO, x))
				
				
			elif frame.ToolBarList[x] == "Comment":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_COMMENT_REGION, x))
			elif frame.ToolBarList[x] == "UnComment":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_UNCOMMENT_REGION, x))
			elif frame.ToolBarList[x] == "Indent":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_INDENT_REGION, x))
			elif frame.ToolBarList[x] == "Dedent":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_DEDENT_REGION, x))
			elif frame.ToolBarList[x] == "Undo":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_UNDO, x))
			elif frame.ToolBarList[x] == "Redo":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_REDO, x))
			elif frame.ToolBarList[x] == "Uppercase":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_UPPERCASE, x))
			elif frame.ToolBarList[x] == "Lowercase":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_LOWERCASE, x))
				
			elif frame.ToolBarList[x] == "Chop Beginning":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_CHOP_BEGINNING, x))
			elif frame.ToolBarList[x] == "Chop End":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_CHOP_END, x))
			elif frame.ToolBarList[x] == "Find And Complete":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_FIND_AND_COMPLETE, x))

			elif frame.ToolBarList[x] == "Copy":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_COPY, x))
			elif frame.ToolBarList[x] == "Cut":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_CUT, x))
			elif frame.ToolBarList[x] == "Paste":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PASTE, x))
			elif frame.ToolBarList[x] == "Delete":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_DELETE, x))

			elif frame.ToolBarList[x] == "Select All":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SELECT_ALL, x))
			elif frame.ToolBarList[x] == "Select None":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SELECT_NONE, x))
			elif frame.ToolBarList[x] == "Zoom In":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_ZOOM_IN, x))
			elif frame.ToolBarList[x] == "Zoom Out":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_ZOOM_OUT, x))
			elif frame.ToolBarList[x] == "Fold All":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_FOLD_ALL, x))
			elif frame.ToolBarList[x] == "Expand All":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_EXPAND_ALL, x))
				
			elif frame.ToolBarList[x] == "Select All":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SELECT_ALL, x))
			elif frame.ToolBarList[x] == "Select None":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SELECT_NONE, x))

			elif frame.ToolBarList[x] == "Show Class Browser":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SHOW_CLASSBROWSER, x))
			elif frame.ToolBarList[x] == "Preferences":
			#Fixed by limodou:
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PREFS, x))
			#End limodou
			elif frame.ToolBarList[x] == "Toggle Prompt":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_TOGGLE_PROMPT, x))
			elif frame.ToolBarList[x] == "Toggle View Whitespace":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_TOGGLE_VIEWWHITESPACE, x))
			elif frame.ToolBarList[x] == "Clear Prompt":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_CLEAR_PROMPT, x))

			elif frame.ToolBarList[x] == "Run":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_RUN, x))
			elif frame.ToolBarList[x] == "Set Arguments":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_SET_ARGS, x))
			elif frame.ToolBarList[x] == "Python":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PYTHON, x))
			elif frame.ToolBarList[x] == "Run With Debugger":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PYTHON_DEBUGGER, x))
			elif frame.ToolBarList[x] == "End":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_END, x))


			elif frame.ToolBarList[x] == "Set Log File":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_LOGGER_SET_LOG_FILE, x))
			elif frame.ToolBarList[x] == "Insert Logger":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_LOGGER_ADD_LOGGER, x))
			elif frame.ToolBarList[x] == "Insert String Logger":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_LOGGER_ADD_STRING_LOGGER, x))
			elif frame.ToolBarList[x] == "Insert Arbitrary Arguments Logger":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_LOGGER_ADD_ARBITRARYARGLOGGER, x))
			elif frame.ToolBarList[x] == "Remove All Loggers":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_LOGGER_REMOVE_ALL_LOGGERS, x))
				
			elif frame.ToolBarList[x] == "Add Breakpoint":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_ADD_BREAKPOINT, x))
			elif frame.ToolBarList[x] == "Remove Breakpoint":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_REMOVE_BREAKPOINT, x))
			elif frame.ToolBarList[x] == "Remove All Breakpoints":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_REMOVE_ALL_BREAKPOINTS, x))

			elif frame.ToolBarList[x] == "Help":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_HELP, x))
			elif frame.ToolBarList[x] == "View Python Docs":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_PYTHON_DOCS, x))
			elif frame.ToolBarList[x] == "View WxWidgets Docs":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_WXWIDGETS_DOCS, x))
			elif frame.ToolBarList[x] == "View Regular Expression Howto":
				ToolBarIdList.append(AddandReturn(frame, bitmapFileDictionary, frame.ID_REHOWTO_DOCS, x))

			x = x + 1
			
		if (len(frame.filename) < 1):
			frame.toolbar.EnableTool(frame.ID_RELOAD, False)
			frame.toolbar.EnableTool(frame.ID_RUN, False)
			frame.toolbar.EnableTool(frame.ID_SET_ARGS, False)
			frame.toolbar.EnableTool(frame.ID_PYTHON_DEBUGGER, False)
		
		if (frame.txtPrompt.pid is -1):
			frame.toolbar.EnableTool(frame.ID_END, False)
		else:
			frame.toolbar.EnableTool(frame.ID_RUN, False)
			frame.toolbar.EnableTool(frame.ID_SET_ARGS, False)
			frame.toolbar.EnableTool(frame.ID_PYTHON, False)
			frame.toolbar.EnableTool(frame.ID_PYTHON_DEBUGGER, False)
								
		frame.toolbar.Realize()
	except:	
		d = wxScrolledMessageDialog(frame, "Error Loading the ToolBar.", "DrPython Error")
		d.ShowModal()
		d.Destroy()
	return ToolBarIdList