#!/usr/bin/env python
#
# drPython installation script. v0.8.1
# Copyright (c) 2004 Radoslaw Stachowiak <radek@gentoo.org>
#
# Last modification: 2004/10/12 23:05:09
#
# (Daniel Pozmanter:  0.8.1:  Modified version number.)

from os import walk
from os.path import join
from distutils.core import setup
from distutils.sysconfig import get_python_lib 

# version, should be synced from other file
MY_VER='3.7.3'

# package name, do not change without understanding
MY_NAME = 'drpython'

# please add every directory to be installed to the list
DIRS = ['documentation','examples','bitmaps']

# destination directory, WARNING: do not support --prefix and --home now!
DEST_DIR = join( get_python_lib() , MY_NAME )

##############################################################################
# we need to create data_files list for distutils using os.walk
data_files = []
# for every subdirectory, create list of files for setup
for dentry in DIRS:
    for root,dirs,files in walk( dentry ):

        temp_files = []

        for f in files:
            temp_files.append( join( root, f ) )

        if temp_files:
            data_files.append( [ join( DEST_DIR, root ), temp_files ] )

# adding runner scripts, TODO: drpython startup should be probably redone
data_files.append( [ DEST_DIR, ['drpython.pyw','drpython.lin'] ] )

##############################################################################
# and now standard distutils installation routine
setup(name="DrPython",
    version=MY_VER,
    description="DrPython is a highly customizable cross-platform python ide using wxWidgets",
    author="Daniel Pozmanter",
    author_email="drpython@bluebottle.com",
    url="http://drpython.sourceforge.net/",
    packages=[ MY_NAME ],
    package_dir = { MY_NAME : ''},
#    scripts=['drpython.pyw','drpython.lin'],
    data_files=data_files,
)
