/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@dereferenced.org>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "dsyslog.h"

/*
 * PLEASE NOTE: this function does not have _ENTER or _LEAVE because it would cause
 * recursion. --nenolod
 */
void
dsyslog_log(const gchar *format, ...)
{
	static gint recursing = 0;
	va_list va;
	gchar *buf;
	static char datebuf[400];
	struct tm *tm;
	time_t now = time(NULL);

	/* XXX */
	if (recursing)
		return;

	tm = localtime(&now);
	strftime(datebuf, sizeof datebuf, "%b %e %T", tm);

	recursing++;

	va_start(va, format);
	buf = g_strdup_vprintf(format, va);
	va_end(va);

#ifdef NDEBUG
	dsyslog_event_dispatch(87, datebuf, NULL, "dsyslog", buf);
#else
	puts(buf);
#endif

	g_free(buf);

	recursing--;
}
