/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 Jeffrey Katz <kraln@kraln.com
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DSYSLOG_TEMPLATE_INCLUDE_RECURSION_GUARD
#define __DSYSLOG_TEMPLATE_INCLUDE_RECURSION_GUARD

/* Logging templates. */
typedef struct dsyslog_template_ dsyslog_template_t;

typedef struct {
	const char* key; 
	const char* value; 
} dsyslog_template_value_t;

struct dsyslog_template_ {
	char* template_string;
	GList* keywords;
};

extern dsyslog_template_t* dsyslog_template_new(char* template_string);
extern void dsyslog_template_associate_str(dsyslog_template_t* template, char* key, char* string);
extern void dsyslog_template_associate_int(dsyslog_template_t* template, char* key, int number);
extern gchar* dsyslog_template_eval(dsyslog_template_t* template);

#endif
