#!/bin/sh

USAGE="Usage: $0 <xen id> <ram size> [normal|install]"
if [ $# -lt 3 ]; then 
	echo $USAGE
fi

# Things that often change

# Source the configuration in the config file!
. /etc/dtc-xen/dtc_create_vps.conf.sh

#NODE_NUM=6501
#DEBIAN_REPOS="http://65.apt-proxy.gplhost.com:9999/debian"
#NETMASK=255.255.255.0
#NETWORK=202.124.18.0
#BROADCAST=202.124.18.255
#GATEWAY=202.124.18.1

# Things that might change
LVMNAME=lvm1
VPSGLOBPATH=/xen
#KERNELNAME="2.6.11.12-xenU"
INSTALL_KERNELPATH="/boot/netbsd-INSTALL_XENU"
NORMAL_KERNELPATH="/boot/netbsd-XENU"
#DEBIAN_BINARCH=i386

# Things that most of then time don't change
VPSNUM=$1
VPSNAME=xen${VPSNUM}
VPSHOSTNAME=xen${NODE_NUM}${VPSNUM}
RAMSIZE=$2
KERNEL_TYPE=$3
ALL_IPADDRS=$4

function calcMacAddr {
	CHARCNT=`echo -n ${NODE_NUM} | wc -m`
	if [ ""${CHARCNT} = "5" ] ; then
		MINOR_NUM=`echo ${NODE_NUM} | awk '{print substr($0,4,2)}'`
		MAJOR_NUM=`echo ${NODE_NUM} | awk '{print substr($0,2,2)}'`
		MEGA_NUM=`echo ${NODE_NUM} | awk '{print substr($0,1,1)}'`
	else
		MINOR_NUM=`echo ${NODE_NUM} | awk '{print substr($0,3,2)}'`
		MAJOR_NUM=`echo ${NODE_NUM} | awk '{print substr($0,1,2)}'`
		MEGA_NUM="0"
	fi
	MAC_ADDR=`echo 00:00:2$MEGA_NUM:$MAJOR_NUM:$MINOR_NUM:$VPSNUM`
}
calcMacAddr

case "$KERNEL_TYPE" in
	"install")
		KERNELPATH=$INSTALL_KERNELPATH
		;;
	"normal")
		KERNELPATH=$NORMAL_KERNELPATH
		;;
	*)
		echo $USAGE;
		exit 1
		;;
esac
	

echo "kernel = \"${KERNELPATH}\"
memory = ${RAMSIZE}
name = \"${VPSNAME}\"
vif = [ 'mac=${MAC_ADDR}, ip=${ALL_IPADDRS}' ]
disk = [ 'phy:/dev/mapper/lvm1-${VPSNAME},0x3,w' ]
" >/etc/xen/${VPSNAME}
if [ ! -e /etc/xen/auto/${VPSNAME} ] ; then
	ln -s ../${VPSNAME} /etc/xen/auto/${VPSNAME}
fi
