CREATE TABLE IF NOT EXISTS config (
db_version int(11) NOT NULL default '10002',
use_mail_alias_group enum('yes','no') NOT NULL default 'yes',
unicrow int(11) NOT NULL default '1',
demo_version enum('yes','no') NOT NULL default 'no',
main_site_ip varchar(16) NOT NULL default '127.0.0.1',
site_addrs varchar(255) NOT NULL default '127.0.0.1|192.168.0.1',
use_multiple_ip enum('yes','no') NOT NULL default 'yes',
use_cname_for_subdomains enum('yes','no') NOT NULL default 'no',
addr_mail_server varchar(255) NOT NULL default 'mx.example.com',
webmaster_email_addr varchar(255) NOT NULL default 'postmaster@example.com',
addr_primary_dns varchar(255) NOT NULL default 'ns1.example.com',
addr_secondary_dns varchar(255) NOT NULL default 'ns2.example.com',
ip_slavezone_dns_server varchar(16) NOT NULL default '192.168.0.3',
ip_allowed_dns_transfer varchar(255) NOT NULL default '192.168.0.1',
domainkey_publickey_filepath varchar(255) NOT NULL default '/var/lib/dkimproxy/public.key',
default_zones_ttl int(11) NOT NULL default '7200',
main_domain varchar(128) NOT NULL default 'gplhost.com',
404_subdomain varchar(128) NOT NULL default '404',
administrative_site varchar(255) NOT NULL default 'dtc.example.com',
administrative_ssl_port varchar(16) NOT NULL default '443',
site_root_host_path varchar(255) NOT NULL default '/var/www',
generated_file_path varchar(255) NOT NULL default '/var/lib/dtc/etc',
dtcshared_path varchar(255) NOT NULL default '/usr/share/dtc/shared',
dtcadmin_path varchar(255) NOT NULL default '/usr/share/dtc/admin',
dtcclient_path varchar(255) NOT NULL default '/usr/share/dtc/client',
dtcdoc_path varchar(255) NOT NULL default '/usr/share/dtc/doc',
dtcemail_path varchar(255) NOT NULL default '/usr/share/dtc/email',
htpasswd_path varchar(255) NOT NULL default '/usr/sbin/htpasswd',
qmail_newu_path varchar(255) NOT NULL default '/var/qmail/bin/qmail-newu',
qmail_rcpthost_path varchar(255) NOT NULL default 'rcpthosts',
qmail_virtualdomains_path varchar(255) NOT NULL default 'virtualdomains',
qmail_assign_path varchar(255) NOT NULL default 'assign',
qmail_poppasswd_path varchar(255) NOT NULL default 'poppasswd',
apache_vhost_path varchar(255) NOT NULL default 'vhosts.conf',
php_additional_library_path varchar(255) NOT NULL default '/usr/local/lib/php/phplib',
php_library_path varchar(255) NOT NULL default '/usr/lib/php:/tmp:/var/lib/dtc/etc/dtc404',
named_path varchar(255) NOT NULL default 'named.conf',
named_slavefile_path varchar(255) NOT NULL default 'named.slavezones.conf',
named_slavezonefiles_path varchar(255) NOT NULL default 'slave_zones',
named_zonefiles_path varchar(255) NOT NULL default 'zones',
autogen_default_subdomains enum('yes','no') NOT NULL default 'yes',
autogen_subdomain_list varchar(255) NOT NULL default 'pop|imap|mail|smtp|ftp',
autogen_webmail_alias enum('yes','no') NOT NULL default 'yes',
autogen_webmail_type enum('squirrelmail','roundcube') NOT NULL default 'squirrelmail',
backup_script_path varchar(255) NOT NULL default 'backup.bash',
bakcup_path varchar(255) NOT NULL default '/mnt/backup',
webalizer_stats_script_path varchar(255) NOT NULL default 'webalizer.bash',
use_javascript enum('yes','no') NOT NULL default 'yes',
use_ssl enum('yes','no') NOT NULL default 'no',
use_nated_vhost enum('yes','no') NOT NULL default 'no',
nated_vhost_ip varchar(16) NOT NULL default '192.168.0.2',
mta_type enum('qmail','postfix') NOT NULL default 'qmail',
use_cyrus enum('yes','no') NOT NULL default 'no',
use_amavis enum('yes','no') NOT NULL default 'yes',
use_clamav enum('yes','no') NOT NULL default 'yes',
use_advanced_lists_tunables enum('yes','no') NOT NULL default 'no',
use_webalizer enum('yes','no') NOT NULL default 'yes',
use_awstats enum('yes','no') NOT NULL default 'no',
use_visitors enum('yes','no') NOT NULL default 'no',
chroot_path varchar(255) NOT NULL default '/var/www/chroot',
domain_based_ftp_logins enum('yes','no') NOT NULL default 'yes',
domain_based_ssh_logins enum('yes','no') NOT NULL default 'yes',
hide_password enum('yes','no') NOT NULL default 'yes',
session_expir_minute int(9) NOT NULL default '10',
skin varchar(128) NOT NULL default 'bwoup',
srs_user varchar(128) NOT NULL default '',
srs_live_key varchar(255) NOT NULL default '',
srs_test_key varchar(255) NOT NULL default '',
srs_enviro enum('LIVE','TEST') NOT NULL default 'TEST',
srs_crypt enum('DES','BLOWFISH') NOT NULL default 'DES',
use_registrar_api enum('yes','no') NOT NULL default 'no',
ftp_backup_host varchar(255) NOT NULL default '',
ftp_backup_login varchar(255) NOT NULL default '',
ftp_backup_pass varchar(255) NOT NULL default '',
ftp_backup_frequency enum('day','week','month') NOT NULL default 'week',
ftp_backup_activate enum('yes','no') NOT NULL default 'no',
ftp_backup_dest_folder varchar(255) NOT NULL default '/',
vps_renewal_before varchar (64) NOT NULL default '5|10',
vps_renewal_after varchar (64) NOT NULL default '3|7',
vps_renewal_lastwarning varchar (64) NOT NULL default '12',
vps_renewal_shutdown varchar (64) NOT NULL default '15',
shared_renewal_before varchar (64) NOT NULL default '40|20|7',
shared_renewal_after varchar (64) NOT NULL default '15|7',
shared_renewal_lastwarning varchar (64) NOT NULL default '25',
shared_renewal_shutdown varchar (64) NOT NULL default '28',
webalizer_country_graph enum('yes','no') NOT NULL default 'no',
apache_version varchar (16) NOT NULL default '1',
dtc_system_uid varchar (16) NOT NULL default '1001',
dtc_system_username varchar (64) NOT NULL default 'dtc',
dtc_system_gid varchar (16) NOT NULL default '1001',
dtc_system_groupname varchar (64) NOT NULL default 'nogroup',
selling_conditions_url varchar (255) NOT NULL default 'none',
user_mysql_prepend_admin_name enum('yes','no') NOT NULL default 'no',
user_mysql_type enum('localhost','distant') NOT NULL default 'localhost',
user_mysql_host varchar (255) NOT NULL default 'localhost',
user_mysql_root_login varchar (255) NOT NULL default 'none',
user_mysql_root_pass varchar (255) NOT NULL default 'none',
user_mysql_client varchar (255) NOT NULL default '%',
`recipient_delimiter` varchar(4) NOT NULL default '\+',
this_server_country_code varchar (4) NOT NULL default 'US',
message_subject_header varchar (255) NOT NULL default '[DTC]',
apache_directoryindex varchar(255) NOT NULL default 'index.php index.cgi index.pl index.htm index.html index.php4',
named_soa_refresh varchar (16) NOT NULL default '2H',
named_soa_retry varchar (16) NOT NULL default '60M',
named_soa_expire varchar (16) NOT NULL default '1W',
named_soa_default_ttl varchar (16) NOT NULL default '24H',
provide_own_domain_hosts enum('yes','no') NOT NULL default 'no',
nagios_host varchar(255) NOT NULL default '',
nagios_username varchar(255) NOT NULL default '',
nagios_config_file_path varchar(255) NOT NULL default '',
nagios_restart_command varchar(255) NOT NULL default 'sudo /etc/init.d/nagios2 restart',
affiliate_return_domain varchar(255) NOT NULL default 'www.example.com',
support_ticket_email varchar(255) NOT NULL default 'support',
support_ticket_domain varchar(255) NOT NULL default 'default',
all_customers_list_email varchar(255) NOT NULL default 'support',
all_customers_list_domain varchar(255) NOT NULL default 'default',
UNIQUE KEY unicrow (unicrow)
)MAX_ROWS = 1 TYPE=MyISAM
