#!/usr/local/bin/perl
# Doel:    bepaal regels om woordenbestand te reduceren aan de hand van
#          een lijst met achtervoegsels
# Aueteur: Piet Tutelaers
# Versie: 1.0 (aug 1996)

while (<>) {
   chop;
   ($achtervoegsel, $regels) = split(/\s+/, $_, 2);
   next unless $regels =~ /;/;
   $regels =~ s/^[^;]+;//; $regels =~ s/\)$//;
   foreach $regel (split(/;/, $regels)) {
      foreach $reductie (split(/\|/, $regel)) {
         if ($reductie =~ /^-/) {
            $retro = reverse($reductie);
	    $reductie{$retro} .=
	       $reductie{$retro} ?  "/$achtervoegsel" : $achtervoegsel;
	 }
	 elsif ($reductie =~ /^\+/) {
	    $reductie =~ s/^\+//;
	    $reductie = $achtervoegsel . $reductie;
            $retro = reverse($reductie);
	    $reductie{$retro} .=
	       $reductie{$retro} ?  "/$achtervoegsel" : $achtervoegsel;
	 }
      }
   }
}

foreach (sort keys(%reductie)) {
   (@alternatief) = split('/', $reductie{$_});
   $achtervoegsel = reverse($_);
   for ($i=0; $i < @alternatief; $i++) {
      print sprintf("%14s %s\n", $achtervoegsel, $alternatief[$i]);
   }
}
