/*==============================================================================

FICHIER     : [uitools.c]

DATE        : 2005/12/0018 21:41:11

CREATEUR    : [Linux!jef]

COMMENTAIRE :
		Released under GPL license, see gnu.org
================================================================================

==============================================================================*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdarg.h>

#include <gnome.h>
#include "interface.h"
#include "support.h"

#include "globals.h"

/*------------------------------------------------------------------------------
	PLAYSUCCESS-
Linux!jef 2006/02/28 22:01:51
------------------------------------------------------------------------------*/

void PlaySuccess()
{
//	gnome_sound_play( "/usr/share/sounds/k3b_success1.wav" );
	gnome_sound_play( "/usr/share/sounds/info.wav" );
}
/*------------------------------------------------------------------------------
	PLAYERROR-
Linux!jef 2006/02/28 22:02:12
------------------------------------------------------------------------------*/

void PlayError()
{
	gnome_sound_play( "/usr/share/sounds/error.wav" );
//	gnome_sound_play( "/usr/share/sounds/k3b_error1.wav" );
}

/*------------------------------------------------------------------------------
	MESSAGEBOX-
Linux!jef 2006/09/29 23:29:41
------------------------------------------------------------------------------*/

int MessageBoxError( char * format, ... )
{
	char message[4096];
	va_list args;
	GtkWidget * mbox;

	va_start( args, format );
	vsnprintf( message, sizeof(message), format, args );
	va_end( args );

	mbox = gtk_message_dialog_new( GTK_WINDOW(MainDlg),
					GTK_DIALOG_MODAL,
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK,
					message );
	gtk_dialog_run( GTK_DIALOG( mbox ) );
	gtk_widget_destroy( GTK_WIDGET( mbox ) );
	return( 0 );
}


/*------------------------------------------------------------------------------
	MESSAGEBOXYESNO-
Linux!jef 2006/09/29 23:29:41
------------------------------------------------------------------------------*/

int MessageBoxYesNo( char * format, ... )
{
	char message[4096];
	va_list args;
	GtkWidget * mbox;
	gint b;

	va_start( args, format );
	vsnprintf( message, sizeof(message), format, args );
	va_end( args );

	mbox = gtk_message_dialog_new( GTK_WINDOW(MainDlg),
					GTK_DIALOG_MODAL,
					GTK_MESSAGE_QUESTION,
					GTK_BUTTONS_YES_NO,
					message );
	b = gtk_dialog_run( GTK_DIALOG( mbox ) );
	gtk_widget_destroy( GTK_WIDGET( mbox ) );
	if( b == GTK_RESPONSE_YES )	return( 1 );
	return( 0 );
}

/*------------------------------------------------------------------------------
	CHOIXFICHIERISO-
Linux!jef 2007/01/21 22:42:12
------------------------------------------------------------------------------*/

int ChoixFichierIso( char * fileName )
{
	GtkWidget * fc;
	int res = -1;

	*fileName = 0;
	fc = create_ChoixFichier();
	if( fc ) {
		GtkFileFilter * fi =  gtk_file_filter_new();

		gtk_file_filter_set_name( fi, _("Fichiers ISO") );
		gtk_file_filter_add_pattern( fi, "*.iso" );
		gtk_file_chooser_add_filter( GTK_FILE_CHOOSER(fc), fi );

		if( gtk_dialog_run (GTK_DIALOG(fc)) == GTK_RESPONSE_OK) {
			char *filename;

			filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(fc));

			strcpy( fileName, filename );
			g_free (filename);
			res = 0;
		}
		gtk_widget_destroy( fc );
	}
	return( res );
}
/*------------------------------------------------------------------------------
	GTKFLUSH-
Linux!jef 2007/01/21 23:24:49
------------------------------------------------------------------------------*/

void GtkFlush()
{
	while( gtk_events_pending() )	gtk_main_iteration();
}

/*------------------------------------------------------------------------------
	HMD2STRING-
Linux!jef 2007/01/23 00:36:37
------------------------------------------------------------------------------*/

void HMS2String( int h, int m, int s, char * string )
{
	*string = 0;
	if( h ) {
		sprintf( string, "%d h ", h );
		string += strlen( string );
	}
	if( m ) {
		if( s )
			sprintf( string, "%d m %d s", m, s );
		else
			sprintf( string, "%d m", m );
		return;
	}
	if( h )
		sprintf( string, "0 m %d s", s );
	else
		sprintf( string, "%d s", s );
}

