/*==============================================================================

FICHIER     : [dvdinfo.c]

DATE        : 2006/01/0005 20:51:46

CREATEUR    : [Linux!jef]

COMMENTAIRE :
		Released under GPL license, see gnu.org
================================================================================

==============================================================================*/
#define _LARGEFILE64_SOURCE
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include <gnome.h>

#ifdef __APPLE__
/* fopen is 64-bit aware on Mac OS X */
#define fopen64(A,B) fopen(A,B)
#endif


#define __IN_DVDINFO__
#include "dvdinfo.h"

#include "globals.h"

static struct {
	char * code;
	char * name;
} ArrLang[] = {
	{ "  ", "Not Specified" }, { "aa", "Afar" },	{ "ab", "Abkhazian" }, { "af", "Afrikaans" },	{ "am", "Amharic" },
	{ "ar", "Arabic" }, { "as", "Assamese" },	{ "ay", "Aymara" }, { "az", "Azerbaijani" }, { "ba", "Bashkir" },
	{ "be", "Byelorussian" }, { "bg", "Bulgarian" }, { "bh", "Bihari" }, { "bi", "Bislama" }, { "bn", "Bengali; Bangla" },
	{ "bo", "Tibetan" }, { "br", "Breton" }, { "ca", "Catalan" }, { "co", "Corsican" }, { "cs", "Czech" },
	{ "cy", "Welsh" }, { "da", "Dansk" }, { "de", "Deutsch" }, { "dz", "Bhutani" }, { "el", "Greek" }, { "en", "English" },
	{ "eo", "Esperanto" }, { "es", "Espanol" }, { "et", "Estonian" }, { "eu", "Basque" }, { "fa", "Persian" },
	{ "fi", "Suomi" }, { "fj", "Fiji" }, { "fo", "Faroese" }, { "fr", "Francais" }, { "fy", "Frisian" }, { "ga", "Gaelic" },
	{ "gd", "Scots Gaelic" }, { "gl", "Galician" }, { "gn", "Guarani" }, { "gu", "Gujarati" }, { "ha", "Hausa" },
	{ "he", "Hebrew" }, { "hi", "Hindi" }, { "hr", "Hrvatski" }, { "hu", "Magyar" }, { "hy", "Armenian" },
	{ "ia", "Interlingua" }, { "id", "Indonesian" }, { "ie", "Interlingue" }, { "ik", "Inupiak" }, { "in", "Indonesian" },
	{ "is", "Islenska" }, { "it", "Italiano" }, { "iu", "Inuktitut" }, { "iw", "Hebrew" }, { "ja", "Japanese" },
	{ "ji", "Yiddish" }, { "jw", "Javanese" }, { "ka", "Georgian" }, { "kk", "Kazakh" }, { "kl", "Greenlandic" },
	{ "km", "Cambodian" }, { "kn", "Kannada" }, { "ko", "Korean" }, { "ks", "Kashmiri" }, { "ku", "Kurdish" },
	{ "ky", "Kirghiz" }, { "la", "Latin" }, { "ln", "Lingala" }, { "lo", "Laothian" }, { "lt", "Lithuanian" },
	{ "lv", "Latvian, Lettish" }, { "mg", "Malagasy" }, { "mi", "Maori" }, { "mk", "Macedonian" }, { "ml", "Malayalam" },
	{ "mn", "Mongolian" }, { "mo", "Moldavian" }, { "mr", "Marathi" }, { "ms", "Malay" }, { "mt", "Maltese" },
	{ "my", "Burmese" }, { "na", "Nauru" }, { "ne", "Nepali" }, { "nl", "Nederlands" }, { "no", "Norsk" }, { "oc", "Occitan" },
	{ "om", "Oromo" }, { "or", "Oriya" }, { "pa", "Punjabi" }, { "pl", "Polish" }, { "ps", "Pashto, Pushto" },
	{ "pt", "Portugues" }, { "qu", "Quechua" }, { "rm", "Rhaeto-Romance" }, { "rn", "Kirundi" }, { "ro", "Romanian"  },
	{ "ru", "Russian" }, { "rw", "Kinyarwanda" }, { "sa", "Sanskrit" }, { "sd", "Sindhi" }, { "sg", "Sangho" },
	{ "sh", "Serbo-Croatian" }, { "si", "Sinhalese" }, { "sk", "Slovak" }, { "sl", "Slovenian" }, { "sm", "Samoan" },
	{ "sn", "Shona"  }, { "so", "Somali" }, { "sq", "Albanian" }, { "sr", "Serbian" }, { "ss", "Siswati" },
	{ "st", "Sesotho" }, { "su", "Sundanese" }, { "sv", "Svenska" }, { "sw", "Swahili" }, { "ta", "Tamil" },
	{ "te", "Telugu" }, { "tg", "Tajik" }, { "th", "Thai" }, { "ti", "Tigrinya" }, { "tk", "Turkmen" }, { "tl", "Tagalog" },
	{ "tn", "Setswana" }, { "to", "Tonga" }, { "tr", "Turkish" }, { "ts", "Tsonga" }, { "tt", "Tatar" }, { "tw", "Twi" },
	{ "ug", "Uighur" }, { "uk", "Ukrainian" }, { "ur", "Urdu" }, { "uz", "Uzbek" }, { "vi", "Vietnamese" },
	{ "vo", "Volapuk" }, { "wo", "Wolof" }, { "xh", "Xhosa" }, { "yi", "Yiddish" }, { "yo", "Yoruba" }, { "za", "Zhuang" },
	{ "zh", "Chinese" }, { "zu", "Zulu" }, { "xx", "Unknown" }, { NULL, "Unknown" }
};

/***************************************************************************//**
 *	GETDVDTITLEUSINGLIBDVD-
 * @date	2008/07/16 22:34:16
 * @author	jef-Linux
 * @brief
 *	Pas d'explication
 * @details
 *	Pas de details
 * @param[in]	Pas de detail
 * @param[out]	Pas de detail
*******************************************************************************/

int GetDVDTitleUsingLibDVD( title )
char * title;
{
	int res;

	res = DVDUDFVolumeInfo( Dvd, title, 33, (unsigned char *) 0, 0);
/* Provide a default title, in case of DVD directory structure */
	if( res < 0 ) {
		strcpy( title, "UNKNOWN" );
		res = 0;
	}
	return( res );
}

/*------------------------------------------------------------------------------
	GETTITLE-
Linux!jef 2005/12/02 22:30:59
------------------------------------------------------------------------------*/

int GetDVDTitle( device, title )
char * device;
char * title;
{
	FILE * fp;
	int i;

	fp = fopen64( device, "r" );
	if( !fp ) {
		fprintf(stderr,"%s: seek error %d\n", __FUNCTION__, errno );
		return( -1 );
	}
	if( fseek( fp, 32808, SEEK_SET)) {
		fprintf(stderr,"%s: seek error %d\n", __FUNCTION__, errno );
		fclose( fp );
		return( -1 );
	}
	if( (i = fread(title, 1, 32, fp)) != 32 ) {
		fprintf(stderr,"%s: read error %d\n", __FUNCTION__, errno );
		fclose( fp );
		return( -1 );
	}
	title[32] = '\0';
	while( i-- > 2 ) {
		if( title[i] == ' ' ) title[i] = '\0';
        }
	fclose( fp );
	return( 0 );
}

/*------------------------------------------------------------------------------
	DVDOPEN-
Linux!jef 2005/12/03 01:02:56
------------------------------------------------------------------------------*/

int DvdOpen( device )
char * device;
{
	int i;

	Dvd = DVDOpen( device );
	if( !Dvd ) {
		return( -1 );
	}
	Ifo_zero = ifoOpen( Dvd, 0);
	if( !Ifo_zero )	return( -1 );

	Ifo =(ifo_handle_t **)malloc((Ifo_zero->vts_atrt->nr_of_vtss + 1) * sizeof (ifo_handle_t *));
	DBG('i',fprintf(stderr,"Loading %d ifos\n", Ifo_zero->vts_atrt->nr_of_vtss ););
	for( i = 1; i <= Ifo_zero->vts_atrt->nr_of_vtss; i++) {
		Ifo[i] = ifoOpen( Dvd, i );
		if( !Ifo[i])	return(-1);
	}
	NrTitles = Ifo_zero->tt_srpt->nr_of_srpts;
	return( 0 );
}

/*------------------------------------------------------------------------------
	DVDCLOSE-
Linux!jef 2005/12/03 01:05:55
------------------------------------------------------------------------------*/

void DvdClose()
{
	int i;

	if( Dvd ) {
		for( i = 1; i <= Ifo_zero->vts_atrt->nr_of_vtss; i++)	ifoClose( Ifo[i] );
		ifoClose( Ifo_zero );
		DVDClose( Dvd );
		free( Ifo );
		Ifo = NULL;
		Dvd = NULL;
		Ifo_zero = NULL;
	}
}
/*------------------------------------------------------------------------------
	DVDLANGCODE2STRING-
Linux!jef 2006/01/06 22:24:03
------------------------------------------------------------------------------*/

char * DvdLangCode2String( char * langCode )
{
	int i;

	for( i = 0; ArrLang[i].code; i++ ) {
		if( !strcmp( ArrLang[i].code, langCode ))	return( ArrLang[i].name );
	}
	DBG('i',fprintf(stderr,"%s: langCode(%s) unknown!\n", __FUNCTION__, langCode ););
	return( _("Inconnu") );
}
/*------------------------------------------------------------------------------
	COPYIFO-
Linux!jef 2006/01/19 19:34:24
------------------------------------------------------------------------------*/

ifo_handle_t * CopyIfo( int vts )
{
	ifo_handle_t * ifo;

	ifo = ifoOpen( Dvd, vts);
	return( ifo );
}
