/***************************************************************************//**
 * @file	profile.h
 * @date	2009/01/14 23:17:09
 * @author	jef-Linux
 * @brief
 *	Brief description
 * @details
 *	Released under GPL license, see gnu.org
 * encoding	UTF8 !-UTF8-!
 * Long description
*******************************************************************************/
#ifndef __PROFILE_H__
#define __PROFILE_H__

typedef struct {
	int 	profileCode;
	int	profileFlags;
	char *	libel;
	double	cq;		/* Quality factor */
	int	passNb;		/* Pass number */
	long long fileSize;
	int	audioBitrate;
	char *	audioCodec;
	char *	videoCodec;
	char *  encTool;
	char *	pass1Opt;
	char *	pass2Opt;
	char *	extension;
	double	overhead;	/* Container overhead */
} Profile_t;

#define PROFILE_AVAIL_F		0x01
#define PROFILE_AVI_F		0x02
#define PROFILE_MULTI_AUDIO_F	0x04
#define PROFILE_HANDLE_SUBS_F	0x08

/*@$#[profile.c] global proto. AutoProtoSigV1.1. date: 2009/02/04 23:21:44 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
/* profile.c */
Profile_t *GetProfiles PROTO((void));
Profile_t *GetProfile PROTO((int profileCode));
void InitProfiles PROTO((void));
#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) [-I ../include]*/


#endif	/* __PROFILE_H__ */

