/*  dvdisaster: Additional error correction for optical media.
 *  Copyright (C) 2004,2005 Carsten Gnoerlich.
 *  Project home page: http://www.dvdisaster.com
 *  Email: carsten@dvdisaster.com  -or-  cgnoerlich@fsfe.org
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA,
 *  or direct your browser at http://www.gnu.org.
 */

#include "dvdisaster.h"

/***
 *** This is a dummy codec without functionality.
 ***
 * Do not blindly use as a boilerplate codec;
 * you must add some abortion/error management also.
 * See RegisterCleanup() and the associated functions
 * in ecc-rs01.c!
 */

static void create(Method *method)
{
  g_printf("DMMY codec -- create() called\n");
  AllowActions(TRUE);
}

static void fix(Method *method)
{
  g_printf("DMMY codec -- fix() called\n");
  AllowActions(TRUE);
}

static void destroy(Method *method)
{
}

static void ResetDMMYEncodeWindow(Method *method)
{
  g_printf("DMMY codec -- ResetEncodeWindow() called\n");
}

static void ResetDMMYFixWindow(Method *method)
{
  g_printf("DMMY codec -- ResetEncodeWindow() called\n");
}

void CreateDMMYEncodeWindow(Method *method, GtkWidget *parent)
{  GtkWidget *lab,*sep;

   lab = gtk_label_new(NULL);
   SetLabelText(GTK_LABEL(lab), "<big>Encoding with dummy codec</big>\n<i>nothing useful will happen</i>");
   gtk_misc_set_alignment(GTK_MISC(lab), 0.0, 0.0); 
   gtk_misc_set_padding(GTK_MISC(lab), 5, 0);
   gtk_box_pack_start(GTK_BOX(parent), lab, FALSE, FALSE, 3);

   sep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(parent), sep, FALSE, FALSE, 0);

   sep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(parent), sep, FALSE, FALSE, 0);
}

void CreateDMMYFixWindow(Method *method, GtkWidget *parent)
{  GtkWidget *lab,*sep;

   lab = gtk_label_new(NULL);
   SetLabelText(GTK_LABEL(lab), "<big>Fixing with dummy codec</big>\n<i>nothing useful will happen</i>");
   gtk_misc_set_alignment(GTK_MISC(lab), 0.0, 0.0); 
   gtk_misc_set_padding(GTK_MISC(lab), 5, 0);
   gtk_box_pack_start(GTK_BOX(parent), lab, FALSE, FALSE, 3);

   sep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(parent), sep, FALSE, FALSE, 0);

   sep = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(parent), sep, FALSE, FALSE, 0);
}

void register_dmmy(void)
{  Method *method = g_malloc0(sizeof(Method));

   /*** Standard infomation and methods */ 

   strncpy(method->name, "DMMY", 4);
   method->description = "Dummy codec; does nothing useful!"; 
   method->create = create;
   method->fix    = fix;

   method->createCreateWindow = CreateDMMYEncodeWindow;
   method->createFixWindow    = CreateDMMYFixWindow;

   method->resetCreateWindow = ResetDMMYEncodeWindow;
   method->resetFixWindow    = ResetDMMYFixWindow;

   method->destroy = destroy;

   /*** Register ourself */

   RegisterMethod(method);
}
