/////////////////////////////////////////////////////////////////////////////
// Name:        MenuObjectPropDlg.h
// Purpose:     DVD menu button properties dialog
// Author:      Alex Thuering
// Created:	20.11.2003
// RCS-ID:      $Id: MenuObjectPropDlg.h,v 1.16 2011/09/04 19:30:33 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef BUTTON_PROP_DLG_H
#define BUTTON_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

enum ButtonDirCommand {
  bdNONE, bdLEFT, bdRIGHT, bdUP, bdDOWN
};

class MenuObjectPropDlg: public wxPropDlg {
  public:
    MenuObjectPropDlg(wxWindow *parent, wxString id, bool multObjects, Menu *menu, DVD* dvd, int tsi, int pgci);
    virtual ~MenuObjectPropDlg() {}

  private:
    wxString m_id;
    bool m_multObjects;
    MenuObject* m_object;
    Menu* m_menu;
    DVD* m_dvd;
    int m_tsi; // tsi of menu
    int m_pgci; // pgci of menu
    void CreatePropPanel(wxSizer* sizer);
    void CreateLocAndSize(wxBoxSizer* mainSizer);
    
    wxChoice* m_targetChoice;
    wxChoice* m_chapterChoice;
    /** Returns titleset id of selected target */
    int GetSelectedTsi();
    /** Returns PGC id of selected target */
    int GetSelectedPgci();
    /** Returns true if selected target is menu */
    bool IsSelectedMenu();
    /** Returns selected chapter number */
    int GetSelectedChapter();

    void* TargetToPtr(int tsi, int pgci, bool menu);
    void FillTargets(wxChoice* ctrl);
    void UpdateChapters();
    void OnChangeTarget(wxCommandEvent& WXUNUSED(evt));
    
    bool m_displayVideoFrame; // shows if video frame must be automatically selected if it is available
    wxTextCtrl* m_imageEdit;
    wxRadioButton* m_imageRadio;
    wxRadioButton* m_videoFrameRadio;
    wxChoice* m_videoFrameChoice;
    wxString GetVideoFilename(bool withTimestamp = false, long position = -1);
    void OnImageRadio(wxCommandEvent& evt);
    
    wxTextCtrl* m_customActionEdit;
    void OnJumpActionSelected(wxCommandEvent& evt);
    void OnCustomActionSelected(wxCommandEvent& evt);
    
    wxTextCtrl* m_widthEdit;
    wxTextCtrl* m_heightEdit;
    void OnKeepAspectRatio(wxCommandEvent& evt);
    
    void AddDirectionProp(wxSizer* sizer, ButtonDirCommand dir);
    bool SetValues();
    
    DECLARE_EVENT_TABLE()
};

#endif // BUTTON_PROP_DLG_H
