/////////////////////////////////////////////////////////////////////////////
// Name:        Slideshow.h
// Purpose:     The class to store information for slideshow
// Author:      Alex Thuering
// Created:	26.06.2005
// RCS-ID:      $Id: Slideshow.h,v 1.6 2011/07/07 22:10:20 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef SLIDESHOW_H
#define SLIDESHOW_H

#include "Menu.h"
#include <vector>

using namespace std;

#define VECTOR_CLEAR(obj, elem_type) \
	for (vector<elem_type*>::iterator vectorIt = obj.begin(); vectorIt != obj.end(); vectorIt++) \
		delete *vectorIt; \
	obj.clear();

#define VECTOR_COPY(src, dst, elem_type) \
	for (vector<elem_type*>::const_iterator vectorIt = src.begin(); vectorIt != src.end(); vectorIt++) \
		dst.push_back(new elem_type(**vectorIt));

class Slide {
public:
    Slide() {}
    Slide(const wxString& filename): m_filename(filename) {}
    Slide(wxSvgXmlNode* node) { PutXML(node); }
    
    inline wxString GetFilename() { return m_filename; }
    inline void SetFilename(const wxString& filename) { m_filename = filename; }
    
    wxSvgXmlNode* GetXML();
	bool PutXML(wxSvgXmlNode* node);
  
protected:
    wxString m_filename;
};

class Slideshow {
public:
    Slideshow(VideoFormat videoFormat = vfPAL, AspectRatio aspectRatio = ar4_3);
    Slideshow(wxSvgXmlNode* node);
    Slideshow(const Slideshow& slideshow);
    ~Slideshow();
    
    inline VideoFormat GetVideoFormat() { return m_videoFormat; }
	inline void SetVideoFormat(VideoFormat format) { m_videoFormat = format; }
	wxSize GetResolution();
	inline AspectRatio GetAspectRatio() { return m_aspectRatio; }
	inline void SetAspectRatio(AspectRatio aspectRatio) { m_aspectRatio = aspectRatio; }
    float GetFPS();
    
    inline int GetDuration() { return m_duration; }
    inline void SetDuration(int duration) { m_duration = duration; }
    
    inline unsigned int GetCount() { return m_slides.size(); }
    inline Slide* GetSlide(unsigned int idx) { return m_slides[idx]; }
    inline void AddSlide(Slide* slide) { m_slides.push_back(slide); }
    void Clear();
    
    wxImage GetThumbImage(int width, int height);
    wxImage GetImage(int index);
    
    wxSvgXmlNode* GetXML(DVDFileType type, wxSvgXmlNode* node = NULL);
	bool PutXML(wxSvgXmlNode* node);
  
protected:
    VideoFormat m_videoFormat;
    AspectRatio m_aspectRatio;
    int m_duration;
    vector<Slide*> m_slides;
};

#endif //SLIDESHOW_H
